/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadSeqRegionByHistoryHandler
extends EventHandler {
    public static final String PATTERN = "([^--]*)--(.*):(.*):(.*)-(.*)";
    Pattern p = Pattern.compile("(\\S+)\\.(\\S+)");

    public LoadSeqRegionByHistoryHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        this.doUpdate();
        LocationModel myModel = model.getLocationModel();
        this.log("Loading seq region from history: selected" + myModel.getSelectedHistoryLocation());
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(myModel.getSelectedHistoryLocation());
        if (!matcher.matches()) {
            throw new NonFatalException("The history item doesn't correspond to the allowed pattern: <version>--<coordsystem>:<seqregion>:<start>-<end>");
        }
        String version = matcher.group(1);
        String coordSystem = matcher.group(2);
        String seqRegion = matcher.group(3);
        String start = matcher.group(4);
        String end = matcher.group(5);
        this.log("Matched to version : " + version + ", and coord system: " + coordSystem + " seq region: " + seqRegion + " start: " + start + " end: " + end);
        if (this.isNull(version) || this.isNull(coordSystem) || this.isNull(seqRegion)) {
            throw new NonFatalException("The chosen version and coord system and seq region " + myModel.getSelectedHistoryLocation() + " can't be resolved " + " into a separate, non-null version and coord system string");
        }
        if (!myModel.isCoordSystemInitialised()) {
            this.log("Coord systems not initialised - finding and populating");
            myModel.setCoordSystems(this.findCoordinateSystems(this.getConnectionForModel(model)));
            myModel.setCoordSystemInitialised(true);
            myModel.setSeqRegions(new ArrayList());
            myModel.setSeqRegionInitialised(false);
        }
        myModel.setSelectedCoordSystem(version + "--" + coordSystem);
        if (!myModel.isSeqRegionInitialised()) {
            myModel.setSeqRegions(this.findSeqRegions(model));
        }
        myModel.setSelectedSeqRegion(seqRegion);
        myModel.setSeqRegionInitialised(true);
        myModel.setStart(start);
        myModel.setEnd(end);
        myModel.setStableIDLocation(false);
        this.doRead();
    }
}

