/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.ensj.NonFatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FindSeqRegionsHandler
extends EventHandler {
    public static final String PATTERN = "([^--]*)--(.*)";

    public FindSeqRegionsHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        this.log("Finding available seq regions");
        this.doUpdate();
        DatabaseModel databaseModel = model.getDatabaseModel();
        LocationModel locationModel = model.getLocationModel();
        if (locationModel.isSeqRegionInitialised()) {
            this.log("Seq regions already initialised - returning");
            return;
        }
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String database = databaseModel.getSelectedEnsemblDatabase();
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList<String> unsortedReturnList = new ArrayList<String>();
        returnList.add("");
        Connection connection = EnsJConnectionUtil.getConnection(jdbcDriver, host, port, database, user, password);
        String versionAndCoordSystem = locationModel.getSelectedCoordSystem();
        if (this.isNull(versionAndCoordSystem)) {
            throw new NonFatalException("Coordinate system must be populated");
        }
        this.log("Found version/coord system: " + versionAndCoordSystem);
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(versionAndCoordSystem);
        if (!matcher.matches()) {
            throw new NonFatalException("The chosen version and coord system: " + versionAndCoordSystem + " don't fit the pattern" + " version--coordsystem");
        }
        String version = matcher.group(1);
        String coordSystem = matcher.group(2);
        this.log("Matched to version : " + version + ", and coord system: " + coordSystem);
        if (this.isNull(version) || this.isNull(coordSystem)) {
            throw new NonFatalException("The chosen version and coord system " + versionAndCoordSystem + " can't be resolved " + " into a separate, non-null version and coord system string");
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet names = version.equals("(No Version)") ? statement.executeQuery("select seq_region.name, seq_region.length from seq_region, coord_system where  seq_region.coord_system_id = coord_system.coord_system_id and  coord_system.name = '" + coordSystem + "' and " + " coord_system.version is null ") : statement.executeQuery("select seq_region.name, seq_region.length from seq_region, coord_system where  seq_region.coord_system_id = coord_system.coord_system_id and  coord_system.name = '" + coordSystem + "' and " + " coord_system.version = '" + version + "'");
            while (names.next()) {
                String name = names.getString(1);
                int length = names.getInt(2);
                unsortedReturnList.add(name);
                locationModel.getSeqRegionToLengthsMap().put(name, new Integer(length));
                this.log("Retreived seq-region: " + name + "(" + length + ")");
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        Collections.sort(unsortedReturnList);
        returnList.addAll(unsortedReturnList);
        locationModel.setSeqRegions(returnList);
        locationModel.setSeqRegionInitialised(true);
        this.closeConnection(connection);
        this.doRead();
    }
}

