/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.controller;

import apollo.dataadapter.ensj.EnsJConnectionUtil;
import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.controller.EventHandler;
import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.Model;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class FindEnsemblDatabaseNamesHandler
extends EventHandler {
    public FindEnsemblDatabaseNamesHandler(Controller controller, String key) {
        super(controller, key);
    }

    public void doAction(Model model) {
        this.doUpdate();
        DatabaseModel databaseModel = model.getDatabaseModel();
        this.log("Finding available available databases");
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("");
        String jdbcDriver = "org.gjt.mm.mysql.Driver";
        String host = databaseModel.getHost();
        String port = databaseModel.getPort();
        String user = databaseModel.getUser();
        String password = databaseModel.getPassword();
        Connection connection = EnsJConnectionUtil.getConnection(jdbcDriver, host, port, null, user, password);
        try {
            Statement statement = connection.createStatement();
            ResultSet names = statement.executeQuery("show databases");
            while (names.next()) {
                String name = names.getString(1);
                this.log("Adding database: " + name);
                returnList.add(name);
            }
        }
        catch (SQLException exception) {
            throw new FatalException(exception.getMessage(), exception);
        }
        databaseModel.setEnsemblDatabases(returnList);
        databaseModel.setDatabaseListFound(true);
        this.doRead();
    }
}

