/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.ensj.controller.Controller;
import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.model.TypesModel;
import apollo.dataadapter.ensj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class EnsJAdapterGUI
extends AbstractDataAdapterUI
implements ApolloDataAdapterGUI {
    private IOOperation _operation;
    private View _view;
    private Model _model;
    private Controller _controller;
    private static final int MAX_HISTORY_LENGTH = 20;

    public EnsJAdapterGUI(IOOperation operation) {
        this._operation = operation;
        this._view = new View(this);
        this._model = new Model();
        this._controller = new Controller(this.getModel(), this.getView());
        this.setLayout(new BorderLayout());
        this.add(this.getView(), "Center");
        this.getView().initialiseView();
        this.getController().handleEventForKey("READ");
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        Properties stateInformation = null;
        try {
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                stateInformation = this.createStateInformation();
                ((ApolloDataAdapterI)this.getDataAdapter()).setStateInformation(stateInformation);
                return ((ApolloDataAdapterI)this.getDataAdapter()).getCurationSet();
            }
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
                stateInformation = this.createStateInformation();
                ((ApolloDataAdapterI)this.getDataAdapter()).setStateInformation(stateInformation);
                return ((ApolloDataAdapterI)this.getDataAdapter()).addToCurationSet();
            }
            throw new ApolloAdapterException("I cannot run the exception: " + this.getOperation().getName());
        }
        catch (NonFatalDataAdapterException exception) {
            throw new ApolloAdapterException("Problem loading data:" + exception.getMessage(), exception);
        }
    }

    public Properties createStateInformation() throws ApolloAdapterException {
        String apolloRoot;
        StateInformation stateInfo = new StateInformation();
        this.getController().handleEventForKey("UPDATE");
        LocationModel locationModel = this.getModel().getLocationModel();
        TypesModel typesModel = this.getModel().getTypesModel();
        DatabaseModel databaseModel = this.getModel().getDatabaseModel();
        File logFile = null;
        if (!locationModel.isStableIDLocation()) {
            String region = "REGION: " + locationModel.getSelectedCoordSystem() + ":" + locationModel.getSelectedSeqRegion() + ":" + locationModel.getStart() + "-" + locationModel.getEnd();
            if (region != null) {
                stateInfo.put("region", region);
            }
        } else {
            stateInfo.put("region", "ID: " + locationModel.getStableID());
        }
        if (!(logFile = new File((apolloRoot = System.getProperty("APOLLO_ROOT")) + "/conf/logging_info_level.conf")).exists()) {
            throw new ApolloAdapterException("The following file must be provided to support ensj - conf/logging_info_level.conf");
        }
        stateInfo.put("loggingFile", apolloRoot + "/conf/logging_info_level.conf");
        stateInfo.put("include.Gene", typesModel.includeGenes());
        stateInfo.put("include.DnaProteinAlignment", typesModel.includeDnaProteinAlignments());
        stateInfo.put("include.DnaDnaAlignment", typesModel.includeDnaDnaAlignments());
        stateInfo.put("include.Feature", typesModel.includeSimpleFeatures());
        stateInfo.put("include.SimplePeptideFeature", typesModel.includeProteinAnnotations());
        stateInfo.put("include.PredictionTranscript", typesModel.includeAbInitioPredictions());
        stateInfo.put("include.RepeatFeature", typesModel.includeRepeats());
        this.putPrefixedProperties(stateInfo, typesModel.getSelectedGeneTypes(), "INCLUDE_GENE_TYPES");
        this.putPrefixedProperties(stateInfo, typesModel.getSelectedDnaDnaAlignTypes(), "INCLUDE_DNA_DNA_ALIGNMENT_TYPES");
        this.putPrefixedProperties(stateInfo, typesModel.getSelectedDnaProteinAlignTypes(), "INCLUDE_DNA_PROTEIN_ALIGNMENT_TYPES");
        this.putPrefixedProperties(stateInfo, typesModel.getSelectedPredictionTypes(), "INCLUDE_PREDICTION_TRANSCRIPT_TYPES");
        this.putPrefixedProperties(stateInfo, typesModel.getSelectedSimpleFeatureTypes(), "INCLUDE_FEATURE");
        stateInfo.put("host", databaseModel.getHost());
        stateInfo.put("port", databaseModel.getPort());
        stateInfo.put("user", databaseModel.getUser());
        stateInfo.put("password", databaseModel.getPassword());
        if (databaseModel.getSelectedEnsemblDatabase() != null) {
            stateInfo.put("database", databaseModel.getSelectedEnsemblDatabase());
            stateInfo.put("name", databaseModel.getSelectedEnsemblDatabase());
        }
        return stateInfo;
    }

    public void setInput(Object input) {
        if (input instanceof HashMap) {
            LocationModel locationModel = this.getModel().getLocationModel();
            HashMap theInput = (HashMap)input;
            this.getController().handleEventForKey("FIND_COORD_SYSTEMS");
            String text = (String)theInput.get("coordsys");
            locationModel.setSelectedCoordSystem(text);
            text = (String)theInput.get("chr");
            locationModel.setSelectedSeqRegion(text);
            text = (String)theInput.get("start");
            locationModel.setStart(text);
            text = (String)theInput.get("end");
            locationModel.setEnd(text);
            this.getController().handleEventForKey("READ");
        }
    }

    public void setProperties(Properties input) {
        LocationModel locationModel = this.getModel().getLocationModel();
        TypesModel typesModel = this.getModel().getTypesModel();
        DatabaseModel databaseModel = this.getModel().getDatabaseModel();
        List locationHistory = this.getPrefixedProperties(input, "locationHistory");
        locationModel.setLocationHistory(locationHistory);
        List stableIDHistory = this.getPrefixedProperties(input, "stableIDHistory");
        locationModel.setStableIDHistory(stableIDHistory);
        typesModel.setIncludeGenes(input.getProperty("include.Gene"));
        List includedTypes = this.getPrefixedProperties(input, "INCLUDE_GENE_TYPES");
        typesModel.setSelectedGeneTypes(includedTypes);
        typesModel.setIncludeDnaProteinAlignments(input.getProperty("include.DnaProteinAlignment"));
        includedTypes = this.getPrefixedProperties(input, "INCLUDE_DNA_PROTEIN_ALIGNMENT_TYPES");
        typesModel.setSelectedDnaProteinAlignTypes(includedTypes);
        typesModel.setIncludeDnaDnaAlignments(input.getProperty("include.DnaDnaAlignment"));
        includedTypes = this.getPrefixedProperties(input, "INCLUDE_DNA_DNA_ALIGNMENT_TYPES");
        typesModel.setSelectedDnaDnaAlignTypes(includedTypes);
        typesModel.setIncludeAbInitioPredictions(input.getProperty("include.PredictionTranscript"));
        includedTypes = this.getPrefixedProperties(input, "INCLUDE_PREDICTION_TRANSCRIPT_TYPES");
        typesModel.setSelectedPredictionTypes(includedTypes);
        typesModel.setIncludeSimpleFeatures(input.getProperty("include.Feature"));
        includedTypes = this.getPrefixedProperties(input, "INCLUDE_FEATURE");
        typesModel.setSelectedSimpleFeatureTypes(includedTypes);
        typesModel.setIncludeProteinAnnotations(input.getProperty("include.SimplePeptideFeature"));
        typesModel.setIncludeRepeats(input.getProperty("include.RepeatFeature"));
        databaseModel.setHost(input.getProperty("host"));
        databaseModel.setPort(input.getProperty("port"));
        databaseModel.setUser(input.getProperty("user"));
        databaseModel.setPassword(input.getProperty("password"));
        this.getController().handleEventForKey("READ");
        this.getController().handleEventForKey("FIND_ENSEMBL_DATABASE_NAMES");
        databaseModel.setSelectedEnsemblDatabase(input.getProperty("database"));
        this.getController().handleEventForKey("READ");
        if (databaseModel.getSelectedEnsemblDatabase() != null && databaseModel.getSelectedEnsemblDatabase().trim().length() > 0) {
            this.getController().handleEventForKey("SELECT_NEW_ENSEMBL_DATABASE");
        }
        if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            this.getController().handleEventForKey("HIDE_OR_SHOW_DATABASE");
            this.getController().handleEventForKey("HIDE_OR_SHOW_TYPES");
            this.getController().handleEventForKey("HIDE_OR_SHOW_LOCATION");
        }
        this.getController().handleEventForKey("READ");
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            properties = this.createStateInformation();
        }
        catch (ApolloAdapterException exception) {
            System.out.println("Not providing properties because of this problem: " + exception.getMessage());
            exception.printStackTrace();
            return properties;
        }
        this.addLocationHistory(properties);
        return properties;
    }

    private void addLocationHistory(Properties properties) {
        LocationModel locationModel = this.getModel().getLocationModel();
        TypesModel typesModel = this.getModel().getTypesModel();
        DatabaseModel databaseModel = this.getModel().getDatabaseModel();
        String currentStableID = null;
        List locationHistory = locationModel.getLocationHistory();
        List stableIDHistory = locationModel.getStableIDHistory();
        String currentLocation = null;
        if (!locationModel.isStableIDLocation()) {
            currentLocation = locationModel.getSelectedCoordSystem() + ":" + locationModel.getSelectedSeqRegion() + ":" + locationModel.getStart() + "-" + locationModel.getEnd();
            if (currentLocation != null && !locationHistory.contains(currentLocation)) {
                locationHistory.add(0, currentLocation);
            }
            this.putPrefixedProperties(properties, locationHistory, "locationHistory");
        } else if (locationModel.isStableIDLocation()) {
            currentStableID = locationModel.getStableID();
            if (currentStableID != null && currentStableID.trim().length() > 0 && !stableIDHistory.contains(currentStableID)) {
                stableIDHistory = locationModel.getStableIDHistory();
                stableIDHistory.add(0, currentStableID);
            }
            this.putPrefixedProperties(properties, stableIDHistory, "stableIDHistory");
        }
    }

    protected List getPrefixedProperties(Properties settings, String prefix) {
        ArrayList<String> returnList = new ArrayList<String>();
        String value = "";
        for (int i = 0; i < settings.size() && value != null; ++i) {
            value = settings.getProperty(prefix + i);
            if (value == null) continue;
            if (value.equals("END_OF_LIST")) {
                return returnList;
            }
            returnList.add(value);
        }
        return returnList;
    }

    protected void putPrefixedProperties(Properties settings, List values, String prefix) {
        int i;
        values.size();
        for (i = 0; i < values.size() && i < 20; ++i) {
            settings.put(prefix + i, (String)values.get(i));
        }
        settings.put(prefix + i, "END_OF_LIST");
    }

    public DataAdapter getDataAdapter() {
        return this.driver;
    }

    private IOOperation getOperation() {
        return this._operation;
    }

    public View getView() {
        return this._view;
    }

    public Model getModel() {
        return this._model;
    }

    public Controller getController() {
        return this._controller;
    }

    public void addActionRouter(JButton button, String handlerKey) {
        this.getController().addActionRouter(button, handlerKey);
    }

    public void addKeyRouter(JTextField textField, String handlerKey) {
        this.getController().addKeyRouter(textField, handlerKey);
    }

    public void addActionRouter(JComboBox dropDown, String handlerKey) {
        this.getController().addActionRouter(dropDown, handlerKey);
    }

    public void addKeyRouter(JComboBox dropDown, String handlerKey) {
        this.getController().addKeyRouter(dropDown, handlerKey);
    }

    public void addKeyRouter(Component component, String handlerKey) {
        this.getController().addKeyRouter(component, handlerKey);
    }

    public void addPopupRouter(JComboBox dropDown, String handlerKey) {
        this.getController().addPopupRouter(dropDown, handlerKey);
    }
}

