/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.debug;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Score;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import java.util.Enumeration;
import java.util.Vector;

public class DisplayTool {
    private static String getRangeDirection(int in) {
        if (in == 1) {
            return "+";
        }
        if (in == -1) {
            return "-";
        }
        if (in == 0) {
            return "n";
        }
        return "?";
    }

    private static String getGeneTypeName(String in) {
        if (in.equals("gene")) {
            return "PROTEIN CODING GENE";
        }
        if (in.equals("tRNA")) {
            return "TRNA";
        }
        if (in.equals("transposon")) {
            return "TRANSPOSON";
        }
        return "Annotation";
    }

    public static void showGene(AnnotatedFeatureI g) {
        System.err.println("Gene : (" + g.getName() + ", " + g.getSynonyms().toString() + ")");
        for (int i = 0; i < g.size(); ++i) {
            Transcript t = (Transcript)g.getFeatureAt(i);
            System.err.println("  transcript " + (i + 1) + ": (" + t.getName() + ", " + t.getSynonyms().toString() + ")");
            for (int j = 0; j < t.getExons().size(); ++j) {
                ExonI e = (ExonI)t.getExons().elementAt(j);
                System.err.println("    exon " + (j + 1) + ": " + e.getName() + (e.getStrand() == 1 ? "+" : "-") + " (" + e.getStart() + ", " + e.getEnd() + ")");
            }
        }
    }

    public static void showExon(ExonI e) {
        System.err.println("    exon : " + e.getName() + (e.getStrand() == 1 ? "+" : "-") + " (" + e.getStart() + ", " + e.getEnd() + ") " + e.getFeatureType());
    }

    public static void showFeatureSet(FeatureSetI fs) {
        DisplayTool.showFeatureSet(fs, 0);
    }

    public static void showFeatureSet(FeatureSetI fs, int indent) {
        int i;
        String indentString = "";
        for (i = 0; i < indent * 8; ++i) {
            indentString = indentString + " ";
        }
        System.err.println(indentString + "(" + String.valueOf(indent) + "-set) " + DisplayTool.getStringForSeqFeature(fs));
        for (i = 0; i < fs.size(); ++i) {
            SeqFeatureI sf = fs.getFeatureAt(i);
            if (sf instanceof FeatureSetI) {
                System.err.println("");
                DisplayTool.showFeatureSet((FeatureSetI)sf, indent + 1);
                System.err.println("");
                continue;
            }
            int tempIndent = indent + 1;
            String tempIndentString = indentString + "        ";
            System.err.println("");
            System.err.println(tempIndentString + "(" + String.valueOf(tempIndent) + "-leaf) " + DisplayTool.getStringForSeqFeature(sf));
            System.err.println("");
        }
    }

    public static void outputSpaces(int nSpace) {
        for (int i = 0; i < nSpace; ++i) {
            System.err.print(" ");
        }
    }

    public static String getStringForSeqFeature(SeqFeatureI sf) {
        if (sf instanceof FeaturePair) {
            return "\"" + sf.getName() + "\"-" + sf.getFeatureType() + " (" + sf.getStart() + ", " + sf.getEnd() + ")" + (sf.getStrand() == 1 ? "+" : "-") + " {" + sf.getClass().getName() + "} " + DisplayTool.getScoresString(sf) + " Pair info: " + ((FeaturePair)sf).getHname() + " " + ((FeaturePair)sf).getHstart() + "-" + ((FeaturePair)sf).getHend();
        }
        return "\"" + sf.getName() + "\"-" + sf.getFeatureType() + " (" + sf.getStart() + ", " + sf.getEnd() + ")" + (sf.getStrand() == 1 ? "+" : "-") + " {" + sf.getClass().getName() + "} " + DisplayTool.getScoresString(sf);
    }

    public static String getScoresString(SeqFeatureI sf) {
        Enumeration keys = sf.getScores().keys();
        StringBuffer buffer = keys.hasMoreElements() ? new StringBuffer("Scores: ") : new StringBuffer("No Scores");
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            buffer.append(" " + ((Score)sf.getScores().get(key)).toString());
        }
        return buffer.toString();
    }

    public static void checkRefFeatures(FeatureSetI fs) {
        Vector children = fs.getFeatures();
        for (int i = 0; i < fs.size(); ++i) {
            SeqFeatureI sf = (SeqFeatureI)children.elementAt(i);
            if (sf.getRefFeature() != fs) {
                System.out.println("RefFeature not parent for " + sf);
            }
            if (!(sf instanceof FeatureSetI)) continue;
            DisplayTool.checkRefFeatures((FeatureSetI)sf);
        }
    }
}

