/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das2;

import apollo.config.Config;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DAS2FeatureSaxParser
extends DefaultHandler {
    static boolean DEBUG = Config.getDebug();
    static final String FEATURELIST = "FEATURELIST";
    static final String FEATURES = "FEATURES";
    static final String FEATURE = "FEATURE";
    static final String LOC = "LOC";
    static final String XID = "XID";
    static final String PART = "PART";
    static final String PROP = "PROP";
    static final String ALIGN = "ALIGN";
    static final String PARENT = "PARENT";
    static final String STYLE = "STYLE";
    static final String BOX = "BOX";
    static final String LABEL = "LABEL";
    static final String LINE = "LINE";
    static final String XHTML = "XHTML";
    static final String ID = "id";
    static final String TYPE = "type";
    static final String TYPE_ID = "type_id";
    static final String NAME = "name";
    static final String CREATED = "created";
    static final String MODIFIED = "modified";
    static final String DOC_HREF = "doc_href";
    static final String POS = "pos";
    static final String RANGE = "range";
    static final String HREF = "href";
    static final String PTYPE = "ptype";
    static final String MIME_TYPE = "mime_type";
    static final String CONTENT_ENCODING = "content_encoding";
    static final String TGT = "tgt";
    static final String TARGET_ID = "target_id";
    static final String GAP = "gap";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String NOTE_PROP = "das:note";
    static final String ALIAS_PROP = "das:alias";
    static final String PHASE_PROP = "das:phase";
    static final String SCORE_PROP = "das:score";
    static final Pattern range_splitter = Pattern.compile("/");
    static final Pattern interval_splitter = Pattern.compile(":");
    String current_elem = null;
    StringBuffer current_chars = null;
    Stack elemstack = new Stack();
    String feat_id = null;
    String feat_type = null;
    String feat_name = null;
    String feat_parent_id = null;
    String feat_prop_key = null;
    String feat_prop_value = "";
    int min = -1;
    int max = -999;
    int strand = 0;
    List feat_locs = new ArrayList();
    List feat_xids = new ArrayList();
    Map feat_parts = new LinkedHashMap();
    List feat_aligns = new ArrayList();
    Map feat_props = null;
    List feat_notes = new ArrayList();
    List feat_aliass = new ArrayList();
    List feat_phases = new ArrayList();
    List feat_scores = new ArrayList();
    List result_syms = null;
    Map id2sym = new HashMap();
    Map parent2parts = new HashMap();
    StrandedFeatureSetI analyses = null;
    Hashtable all_analyses = null;
    String chromosome = null;

    public void parse(BufferedInputStream isrc, CurationSet curation) throws Exception {
        SAXParser reader = new SAXParser();
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setContentHandler(this);
        this.initCurationSet(curation);
        reader.parse(new InputSource(isrc));
        if (DEBUG) {
            System.out.println("\nDone parsing DAS2XML input");
        }
        curation.setResults(this.analyses);
        StrandedFeatureSet annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        annotations.setName("Annotations");
        annotations.setFeatureType("Annotation");
        curation.setAnnots(annotations);
    }

    public void startDocument() {
        if (DEBUG) {
            System.out.println("Das2FeaturesSaxParser.startDocument() called");
        }
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qname, Attributes atts) {
        this.elemstack.push(this.current_elem);
        this.current_elem = name.intern();
        if (this.current_elem != FEATURELIST && this.current_elem != FEATURES) {
            if (this.current_elem == FEATURE) {
                this.feat_id = atts.getValue(ID);
                if (this.feat_id == null || this.feat_id.equals("")) {
                    this.feat_id = atts.getValue("uri");
                }
                this.feat_id = this.stripPrefix(this.feat_id);
                this.feat_type = atts.getValue(TYPE);
                this.feat_type = this.stripPrefix(this.feat_type);
                this.feat_name = atts.getValue(NAME);
                if (DEBUG) {
                    System.out.println("Got feature with id " + this.feat_id + ", type " + this.feat_type + ", name = " + name);
                }
                SeqFeature feat = new SeqFeature();
                feat.setId(this.feat_id);
                if (this.feat_name != null) {
                    feat.setName(this.feat_name);
                } else {
                    feat.setName(this.feat_id);
                }
                feat.setFeatureType(this.feat_type);
                feat.setTopLevelType(this.feat_type);
                feat.addProperty(CREATED, atts.getValue(CREATED));
                feat.addProperty(MODIFIED, atts.getValue(MODIFIED));
                if (this.id2sym.get(this.feat_id) != null) {
                    System.out.println("WARNING, duplicate feature id: " + this.feat_id);
                } else {
                    this.id2sym.put(this.feat_id, feat);
                }
            } else if (this.current_elem == LOC) {
                String span_id;
                SeqFeature span = (SeqFeature)this.id2sym.get(this.feat_id);
                if (span == null) {
                    if (DEBUG) {
                        System.out.println("No pre-existing seqfeature for " + this.feat_id);
                    }
                    span = new SeqFeature();
                    span.setId(this.feat_id);
                }
                if ((span_id = atts.getValue(ID)) == null || span_id.equals("")) {
                    span_id = atts.getValue("segment");
                }
                String range = atts.getValue(RANGE);
                if (DEBUG) {
                    System.out.println("Got LOC id=" + span_id + ", range = " + range);
                }
                this.setSpanRange(span, span_id, range);
                if (this.id2sym.get(this.feat_id) == null) {
                    this.id2sym.put(this.feat_id, span);
                }
            } else if (this.current_elem != XID) {
                if (this.current_elem == PARENT) {
                    if (this.feat_parent_id == null) {
                        this.feat_parent_id = atts.getValue(ID);
                        this.feat_parent_id = this.stripPrefix(this.feat_parent_id);
                    } else {
                        System.out.println("WARNING:  second parent (" + atts.getValue(ID) + ") for feature, just using first one (" + this.feat_parent_id + ")");
                    }
                } else if (this.current_elem == PART) {
                    SeqFeature child;
                    String part_id = atts.getValue(ID);
                    part_id = this.stripPrefix(part_id);
                    if (DEBUG) {
                        System.out.println("Got part id " + part_id);
                    }
                    if ((child = (SeqFeature)this.id2sym.get(part_id)) == null) {
                        this.feat_parts.put(part_id, part_id);
                    } else {
                        this.feat_parts.put(part_id, child);
                    }
                } else if (this.current_elem == PROP) {
                    SeqFeature child;
                    String feat_prop_ptype = atts.getValue(PTYPE);
                    if (feat_prop_ptype != null && !feat_prop_ptype.equals("")) {
                        System.err.println("Warning: not handling old-fashioned PROP with ptype=" + feat_prop_ptype);
                        return;
                    }
                    this.feat_prop_key = atts.getValue(KEY);
                    this.feat_prop_value = atts.getValue(VALUE);
                    if (this.feat_prop_value == null || this.feat_prop_value.equals("")) {
                        String url = atts.getValue(HREF);
                        this.feat_prop_value = "href:" + url;
                    }
                    if ((child = (SeqFeature)this.id2sym.get(this.feat_id)) == null) {
                        if (DEBUG) {
                            System.out.println("Error--got prop " + this.feat_prop_key + " = " + this.feat_prop_value + " for child " + this.feat_id + " that can't be found");
                        }
                    } else {
                        child.addProperty(this.feat_prop_key, this.feat_prop_value);
                        if (this.feat_prop_key.indexOf("score") >= 0 && child.getScore() == 0.0) {
                            try {
                                double score = Double.parseDouble(this.feat_prop_value);
                                child.setScore(score);
                                if (DEBUG) {
                                    System.out.println("Set score = " + this.feat_prop_value + " for " + child.getName());
                                }
                            }
                            catch (Exception e) {}
                        }
                    }
                } else if (this.current_elem == ALIGN) {
                    if (DEBUG) {
                        System.out.println("Got ALIGN record");
                    }
                    String subject_id = atts.getValue(TARGET_ID);
                    String subject_range = atts.getValue(RANGE);
                    this.addSubject(this.feat_id, subject_id, subject_range);
                } else if (this.current_elem == STYLE) {
                    if (DEBUG) {
                        System.out.println("Got STYLE record");
                    }
                } else if (this.current_elem != BOX && this.current_elem != LABEL && this.current_elem != LINE) {
                    if (this.current_elem == XHTML) {
                        if (DEBUG) {
                            System.out.println("Got XHTML record");
                        }
                    } else {
                        System.out.println("element not recognized: " + this.current_elem);
                    }
                }
            }
        }
    }

    private void getPositionSpan(String position, SeqFeature span) {
        if (position == null) {
            return;
        }
        String[] fields = range_splitter.split(position);
        String remainder = fields[fields.length - 1];
        this.setSpanRange(span, fields[1], remainder);
    }

    private void setSpanRange(SeqFeature span, String chrom, String range) {
        String[] subfields = interval_splitter.split(range);
        this.min = Integer.parseInt(subfields[0]);
        this.max = Integer.parseInt(subfields[1]);
        if (subfields.length >= 3) {
            try {
                this.strand = Integer.parseInt(subfields[2]);
            }
            catch (Exception e) {
                System.out.println("Couldn't parse integer strand from " + subfields[2] + "--loc string was " + range);
            }
        }
        span.setLow(this.min);
        span.setHigh(this.max);
        span.setStrand(this.strand);
        this.chromosome = chrom;
    }

    public void clearAll() {
        this.result_syms = null;
        this.id2sym.clear();
        this.clearFeature();
    }

    public void clearFeature() {
        this.feat_id = null;
        this.feat_type = null;
        this.feat_name = null;
        this.feat_parent_id = null;
        this.feat_locs.clear();
        this.feat_xids.clear();
        this.feat_parts = new LinkedHashMap();
        this.feat_aligns.clear();
        this.feat_notes.clear();
        this.feat_aliass.clear();
        this.feat_phases.clear();
        this.feat_scores.clear();
        this.feat_props = null;
        this.feat_prop_key = null;
        this.feat_prop_value = "";
    }

    public void endElement(String uri, String name, String qname) {
        if (name.equals(FEATURE)) {
            this.addFeature();
            this.clearFeature();
        } else if (name.equals(PROP)) {
            Object prev;
            if (this.feat_props == null) {
                this.feat_props = new HashMap();
            }
            if ((prev = this.feat_props.get(this.feat_prop_key)) == null) {
                this.feat_props.put(this.feat_prop_key, this.feat_prop_value);
            } else if (prev instanceof List) {
                ((List)prev).add(this.feat_prop_value);
            } else {
                ArrayList<Object> multivals = new ArrayList<Object>();
                multivals.add(prev);
                multivals.add(this.feat_prop_value);
                this.feat_props.put(this.feat_prop_key, this.feat_prop_value);
            }
            this.feat_prop_key = null;
            this.feat_prop_value = "";
        }
        this.current_elem = (String)this.elemstack.pop();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.current_elem == PROP) {
            this.feat_prop_value = this.feat_prop_value + new String(ch, start, length);
        }
    }

    private String stripPrefix(String s) {
        if (s != null && !s.equals("")) {
            s = s.substring(s.indexOf("/") + 1);
        }
        return s;
    }

    public void addFeature() {
        SeqFeatureI feat;
        if (DEBUG) {
            System.out.println("Adding feature: " + this.feat_id);
        }
        if ((feat = (SeqFeatureI)this.id2sym.get(this.feat_id)) == null) {
            System.out.println("Warning: addFeature: couldn't find " + this.feat_id + " in id2sym");
            return;
        }
        this.parent2parts.put(feat, this.feat_parts);
        SeqFeatureI parent = null;
        if (this.feat_parent_id == null) {
            if (DEBUG) {
                System.out.println("addFeature: feat " + feat + " is a top-level feature");
            }
            parent = feat;
        } else {
            LinkedHashMap parent_parts;
            parent = (SeqFeatureI)this.id2sym.get(this.feat_parent_id);
            if (parent == null) {
                if (DEBUG) {
                    System.out.println("No parent feature yet for id " + this.feat_parent_id);
                }
                return;
            }
            feat.setRefFeature(parent);
            if (DEBUG) {
                System.out.println("Found parent " + this.feat_parent_id + " for child feature " + feat);
            }
            if ((parent_parts = (LinkedHashMap)this.parent2parts.get(parent)) == null) {
                if (DEBUG) {
                    System.out.println("WARNING: no parent_parts found for parent " + this.feat_parent_id);
                }
            } else {
                parent_parts.put(this.feat_id, feat);
            }
        }
        if (this.childrenReady(parent)) {
            FeatureSet parentset = this.addChildren(parent);
            if (parentset.getFeatures().size() > 0) {
                parentset.setFeatureType(((SeqFeatureI)parentset.getFeatures().firstElement()).getFeatureType());
            }
            if (DEBUG) {
                System.out.println("Done making parent feature: " + parentset);
                System.out.println("Children: ");
                Vector spans = parentset.getFeatures();
                for (int i = 0; i < spans.size(); ++i) {
                    SeqFeature span = (SeqFeature)spans.elementAt(i);
                    System.out.println("  Child " + i + ": " + span);
                }
            }
            this.addResultToAnalysis(parentset);
        } else if (DEBUG) {
            System.out.println("Children not all ready for parent " + parent);
        }
        if (this.feat_parts.size() > 0 && DEBUG) {
            System.out.println("feat_parts.size = " + this.feat_parts.size() + " for " + feat);
        }
    }

    protected boolean childrenReady(SeqFeatureI parent) {
        if (parent == null) {
            System.out.println("childrenReady: parent is null!");
            return false;
        }
        LinkedHashMap parts = (LinkedHashMap)this.parent2parts.get(parent);
        Iterator citer = parts.values().iterator();
        boolean all_child_syms = true;
        while (citer.hasNext()) {
            Object val = citer.next();
            if (val instanceof SeqFeatureI) continue;
            all_child_syms = false;
            break;
        }
        return all_child_syms;
    }

    protected FeatureSet addChildren(SeqFeatureI parent_feat) {
        FeatureSet parent_set = new FeatureSet(parent_feat);
        DAS2FeatureSaxParser.copyProperties(parent_feat, parent_set);
        LinkedHashMap parts = (LinkedHashMap)this.parent2parts.get(parent_feat);
        Iterator citer = parts.entrySet().iterator();
        while (citer.hasNext()) {
            Map.Entry keyval = citer.next();
            String child_id = (String)keyval.getKey();
            SeqFeatureI child_sym = (SeqFeatureI)keyval.getValue();
            parent_set.addFeature(child_sym);
        }
        return parent_set;
    }

    private static void copyProperties(SeqFeatureI from, SeqFeatureI to) {
        Hashtable props = from.getProperties();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            String type = (String)e.nextElement();
            Vector values = ((SeqFeature)from).getPropertyMulti(type);
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                to.addProperty(type, value);
            }
        }
    }

    private void initCurationSet(CurationSet curation) {
        StrandedFeatureSetI results;
        if (curation == null) {
            curation = new CurationSet();
        }
        if ((results = curation.getResults()) == null) {
            results = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            this.analyses = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            this.all_analyses = new Hashtable();
        }
    }

    private void addResultToAnalysis(FeatureSetI result) {
        String prog = result.getProperty("program");
        String db = result.getProperty("sourcename");
        String date = result.getProperty("timeexecuted");
        String programversion = result.getProperty("programversion");
        String sourceversion = result.getProperty("sourceversion");
        if (db.equals("")) {
            db = "das2";
        }
        if (prog.equals("")) {
            prog = result.getFeatureType();
        }
        FeatureSetI forward_analysis = this.initAnalysis(this.analyses, 1, prog, db, date, programversion, sourceversion, this.all_analyses);
        FeatureSetI reverse_analysis = this.initAnalysis(this.analyses, -1, prog, db, date, programversion, sourceversion, this.all_analyses);
        if (result.getStrand() == 1) {
            forward_analysis.addFeature(result);
            if (DEBUG) {
                System.out.println("Added result " + result + " to forward analysis " + forward_analysis.getName() + ", which has " + forward_analysis.size() + " features");
            }
            if (!forward_analysis.hasFeatureType()) {
                forward_analysis.setFeatureType(result.getFeatureType());
            }
        } else {
            if (DEBUG) {
                System.out.println("Added result " + result + " to reverse analysis " + reverse_analysis.getName() + ", which has " + reverse_analysis.size() + " features");
            }
            reverse_analysis.addFeature(result);
            if (!reverse_analysis.hasFeatureType()) {
                reverse_analysis.setFeatureType(result.getFeatureType());
            }
        }
        boolean fwd = this.addAnalysisIfHasFeatures(forward_analysis, this.all_analyses, this.analyses);
        boolean rev = this.addAnalysisIfHasFeatures(reverse_analysis, this.all_analyses, this.analyses);
        if (fwd && rev) {
            forward_analysis.setAnalogousOppositeStrandFeature(reverse_analysis);
            reverse_analysis.setAnalogousOppositeStrandFeature(forward_analysis);
        }
    }

    private FeatureSetI initAnalysis(StrandedFeatureSetI analyses, int strand, String prog, String db, String date, String programversion, String sourceversion, Hashtable all_analyses) {
        FeatureSetI analysis;
        String analysis_type = this.constructAnalysisType(prog, db);
        String analysis_name = !analysis_type.equals("no_type") ? analysis_type + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : "")) : "no_name" + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : ""));
        if (all_analyses == null) {
            all_analyses = new Hashtable();
        }
        if ((analysis = (FeatureSetI)all_analyses.get(analysis_name)) == null) {
            analysis = new FeatureSet();
            analysis.setProgramName(prog);
            analysis.setDatabase(db);
            analysis.setFeatureType(analysis_type);
            if (!analysis_type.equals("no_type")) {
                analysis.setName(analysis_name);
            }
            analysis.setStrand(strand);
        }
        return analysis;
    }

    private String constructAnalysisType(String prog, String db) {
        String analysis_type = prog != null && !prog.equals("") && db != null && !db.equals("") ? prog + ":" + db : (prog != null && !prog.equals("") ? prog : (db != null && !db.equals("") ? db : "no_type"));
        return analysis_type;
    }

    private boolean addAnalysisIfHasFeatures(FeatureSetI analysis, Hashtable all_analyses, StrandedFeatureSetI analyses) {
        if (all_analyses == null) {
            if (DEBUG) {
                System.out.println("addAnalysisIfHasFeatures: analysis hash was null!");
            }
            return false;
        }
        if (all_analyses.containsKey(analysis.getName())) {
            return true;
        }
        if (analysis.size() > 0) {
            all_analyses.put(analysis.getName(), analysis);
            analyses.addFeature(analysis);
            return true;
        }
        return false;
    }

    public void addSubject(String feat_id, String subject_id, String subject_range) {
        SeqFeature feature = (SeqFeature)this.id2sym.get(feat_id);
        feature.addProperty("subject_id", subject_id);
        feature.addProperty("subject_range", subject_range);
    }
}

