/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.DASDsnContentHandler;
import apollo.dataadapter.das.simple.DASEntryPointContentHandler;
import apollo.dataadapter.das.simple.DASFeatureContentHandler;
import apollo.dataadapter.das.simple.DASSequenceContentHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleDASServer
implements DASServerI {
    private String url = "";
    private String server;
    private static final float version = 1.0f;

    public SimpleDASServer(String url) {
        this.setURL(url);
    }

    public void setURL(String url) {
        if (url.indexOf("http://") != 0) {
            url = "http://" + url;
        }
        if (!url.substring(url.length() - 1).equals("/")) {
            url = url + "/";
        }
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public List getDSNs() {
        List dsnList = new ArrayList();
        DASDsnContentHandler theSAXHandler = new DASDsnContentHandler();
        String queryString = this.getURL() + "dsn";
        System.out.println("SimpleDASServer.getDSNs: query string = " + queryString);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(theSAXHandler);
            parser.parse(queryString);
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException(theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException(theException.getMessage());
        }
        dsnList = theSAXHandler.getDsns();
        return dsnList;
    }

    public List getEntryPoints(DASDsn dsn) {
        List entryPoints = new ArrayList();
        DASEntryPointContentHandler theSAXHandler = new DASEntryPointContentHandler();
        String queryString = this.getURL() + dsn.getSourceId() + "/entry_points";
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(theSAXHandler);
            parser.parse(queryString);
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException("SAX Problem fetching Entry Points: " + theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException("IO Problem fetching Entry Points: " + theException.getMessage());
        }
        entryPoints = theSAXHandler.getSegments();
        return entryPoints;
    }

    public List getFeatures(DASDsn dsn, DASSegment[] segmentSelection) {
        HashMap<String, DASSegment> segmentMap = new HashMap<String, DASSegment>();
        for (int i = 0; i < segmentSelection.length; ++i) {
            segmentMap.put(segmentSelection[i].getId(), segmentSelection[i]);
        }
        return this.getFeatures(dsn, segmentMap, new HashMap(), Long.valueOf(segmentSelection[0].getStart()), Long.valueOf(segmentSelection[0].getStop()));
    }

    public List getFeatures(DASDsn dsn, HashMap segmentSelection, HashMap parentFeatures, long globalStart, long globalEnd) {
        String dsnId = dsn.getSourceId();
        Iterator segmentIterator = segmentSelection.values().iterator();
        DASFeatureContentHandler theSAXHandler = new DASFeatureContentHandler(this, dsn, segmentSelection, parentFeatures, globalStart, globalEnd);
        String queryString = this.getURL() + dsnId + "/features?";
        while (segmentIterator.hasNext()) {
            DASSegment aSegment = (DASSegment)segmentIterator.next();
            String segmentId = aSegment.getId();
            String start = aSegment.getStart();
            String stop = aSegment.getStop();
            queryString = queryString + "segment=" + segmentId + ":" + start + "," + stop + ";";
        }
        Object xmlStream = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(theSAXHandler);
            parser.parse(queryString);
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException("SAX Problem fetching features: " + theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException("IO Problem fetching features: " + theException.getMessage());
        }
        return theSAXHandler.getFeatures();
    }

    public List getSequences(DASDsn dsn, DASSegment[] segmentSelection) {
        StringBufferInputStream stringReader;
        Object sequences = null;
        String dsnId = dsn.getSourceId();
        String segmentId = segmentSelection[0].getId();
        String start = segmentSelection[0].getStart();
        String stop = segmentSelection[0].getStop();
        DASSequenceContentHandler theSAXHandler = new DASSequenceContentHandler(this, dsn, segmentSelection);
        String queryString = this.getURL() + dsnId + "/dna?segment=" + segmentId + ":" + start + "," + stop;
        Object xmlStream = null;
        StringBuffer sequenceString = new StringBuffer();
        try {
            URL sequenceURL = new URL(queryString);
            DataInputStream content = new DataInputStream(sequenceURL.openStream());
            String dataLine = content.readLine();
            String lastCharacter = dataLine.substring(dataLine.length() - 1);
            if (!lastCharacter.equals(">")) {
                dataLine = dataLine + ">";
            }
            sequenceString.append(dataLine);
            dataLine = content.readLine();
            while (dataLine != null) {
                sequenceString.append(dataLine);
                dataLine = content.readLine();
            }
            stringReader = new StringBufferInputStream(sequenceString.toString());
        }
        catch (IOException exception) {
            throw new NonFatalDataAdapterException("attempt to read sequence failed:" + exception.getMessage());
        }
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(theSAXHandler);
            InputSource inputSource = new InputSource(stringReader);
            inputSource.setSystemId(this.getURL());
            parser.parse(inputSource);
        }
        catch (SAXException theException) {
            throw new NonFatalDataAdapterException("SAX Problem fetching sequence: " + theException.getMessage());
        }
        catch (IOException theException) {
            throw new NonFatalDataAdapterException("IO Problem fetching sequence: " + theException.getMessage());
        }
        return theSAXHandler.getSequences();
    }
}

