/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.SimpleDASAdapter;
import apollo.dataadapter.das.simple.SimpleDASDsn;
import apollo.dataadapter.das.simple.SimpleDASServer;
import apollo.dataadapter.debug.DisplayTool;
import apollo.datamodel.CurationSet;
import apollo.gui.ProxyDialog;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class SimpleDASAdapterGUI
extends AbstractDataAdapterUI
implements ApolloDataAdapterGUI {
    JComboBox serverList;
    JComboBox dsnList;
    JComboBox segList;
    JTextField lowTextBox;
    JTextField hiTextBox;
    JComboBox historyList;
    private static final String CHOOSE_STRING = "choose...";
    JLabel serverLabel;
    JLabel dsnLabel;
    JLabel segLabel;
    JLabel lowLabel;
    JLabel hiLabel;
    JLabel historyLabel;
    JLabel proxyLabel;
    JPanel pane;
    private JTextField proxyTextField;
    private JButton proxyButton;
    Vector dsnVector = new Vector();
    Vector serverVector = new Vector();
    Vector historyVector = new Vector();
    Vector segmentVector = null;
    Vector emptyVector = new Vector();
    public static final int MAX_HISTORY_LENGTH = 5;
    protected DataAdapter driver;
    protected IOOperation op;
    private Properties props;
    protected ServerListener server_listener;
    protected DSNListener dsn_listener;
    protected HistoryListener history_listener;
    LongValidator posValidator = new LongValidator();
    private DASServerI dasServer;

    public SimpleDASAdapterGUI(IOOperation op) {
        this.op = op;
        this.serverList = new JComboBox();
        this.dsnList = new JComboBox();
        this.segList = new JComboBox();
        this.hiTextBox = new JTextField();
        this.lowTextBox = new JTextField();
        this.historyList = new JComboBox();
        this.serverLabel = new JLabel("DAS Server");
        this.dsnLabel = new JLabel("Sequence sources");
        this.segLabel = new JLabel("Annotated sequences");
        this.lowLabel = new JLabel("Sequence from");
        this.hiLabel = new JLabel("to");
        this.historyLabel = new JLabel("Previous selections");
        this.server_listener = new ServerListener();
        this.dsn_listener = new DSNListener();
        this.history_listener = new HistoryListener();
        this.proxyLabel = new JLabel("Proxy Settings");
        this.proxyTextField = new JTextField(20);
        this.proxyTextField.setEnabled(false);
        this.proxyButton = new JButton("Change...");
        this.proxyButton.addActionListener(new ProxyListener());
        this.buildGUI();
    }

    public Properties createStateInformation() {
        StateInformation stateInfo = new StateInformation();
        String proxySet = System.getProperty("proxySet");
        String proxyHost = System.getProperty("proxyHost");
        String proxyPort = System.getProperty("proxyPort");
        DASSegment theSegment = this.getSelectedSegment();
        if (this.getSelectedDSN() != null) {
            this.setPropertyIfNotNull(stateInfo, "DSN_description", this.getSelectedDSN().getDescription());
            this.setPropertyIfNotNull(stateInfo, "DSN_mapMaster", this.getSelectedDSN().getMapMaster());
            this.setPropertyIfNotNull(stateInfo, "DSN_source", this.getSelectedDSN().getSource());
            this.setPropertyIfNotNull(stateInfo, "DSN_sourceId", this.getSelectedDSN().getSourceId());
            this.setPropertyIfNotNull(stateInfo, "DSN_sourceVersion", this.getSelectedDSN().getSourceVersion());
        }
        if (this.getDASServer() != null) {
            this.setPropertyIfNotNull(stateInfo, "DAS_server_url", this.getDASServer().getURL());
        }
        if (theSegment != null) {
            this.setPropertyIfNotNull(stateInfo, "Segment_segment", theSegment.getSegment());
            this.setPropertyIfNotNull(stateInfo, "Segment_id", theSegment.getId());
            this.setPropertyIfNotNull(stateInfo, "Segment_start", this.lowTextBox.getText());
            this.setPropertyIfNotNull(stateInfo, "Segment_stop", this.hiTextBox.getText());
            this.setPropertyIfNotNull(stateInfo, "Segment_orientation", theSegment.getOrientation());
            this.setPropertyIfNotNull(stateInfo, "Segment_subparts", theSegment.getSubparts());
            this.setPropertyIfNotNull(stateInfo, "Segment_length", theSegment.getLength());
        }
        return stateInfo;
    }

    public void setProperties(Properties in) {
        int i;
        int items;
        String propertyString;
        Properties systemProperties;
        block13: {
            this.props = in;
            this.serverVector.removeAllElements();
            systemProperties = System.getProperties();
            this.serverList.removeItemListener(this.server_listener);
            this.historyList.removeActionListener(this.history_listener);
            try {
                this.serverVector.addElement(CHOOSE_STRING);
                propertyString = this.props.getProperty("srvItems");
                if (propertyString != null) {
                    items = Integer.parseInt(propertyString);
                    for (i = 0; i < items; ++i) {
                        String server = this.props.getProperty("srvItem" + i);
                        if (server == null || server.trim().length() <= 0) continue;
                        this.serverVector.addElement(this.props.getProperty("srvItem" + i));
                    }
                } else {
                    this.serverVector.addElement(Config.getDASServer());
                }
            }
            catch (Exception e) {
                if (this.serverVector.size() != 0) break block13;
                this.serverVector.addElement(Config.getDASServer());
            }
        }
        this.serverList.setModel(new DefaultComboBoxModel(this.serverVector));
        this.historyVector.removeAllElements();
        try {
            this.historyVector.addElement(CHOOSE_STRING);
            propertyString = this.props.getProperty("dasItems");
            items = propertyString != null ? Integer.parseInt(propertyString) : 0;
            for (i = 0; i < items; ++i) {
                this.historyVector.addElement(this.props.getProperty("dasItem" + i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.historyList.setModel(new DefaultComboBoxModel(this.historyVector));
        String useProxy = this.props.getProperty("dasUseProxy");
        String proxyPort = this.props.getProperty("dasProxyPort");
        String proxyHost = this.props.getProperty("dasProxyHost");
        if (proxyHost != null && !proxyHost.equals("none")) {
            System.setProperty("http.proxyHost", proxyHost);
        }
        if (proxyPort != null && !proxyPort.equals("none")) {
            systemProperties.setProperty("http.proxyPort", proxyPort);
        } else {
            systemProperties.remove("http.proxyPort");
        }
        if (useProxy != null && useProxy.equals("true")) {
            systemProperties.put("http.proxySet", "true");
        } else {
            systemProperties.remove("http.proxySet");
        }
        this.updateProxyTextField(useProxy, proxyHost, proxyPort);
        this.serverList.addItemListener(this.server_listener);
        this.historyList.addActionListener(this.history_listener);
        this.dsnList.addItemListener(this.dsn_listener);
    }

    public Properties getProperties() {
        int i;
        String history = null;
        Properties out = new Properties();
        this.serverList.removeItemListener(this.server_listener);
        this.historyList.removeActionListener(this.history_listener);
        String selectedServer = this.getSelectedServer();
        if (selectedServer != null && selectedServer.trim().length() > 0 && !selectedServer.equals(CHOOSE_STRING)) {
            history = selectedServer + " " + this.getSelectedDSN().getSourceId() + " " + this.getSelectedSegment().getId() + " " + this.lowTextBox.getText() + " " + this.hiTextBox.getText();
            this.historyVector.insertElementAt(history, 0);
        }
        int maximumHistoryCount = this.serverVector.size() > 5 ? 5 : this.serverVector.size();
        out.put("srvItems", maximumHistoryCount + "");
        for (i = 0; i < maximumHistoryCount; ++i) {
            if (this.serverVector.elementAt(i).equals(CHOOSE_STRING)) continue;
            out.put("srvItem" + i, (String)this.serverVector.elementAt(i));
        }
        maximumHistoryCount = this.historyVector.size() > 5 ? 5 : this.historyVector.size();
        out.put("dasItems", maximumHistoryCount + "");
        for (i = 0; i < maximumHistoryCount; ++i) {
            if (this.historyVector.elementAt(i) == null || this.historyVector.elementAt(i).equals(CHOOSE_STRING)) continue;
            out.put("dasItem" + i, (String)this.historyVector.elementAt(i));
        }
        this.serverList.addItemListener(this.server_listener);
        this.historyList.addActionListener(this.history_listener);
        String proxySet = System.getProperty("http.proxySet");
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxySet != null) {
            out.put("dasUseProxy", proxySet);
        } else {
            out.put("dasUseProxy", "none");
        }
        if (proxyHost != null) {
            out.put("dasProxyHost", proxyHost);
        } else {
            out.put("dasProxyHost", "none");
        }
        if (proxyPort != null) {
            out.put("dasProxyPort", proxyPort);
        } else {
            out.put("dasProxyPort", "none");
        }
        return out;
    }

    public void setFont(Font font) {
    }

    public void buildGUI() {
        Dimension listBoxSize = new Dimension(350, 20);
        Dimension textBoxSize = new Dimension(140, 20);
        Dimension labelSize = new Dimension(150, 20);
        this.setForeground(SystemColor.text);
        this.setBackground(SystemColor.window);
        this.serverList.setPreferredSize(listBoxSize);
        this.serverList.setMinimumSize(listBoxSize);
        this.serverList.setEditable(true);
        this.dsnList.setPreferredSize(listBoxSize);
        this.dsnList.setMinimumSize(listBoxSize);
        this.segList.setPreferredSize(listBoxSize);
        this.segList.setMinimumSize(listBoxSize);
        this.historyList.setPreferredSize(listBoxSize);
        this.lowTextBox.setPreferredSize(textBoxSize);
        this.lowTextBox.setMinimumSize(textBoxSize);
        this.hiTextBox.setPreferredSize(textBoxSize);
        this.hiTextBox.setMinimumSize(textBoxSize);
        this.hiTextBox.addKeyListener(this.posValidator);
        this.lowTextBox.addKeyListener(this.posValidator);
        this.pane = new JPanel();
        this.pane.setLayout(new GridBagLayout());
        this.pane.setBackground(SystemColor.window);
        this.pane.setForeground(SystemColor.text);
        this.pane.add((Component)this.serverLabel, GuiUtil.makeConstraintAt(0, 0, 1));
        this.pane.add((Component)this.serverList, GuiUtil.makeConstraintAt(1, 0, 3));
        this.pane.add((Component)this.dsnLabel, GuiUtil.makeConstraintAt(0, 1, 1));
        this.pane.add((Component)this.dsnList, GuiUtil.makeConstraintAt(1, 1, 3));
        this.pane.add((Component)this.segLabel, GuiUtil.makeConstraintAt(0, 2, 1));
        this.pane.add((Component)this.segList, GuiUtil.makeConstraintAt(1, 2, 3));
        this.pane.add((Component)this.lowLabel, GuiUtil.makeConstraintAt(0, 3, 1));
        this.pane.add((Component)this.lowTextBox, GuiUtil.makeConstraintAt(1, 3, 1));
        this.pane.add((Component)this.hiLabel, GuiUtil.makeConstraintAt(2, 3, 1));
        this.pane.add((Component)this.hiTextBox, GuiUtil.makeConstraintAt(3, 3, 1));
        this.pane.add((Component)this.historyLabel, GuiUtil.makeConstraintAt(0, 4, 1));
        this.pane.add((Component)this.historyList, GuiUtil.makeConstraintAt(1, 4, 3));
        this.pane.add((Component)this.getProxyLabel(), GuiUtil.makeConstraintAt(0, 5, 1));
        this.pane.add((Component)this.getProxyTextField(), GuiUtil.makeConstraintAt(1, 5, 2));
        this.pane.add((Component)this.getProxyButton(), GuiUtil.makeConstraintAt(3, 5, 2));
        this.add(this.pane);
    }

    public void setDataAdapter(DataAdapter driver) {
        this.driver = driver;
    }

    public String getSelectedServer() {
        return (String)this.serverList.getSelectedItem();
    }

    public DASDsn getSelectedDSN() {
        return (DASDsn)this.dsnList.getSelectedItem();
    }

    public DASSegment getSelectedSegment() {
        DASSegment selectedSegment = (DASSegment)this.segList.getSelectedItem();
        return selectedSegment;
    }

    public String getSelectedHistory() {
        String selectedHistory = (String)this.historyList.getSelectedItem();
        if (selectedHistory == null) {
            selectedHistory = (String)this.historyList.getItemAt(0);
        }
        return selectedHistory;
    }

    protected void updateDSNs() {
        this.dsnVector.removeAllElements();
        try {
            this.serverList.removeItemListener(this.server_listener);
            this.historyList.removeActionListener(this.history_listener);
            ((MutableComboBoxModel)this.serverList.getModel()).removeElement(CHOOSE_STRING);
            ((MutableComboBoxModel)this.historyList.getModel()).removeElement(CHOOSE_STRING);
            if (this.getSelectedServer() != null && this.getSelectedServer().trim().length() > 0 && !this.getSelectedServer().equals(CHOOSE_STRING)) {
                this.setDASServer(new SimpleDASServer(this.getSelectedServer()));
                List theDSNList = this.getDASServer().getDSNs();
                Iterator dsnIterator = theDSNList.iterator();
                this.dsnVector.addElement(new SimpleDASDsn("", "", "", "", ""));
                while (dsnIterator.hasNext()) {
                    this.dsnVector.addElement(dsnIterator.next());
                }
            }
            this.dsnList.setModel(new DefaultComboBoxModel(this.dsnVector));
            this.serverList.addItemListener(this.server_listener);
            this.historyList.addActionListener(this.history_listener);
        }
        catch (NonFatalDataAdapterException theException) {
            theException.printStackTrace();
            this.serverList.removeItemListener(this.server_listener);
            this.serverList.addItemListener(this.server_listener);
            this.historyList.removeActionListener(this.history_listener);
            this.historyList.addActionListener(this.history_listener);
            this.displayDialog("The URL you provided could not provide DSN's - source message:" + theException.getMessage());
        }
    }

    protected void updateSegments() {
        DASDsn dsn = this.getSelectedDSN();
        Iterator segmentIterator = null;
        this.segmentVector = new Vector();
        List segmentList = null;
        if (dsn != null && dsn.getSourceId() != null) {
            segmentList = this.getDASServer().getEntryPoints(dsn);
        }
        if (segmentList != null) {
            this.segList.setEditable(false);
            segmentIterator = segmentList.iterator();
            while (segmentIterator.hasNext()) {
                DASSegment segment = (DASSegment)segmentIterator.next();
                this.segmentVector.addElement(segment);
            }
        } else {
            this.segList.setEditable(true);
        }
        this.segList.setModel(new DefaultComboBoxModel(this.segmentVector));
    }

    private void validateInputs() {
        SimpleDASAdapter das_adapter = (SimpleDASAdapter)this.driver;
        String lowText = this.lowTextBox.getText().trim();
        String highText = this.hiTextBox.getText().trim();
        if (das_adapter == null || this.getSelectedDSN() == null || this.getSelectedSegment() == null) {
            throw new NonFatalDataAdapterException("Attempt to fetch features from DAS server without specifying adapter, dsn or segment");
        }
        if (lowText == null || lowText.length() <= 0 || highText == null || highText.length() <= 0) {
            throw new NonFatalDataAdapterException("Low/High range must be specified");
        }
        try {
            int lowTextInt = Integer.parseInt(lowText);
            int highTextInt = Integer.parseInt(highText);
        }
        catch (NumberFormatException theException) {
            throw new NonFatalDataAdapterException("Low/High ranges are not in integer format");
        }
    }

    public Object doOperation(Object values) throws DataAdapterException {
        try {
            SimpleDASAdapter das_adapter = (SimpleDASAdapter)this.driver;
            DASSegment theSegment = this.getSelectedSegment();
            this.validateInputs();
            das_adapter.setStateInformation(this.createStateInformation());
            if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                CurationSet out = ((ApolloDataAdapterI)this.driver).getCurationSet();
                DisplayTool.showFeatureSet(out.getResults());
                return out;
            }
            return null;
        }
        catch (NonFatalDataAdapterException exception) {
            throw new ApolloAdapterException("Problem loading data: " + exception.getMessage(), exception);
        }
    }

    private void setPropertyIfNotNull(StateInformation props, String key, String value) {
        if (value != null) {
            props.setProperty(key, value);
        }
    }

    private void _beep() {
        byte[] beep = new byte[]{7};
        System.out.print(new String(beep));
    }

    protected void setSelection(Object item, Vector model, JComboBox list) {
        int index = -1;
        for (int i = 0; i < model.size() && index < 0; ++i) {
            if (!model.elementAt(i).equals(item)) continue;
            index = i;
        }
        if (index < 0) {
            model.insertElementAt(item, 0);
            index = 0;
        }
        list.setModel(new DefaultComboBoxModel(model));
        list.setSelectedIndex(index);
    }

    protected void setSelectedDSNWithId(String id, Vector model, JComboBox list) {
        int index = -1;
        for (int i = 0; i < model.size() && index < 0; ++i) {
            if (!((DASDsn)model.elementAt(i)).getSourceId().equals(id)) continue;
            index = i;
        }
        list.setModel(new DefaultComboBoxModel(model));
        if (index >= 0) {
            list.setSelectedIndex(index);
        }
    }

    protected void setSelectedSegmentWithId(String id, Vector model, JComboBox list) {
        int index = -1;
        for (int i = 0; i < model.size() && index < 0; ++i) {
            if (!((DASSegment)model.elementAt(i)).getId().equals(id)) continue;
            index = i;
        }
        list.setModel(new DefaultComboBoxModel(model));
        if (index >= 0) {
            list.setSelectedIndex(index);
        }
    }

    private DASServerI getDASServer() {
        return this.dasServer;
    }

    private void setDASServer(DASServerI theServer) {
        this.dasServer = theServer;
    }

    private JButton getProxyButton() {
        return this.proxyButton;
    }

    private JLabel getProxyLabel() {
        return this.proxyLabel;
    }

    private JTextField getProxyTextField() {
        return this.proxyTextField;
    }

    private void updateProxyTextField(String useProxy, String proxyHost, String proxyPort) {
        if (proxyHost != null && proxyHost.trim().length() > 0 && !proxyHost.equals("none")) {
            this.getProxyTextField().setText(proxyHost + ":" + proxyPort + ". Use? " + useProxy);
        } else {
            this.getProxyTextField().setText(null);
        }
    }

    private void displayDialog(String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Error Loading DSNs", 0);
    }

    public class ProxyListener
    implements ActionListener {
        public void actionPerformed(ActionEvent theEvent) {
            ProxyDialog pd = new ProxyDialog(null);
            pd.setVisible(true);
            Properties systemProperties = System.getProperties();
            String useProxy = systemProperties.getProperty("http.proxySet");
            String proxyPort = systemProperties.getProperty("http.proxyPort");
            String proxyHost = systemProperties.getProperty("http.proxyHost");
            SimpleDASAdapterGUI.this.updateProxyTextField(useProxy, proxyHost, proxyPort);
        }
    }

    public class HistoryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String item = (String)SimpleDASAdapterGUI.this.historyList.getSelectedItem();
            int low = 0;
            int hi = 0;
            if (item != null && item.trim().length() > 0 && !item.trim().equals(SimpleDASAdapterGUI.CHOOSE_STRING)) {
                StringTokenizer tokenizer = new StringTokenizer(item);
                try {
                    String server = tokenizer.nextToken();
                    String dsn = tokenizer.nextToken();
                    String segment = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        low = Integer.parseInt(tokenizer.nextToken());
                    }
                    if (tokenizer.hasMoreTokens()) {
                        hi = Integer.parseInt(tokenizer.nextToken());
                    }
                    SimpleDASAdapterGUI.this.setSelection(server, SimpleDASAdapterGUI.this.serverVector, SimpleDASAdapterGUI.this.serverList);
                    SimpleDASAdapterGUI.this.updateDSNs();
                    SimpleDASAdapterGUI.this.setSelectedDSNWithId(dsn, SimpleDASAdapterGUI.this.dsnVector, SimpleDASAdapterGUI.this.dsnList);
                    SimpleDASAdapterGUI.this.updateSegments();
                    SimpleDASAdapterGUI.this.setSelectedSegmentWithId(segment, SimpleDASAdapterGUI.this.segmentVector, SimpleDASAdapterGUI.this.segList);
                    if (low > 0) {
                        SimpleDASAdapterGUI.this.lowTextBox.setText(low + "");
                        SimpleDASAdapterGUI.this.hiTextBox.setText(hi + "");
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed parsing location string " + item);
                }
            }
        }
    }

    public class DSNListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            SimpleDASAdapterGUI.this.updateSegments();
        }
    }

    public class ServerListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            SimpleDASAdapterGUI.this.updateDSNs();
        }
    }

    class LongValidator
    extends KeyAdapter {
        LongValidator() {
        }

        public void keyTyped(KeyEvent evt) {
            JTextField field = (JTextField)evt.getSource();
            if (!Character.isDigit(evt.getKeyChar()) && !Character.isISOControl(evt.getKeyChar())) {
                evt.consume();
                SimpleDASAdapterGUI.this._beep();
            }
        }
    }
}

