/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.das.simple;

import apollo.dataadapter.das.DASDsn;
import apollo.dataadapter.das.DASSegment;
import apollo.dataadapter.das.DASSequence;
import apollo.dataadapter.das.DASServerI;
import apollo.dataadapter.das.simple.SimpleDASSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DASSequenceContentHandler
extends DefaultHandler {
    private String mode;
    private Stack modeStack = new Stack();
    private List sequenceArray = new ArrayList();
    private String DASDNA = "DASDNA";
    private String SEQUENCE = "SEQUENCE";
    private String DNA = "DNA";
    private String LABEL = "label";
    private String SEQUENCE_ID = "id";
    private String SEQUENCE_START = "start";
    private String SEQUENCE_STOP = "stop";
    private String SEQUENCE_VERSION = "version";
    private String DNA_LENGTH = "length";
    private DASSequence currentSequence;
    public DASServerI server;
    public DASSegment[] segments;
    public DASDsn dsn;
    private static boolean print = true;

    public DASSequenceContentHandler() {
    }

    public DASSequenceContentHandler(DASServerI theServer, DASDsn theDsn, DASSegment[] theSegments) {
        this.server = theServer;
        this.dsn = theDsn;
        this.segments = theSegments;
    }

    private DASServerI getServer() {
        return this.server;
    }

    private DASSegment[] getSegments() {
        return this.segments;
    }

    private DASDsn getDSN() {
        return this.dsn;
    }

    private void setSegments(DASSegment[] theSegments) {
        this.segments = theSegments;
    }

    private void setDSN(DASDsn theDSN) {
        this.dsn = theDSN;
    }

    private DASSequence getCurrentSequence() {
        return this.currentSequence;
    }

    private void setCurrentSequence(DASSequence theSequence) {
        this.currentSequence = theSequence;
    }

    private void addSequence(DASSequence theSequence) {
        this.getSequences().add(theSequence);
    }

    public List getSequences() {
        return this.sequenceArray;
    }

    private Stack getModeStack() {
        return this.modeStack;
    }

    private void setMode(String theMode) {
        this.getModeStack().push(theMode);
    }

    private String getMode() {
        if (!this.getModeStack().isEmpty()) {
            return (String)this.getModeStack().peek();
        }
        return null;
    }

    private void closeMode() {
        if (!this.getModeStack().isEmpty()) {
            this.getModeStack().pop();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.DASDNA.equals(localName)) {
            this.setMode(this.DASDNA);
        } else if (this.SEQUENCE.equals(localName)) {
            this.setMode(this.SEQUENCE);
            this.setCurrentSequence(new SimpleDASSequence(attributes.getValue(this.SEQUENCE_ID), attributes.getValue(this.SEQUENCE_START), attributes.getValue(this.SEQUENCE_STOP), attributes.getValue(this.SEQUENCE_VERSION), null, null));
        } else if (this.DNA.equals(localName)) {
            this.setMode(this.DNA);
            this.getCurrentSequence().setDNALength(attributes.getValue(this.DNA_LENGTH));
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.DNA.equals(localName)) {
            this.closeMode();
        } else if (this.SEQUENCE.equals(localName)) {
            DASSequence theCurrentSequence = this.getCurrentSequence();
            this.addSequence(theCurrentSequence);
            this.setCurrentSequence(null);
            this.closeMode();
        } else if (this.DASDNA.equals(localName)) {
            this.closeMode();
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        String charactersWithNoWhiteSpace = null;
        String mode = this.getMode();
        DASSequence sequence = this.getCurrentSequence();
        if (mode != null && sequence != null && mode.equals(this.DNA)) {
            String characters = new StringBuffer().append(text, start, length).toString();
            StringTokenizer tokenizer = new StringTokenizer(characters);
            while (tokenizer.hasMoreTokens()) {
                if (charactersWithNoWhiteSpace != null) {
                    charactersWithNoWhiteSpace = charactersWithNoWhiteSpace + tokenizer.nextToken();
                    continue;
                }
                charactersWithNoWhiteSpace = tokenizer.nextToken();
            }
            if (sequence.getDNA() != null) {
                sequence.setDNA(sequence.getDNA() + charactersWithNoWhiteSpace);
            } else {
                sequence.setDNA(charactersWithNoWhiteSpace);
            }
        }
    }
}

