/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chadoxml;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.dataadapter.TransactionOutputAdapter;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chadoxml.ChadoTransactionXMLWriter;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.dataadapter.gamexml.TransactionXMLAdapter;
import apollo.datamodel.AbstractSequence;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Protein;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.editor.UserName;
import apollo.util.DateUtil;
import apollo.util.IOUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.xml.XML_util;

public class ChadoXmlWrite {
    static String typeIDOntology = "SO";
    static String IDForDbxref = "SO:0000105";
    static String defaultChadoDatabase;
    static String database;
    static String defaultSynonymAuthor;
    static String defaultSynonymPubType;
    static String featurepropCV;
    static String TAB;
    static String CVTermForResults;
    static String chromosome;
    static ApolloNameAdapterI nameAdapter;
    static String CHADO_XML_VERSION;
    static String mayHaveBeenEditedMessage;

    public static boolean writeXML(CurationSet curation, String file_str, String preamble, boolean saveAnnots, boolean saveResults, ApolloNameAdapterI localNameAdapter, String version) {
        nameAdapter = localNameAdapter;
        String filename = IOUtil.findFile(file_str, true);
        if (filename == null) {
            String message = "Failed to open file for writing: " + file_str + "\nThe directory may not exist, or may be unwriteable.";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file_str);
        }
        catch (Exception ex) {
            System.err.println("writeXML: caught exception opening " + file_str + " (" + filename + ")");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        if (fileWriter == null) {
            return false;
        }
        String what = "annotations and evidence";
        if (!saveAnnots) {
            what = "evidence (results) only";
        }
        if (!saveResults) {
            what = "annotations only (no results)";
        }
        String msg = "Saving " + what + " to file " + filename;
        System.out.println(msg);
        boolean success = ChadoXmlWrite.writeXML(curation, fileWriter, preamble, saveAnnots, saveResults, nameAdapter, version);
        try {
            fileWriter.close();
        }
        catch (Exception ex) {
            System.err.println("writeXML: caught exception closing " + filename);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        return success;
    }

    public static boolean writeXML(CurationSet curation, FileWriter fileWriter, String preamble, boolean saveAnnots, boolean saveResults, ApolloNameAdapterI nameAdapter, String version) {
        ChadoXmlWrite.initConstants();
        String startingIndent = TAB;
        BufferedWriter bw = new BufferedWriter(fileWriter);
        PrintWriter pw = new PrintWriter(bw);
        try {
            pw.print(ChadoXmlWrite.writeBegin(version));
            pw.print("\n" + preamble);
            pw.print("<chado date=\"" + DateUtil.toGMT(new Date()) + "\">\n");
            ChadoXmlWrite.writeGenomePosition(curation, startingIndent, pw);
            if (saveAnnots) {
                ChadoXmlWrite.writeAnnotations(curation, startingIndent, pw);
            }
            if (saveResults) {
                ChadoXmlWrite.writeResults(curation, startingIndent, pw);
            }
            pw.print(ChadoXmlWrite.writeEnd());
            pw.close();
        }
        catch (Exception ex) {
            System.err.println("Caught exception committing XML");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static void initConstants() {
        if (!Config.getStyle().getParameter("typeIDOntology").equals("")) {
            typeIDOntology = Config.getStyle().getParameter("typeIDOntology");
        }
        if (!Config.getStyle().getParameter("IDForDbxref").equals("")) {
            IDForDbxref = Config.getStyle().getParameter("IDForDbxref");
        }
        if (!Config.getStyle().getParameter("defaultChadoDatabase").equals("")) {
            defaultChadoDatabase = Config.getStyle().getParameter("defaultChadoDatabase");
            System.out.println("Got new setting for defaultDatabase: " + defaultChadoDatabase);
            database = defaultChadoDatabase;
        }
        if (!Config.getStyle().getParameter("defaultSynonymAuthor").equals("")) {
            defaultSynonymAuthor = Config.getStyle().getParameter("defaultSynonymAuthor");
        }
        if (!Config.getStyle().getParameter("defaultSynonymPubType").equals("")) {
            defaultSynonymPubType = Config.getStyle().getParameter("defaultSynonymPubType");
        }
        if (!Config.getStyle().getParameter("featurepropCV").equals("")) {
            featurepropCV = Config.getStyle().getParameter("featurepropCV");
        }
    }

    private static String writeBegin(String ApolloVersion) {
        StringBuffer buf = new StringBuffer();
        String XML_VERSION = "1.0";
        buf.append("<?xml version=\"" + XML_VERSION + "\" encoding=\"ISO-8859-1\"?>\n");
        buf.append("<!-- ChadoXML file (" + CHADO_XML_VERSION + ") created by " + UserName.getUserName() + " on " + DateUtil.toGMT(new Date()) + " -->\n");
        buf.append("<!-- " + ApolloVersion + " -->\n");
        return buf.toString();
    }

    private static void writeGenomePosition(CurationSet curation, String indent, PrintWriter pw) {
        SequenceI genomic_seq = curation.getRefSequence();
        pw.print(indent + "<_appdata  name=\"title\">" + curation.getName() + "</_appdata>\n");
        chromosome = curation.getChromosome();
        if (chromosome == null || chromosome.equals("")) {
            System.err.println("Warning: couldn't find chromosome for curation " + curation.getName());
            chromosome = "";
        }
        pw.print(indent + "<_appdata  name=\"arm\">" + chromosome + "</_appdata>\n");
        pw.print(indent + "<_appdata  name=\"fmin\">" + (curation.getStart() - 1) + "</_appdata>\n");
        pw.print(indent + "<_appdata  name=\"fmax\">" + curation.getEnd() + "</_appdata>\n");
        ChadoXmlWrite.writeGenomicSequence((AbstractSequence)genomic_seq, indent + "", true, pw);
        if (genomic_seq != null && genomic_seq.getGenomicErrors() != null) {
            String message = "Warning: there are genomic sequencing errors annotated, but\n I don't know how to save them in ChadoXML!";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        }
    }

    private static void writeGenomicSequence(SequenceI seq, String indent, boolean include_residues, PrintWriter pw) {
        if (seq == null) {
            return;
        }
        if (include_residues && seq.getResidues() != null && !seq.getResidues().equals("")) {
            pw.print(indent + "<_appdata  name=\"residues\">");
            pw.print(seq.getResidues());
            pw.print("</_appdata>\n");
        }
    }

    private static void writeAnnotations(CurationSet curation, String indent, PrintWriter pw) {
        StrandedFeatureSetI annots = curation.getAnnots();
        if (annots != null) {
            AnnotatedFeatureI prevAnnot = null;
            AnnotatedFeatureI annot = null;
            for (int i = 0; i < annots.size(); ++i) {
                prevAnnot = annot;
                annot = (AnnotatedFeatureI)annots.getFeatureAt(i);
                if (prevAnnot != null && (annot.getId() == null || annot.getId().equals(prevAnnot.getId()))) {
                    System.out.println("Annotation " + annot.getId() + "has strand=0 so it got added to both strands.  Saving single copy.");
                    continue;
                }
                ChadoXmlWrite.writeAnnotation(curation, annot, indent, pw);
            }
        }
    }

    private static void writeAnnotation(CurationSet curation, AnnotatedFeatureI annot, String startingIndent, PrintWriter pw) {
        SequenceI seq;
        pw.print(startingIndent + "<feature>\n");
        String indent = startingIndent + TAB;
        DbXref xref = ((SeqFeature)((Object)annot)).getPrimaryDbXref();
        if (xref != null) {
            ChadoXmlWrite.writeXref(indent, xref.getDbName(), xref.getIdValue(), false, -1, pw);
        } else {
            System.out.println("Warning: couldn't find primary xref for annotation with uniquename " + annot.getId());
        }
        pw.print(indent + "<is_analysis>0</is_analysis>\n");
        if (!annot.getProperty("is_obsolete").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent, "is_obsolete", annot.getProperty("is_obsolete")));
        }
        pw.print(indent + "<name>" + XML_util.transformToPCData((String)annot.getName()) + "</name>\n");
        ChadoXmlWrite.writeFields(indent, annot, pw);
        ChadoXmlWrite.writeOrganismFromFeature(indent, annot, curation, pw);
        if (annot.getFeatures().size() > 0 && (seq = annot.getRefSequence()) != null && seq.getResidues() != null && !seq.getResidues().equals("")) {
            int seqlen = annot.getStart() > annot.getEnd() ? annot.getStart() - annot.getEnd() + 1 : annot.getEnd() - annot.getStart() + 1;
            pw.print(ChadoXmlWrite.writeField(indent, "seqlen", seqlen + ""));
        }
        ChadoXmlWrite.writeTimes(indent, annot, pw);
        ChadoXmlWrite.writeCVtype(indent, typeIDOntology, ChadoXmlWrite.annotTypeForChado(annot), pw);
        pw.print(ChadoXmlWrite.writeField(indent, "uniquename", XML_util.transformToPCData((String)annot.getId())));
        boolean isa_gene = annot.getTopLevelType().equalsIgnoreCase("gene");
        Vector transcripts = annot.getFeatures();
        for (int i = 0; i < transcripts.size(); ++i) {
            Transcript fs = (Transcript)transcripts.elementAt(i);
            ChadoXmlWrite.writeTranscript(indent, fs, isa_gene, curation, pw);
        }
        ChadoXmlWrite.writeProperty(indent, "owner", annot.getOwner(), 0, pw);
        ChadoXmlWrite.writeComments(indent, annot, pw);
        Vector xrefs = annot.getDbXrefs();
        for (int i = 0; i < xrefs.size(); ++i) {
            xref = (DbXref)xrefs.elementAt(i);
            if (!xref.isSecondary()) continue;
            ChadoXmlWrite.writeXref(indent, xref.getDbName(), xref.getIdValue(), true, xref.getCurrent(), pw);
        }
        ChadoXmlWrite.writeSynonyms(indent, annot, pw);
        ChadoXmlWrite.writeFeatureloc(indent, annot, pw);
        ChadoXmlWrite.writeProperties(indent, annot, pw);
        if (annot.isProblematic()) {
            ChadoXmlWrite.writeProperty(indent, "problem", "true", 0, pw);
        }
        pw.print(startingIndent + "</feature>\n");
    }

    private static void writeXref(String indent, String db, String id, boolean feature_dbxref, int isCurrent, PrintWriter pw) {
        if (id == null || id.equals("")) {
            return;
        }
        String original_indent = indent;
        if (feature_dbxref) {
            pw.print(indent + "<feature_dbxref>\n");
            indent = indent + TAB;
        }
        pw.print(indent + "<dbxref_id>\n");
        pw.print(indent + TAB + "<dbxref>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB, "accession", id));
        pw.print(indent + TAB + TAB + "<db_id>\n");
        pw.print(indent + TAB + TAB + TAB + "<db>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB + TAB, "name", db));
        pw.print(indent + TAB + TAB + TAB + "</db>\n");
        pw.print(indent + TAB + TAB + "</db_id>\n");
        pw.print(indent + TAB + "</dbxref>\n");
        pw.print(indent + "</dbxref_id>\n");
        if (feature_dbxref) {
            pw.print(indent + "<is_current>" + isCurrent + "</is_current>\n");
            pw.print(original_indent + "</feature_dbxref>\n");
        }
    }

    private static void writeTranscript(String indent, Transcript transcript, boolean isa_gene, CurationSet curation, PrintWriter pw) {
        String message;
        SequenceI seq;
        String checksum;
        pw.print(indent + "<feature_relationship>\n");
        pw.print(indent + TAB + "<subject_id>\n");
        pw.print(indent + TAB + TAB + "<feature>\n");
        DbXref xref = transcript.getPrimaryDbXref();
        if (xref != null) {
            ChadoXmlWrite.writeXref(indent + TAB + TAB + TAB, xref.getDbName(), xref.getIdValue(), false, -1, pw);
        } else {
            System.out.println("Warning: couldn't find primary xref for transcript with uniquename " + transcript.getId());
        }
        pw.print(indent + TAB + TAB + TAB);
        pw.print("<is_analysis>0</is_analysis>\n");
        if (!transcript.getProperty("is_obsolete").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "is_obsolete", transcript.getProperty("is_obsolete")));
        }
        if ((checksum = (seq = transcript.get_cDNASequence()).getChecksum()) != null && !checksum.equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "md5checksum", checksum));
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "name", XML_util.transformToPCData((String)transcript.getName())));
        ChadoXmlWrite.writeFields(indent + TAB + TAB + TAB, transcript, pw);
        ChadoXmlWrite.writeOrganismFromFeature(indent + TAB + TAB + TAB, transcript, curation, pw);
        if (seq != null && seq.getResidues() != null && !seq.getResidues().equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "residues", seq.getResidues()));
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "seqlen", seq.getResidues().length() + ""));
        }
        ChadoXmlWrite.writeTimes(indent + TAB + TAB + TAB, transcript, pw);
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, typeIDOntology, ChadoXmlWrite.transcriptTypeForChado(transcript), pw);
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "uniquename", XML_util.transformToPCData((String)transcript.getId())));
        boolean edited = ChadoXmlWrite.mayHaveBeenEdited(transcript, curation);
        if (edited && !mayHaveBeenEditedMessage.equals(message = transcript.getRefFeature().getName() + " may have been edited--updaing exon names and ids")) {
            System.err.println(message);
            mayHaveBeenEditedMessage = message;
        }
        Vector exons = transcript.getFeatures();
        for (int i = 0; i < exons.size(); ++i) {
            Exon exon = (Exon)exons.elementAt(i);
            if (edited || exon.getName().equals("no_name")) {
                ChadoXmlWrite.renameExon(exon, i + 1, curation);
            }
            ChadoXmlWrite.writeExon(indent + TAB + TAB + TAB, exon, i + 1, pw);
        }
        if (isa_gene) {
            ChadoXmlWrite.writePeptide(indent + TAB + TAB + TAB, transcript, curation, pw);
        }
        ChadoXmlWrite.writeFeatureloc(indent + TAB + TAB + TAB, transcript, pw);
        Vector xrefs = transcript.getDbXrefs();
        for (int i = 0; i < xrefs.size(); ++i) {
            xref = (DbXref)xrefs.elementAt(i);
            if (!xref.isSecondary()) continue;
            ChadoXmlWrite.writeXref(indent + TAB + TAB + TAB, xref.getDbName(), xref.getIdValue(), true, xref.getCurrent(), pw);
        }
        ChadoXmlWrite.writeSynonyms(indent + TAB + TAB + TAB, transcript, pw);
        ChadoXmlWrite.writeProperty(indent + TAB + TAB + TAB, "owner", transcript.getOwner(), 0, pw);
        ChadoXmlWrite.writeComments(indent + TAB + TAB + TAB, transcript, pw);
        ChadoXmlWrite.writeProperties(indent + TAB + TAB + TAB, transcript, pw);
        if (isa_gene) {
            ChadoXmlWrite.writeWeirdTranscriptProperties(indent + TAB + TAB + TAB, transcript, pw);
        }
        pw.print(indent + TAB + TAB + "</feature>\n");
        pw.print(indent + TAB + "</subject_id>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB, "relationship type", "partof", pw);
        pw.print(indent + "</feature_relationship>\n");
    }

    private static void writePeptide(String indent, Transcript transcript, CurationSet curation, PrintWriter pw) {
        String checksum;
        SequenceI seq = transcript.getPeptideSequence();
        Protein protFeat = transcript.getProteinFeat();
        if (seq == null) {
            System.err.println("Warning: peptide seq is null for transcript " + transcript.getName() + "--parent annot type is " + transcript.getRefFeature().getTopLevelType());
            return;
        }
        pw.print(indent + "<feature_relationship>\n");
        pw.print(indent + TAB + "<subject_id>\n");
        pw.print(indent + TAB + TAB + "<feature>\n");
        DbXref xref = protFeat.getPrimaryDbXref();
        if (xref != null) {
            ChadoXmlWrite.writeXref(indent + TAB + TAB + TAB, xref.getDbName(), xref.getIdValue(), false, -1, pw);
        }
        pw.print(indent + TAB + TAB + TAB);
        pw.print("<is_analysis>0</is_analysis>\n");
        if (!protFeat.getProperty("is_obsolete").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "is_obsolete", protFeat.getProperty("is_obsolete")));
        }
        if ((checksum = seq.getChecksum()) != null && !checksum.equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "md5checksum", checksum));
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "name", XML_util.transformToPCData((String)seq.getName())));
        ChadoXmlWrite.writeFields(indent + TAB + TAB + TAB, protFeat, pw);
        ChadoXmlWrite.writeOrganismFromFeature(indent + TAB + TAB + TAB, protFeat, curation, pw);
        try {
            if (seq.getResidues() != null && !seq.getResidues().equals("")) {
                pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "residues", seq.getResidues()));
                pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "seqlen", seq.getResidues().length() + ""));
            }
        }
        catch (Exception e) {
            System.err.println("Can't save residues for peptide " + seq.getName() + ": ");
            e.printStackTrace();
        }
        ChadoXmlWrite.writeTimes(indent + TAB + TAB + TAB, protFeat, pw);
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, typeIDOntology, "protein", pw);
        String acc = seq.getAccessionNo();
        if (acc == null || acc.equals("")) {
            acc = seq.getName();
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "uniquename", XML_util.transformToPCData((String)acc)));
        ChadoXmlWrite.writePepFeatloc(indent + TAB + TAB + TAB, protFeat, transcript, pw);
        for (int i = 0; i < protFeat.getDbXrefs().size(); ++i) {
            xref = protFeat.getDbXref(i);
            if (!xref.isSecondary()) continue;
            ChadoXmlWrite.writeXref(indent + TAB + TAB + TAB, xref.getDbName(), xref.getIdValue(), true, xref.getCurrent(), pw);
        }
        ChadoXmlWrite.writeProperties(indent + TAB + TAB + TAB, protFeat, pw);
        ChadoXmlWrite.writeSynonyms(indent + TAB + TAB + TAB, protFeat, pw);
        pw.print(indent + TAB + TAB + "</feature>\n");
        pw.print(indent + TAB + "</subject_id>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB, "relationship type", "producedby", pw);
        pw.print(indent + "</feature_relationship>\n");
    }

    private static void writeExon(String indent, Exon exon, int exonNum, PrintWriter pw) {
        pw.print(indent + "<feature_relationship>\n");
        ChadoXmlWrite.writeExonRank(indent + TAB, exon, pw);
        pw.print(indent + TAB + "<subject_id>\n");
        pw.print(indent + TAB + TAB + "<feature>\n");
        pw.print(indent + TAB + TAB + TAB);
        pw.print("<is_analysis>0</is_analysis>\n");
        if (!exon.getProperty("is_obsolete").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "is_obsolete", exon.getProperty("is_obsolete")));
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "name", XML_util.transformToPCData((String)exon.getName())));
        ChadoXmlWrite.writeFields(indent + TAB + TAB + TAB, exon, pw);
        ChadoXmlWrite.writeOrganismFromFeature(indent + TAB + TAB + TAB, exon, pw);
        int seqlen = exon.getStart() > exon.getEnd() ? exon.getStart() - exon.getEnd() + 1 : exon.getEnd() - exon.getStart() + 1;
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "seqlen", seqlen + ""));
        ChadoXmlWrite.writeTimes(indent + TAB + TAB + TAB, exon, pw);
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, typeIDOntology, "exon", pw);
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "uniquename", exon.getId()));
        ChadoXmlWrite.writeFeatureloc(indent + TAB + TAB + TAB, exon, pw);
        pw.print(indent + TAB + TAB + "</feature>\n");
        pw.print(indent + TAB + "</subject_id>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB, "relationship type", "partof", pw);
        pw.print(indent + "</feature_relationship>\n");
    }

    private static boolean mayHaveBeenEdited(Transcript transcript, CurationSet curation) {
        AnnotatedFeatureI annot = (AnnotatedFeatureI)transcript.getRefFeature();
        return ChadoXmlWrite.someTransactionIncludesThisAnnot(annot, curation);
    }

    private static boolean someTransactionIncludesThisAnnot(AnnotatedFeatureI annotInQuestion, CurationSet curation) {
        if (curation.getTransactionManager() == null) {
            return false;
        }
        boolean edited = false;
        try {
            edited = curation.getTransactionManager().featureHasBeenEdited(annotInQuestion);
        }
        catch (Exception e) {
            System.err.println("Error checking transactions: ");
            e.printStackTrace();
        }
        return edited;
    }

    private static void renameExon(Exon exon, int exonNum, CurationSet curation) {
        exon.setName(nameAdapter.generateName(curation.getAnnots(), curation.getName(), exon));
        exon.setId(nameAdapter.generateId(curation.getAnnots(), curation.getName(), exon));
        ChadoXmlWrite.assignExonRank(exon, exonNum);
    }

    private static void assignExonRank(Exon exon, int rank) {
        exon.replaceProperty("rank", rank + "");
    }

    private static void writeFeatureloc(String indent, SeqFeatureI sf, PrintWriter pw) {
        int strand = sf.getStrand();
        if (sf.getProperty("unstranded").equals("true")) {
            strand = 0;
        }
        if (sf instanceof FeaturePair) {
            FeaturePair fp = (FeaturePair)sf;
            SeqFeatureI query = fp.getQueryFeature();
            SeqFeatureI subject = fp.getHitFeature();
            int start = subject.getLow() - 1;
            int end = subject.getHigh();
            ChadoXmlWrite.writeFeatureloc(indent, start, end, strand, false, false, subject, true, pw);
            start = query.getLow() - 1;
            end = query.getHigh();
            ChadoXmlWrite.writeFeatureloc(indent, start, end, strand, false, false, query, false, pw);
        } else {
            int start = sf.getLow() - 1;
            int end = sf.getHigh();
            if (sf.getProperty("unstranded").equals("true") && sf.getStrand() == -1) {
                System.out.println("Unstranded feature " + sf.getName() + " had its fmax/fmin swapped when it was forced\nonto the minus strand--swapping back for writing.");
                int temp = start;
                start = end - 1;
                end = temp + 1;
            }
            boolean isFminPartial = false;
            boolean isFmaxPartial = false;
            if (sf instanceof Transcript) {
                isFminPartial = ChadoXmlWrite.isPartial((Transcript)sf, "fmin");
                isFmaxPartial = ChadoXmlWrite.isPartial((Transcript)sf, "fmax");
            }
            ChadoXmlWrite.writeFeatureloc(indent, start, end, strand, isFminPartial, isFmaxPartial, sf, false, pw);
        }
    }

    private static void writePepFeatloc(String indent, Protein prot, Transcript trans, PrintWriter pw) {
        Range baseOrientedRange = new Range(-1, -1);
        baseOrientedRange.setStrand(trans.getStrand());
        if (prot.hasTranslationStart()) {
            baseOrientedRange.setStart(prot.getStart());
        } else {
            System.err.println("Warning: no translation start for " + prot.getName() + "--using start of " + trans.getName());
            baseOrientedRange.setStart(trans.getStart());
        }
        if (prot.hasTranslationEnd()) {
            baseOrientedRange.setEnd(prot.getEnd());
        } else {
            System.err.println("Warning: no translation end for " + prot.getName() + "--using end of " + trans.getName());
            baseOrientedRange.setEnd(trans.getEnd());
        }
        RangeI interbaseRange = ChadoXmlWrite.convertToInterbase(baseOrientedRange);
        ChadoXmlWrite.writeFeatureloc(indent, interbaseRange, ChadoXmlWrite.isPartial(trans, "fmin"), ChadoXmlWrite.isPartial(trans, "fmax"), prot, false, pw);
    }

    private static RangeI convertToInterbase(RangeI baseOriented) {
        RangeI interbase = baseOriented.getRangeClone();
        interbase.convertFromBaseOrientedToInterbase();
        return interbase;
    }

    private static void writeFeatureloc(String in, RangeI range, boolean minPart, boolean maxPart, SeqFeatureI feat, boolean isSub, PrintWriter pw) {
        ChadoXmlWrite.writeFeatureloc(in, range.getLow(), range.getHigh(), range.getStrand(), minPart, maxPart, feat, isSub, pw);
    }

    private static void writeFeatureloc(String indent, int start, int end, int strand, boolean is_fmin_partial, boolean is_fmax_partial, SeqFeatureI feat, boolean isSubject, PrintWriter pw) {
        if (start == -1 && end == 0) {
            return;
        }
        pw.print(indent + "<featureloc>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "fmax", end + ""));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "fmin", start + ""));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "is_fmax_partial", is_fmax_partial ? "1" : "0"));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "is_fmin_partial", is_fmin_partial ? "1" : "0"));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "locgroup", "0"));
        if (isSubject) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB, "rank", "1"));
        } else {
            pw.print(ChadoXmlWrite.writeField(indent + TAB, "rank", "0"));
        }
        if (feat.haveExplicitAlignment()) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB, "residue_info", feat.getExplicitAlignment()));
        }
        if (feat != null) {
            ChadoXmlWrite.writeSrcfeatureId(indent + TAB, feat, isSubject, pw);
        }
        if (isSubject) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB, "strand", "1"));
        } else {
            pw.print(ChadoXmlWrite.writeField(indent + TAB, "strand", strand + ""));
        }
        pw.print(indent + "</featureloc>\n");
    }

    private static void writeSrcfeatureId(String indent, SeqFeatureI sf, boolean isSubject, PrintWriter pw) {
        SequenceI seq;
        pw.print(indent + "<srcfeature_id>\n");
        pw.print(indent + TAB + "<feature>\n");
        if (ChadoXmlWrite.isResult(sf)) {
            if (isSubject) {
                pw.print(indent + TAB + TAB + "<is_analysis>1</is_analysis>\n");
                String name = sf.getProperty("ref_name");
                if (name.equals("")) {
                    name = sf.getName();
                }
                pw.print(indent + TAB + TAB + "<name>" + name + "</name>\n");
            } else {
                ChadoXmlWrite.writeXref(indent + TAB + TAB, database, chromosome, false, -1, pw);
            }
        }
        if (isSubject) {
            ChadoXmlWrite.writeOrganism(indent + TAB + TAB, "Computational", "Result", pw);
        } else {
            ChadoXmlWrite.writeOrganismFromFeature(indent + TAB + TAB, sf, pw);
        }
        if (isSubject) {
            seq = sf.getRefSequence();
            if (seq != null) {
                pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB, "residues", seq.getResidues()));
            }
            ChadoXmlWrite.writeTimes(indent + TAB + TAB, sf, pw);
        }
        if (ChadoXmlWrite.isResult(sf)) {
            if (isSubject) {
                ChadoXmlWrite.writeCVtype(indent + TAB + TAB, typeIDOntology, ChadoXmlWrite.typeForResult(sf), pw);
            } else {
                ChadoXmlWrite.writeCVtype(indent + TAB + TAB, typeIDOntology, "chromosome_arm", pw);
            }
            pw.print(indent + TAB + TAB + "<uniquename>" + ChadoXmlWrite.idForResult(sf, true) + "</uniquename>\n");
            if (isSubject) {
                ChadoXmlWrite.writeProperties(indent + TAB + TAB, sf, pw);
                if (sf.getProperty("description").equals("") && (seq = sf.getRefSequence()) != null) {
                    ChadoXmlWrite.writeProperty(indent + TAB + TAB, "description", seq.getDescription(), 0, pw);
                }
            }
        } else {
            ChadoXmlWrite.writeChromArmTypeId(indent + TAB + TAB, sf, pw);
        }
        pw.print(indent + TAB + "</feature>\n");
        pw.print(indent + "</srcfeature_id>\n");
    }

    private static boolean isResult(SeqFeatureI sf) {
        return !(sf instanceof AnnotatedFeature);
    }

    private static String typeForResult(SeqFeatureI result) {
        if (!result.getProperty("ref_type").equals("")) {
            return result.getProperty("ref_type");
        }
        String parent_type = "";
        if (result.getRefFeature() != null) {
            parent_type = result.getRefFeature().getFeatureType();
        }
        return parent_type;
    }

    private static String idForResult(SeqFeatureI result, boolean useRefId) {
        if (useRefId && !result.getProperty("ref_id").equals("")) {
            return result.getProperty("ref_id");
        }
        if (result.getId() != null && !result.getId().equals("")) {
            if ((result.getId().startsWith("result_span") || result.getId().equals("")) && !result.getName().equals("")) {
                return result.getName();
            }
            return result.getId();
        }
        return "";
    }

    private static boolean isPartial(Transcript trans, String which) {
        if (which.equals("fmin")) {
            if (trans.getStrand() == 1 && trans.isMissing5prime()) {
                return true;
            }
            if (trans.getStrand() == -1 && trans.isMissing3prime()) {
                return true;
            }
        } else {
            if (trans.getStrand() == -1 && trans.isMissing5prime()) {
                return true;
            }
            if (trans.getStrand() == 1 && trans.isMissing3prime()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isPartial(Protein prot, String which) {
        if (which.equals("fmin")) {
            if (prot.getProperty("is_fmin_partial").equals("1")) {
                return true;
            }
            if (prot.getProperty("is_fmax_partial").equals("1")) {
                return true;
            }
        }
        return false;
    }

    private static void writeExonRank(String indent, Exon exon, PrintWriter pw) {
        if (!exon.getProperty("rank").equals("")) {
            pw.print(indent + "<rank>" + exon.getProperty("rank") + "</rank>\n");
        } else {
            pw.print(indent + "<rank>0</rank>\n");
        }
    }

    private static void writeChromArmTypeId(String indent, SeqFeatureI sf, PrintWriter pw) {
        pw.print(indent + "<type_id>\n");
        pw.print(indent + TAB + "<cvterm>\n");
        pw.print(indent + TAB + TAB + "<cv_id>\n");
        pw.print(indent + TAB + TAB + TAB + "<cv>\n");
        pw.print(indent + TAB + TAB + TAB + TAB + "<name>" + typeIDOntology + "</name>\n");
        pw.print(indent + TAB + TAB + TAB + "</cv>\n");
        pw.print(indent + TAB + TAB + "</cv_id>\n");
        if (sf.isAnnot()) {
            if (sf.isExon() || sf.isTranscript() || sf.isProtein() || sf.getFeatureType().equalsIgnoreCase("mRNA")) {
                ChadoXmlWrite.writeXref(indent + TAB + TAB, typeIDOntology, IDForDbxref, false, -1, pw);
            }
        } else {
            ChadoXmlWrite.writeXref(indent + TAB + TAB, typeIDOntology, IDForDbxref, false, -1, pw);
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB, "name", "chromosome_arm"));
        pw.print(indent + TAB + "</cvterm>\n");
        pw.print(indent + "</type_id>\n");
        pw.print(ChadoXmlWrite.writeField(indent, "uniquename", chromosome));
    }

    private static void writeSynonyms(String indent, AnnotatedFeatureI feat, PrintWriter pw) {
        Vector syns = feat.getSynonyms();
        for (int i = 0; i < syns.size(); ++i) {
            Synonym syn = (Synonym)syns.elementAt(i);
            ChadoXmlWrite.writeSynonym(indent, feat, feat.getName(), syn, pw);
        }
    }

    private static void writeSynonym(String indent, AnnotatedFeatureI feat, String feature_name, Synonym syn, PrintWriter pw) {
        String pubType;
        if (syn == null) {
            return;
        }
        pw.print(indent + "<feature_synonym>\n");
        syn.setName(XML_util.transformToPCData((String)syn.getName(), (boolean)true));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "is_current", ChadoXmlWrite.getIsCurrent(syn, feature_name)));
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "is_internal", ChadoXmlWrite.getIsInternal(syn)));
        String pub_id = syn.getOwner();
        if (syn == null || syn.equals("")) {
            pub_id = syn.getProperty("author");
        }
        if (syn.equals("")) {
            pub_id = feat.getOwner() != null && !feat.getOwner().equals("") && !feat.getOwner().equals("null") ? feat.getOwner() : defaultSynonymAuthor;
        }
        if ((pubType = syn.getProperty("pub_type")).equals("")) {
            pubType = defaultSynonymPubType;
        }
        ChadoXmlWrite.writePubId(indent + TAB, pub_id, pubType, pw);
        pw.print(indent + TAB + "<synonym_id>\n");
        pw.print(indent + TAB + TAB + "<synonym>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "name", syn.getName()));
        if (syn.getProperty("synonym_sgml").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "synonym_sgml", syn.getName()));
        } else {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "synonym_sgml", syn.getProperty("synonym_sgml")));
        }
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, "synonym type", "synonym", pw);
        pw.print(indent + TAB + TAB + "</synonym>\n");
        pw.print(indent + TAB + "</synonym_id>\n");
        pw.print(indent + "</feature_synonym>\n");
    }

    private static void writePubId(String indent, String id, String pubType, PrintWriter pw) {
        pw.print(indent + "<pub_id>\n");
        pw.print(indent + TAB + "<pub>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB, "pub type", pubType, pw);
        pw.print(indent + TAB + TAB + "<uniquename>" + id + "</uniquename>\n");
        pw.print(indent + TAB + "</pub>\n");
        pw.print(indent + "</pub_id>\n");
    }

    private static String getIsCurrent(Synonym syn, String feature_name) {
        String value = syn.getProperty("is_current");
        if (value != null && !value.equals("")) {
            return value;
        }
        return feature_name.equals(syn.getName()) ? "1" : "0";
    }

    private static String getIsInternal(Synonym syn) {
        String value = syn.getProperty("is_internal");
        if (value != null && !value.equals("")) {
            return value;
        }
        return "0";
    }

    private static void writeResults(CurationSet curation, String indent, PrintWriter pw) {
        StrandedFeatureSetI analyses = curation.getResults();
        if (analyses == null) {
            System.err.println("No results to save.");
            return;
        }
        System.out.println("Saving " + analyses.size() + " types of results");
        if (analyses.size() > 0) {
            Vector genomic_xrefs = curation.getRefSequence().getDbXrefs();
            if (genomic_xrefs != null && genomic_xrefs.size() > 0) {
                DbXref xref = (DbXref)genomic_xrefs.firstElement();
                database = xref.getDbName();
                System.out.println("Set genomic database to " + database + " based on xref for curation's ref seq");
            } else {
                System.err.println("No dbxref for genomic sequence--using default database definition " + database);
            }
            for (int i = 0; i < analyses.size(); ++i) {
                FeatureSetI analysis = (FeatureSetI)analyses.getFeatureAt(i);
                if (analysis.getFeatureType() == null || analysis.getFeatureType().equals("codons") || analysis.getFeatureType().equals("Gene")) continue;
                ChadoXmlWrite.writeAnalysisResults(analysis, indent, pw);
            }
        }
    }

    private static void writeAnalysisResults(FeatureSetI analysis, String indent, PrintWriter pw) {
        String program = analysis.getProgramName();
        if (program == null || program.equals("") || program.equals("no_type")) {
            program = analysis.getProperty("type");
        }
        if (program.equals("") || program.equals("no_type")) {
            program = analysis.getTopLevelType();
        }
        Vector results = analysis.getFeatures();
        for (int i = 0; i < results.size(); ++i) {
            if (results.elementAt(i) instanceof FeatureSetI) {
                FeatureSetI result = (FeatureSetI)results.elementAt(i);
                ChadoXmlWrite.writeResult(result, indent, pw);
                continue;
            }
            System.err.println("writeAnalysisResults: don't know what to do to save non-FeatureSet class " + results.elementAt(i).getClass().getName());
        }
    }

    private static void writeResult(FeatureSetI result, String indent, PrintWriter pw) {
        pw.print(indent + "<feature>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "is_analysis", "1"));
        if (!result.getProperty("is_obsolete").equals("")) {
            pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "is_obsolete", result.getProperty("is_obsolete")));
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "name", XML_util.transformToPCData((String)result.getName())));
        ChadoXmlWrite.writeFields(indent + TAB + TAB + TAB, result, pw);
        ChadoXmlWrite.writeOrganism(indent + TAB, "Computational", "Result", pw);
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "seqlen", "0"));
        ChadoXmlWrite.writeTimes(indent + TAB, result, pw);
        ChadoXmlWrite.writeCVtype(indent + TAB, typeIDOntology, CVTermForResults, pw);
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "uniquename", XML_util.transformToPCData((String)result.getId())));
        ChadoXmlWrite.writeAnalysisFeature(indent + TAB, result, pw);
        Vector spans = result.getFeatures();
        for (int i = 0; i < spans.size(); ++i) {
            SeqFeatureI span = (SeqFeatureI)spans.elementAt(i);
            ChadoXmlWrite.writeSpan(indent + TAB, span, pw);
        }
        pw.print(indent + "</feature>\n");
    }

    private static void writeSpan(String indent, SeqFeatureI span, PrintWriter pw) {
        pw.print(indent + "<feature_relationship>\n");
        pw.print(indent + TAB + "<subject_id>\n");
        pw.print(indent + TAB + TAB + "<feature>\n");
        ChadoXmlWrite.writeOrganism(indent + TAB + TAB + TAB, "Computational", "Result", pw);
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, typeIDOntology, "match", pw);
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "uniquename", XML_util.transformToPCData((String)ChadoXmlWrite.idForResult(span, false))));
        ChadoXmlWrite.writeAnalysisFeature(indent + TAB + TAB + TAB, span, pw);
        ChadoXmlWrite.writeFeatureloc(indent + TAB + TAB + TAB, span, pw);
        pw.print(indent + TAB + TAB + "</feature>\n");
        pw.print(indent + TAB + "</subject_id>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB, "relationship type", "partof", pw);
        pw.print(indent + "</feature_relationship>\n");
    }

    private static void writeOrganismFromFeature(String indent, SeqFeatureI feat, PrintWriter pw) {
        ChadoXmlWrite.writeOrganismFromFeature(indent, feat, null, pw);
    }

    private static void writeOrganismFromFeature(String indent, SeqFeatureI feat, CurationSet curation, PrintWriter pw) {
        String organism = ChadoXmlWrite.getOrganismFromFeature(feat, curation);
        if (organism != null) {
            String genus = organism;
            String species = "";
            if (organism.indexOf(" ") > 0) {
                genus = organism.substring(0, organism.indexOf(" "));
                species = organism.substring(organism.indexOf(" ") + 1);
            }
            ChadoXmlWrite.writeOrganism(indent, genus, species, pw);
        } else {
            System.out.println("Warning: no organism for " + feat.getName() + " (" + feat.getId() + ")");
            organism = Config.getStyle().getParameter("organism");
            if (organism != null && !organism.equals("")) {
                System.out.println("Using default organism for this style: " + organism);
                String genus = organism;
                String species = "";
                if (organism.indexOf(" ") > 0) {
                    genus = organism.substring(0, organism.indexOf(" "));
                    species = organism.substring(organism.indexOf(" ") + 1);
                }
                ChadoXmlWrite.writeOrganism(indent, genus, species, pw);
            }
        }
    }

    private static String getOrganismFromFeature(SeqFeatureI feat, CurationSet curation) {
        SequenceI seq;
        String organism = feat.getProperty("organism");
        if (organism != null && !organism.equals("")) {
            return organism;
        }
        SeqFeatureI parent = feat.getRefFeature();
        if (parent != null && (organism = parent.getProperty("organism")) != null && !organism.equals("")) {
            if (organism.indexOf(" ") > 0) {
                String genus = organism.substring(0, organism.indexOf(" "));
                String species = organism.substring(organism.indexOf(" ") + 1);
                feat.addProperty("organism", genus + " " + species);
            }
            return organism;
        }
        if (feat.isAnnot() && (organism = (seq = feat.getRefSequence()).getOrganism()) != null && !organism.equals("")) {
            if (organism.indexOf(" ") > 0) {
                String genus = organism.substring(0, organism.indexOf(" "));
                String species = organism.substring(organism.indexOf(" ") + 1);
                feat.addProperty("organism", genus + " " + species);
            }
            return organism;
        }
        if (parent != null && (organism = (seq = parent.getRefSequence()).getOrganism()) != null && !organism.equals("")) {
            if (organism.indexOf(" ") > 0) {
                String genus = organism.substring(0, organism.indexOf(" "));
                String species = organism.substring(organism.indexOf(" ") + 1);
                feat.addProperty("organism", genus + " " + species);
                parent.addProperty("organism", genus + " " + species);
            }
            return organism;
        }
        if (curation != null && feat.isAnnot() && (organism = curation.getOrganism()) != null && !organism.equals("")) {
            if (organism.indexOf(" ") > 0) {
                String genus = organism.substring(0, organism.indexOf(" "));
                String species = organism.substring(organism.indexOf(" ") + 1);
                feat.addProperty("organism", genus + " " + species);
                if (parent != null) {
                    parent.addProperty("organism", genus + " " + species);
                }
            }
            return organism;
        }
        return null;
    }

    private static void writeOrganism(String indent, String genus, String species, PrintWriter pw) {
        pw.print(indent + "<organism_id>\n");
        pw.print(indent + TAB + "<organism>\n");
        pw.print(indent + TAB + TAB + "<genus>" + genus + "</genus>\n");
        pw.print(indent + TAB + TAB + "<species>" + species + "</species>\n");
        pw.print(indent + TAB + "</organism>\n");
        pw.print(indent + "</organism_id>\n");
    }

    private static void writeCVtype(String indent, String type, String term, PrintWriter pw) {
        if (term == null || term.equals("")) {
            return;
        }
        pw.print(indent + "<type_id>\n");
        pw.print(indent + TAB + "<cvterm>\n");
        pw.print(indent + TAB + TAB + "<cv_id>\n");
        pw.print(indent + TAB + TAB + TAB + "<cv>\n");
        pw.print(indent + TAB + TAB + TAB + TAB + "<name>" + ChadoXmlWrite.convertToChado(type) + "</name>\n");
        pw.print(indent + TAB + TAB + TAB + "</cv>\n");
        pw.print(indent + TAB + TAB + "</cv_id>\n");
        pw.print(indent + TAB + TAB + "<name>" + term + "</name>\n");
        pw.print(indent + TAB + "</cvterm>\n");
        pw.print(indent + "</type_id>\n");
    }

    private static String convertToChado(String type) {
        if (type.equalsIgnoreCase("cdna")) {
            return "cDNA";
        }
        if (type.equalsIgnoreCase("transcript")) {
            return "mRNA";
        }
        if (type.equalsIgnoreCase("pseudotranscript")) {
            return "mRNA";
        }
        if (type.equalsIgnoreCase("transposon")) {
            return "transposable_element";
        }
        if (type.equalsIgnoreCase("aa")) {
            return "protein";
        }
        if (type.equalsIgnoreCase("misc. non-coding RNA")) {
            return "ncRNA";
        }
        if (type.equalsIgnoreCase("microRNA")) {
            return "nuclear_micro_RNA_coding_gene";
        }
        if (type.equalsIgnoreCase("miscellaneous curator's observation")) {
            return "remark";
        }
        return type;
    }

    private static String annotTypeForChado(AnnotatedFeatureI annot) {
        String type = annot.getTopLevelType();
        if (type.equalsIgnoreCase("pseudogene") || type.equalsIgnoreCase("tRNA") || type.equalsIgnoreCase("snoRNA") || type.equalsIgnoreCase("ncRNA") || type.equalsIgnoreCase("rRNA") || type.equalsIgnoreCase("miRNA") || type.equalsIgnoreCase("snRNA")) {
            return "gene";
        }
        return type;
    }

    private static String transcriptTypeForChado(Transcript transcript) {
        String type = transcript.getTopLevelType();
        if (type.equalsIgnoreCase("gene")) {
            type = "mRNA";
        }
        return type;
    }

    private static void writeAnalysisFeature(String indent, SeqFeatureI sf, PrintWriter pw) {
        double score = sf.getScore();
        pw.print(indent + "<analysisfeature>\n");
        pw.print(indent + TAB + "<analysis_id>\n");
        pw.print(indent + TAB + TAB + "<analysis>\n");
        if (sf.getProgramName() == null || sf.getProgramName().equals("")) {
            sf = sf.getRefFeature();
        }
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "program", sf.getProgramName()));
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "programversion", sf.getProperty("programversion")));
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "sourcename", sf.getDatabase()));
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "sourceversion", sf.getProperty("sourceversion")));
        pw.print(ChadoXmlWrite.writeField(indent + TAB + TAB + TAB, "timeexecuted", sf.getProperty("timeexecuted")));
        pw.print(indent + TAB + TAB + "</analysis>\n");
        pw.print(indent + TAB + "</analysis_id>\n");
        pw.print(ChadoXmlWrite.writeField(indent + TAB, "rawscore", score + ""));
        pw.print(indent + "</analysisfeature>\n");
    }

    private static void writeTimes(String indent, SeqFeatureI sf, PrintWriter pw) {
        pw.print(ChadoXmlWrite.writeField(indent, "timeaccessioned", sf.getProperty("timeaccessioned")));
        pw.print(ChadoXmlWrite.writeField(indent, "timelastmodified", sf.getProperty("timelastmodified")));
    }

    private static void writeProperties(String indent, SeqFeatureI feat, PrintWriter pw) {
        Hashtable props = feat.getPropertiesMulti();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Vector values;
            String type = (String)e.nextElement();
            if (ChadoXmlWrite.isSpecialProperty(type) || type.equals("unstranded") || (values = feat.getPropertyMulti(type)) == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                if (type.equals("dicistronic") && value.equals("false") || value.startsWith(ChadoXmlAdapter.FIELD_LABEL)) continue;
                ChadoXmlWrite.writeProperty(indent, type, value, i, pw);
            }
        }
    }

    private static void writeFields(String indent, SeqFeatureI feat, PrintWriter pw) {
        Hashtable props = feat.getPropertiesMulti();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Vector values;
            String type = (String)e.nextElement();
            if (ChadoXmlWrite.isSpecialProperty(type) || (values = feat.getPropertyMulti(type)) == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                if (!value.startsWith(ChadoXmlAdapter.FIELD_LABEL)) continue;
                pw.print(ChadoXmlWrite.writeField(indent, type, value));
            }
        }
    }

    private static void writeWeirdTranscriptProperties(String indent, Transcript trans, PrintWriter pw) {
        if (trans.readThroughStopResidue() != null) {
            if (trans.readThroughStopResidue().equals("U")) {
                ChadoXmlWrite.writeProperty(indent, "stop_codon_redefinition_as_selenocysteine", "true", 0, pw);
            } else if (trans.readThroughStopResidue().equals("X")) {
                ChadoXmlWrite.writeProperty(indent, "stop_codon_readthrough", "true", 0, pw);
            } else {
                ChadoXmlWrite.writeProperty(indent, "stop_codon_readthrough", trans.readThroughStopResidue(), 0, pw);
            }
        }
        if (trans.plus1FrameShiftPosition() > 0) {
            ChadoXmlWrite.writeProperty(indent, "plus_1_translational_frameshift", trans.plus1FrameShiftPosition() + "", 0, pw);
        }
        if (trans.minus1FrameShiftPosition() > 0) {
            ChadoXmlWrite.writeProperty(indent, "minus_1_translational_frameshift", trans.minus1FrameShiftPosition() + "", 0, pw);
        }
        if (trans.unConventionalStart()) {
            ChadoXmlWrite.writeProperty(indent, "non_canonical_start_codon", trans.getStartCodon(), 0, pw);
        }
        if (trans.isMissing5prime()) {
            ChadoXmlWrite.writeProperty(indent, "missing_start_codon", "true", 0, pw);
        }
        if (trans.isMissing3prime()) {
            ChadoXmlWrite.writeProperty(indent, "missing_stop_codon", "true", 0, pw);
        }
        if ((trans.getNonConsensusAcceptorNum() >= 0 || trans.getNonConsensusDonorNum() >= 0) && trans.getProperty("non_canonical_splice_site").equals("")) {
            ChadoXmlWrite.writeProperty(indent, "non_canonical_splice_site", trans.nonConsensusSplicingOkay() ? "approved" : "unapproved", 0, pw);
        }
        if (trans.isProblematic()) {
            ChadoXmlWrite.writeProperty(indent, "problem", "true", 0, pw);
        }
    }

    public static boolean isSpecialProperty(String prop) {
        if (prop.equalsIgnoreCase("timeaccessioned")) {
            return true;
        }
        if (prop.equalsIgnoreCase("timelastmodified")) {
            return true;
        }
        if (prop.equalsIgnoreCase("seqlen")) {
            return true;
        }
        if (prop.equalsIgnoreCase("is_analysis")) {
            return true;
        }
        if (prop.equalsIgnoreCase("is_obsolete")) {
            return true;
        }
        if (prop.equalsIgnoreCase("uniquename")) {
            return true;
        }
        if (prop.equalsIgnoreCase("name")) {
            return true;
        }
        if (prop.equalsIgnoreCase("organism")) {
            return true;
        }
        if (prop.equalsIgnoreCase("rank")) {
            return true;
        }
        if (prop.equalsIgnoreCase("is_fmin_partial")) {
            return true;
        }
        if (prop.equalsIgnoreCase("is_fmax_partial")) {
            return true;
        }
        if (prop.equalsIgnoreCase("ref_name")) {
            return true;
        }
        if (prop.equalsIgnoreCase("ref_id")) {
            return true;
        }
        if (prop.equalsIgnoreCase("ref_type")) {
            return true;
        }
        if (prop.equalsIgnoreCase("type_id")) {
            return true;
        }
        if (prop.equalsIgnoreCase("programversion")) {
            return true;
        }
        if (prop.equalsIgnoreCase("sourceversion")) {
            return true;
        }
        if (prop.equalsIgnoreCase("timeexecuted")) {
            return true;
        }
        if (prop.equalsIgnoreCase("internal_synonym")) {
            return true;
        }
        return prop.equalsIgnoreCase("readthrough_stop_codon");
    }

    private static void writeProperty(String indent, String prop, String value, int rank, PrintWriter pw) {
        if (value == null || value.equals("")) {
            return;
        }
        if (prop.equals("tag")) {
            prop = "problem";
        }
        pw.print(indent + "<featureprop>\n");
        pw.print(indent + TAB + "<rank>" + rank + "</rank>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB, featurepropCV, prop, pw);
        value = XML_util.transformToPCData((String)value, (boolean)true);
        pw.print(indent + TAB + "<value>" + value + "</value>\n");
        pw.print(indent + "</featureprop>\n");
    }

    private static void writeComments(String indent, AnnotatedFeatureI feat, PrintWriter pw) {
        Vector comments = feat.getComments();
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            pw.print(indent + "<featureprop>\n");
            pw.print(indent + TAB + "<rank>" + i + "</rank>\n");
            ChadoXmlWrite.writeCVtype(indent + TAB, featurepropCV, "comment", pw);
            String commentText = XML_util.transformToPCData((String)comment.getText(), (boolean)true);
            pw.print(indent + TAB + "<value>" + commentText + "</value>\n");
            ChadoXmlWrite.writeFeaturepropPub(indent + TAB, comment.getPerson(), pw);
            pw.print(indent + "</featureprop>\n");
        }
    }

    private static void writeFeaturepropPub(String indent, String id, PrintWriter pw) {
        if (id == null) {
            return;
        }
        pw.print(indent + "<featureprop_pub>\n");
        pw.print(indent + TAB + "<pub_id>\n");
        pw.print(indent + TAB + TAB + "<pub>\n");
        ChadoXmlWrite.writeCVtype(indent + TAB + TAB + TAB, "pub type", defaultSynonymPubType, pw);
        pw.print(indent + TAB + TAB + TAB + "<uniquename>" + id + "</uniquename>\n");
        pw.print(indent + TAB + TAB + "</pub>\n");
        pw.print(indent + TAB + "</pub_id>\n");
        pw.print(indent + "</featureprop_pub>\n");
    }

    private static String writeField(String startingIndent, String name, String value, boolean separateLines) {
        if (name == null || name.equals("")) {
            return "";
        }
        if (value == null || value.equals("") || value.equals(ChadoXmlAdapter.FIELD_LABEL)) {
            return "";
        }
        String field = startingIndent + "<" + name + ">";
        if (separateLines) {
            field = field + "\n" + startingIndent + TAB;
        }
        if (value.startsWith(ChadoXmlAdapter.FIELD_LABEL)) {
            value = value.substring(ChadoXmlAdapter.FIELD_LABEL.length());
        }
        field = field + value;
        if (separateLines) {
            field = field + "\n" + startingIndent;
        }
        field = field + "</" + name + ">" + "\n";
        return field;
    }

    private static String writeField(String startingIndent, String name, String value) {
        return ChadoXmlWrite.writeField(startingIndent, name, value, false);
    }

    private static String writeEnd() {
        return "</chado>\n";
    }

    protected static void saveTransactions(CurationSet curation, String mainFileName) {
        if (curation.getTransactionManager() == null) {
            return;
        }
        try {
            curation.getTransactionManager().coalesce();
            if (curation.getTransactionManager().getTransactions().size() == 0) {
                System.err.println("No transactions to save");
                return;
            }
            if (Config.outputTransactionXML()) {
                ChadoXmlWrite.saveTransactionsInGAME(curation, mainFileName);
            }
            if (Config.isChadoTnOutputNeeded()) {
                ChadoTransactionXMLWriter output = new ChadoTransactionXMLWriter();
                if (curation.isChromosomeArmUsed()) {
                    output.setMapID(curation.getChromosome());
                    output.setMapType("chromosome_arm");
                } else {
                    output.setMapID(curation.getChromosome());
                    output.setMapType("chromosome");
                }
                ((TransactionOutputAdapter)output).setTransformer(new ChadoTransactionTransformer());
                ((TransactionOutputAdapter)output).setTarget(mainFileName);
                output.commitTransactions(curation.getTransactionManager());
            }
        }
        catch (Exception e) {
            System.err.println("ChadoXmlWrite.saveTransactions(): " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Transactions cannot be saved.", "Error", 0);
        }
    }

    private static void saveTransactionsInGAME(CurationSet curationSet, String fileName) {
        try {
            TransactionXMLAdapter tnAdapter = new TransactionXMLAdapter();
            tnAdapter.setFileName(fileName);
            tnAdapter.save(curationSet.getTransactionManager().getTransactions());
        }
        catch (IOException e) {
            System.err.println("saveTransactionsInGAME(): " + e);
            e.printStackTrace();
        }
    }

    static {
        database = defaultChadoDatabase = "FlyBase";
        defaultSynonymAuthor = "gadfly3";
        defaultSynonymPubType = "computer file";
        featurepropCV = "annotation property type";
        TAB = "  ";
        CVTermForResults = "match";
        chromosome = "";
        nameAdapter = null;
        CHADO_XML_VERSION = "FlyBase v1.0, no macros";
        mayHaveBeenEditedMessage = "";
    }
}

