/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chadoxml;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.GmodNameAdapter;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.chadoxml.ChadoXmlAdapterGUI;
import apollo.dataadapter.chadoxml.ChadoXmlUtils;
import apollo.dataadapter.chadoxml.ChadoXmlWrite;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.dataadapter.gamexml.TransactionXMLAdapter;
import apollo.dataadapter.gamexml.XMLParser;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Protein;
import apollo.datamodel.Range;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.datamodel.seq.GAMESequence;
import apollo.main.DataLoader;
import apollo.main.LoadUtil;
import apollo.main.Version;
import apollo.util.HTMLUtil;
import apollo.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;
import org.bdgp.xml.XMLElement;

public class ChadoXmlAdapter
extends AbstractApolloAdapter {
    private ChadoXmlAdapterGUI gui;
    String filename = null;
    static String originalFilename = null;
    StrandedFeatureSetI analyses = null;
    Hashtable all_analyses = null;
    boolean savedGenomicDbxref = false;
    boolean warnedAboutFeatureCvterm = false;
    public static String FIELD_LABEL = "field:";
    boolean NO_GUI = false;
    boolean genomicRegionSet = false;
    private static final IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA, ApolloDataAdapterI.OP_APPEND_DATA};

    public ChadoXmlAdapter() {
        this.setName("Chado XML file (FlyBase v1.0, no macros)");
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (this.gui == null) {
            this.gui = new ChadoXmlAdapterGUI();
        }
        this.gui.setIOOperation(op);
        return this.gui;
    }

    public IOOperation[] getSupportedOperations() {
        return supportedOperations;
    }

    public String getType() {
        return this.getName();
    }

    public void setInput(String inputfile) {
        this.filename = inputfile;
    }

    public String getInput() {
        return this.filename;
    }

    public void setDataInput(DataInput dataInput) {
        super.setDataInput(dataInput);
        this.setInput(dataInput.getInputString());
    }

    public void setOriginalFilename(String file) {
        originalFilename = file;
    }

    private InputStream chadoXmlInputStream(String filename) throws ApolloAdapterException {
        BufferedReader in;
        InputStream stream = null;
        System.err.println("Locating Chado XML datasource...");
        if (filename.startsWith("http")) {
            try {
                URL url = new URL(filename);
                stream = IOUtil.getStreamFromUrl(url, "URL " + url + " not found");
                this.setOriginalFilename(filename);
                return stream;
            }
            catch (Exception e) {
                stream = null;
                throw new ApolloAdapterException("Error: could not open ChadoXML URL " + filename + " for reading.");
            }
        }
        String path = IOUtil.findFile(filename, false);
        try {
            stream = new FileInputStream(path);
            this.setOriginalFilename(path);
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("could not open ChadoXML file " + filename + " for reading.");
        }
        try {
            in = new BufferedReader(new FileReader(path));
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("Error: could not open ChadoXML file " + path + " for reading.");
        }
        if (!this.appearsToBeChadoXML(filename, in)) {
            throw new ApolloAdapterException("File " + filename + "\ndoes not appear to contain chadoXML--couldn't find <chado> line.\n");
        }
        return stream;
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding data..."));
            InputStream xml_stream = this.chadoXmlInputStream(this.getInput());
            return this.getCurationSetFromInputStream(xml_stream);
        }
        catch (ApolloAdapterException dae) {
            System.err.println("Error while parsing " + this.getInput());
            throw dae;
        }
        catch (Exception ex2) {
            System.err.println("Error while parsing " + this.getInput());
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
    }

    public CurationSet getCurationSetFromInputStream(InputStream xml_stream) throws ApolloAdapterException {
        this.genomicRegionSet = false;
        CurationSet curation = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(xml_stream);
            if (!this.NO_GUI) {
                super.clearOldData();
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Reading XML..."));
            XMLParser parser = new XMLParser();
            XMLElement rootElement = parser.readXML(bis);
            if (rootElement == null) {
                String msg = "XML input stream was empty--nothing loaded.";
                System.err.println(msg);
                throw new ApolloAdapterException(msg);
            }
            xml_stream.close();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(40.0), "Populating data models..."));
            curation = new CurationSet();
            this.populateDataModels(rootElement, curation);
            System.out.println("Completed XML parse of " + curation.getName());
            parser.clean();
            rootElement = null;
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(90.0), "Reading transaction file..."));
            TransactionXMLAdapter.loadTransactions(this.getInput(), curation);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(95.0), "Drawing..."));
        }
        catch (ApolloAdapterException dae) {
            System.err.println("Error while parsing " + this.getInput());
            throw dae;
        }
        catch (Exception ex2) {
            System.err.println("Error while parsing " + this.getInput());
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        curation.setInputFilename(originalFilename);
        return curation;
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        boolean okay = false;
        if (this.curation_set == null) {
            String message = "Can't layer ChadoXML data on top of non-ChadoXML data.";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Error", 2);
            return new Boolean(false);
        }
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding new data..."));
            InputStream xml_stream = this.chadoXmlInputStream(this.getInput());
            BufferedInputStream bis = new BufferedInputStream(xml_stream);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Reading XML..."));
            XMLParser parser = new XMLParser();
            XMLElement rootElement = parser.readXML(bis);
            if (rootElement == null) {
                String msg = "XML input stream was empty--nothing loaded.";
                System.err.println(msg);
                throw new ApolloAdapterException(msg);
            }
            xml_stream.close();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(40.0), "Populating data models..."));
            this.populateDataModels(rootElement, this.curation_set);
            System.out.println("Completed XML parse of file " + this.getInput() + " for region " + this.curation_set.getName());
            parser.clean();
            rootElement = null;
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(90.0), "Reading transaction file..."));
            TransactionXMLAdapter.loadTransactions(this.getInput(), this.curation_set);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(95.0), "Drawing..."));
            okay = true;
        }
        catch (ApolloAdapterException dae) {
            System.err.println("Error while parsing " + this.getInput());
            throw dae;
        }
        catch (Exception ex2) {
            System.err.println("Error while parsing " + this.getInput());
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        return new Boolean(okay);
    }

    private void populateDataModels(XMLElement rootElement, CurationSet curation) throws ApolloAdapterException {
        StrandedFeatureSetI results;
        String seq_id = "";
        int start = -1;
        int end = -1;
        String dna = "";
        String arm = "";
        StrandedFeatureSetI annotations = curation.getAnnots();
        if (annotations == null) {
            annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            annotations.setName("Annotations");
            annotations.setFeatureType("Annotation");
            curation.setAnnots(annotations);
        }
        if ((results = curation.getResults()) == null) {
            results = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            this.analyses = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            this.all_analyses = new Hashtable();
        }
        int total = rootElement.numChildren();
        int count = 0;
        while (rootElement.numChildren() > 0) {
            try {
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(40.0 + (double)(++count) / (double)total * 55.0), "Parsing XML element #" + count));
                XMLElement element = rootElement.popChild();
                if (element.getAttribute("name") != null) {
                    try {
                        if (element.getAttribute("name").equalsIgnoreCase("title")) {
                            seq_id = element.getCharData();
                            continue;
                        }
                        if (element.getAttribute("name").equalsIgnoreCase("arm")) {
                            arm = element.getCharData();
                            if (seq_id.equals("")) {
                                seq_id = arm;
                            }
                            if (arm == null || arm.equals("")) continue;
                            curation.setChromosome(arm);
                            continue;
                        }
                        if (element.getAttribute("name").equalsIgnoreCase("fmin")) {
                            try {
                                start = Integer.parseInt(element.getCharData());
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't parse integer from fmin " + element.getCharData() + " in XML element " + count);
                            }
                            continue;
                        }
                        if (element.getAttribute("name").equalsIgnoreCase("fmax")) {
                            try {
                                end = Integer.parseInt(element.getCharData());
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't parse integer from fmax " + element.getCharData() + " in XML element " + count);
                            }
                            continue;
                        }
                        if (!element.getAttribute("name").equalsIgnoreCase("residues")) continue;
                        dna = element.getCharData();
                    }
                    catch (Exception e) {
                        System.err.println("Warning: error parsing map element " + ChadoXmlUtils.printXMLElement(element));
                    }
                    continue;
                }
                if (element.getType().equalsIgnoreCase("feature")) {
                    FeatureSetI feature;
                    if (!this.genomicRegionSet) {
                        this.createGenomicRegion(start, end, seq_id, dna, curation, annotations, results);
                    }
                    if (!((feature = this.processFeature(element, curation)) instanceof AnnotatedFeatureI)) continue;
                    annotations.addFeature(feature);
                    continue;
                }
                if (element.getType().equalsIgnoreCase("cv") || element.getType().equalsIgnoreCase("cvterm") || element.getAttribute("lookup") != null) {
                    String error = "This file includes macros!  I can't deal with macros!\nOffending element: " + ChadoXmlUtils.printXMLElement(element);
                    System.err.println(error);
                    throw new ApolloAdapterException(error);
                }
                System.out.println("Unknown top-level element " + element.getType());
            }
            catch (ApolloAdapterException dae) {
                throw dae;
            }
            catch (Exception ex2) {
                System.err.println("Caught exception while parsing XML:");
                ex2.printStackTrace();
                throw new ApolloAdapterException(ex2.getMessage());
            }
        }
        if (curation.getStart() == curation.getEnd()) {
            String error = "Error: input from " + originalFilename + "\nis not valid Chado XML--couldn't find _appdata fields.\nProbably the input was not actually Chado XML but was actually some other format.\n";
            System.err.println(error);
            throw new ApolloAdapterException(error);
        }
        curation.setResults(this.analyses);
    }

    private void createGenomicRegion(int start, int end, String seq_id, String dna, CurationSet curation, StrandedFeatureSetI annotations, StrandedFeatureSetI results) {
        GAMESequence curated_seq = new GAMESequence(seq_id, Config.getController(), dna);
        curated_seq.setLength(Math.abs(end - start) + 1);
        curated_seq.setName(seq_id);
        curated_seq.setAccessionNo(seq_id);
        curated_seq.setResidueType("DNA");
        curation.setRefSequence(curated_seq);
        curation.addSequence(curated_seq);
        annotations.setRefSequence(curated_seq);
        results.setRefSequence(curated_seq);
        curation.setLow(++start);
        curation.setHigh(end);
        int strand = start < end ? 1 : -1;
        curation.setStrand(strand);
        curation.setName(seq_id);
        this.genomicRegionSet = true;
    }

    private FeatureSetI processFeature(XMLElement xml, CurationSet curation) {
        Vector elements = xml.getChildren();
        boolean isResult = true;
        String type = "";
        String name = "";
        String uniquename = "";
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement child = (XMLElement)elements.elementAt(i);
            if (child.getType().equalsIgnoreCase("is_analysis")) {
                if (child.getCharData().equals("0")) {
                    isResult = false;
                    continue;
                }
                isResult = true;
                continue;
            }
            if (child.getType().equalsIgnoreCase("type_id")) {
                type = this.getDataType(child);
                continue;
            }
            if (child.getType().equalsIgnoreCase("name")) {
                name = child.getCharData();
                continue;
            }
            if (!child.getType().equalsIgnoreCase("uniquename")) continue;
            uniquename = child.getCharData();
        }
        if (isResult) {
            FeatureSet result = new FeatureSet();
            result.addProperty("is_analysis", "1");
            result.setId(uniquename);
            result.setName(name);
            this.processResult(xml, result, curation);
            return result;
        }
        AnnotatedFeature annot = new AnnotatedFeature();
        annot.setId(uniquename);
        annot.setName(name);
        annot.setFeatureType(type);
        annot.setTopLevelType(type);
        this.processAnnot(xml, annot, curation);
        return annot;
    }

    private FeatureSetI processResult(XMLElement xml, FeatureSetI result, CurationSet curation) {
        Vector elements = xml.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement child = (XMLElement)elements.elementAt(i);
            if (child.getType().equalsIgnoreCase("featureloc")) {
                System.out.println("How weird--a featureloc right under a result for " + ChadoXmlUtils.printXMLElement(xml));
                return null;
            }
            if (child.getType().equalsIgnoreCase("name")) {
                result.setName(child.getCharData());
                continue;
            }
            if (child.getType().equalsIgnoreCase("uniquename")) {
                result.setId(child.getCharData());
                continue;
            }
            if (child.getType().equalsIgnoreCase("analysisfeature")) {
                this.handleAnalysisType(child, result);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_relationship")) {
                SeqFeatureI seqFeat = this.getSeqFeature(child, result, curation);
                result.addFeature(seqFeat);
                result.setStrand(seqFeat.getStrand());
                continue;
            }
            if (child.getCharData().equals("")) continue;
            this.addField(result, child);
        }
        this.addResultToAnalysis(result);
        return result;
    }

    private AnnotatedFeatureI processAnnot(XMLElement xml, AnnotatedFeature annot, CurationSet curation) {
        boolean gotFeatureloc = false;
        annot.addProperty("is_analysis", "0");
        Vector elements = xml.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement child = (XMLElement)elements.elementAt(i);
            if (child.getType().equalsIgnoreCase("dbxref_id")) {
                DbXref xref = this.getDbxref(child, annot, true);
                if (xref == null) continue;
                String dbxref = xref.getIdValue();
                if (annot.getId() != null && !dbxref.equals(annot.getId())) {
                    System.err.println("Warning: annot's dbxref_id " + dbxref + " doesn't match its uniquename " + annot.getId());
                    continue;
                }
                annot.setId(dbxref);
                continue;
            }
            if (child.getType().equalsIgnoreCase("uniquename")) {
                if (annot.getId() != null && !annot.getId().equals(child.getCharData())) {
                    System.err.println("Warning: annot's primary xref id " + annot.getId() + " doesn't match its uniquename " + child.getCharData());
                    System.err.println("Using new uniquename " + child.getCharData() + " as the annotation id");
                }
                annot.setId(child.getCharData());
                continue;
            }
            if (child.getType().equalsIgnoreCase("featureloc")) {
                gotFeatureloc = true;
                this.handleFeatureLoc(child, annot, curation);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_relationship")) {
                Transcript transcript = this.getTranscript(child, curation);
                String transcriptType = transcript.getTopLevelType();
                annot.addFeature(transcript);
                annot.setStrand(transcript.getStrand());
                annot.setFeatureType(transcriptType);
                annot.setTopLevelType(transcriptType);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_synonym")) {
                Synonym syn = this.getSynonym(child);
                annot.addSynonym(syn);
                continue;
            }
            if (child.getType().equalsIgnoreCase("featureprop")) {
                this.getProperty(child, annot);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_dbxref")) {
                this.getDbxref(child, annot, false);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_cvterm")) {
                if (this.warnedAboutFeatureCvterm) continue;
                System.err.println("Warning: not handling feature_cvterm(s) for annot " + annot.getId());
                this.warnedAboutFeatureCvterm = true;
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_pub")) {
                System.err.println("Warning: not handling feature_pub for annot " + annot.getId());
                continue;
            }
            if (child.getType().equalsIgnoreCase("organism_id")) {
                this.getOrganism(child, annot);
                if (curation.getOrganism() != null && !curation.getOrganism().equals("")) continue;
                curation.setOrganism(annot.getProperty("organism"));
                continue;
            }
            if (child.getCharData().equals("")) continue;
            this.addField(annot, child);
        }
        if (!gotFeatureloc) {
            System.out.println("Warning: " + annot.getFeatureType() + " annotation " + annot.getName() + " (" + annot.getId() + ") has no start/end positions!");
            if (annot.getStrand() == 0) {
                annot.addProperty("unstranded", "true");
                annot.setStrand(1);
            }
            annot.setStart(0);
            annot.setEnd(0);
            return annot;
        }
        this.warnIfOneLevelDiscrepancy(annot);
        this.forceStrandIfNeeded(annot);
        if (annot.getName().equals("no_name") && annot.getId() != null) {
            System.out.println("Warning: annot with uniquename " + annot.getId() + " has no name--using uniquename as name.");
            annot.setName(annot.getId());
        }
        return annot;
    }

    private void warnIfOneLevelDiscrepancy(SeqFeature annot) {
        FeatureProperty fp;
        if ((annot.getFeatures() == null || annot.getFeatures().size() == 0) && (fp = Config.getPropertyScheme().getFeatureProperty(annot.getFeatureType())).getNumberOfLevels() != 1) {
            IOUtil.errorDialog("Annotation " + annot.getName() + " is one-level, but type " + annot.getFeatureType() + "\ndoes not have 'number_of_levels: 1' in tiers file " + Config.getStyle().getTiersFile() + ".\nEither the data is buggy or your tiers file is out of date.");
        }
    }

    private String getDataType(XMLElement xml) {
        if (!xml.getType().equalsIgnoreCase("type_id") && (xml = this.getChild(xml, "type_id")) == null) {
            return null;
        }
        XMLElement child = (XMLElement)xml.getChildren().firstElement();
        XMLElement grandchild2 = this.getChild(child, "name");
        return grandchild2.getCharData();
    }

    private DbXref getDbxref(XMLElement xml, SeqFeature feature, boolean is_primary_dbxref) {
        XMLElement current;
        Vector grandchildren;
        Vector children = xml.getChildren();
        if (children == null) {
            System.out.println("getDbxref: no children of " + ChadoXmlUtils.printXMLElement(xml));
            return null;
        }
        XMLElement child = (XMLElement)children.firstElement();
        if (!is_primary_dbxref) {
            child = this.getChild(child, "dbxref");
        }
        if ((grandchildren = child.getChildren()) == null) {
            System.out.println("getDbxref: no grandchildren of " + ChadoXmlUtils.printXMLElement(xml));
            return null;
        }
        XMLElement grandchild = (XMLElement)grandchildren.firstElement();
        if (!grandchild.getType().equalsIgnoreCase("accession")) {
            System.out.println("Grandchild of dbxref_id is not accession: " + ChadoXmlUtils.printXMLElement(grandchild));
            return null;
        }
        String acc = grandchild.getCharData();
        XMLElement db_xml = this.getChild(child, "db_id");
        String db = "";
        if (db_xml != null) {
            db = this.getDb(db_xml);
        }
        int isCurrent = 1;
        if (!is_primary_dbxref && (current = this.getChild(xml, "is_current")) != null) {
            try {
                isCurrent = Integer.parseInt(current.getCharData());
            }
            catch (Exception e) {
                System.out.println("Couldn't parse integer from is_current " + current + " for acc " + acc);
            }
        }
        if (db != null && !db.equals("") && acc != null && !acc.equals("")) {
            DbXref xref = new DbXref("id", acc, db);
            if (is_primary_dbxref) {
                xref.setIsPrimary(true);
                xref.setIsSecondary(false);
            } else {
                DbXref primary = feature.getPrimaryDbXref();
                if (primary != null && primary.getIdValue().equals(acc)) {
                    primary.setIsSecondary(true);
                    xref = primary;
                }
            }
            xref.setCurrent(isCurrent);
            if (feature != null) {
                feature.addDbXref(xref);
            }
            return xref;
        }
        return null;
    }

    private String getDb(XMLElement xml) {
        XMLElement name = this.getGrandchild(xml, -1, "name");
        if (name == null) {
            return "";
        }
        return name.getCharData();
    }

    private void handleFeatureLoc(XMLElement xml, SeqFeatureI feature, CurationSet curation) {
        Vector children = xml.getChildren();
        int start = -1;
        int end = -1;
        int strand = 1;
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            try {
                if (child.getType().equalsIgnoreCase("fmin")) {
                    try {
                        start = Integer.parseInt(child.getCharData()) + 1;
                        feature.setLow(start);
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't parse integer from fmin " + child.getCharData());
                    }
                    continue;
                }
                if (child.getType().equalsIgnoreCase("fmax")) {
                    try {
                        end = Integer.parseInt(child.getCharData());
                        feature.setHigh(end);
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't parse integer from fmax " + child.getCharData());
                    }
                    continue;
                }
                if (child.getType().equalsIgnoreCase("strand")) {
                    try {
                        strand = Integer.parseInt(child.getCharData());
                        feature.setStrand(strand);
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't parse integer from strand " + child.getCharData());
                    }
                    continue;
                }
                if (this.isAnalysis(feature) && child.getType().equalsIgnoreCase("rank")) {
                    feature.addProperty(child.getType(), child.getCharData());
                    continue;
                }
                if (child.getType().equalsIgnoreCase("residue_info")) {
                    String residues = child.getCharData();
                    feature.setExplicitAlignment(residues);
                    continue;
                }
                if (child.getType().equalsIgnoreCase("srcfeature_id")) {
                    if (!this.isAnalysis(feature)) continue;
                    this.handleSrcFeature(child, feature, curation);
                    continue;
                }
                if (!child.getType().equalsIgnoreCase("is_fmin_partial") && !child.getType().equalsIgnoreCase("is_fmax_partial")) continue;
                feature.addProperty(child.getType(), child.getCharData());
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception handling featureloc " + ChadoXmlUtils.printXMLElement(xml));
            }
        }
    }

    void handleSrcFeature(XMLElement xml, SeqFeatureI feat, CurationSet curation) {
        XMLElement xml_feature = this.getChild(xml, "feature");
        if (xml == null) {
            System.err.println("handleSrcFeature: couldn't find feature child of " + ChadoXmlUtils.printXMLElement(xml));
            return;
        }
        Vector children = xml_feature.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            try {
                if (child.getType().equalsIgnoreCase("is_analysis")) continue;
                if (child.getType().equalsIgnoreCase("name")) {
                    feat.replaceProperty("ref_name", child.getCharData());
                    SequenceI seq = feat.getRefSequence();
                    if (seq == null) {
                        seq = new Sequence(feat.getName(), "");
                        feat.setRefSequence(seq);
                    }
                    seq.setName(child.getCharData());
                    continue;
                }
                if (child.getType().equalsIgnoreCase("uniquename")) {
                    feat.replaceProperty("ref_id", child.getCharData());
                    continue;
                }
                if (child.getType().equalsIgnoreCase("dbxref_id")) {
                    DbXref xref;
                    if (this.savedGenomicDbxref || !feat.getProperty("rank").equals("0") || (xref = this.getDbxref(child, null, true)) == null) continue;
                    curation.getRefSequence().addDbXref(xref);
                    this.savedGenomicDbxref = true;
                    continue;
                }
                if (child.getType().equalsIgnoreCase("organism_id")) {
                    this.getOrganism(child, feat);
                    continue;
                }
                if (child.getType().equalsIgnoreCase("type_id")) {
                    String type = this.getDataType(child);
                    feat.addProperty("ref_type", type);
                    continue;
                }
                if (child.getType().equalsIgnoreCase("residues")) {
                    String residues = child.getCharData();
                    SequenceI seq = feat.getRefSequence();
                    if (seq == null) {
                        seq = new Sequence(feat.getName(), residues);
                        feat.setRefSequence(seq);
                        continue;
                    }
                    seq.setResidues(residues);
                    continue;
                }
                if (!child.getType().equalsIgnoreCase("featureprop")) continue;
                this.getProperty(child, feat);
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception handling srcfeature_id " + ChadoXmlUtils.printXMLElement(child) + ":\n " + e);
            }
        }
    }

    private boolean isAnalysis(SeqFeatureI feat) {
        return !feat.getProperty("is_analysis").equals("") && !feat.getProperty("is_analysis").equals("0") && !feat.getProperty("is_analysis").equals(FIELD_LABEL + "0");
    }

    private void addField(SeqFeatureI feat, XMLElement xml) {
        String type = xml.getType();
        String value = xml.getCharData();
        if (!ChadoXmlWrite.isSpecialProperty(type)) {
            value = FIELD_LABEL + value;
        }
        feat.addProperty(type, value);
    }

    private Transcript getTranscript(XMLElement xml, CurationSet curation) {
        Transcript transcript = new Transcript();
        transcript.setRefSequence(curation.getRefSequence());
        transcript.addProperty("is_analysis", "0");
        Vector children = xml.getChildren();
        Vector grandchildren = null;
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            if (!child.getType().equalsIgnoreCase("subject_id")) continue;
            grandchildren = child.getChildren();
            if (grandchildren == null) {
                System.out.println("getTranscript: no grandchildren for " + ChadoXmlUtils.printXMLElement(xml));
                return transcript;
            }
            XMLElement xml_feature = (XMLElement)grandchildren.firstElement();
            if (!xml_feature.getType().equalsIgnoreCase("feature")) {
                System.out.println("getTranscript: found non-feature child " + ChadoXmlUtils.printXMLElement(xml_feature) + "\n of subject_id " + ChadoXmlUtils.printXMLElement(child));
                return null;
            }
            Vector transcript_parts = xml_feature.getChildren();
            for (int j = 0; j < transcript_parts.size(); ++j) {
                SequenceI seq;
                XMLElement tp = (XMLElement)transcript_parts.elementAt(j);
                if (tp.getType().equalsIgnoreCase("dbxref_id")) {
                    DbXref xref = this.getDbxref(tp, transcript, true);
                    if (xref == null) continue;
                    transcript.setId(xref.getIdValue());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("uniquename")) {
                    if (tp.getCharData().equals(transcript.getId())) continue;
                    System.err.println("Warning: uniquename " + tp.getCharData() + " doesn't match transcript's dbxref_id " + transcript.getId());
                    transcript.setId(tp.getCharData());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("name")) {
                    transcript.setName(tp.getCharData());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("type_id")) {
                    String type = this.getDataType(tp);
                    if (type.equalsIgnoreCase("mRNA")) {
                        transcript.setTopLevelType("gene");
                        continue;
                    }
                    transcript.setTopLevelType(type);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("md5checksum")) {
                    String checksum = tp.getCharData();
                    if (checksum == null || checksum.equals("")) continue;
                    seq = transcript.get_cDNASequence();
                    if (seq == null) {
                        seq = new Sequence(transcript.getId(), "");
                        transcript.set_cDNASequence(seq);
                    }
                    seq.setChecksum(checksum);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("residues")) {
                    String dna = tp.getCharData();
                    seq = transcript.get_cDNASequence();
                    if (seq == null) {
                        seq = new Sequence(transcript.getId(), dna);
                        transcript.set_cDNASequence(seq);
                    } else {
                        seq.setResidues(dna);
                    }
                    seq.setLength(dna.length());
                    if (transcript.getId() != null && !transcript.getId().equals("")) {
                        seq.setAccessionNo(transcript.getId());
                    }
                    seq.setResidueType("DNA");
                    curation.addSequence(seq);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("seqlen")) continue;
                if (tp.getType().equalsIgnoreCase("feature_relationship")) {
                    XMLElement subject_id;
                    String type;
                    XMLElement rank = this.getChild(tp, "rank");
                    if (rank != null) {
                        transcript.addProperty(tp.getType(), tp.getCharData());
                    }
                    if ((type = this.getDataType(this.getGrandchild(subject_id = this.getChild(tp, "subject_id"), "type_id"))).equalsIgnoreCase("exon")) {
                        ExonI exon = this.getExon(tp, curation.getRefSequence());
                        transcript.addExon(exon);
                        if (transcript.getStrand() != 0 && exon.getStrand() != transcript.getStrand()) {
                            System.err.println("Warning: strand for " + exon + " doesn't match strand " + transcript.getStrand() + " for transcript " + transcript);
                        }
                        transcript.setStrand(exon.getStrand());
                        continue;
                    }
                    if (type.equalsIgnoreCase("protein")) {
                        this.addPeptide(this.getChild(subject_id, 0, null), transcript, curation);
                        continue;
                    }
                    System.out.println("Don't know how to handle child type " + type + " for transcript " + transcript.getId());
                    continue;
                }
                if (tp.getType().equals("featureloc")) {
                    this.handleFeatureLoc(tp, transcript, curation);
                    if (transcript.get_cDNASequence() == null) {
                        Sequence seq2 = new Sequence(transcript.getId(), "");
                        transcript.set_cDNASequence(seq2);
                        continue;
                    }
                    transcript.get_cDNASequence().setRange(new Range(transcript.getLow(), transcript.getHigh()));
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("feature_dbxref")) {
                    this.getDbxref(tp, transcript, false);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("feature_synonym")) {
                    Synonym syn = this.getSynonym(tp);
                    transcript.addSynonym(syn);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("featureprop")) {
                    this.getProperty(tp, transcript);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("feature_cvterm")) {
                    if (this.warnedAboutFeatureCvterm) continue;
                    System.err.println("Warning: not handling feature_cvterm for transcript " + transcript.getId());
                    this.warnedAboutFeatureCvterm = true;
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("feature_pub")) {
                    System.err.println("Warning: not handling feature_pub for transcript " + transcript.getId());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("organism_id")) {
                    this.getOrganism(tp, transcript);
                    continue;
                }
                if (tp.getCharData().equals("")) continue;
                this.addField(transcript, tp);
            }
        }
        if (transcript.isMissing5prime()) {
            transcript.calcTranslationStartForLongestPeptide();
        }
        return transcript;
    }

    private ExonI getExon(XMLElement xml, SequenceI refSeq) {
        Exon exon = new Exon();
        exon.setRefSequence(refSeq);
        exon.addProperty("is_analysis", "0");
        Vector children = xml.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            if (child.getType().equalsIgnoreCase("rank")) {
                exon.addProperty(child.getType(), child.getCharData());
                continue;
            }
            if (!child.getType().equalsIgnoreCase("subject_id")) continue;
            Vector grandchildren = child.getChildren();
            if (grandchildren == null) {
                System.out.println("getExon: no grandchildren for " + ChadoXmlUtils.printXMLElement(xml));
                return exon;
            }
            XMLElement xml_feature = (XMLElement)grandchildren.firstElement();
            if (!xml_feature.getType().equalsIgnoreCase("feature")) {
                System.out.println("Wrong child " + ChadoXmlUtils.printXMLElement(xml_feature) + " of subject_id " + ChadoXmlUtils.printXMLElement(child));
                return exon;
            }
            Vector exon_parts = xml_feature.getChildren();
            for (int j = 0; j < exon_parts.size(); ++j) {
                XMLElement ep = (XMLElement)exon_parts.elementAt(j);
                if (ep.getType().equalsIgnoreCase("name")) {
                    exon.setName(ep.getCharData());
                    continue;
                }
                if (ep.getType().equalsIgnoreCase("uniquename")) {
                    exon.setId(ep.getCharData());
                    continue;
                }
                if (ep.getType().equals("featureloc")) {
                    this.handleFeatureLoc(ep, exon, null);
                    continue;
                }
                if (ep.getType().equalsIgnoreCase("organism_id")) {
                    this.getOrganism(ep, exon);
                    continue;
                }
                if (ep.getCharData().equals("")) continue;
                this.addField(exon, ep);
            }
        }
        return exon;
    }

    private void addPeptide(XMLElement xml, Transcript transcript, CurationSet curation) {
        String seq_id = "";
        Sequence seq = new Sequence(seq_id, "");
        Protein protFeat = transcript.getProteinFeat();
        Vector children = xml.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            if (child.getType().equalsIgnoreCase("uniquename")) {
                seq_id = child.getCharData();
                if (seq_id == null || seq_id.equals("")) continue;
                seq.setAccessionNo(seq_id);
                continue;
            }
            if (child.getType().equalsIgnoreCase("dbxref_id")) {
                DbXref xref = this.getDbxref(child, protFeat, true);
                if (xref == null || (seq_id = xref.getIdValue()) == null || seq_id.equals("")) continue;
                seq.setAccessionNo(seq_id);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_dbxref")) {
                this.getDbxref(child, protFeat, false);
                continue;
            }
            if (child.getType().equalsIgnoreCase("residues")) {
                seq.setResidues(child.getCharData());
                seq.setResidueType("AA");
                continue;
            }
            if (child.getType().equalsIgnoreCase("name")) {
                seq.setName(child.getCharData());
                continue;
            }
            if (child.getType().equalsIgnoreCase("md5checksum")) {
                String checksum = child.getCharData();
                if (checksum == null || checksum.equals("")) continue;
                seq.setChecksum(checksum);
                continue;
            }
            if (child.getType().equalsIgnoreCase("featureloc")) {
                Vector fchildren = child.getChildren();
                int start = -1;
                int end = -1;
                int strand = 1;
                for (int j = 0; j < fchildren.size(); ++j) {
                    XMLElement fchild = (XMLElement)fchildren.elementAt(j);
                    try {
                        if (fchild.getType().equalsIgnoreCase("fmin")) {
                            try {
                                start = Integer.parseInt(fchild.getCharData()) + 1;
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't parse integer from fmin " + child.getCharData());
                            }
                            continue;
                        }
                        if (fchild.getType().equalsIgnoreCase("fmax")) {
                            try {
                                end = Integer.parseInt(fchild.getCharData());
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't parse integer from fmax " + child.getCharData());
                            }
                            continue;
                        }
                        if (fchild.getType().equalsIgnoreCase("strand")) {
                            try {
                                strand = Integer.parseInt(fchild.getCharData());
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't parse integer from strand " + child.getCharData());
                            }
                            continue;
                        }
                        if (!fchild.getType().equalsIgnoreCase("is_fmin_partial") && !fchild.getType().equalsIgnoreCase("is_fmax_partial")) continue;
                        protFeat.addProperty(fchild.getType(), fchild.getCharData());
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Exception handling featureloc " + ChadoXmlUtils.printXMLElement(fchild));
                    }
                }
                seq.setRange(new Range(start, end));
                transcript.setPeptideSequence(seq);
                curation.addSequence(seq);
                boolean missing5prime = false;
                boolean missing3prime = false;
                if (protFeat.getProperty("is_fmin_partial").equals("1") && strand == 1 || protFeat.getProperty("is_fmax_partial").equals("1") && strand == -1) {
                    missing5prime = true;
                }
                if (protFeat.getProperty("is_fmax_partial").equals("1") && strand == 1 || protFeat.getProperty("is_fmin_partial").equals("1") && strand == -1) {
                    missing3prime = true;
                }
                if (transcript.getProperty("missing_start_codon").equals("true") || missing5prime) {
                    transcript.setMissing5prime(true);
                    System.out.println(seq.getName() + " has now been marked as missing start codon");
                } else if (!missing3prime) {
                    boolean foundTranslationStart = false;
                    foundTranslationStart = strand == 1 ? transcript.setTranslationStart(start, false) : transcript.setTranslationStart(end, false);
                    if (!foundTranslationStart) {
                        System.out.println("Warning: couldn't set translation start to " + (strand == 1 ? start : end) + " for transcript " + transcript.getName());
                    } else if (transcript.isTransSpliced()) {
                        System.err.println("Dealing with trans-spliced transcript " + transcript.getName());
                        transcript.sortTransSpliced();
                    }
                }
                if (transcript.getProperty("missing_stop_codon").equals("true") || missing3prime) {
                    transcript.setMissing3prime(true);
                    continue;
                }
                if (strand == 1) {
                    transcript.setTranslationEnd(end + 1);
                    continue;
                }
                transcript.setTranslationEnd(start - 1);
                continue;
            }
            if (child.getType().equalsIgnoreCase("feature_synonym")) {
                Synonym synonym = this.getSynonym(child);
                protFeat.addSynonym(synonym);
                continue;
            }
            if (child.getType().equalsIgnoreCase("organism_id")) {
                this.getOrganism(child, seq);
                continue;
            }
            if (child.getCharData().equals("")) continue;
            this.addField(protFeat, child);
        }
    }

    private void forceStrandIfNeeded(AnnotatedFeatureI annot) {
        if (annot.getStrand() == 0) {
            annot.addProperty("unstranded", "true");
            int strand = 1;
            if (annot.getStart() > annot.getEnd()) {
                strand = -1;
                int temp = annot.getStart();
                annot.setStart(annot.getEnd());
                annot.setEnd(temp);
                System.out.println("Had to swap start and end for unstranded feature " + annot.getName() + " because start>end");
            }
            annot.setStrand(strand);
            System.out.println("Annot " + annot.getName() + " (" + annot.getId() + ") is unstranded--showing on " + strand + " strand.  start = " + annot.getStart() + ", end = " + annot.getEnd());
        }
    }

    private Synonym getSynonym(XMLElement xml) {
        Synonym syn = new Synonym();
        Vector children = xml.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            if (child.getType().equalsIgnoreCase("synonym_id")) {
                XMLElement nameElement = this.getGrandchild(child, "name");
                String name = nameElement.getCharData();
                name = HTMLUtil.replaceSGMLWithGreekLetter(name);
                syn.setName(name);
                XMLElement sgml = this.getGrandchild(child, "synonym_sgml");
                if (sgml != null) {
                    syn.addProperty("synonym_sgml", sgml.getCharData());
                    continue;
                }
                syn.addProperty("synonym_sgml", name);
                continue;
            }
            if (child.getType().equalsIgnoreCase("pub_id")) {
                syn.setOwner(this.getSynonymAuthor(child));
                String pubType = this.getPubType(child);
                if (pubType == null) continue;
                syn.addProperty("pub_type", pubType);
                continue;
            }
            if (child.getCharData() == null || child.getCharData().equals("")) continue;
            syn.addProperty(child.getType(), child.getCharData());
        }
        return syn;
    }

    private String getProperty(XMLElement xml, SeqFeatureI feature) {
        XMLElement type_id = this.getChild(xml, "type_id");
        String val = null;
        if (type_id == null) {
            System.out.println("getProperty: couldn't find grandchild type_id of node " + ChadoXmlUtils.printXMLElement(xml));
            return null;
        }
        String prop = this.getDataType(type_id);
        XMLElement value = this.getChild(xml, "value");
        if (value == null) {
            return null;
        }
        val = value.getCharData();
        if (this.handleSpecialProp(xml, prop, val, feature)) {
            return val;
        }
        if (feature != null) {
            feature.addProperty(prop, val);
        }
        return val;
    }

    private boolean handleSpecialProp(XMLElement xml, String prop, String val, SeqFeatureI feature) {
        if (prop.equalsIgnoreCase("comment")) {
            if (!(feature instanceof AnnotatedFeatureI)) {
                System.err.println("Can't add comment " + val + " to non-annotation feature " + feature);
                feature.addProperty(prop, val);
                return true;
            }
            Comment comment = new Comment();
            comment.setText(val);
            if (val.indexOf("nternal view only") > 0) {
                comment.setIsInternal(true);
            }
            String curator = this.getCurator(this.getChild(xml, "featureprop_pub"));
            comment.setPerson(curator);
            if (val.indexOf("TS") > 0) {
                String timestring = val.substring(val.indexOf("TS") + 3);
                try {
                    long time = Long.parseLong(timestring);
                    comment.setTimeStamp(time);
                }
                catch (NumberFormatException e) {
                    System.err.println("Warning: error parsing timestamp " + timestring + " from comment " + val);
                }
            }
            ((AnnotatedFeatureI)feature).addComment(comment);
            return true;
        }
        if (prop.equalsIgnoreCase("owner")) {
            if (feature instanceof AnnotatedFeatureI) {
                ((AnnotatedFeatureI)feature).setOwner(val);
                return true;
            }
        } else {
            if (prop.equalsIgnoreCase("problem") && feature instanceof AnnotatedFeatureI) {
                if (val.equals("true") || val.equals("t")) {
                    ((AnnotatedFeatureI)feature).setIsProblematic(true);
                } else {
                    System.err.println("Warning: non-boolean value for problem for annotation or transcript " + feature.getName() + "--can't save it.");
                }
                return true;
            }
            if (prop.equalsIgnoreCase("problem")) {
                ((SeqFeature)feature).addProperty("tag", val);
                return true;
            }
            if (prop.equalsIgnoreCase("description")) {
                this.addDescription(feature, val);
            } else {
                if (prop.equalsIgnoreCase("non_canonical_start_codon") && feature instanceof Transcript) {
                    System.err.println("Warning: not yet doing anything with non_canonical_start_codon property--\nnormally this is derived by Apollo.");
                    return true;
                }
                if (prop.equalsIgnoreCase("non_canonical_splice_site") && feature instanceof Transcript) {
                    System.out.println("Marking non_canonical_splice_site " + (val.equalsIgnoreCase("approved") ? "approved" : "unapproved") + " for transcript " + feature.getName());
                    ((Transcript)feature).nonConsensusSplicingOkay(val.equalsIgnoreCase("approved"));
                    return true;
                }
                if ((prop.equalsIgnoreCase("plus_1_translational_frame_shift") || prop.equalsIgnoreCase("plus1_translational_frame_shift") || prop.equalsIgnoreCase("plus_1_translational_frameshift")) && feature instanceof Transcript) {
                    try {
                        int plus1_frameshift = Integer.parseInt(val);
                        System.out.println("Marking plus_1_translational_frameshift = " + plus1_frameshift + " for transcript " + feature.getName());
                        ((Transcript)feature).setPlus1FrameShiftPosition(plus1_frameshift);
                    }
                    catch (Error e) {
                        System.out.println("Couldn't parse plus_1_translational_frameshift value " + val + "--not an integer");
                    }
                    return true;
                }
                if ((prop.equalsIgnoreCase("minus_1_translational_frame_shift") || prop.equalsIgnoreCase("minus1_translational_frame_shift") || prop.equalsIgnoreCase("minus_1_translational_frameshift")) && feature instanceof Transcript) {
                    try {
                        int minus1_frameshift = Integer.parseInt(val);
                        System.out.println("Marking minus_1_translational_frameshift = " + minus1_frameshift + " for transcript " + feature.getName());
                        ((Transcript)feature).setMinus1FrameShiftPosition(minus1_frameshift);
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't parse minus_1_translational_frameshift value " + val + "--not an integer");
                    }
                    return true;
                }
                if (prop.equalsIgnoreCase("stop_codon_redefinition_as_selenocysteine") && feature instanceof Transcript) {
                    boolean seleno;
                    boolean bl = seleno = val.toLowerCase().startsWith("t") || val.equalsIgnoreCase("U");
                    if (seleno) {
                        System.out.println("Got stop_codon_redefinition_as_selenocysteine for transcript " + feature.getName());
                        ((Transcript)feature).setReadThroughStop("U");
                        return true;
                    }
                } else {
                    if (feature instanceof Transcript && (prop.equalsIgnoreCase("stop_codon_readthrough") || prop.equalsIgnoreCase("readthrough_stop_codon"))) {
                        System.out.println("Got stop_codon_readthrough = " + val + " for transcript " + feature.getName());
                        ((Transcript)feature).setReadThroughStop(val);
                        return true;
                    }
                    if (feature instanceof Transcript && prop.equalsIgnoreCase("missing_start_codon") && val.equalsIgnoreCase("true")) {
                        System.out.println("Marking missing_start_codon for transcript " + feature.getName());
                        ((Transcript)feature).calcTranslationStartForLongestPeptide();
                        return true;
                    }
                    if (feature instanceof Transcript && prop.equalsIgnoreCase("missing_stop_codon") && val.equalsIgnoreCase("true")) {
                        System.out.println("Marking missing_stop_codon for transcript " + feature.getName());
                        ((Transcript)feature).setMissing3prime(true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void addDescription(SeqFeatureI feature, String description) {
        SequenceI seq = feature.getRefSequence();
        if (seq == null) {
            seq = new Sequence(feature.getName(), "");
            feature.setRefSequence(seq);
        }
        GAMEAdapter.setSeqDescription(seq, description, feature.getName());
    }

    private String getCurator(XMLElement xml) {
        XMLElement pub = this.getGrandchild(xml, 0, null);
        if (pub == null) {
            return null;
        }
        XMLElement curator = this.getChild(pub, "uniquename");
        if (curator == null) {
            return null;
        }
        return curator.getCharData();
    }

    private String getSynonymAuthor(XMLElement xml) {
        XMLElement pub = this.getChild(xml, 0, null);
        if (pub == null) {
            return null;
        }
        XMLElement curator = this.getChild(pub, "uniquename");
        if (curator == null) {
            return null;
        }
        return curator.getCharData();
    }

    private String getPubType(XMLElement xml) {
        XMLElement pub = this.getChild(xml, 0, null);
        if (pub == null) {
            return null;
        }
        XMLElement type = this.getChild(pub, "type_id");
        if (type == null) {
            return null;
        }
        return this.getDataType(type);
    }

    private void getOrganism(XMLElement xml, SeqFeatureI feat) {
        XMLElement genus = this.getGrandchild(xml, "genus");
        XMLElement species = this.getGrandchild(xml, "species");
        if (genus != null && species != null) {
            feat.addProperty("organism", genus.getCharData() + " " + species.getCharData());
        }
    }

    private void getOrganism(XMLElement xml, SequenceI seq) {
        XMLElement genus = this.getGrandchild(xml, "genus");
        XMLElement species = this.getGrandchild(xml, "species");
        if (genus != null && species != null) {
            seq.setOrganism(genus.getCharData() + " " + species.getCharData());
        }
    }

    private SeqFeatureI getSeqFeature(XMLElement xml, SeqFeatureI result, CurationSet curation) {
        SeqFeature feature1 = new SeqFeature();
        feature1.addProperty("is_analysis", "1");
        boolean sawFeatureLoc = false;
        SeqFeature feature2 = null;
        SeqFeature current_feature = feature1;
        Vector children = xml.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = (XMLElement)children.elementAt(i);
            if (!child.getType().equalsIgnoreCase("subject_id")) continue;
            Vector grandchildren = child.getChildren();
            if (grandchildren == null) {
                System.out.println("getSeqFeature: no grandchildren for " + ChadoXmlUtils.printXMLElement(xml));
                return feature1;
            }
            XMLElement xml_feat = (XMLElement)grandchildren.firstElement();
            if (!xml_feat.getType().equalsIgnoreCase("feature")) {
                System.out.println("Wrong child " + ChadoXmlUtils.printXMLElement(xml_feat) + " of subject_id " + ChadoXmlUtils.printXMLElement(child));
                return feature1;
            }
            Vector feat_parts = xml_feat.getChildren();
            for (int j = 0; j < feat_parts.size(); ++j) {
                XMLElement tp = (XMLElement)feat_parts.elementAt(j);
                if (tp.getType().equalsIgnoreCase("organism_id")) {
                    this.getOrganism(tp, current_feature);
                }
                if (tp.getType().equalsIgnoreCase("type_id")) {
                    String type_id = this.getDataType(child);
                    current_feature.addProperty("type_id", type_id);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("dbxref_id")) {
                    DbXref xref;
                    if (current_feature.getId() != null || (xref = this.getDbxref(tp, current_feature, false)) == null) continue;
                    current_feature.setId(xref.getIdValue());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("uniquename")) {
                    current_feature.setId(tp.getCharData());
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("residue_info")) {
                    String residues = tp.getCharData();
                    current_feature.setExplicitAlignment(residues);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("analysisfeature")) {
                    this.getScore(tp, current_feature);
                    continue;
                }
                if (tp.getType().equalsIgnoreCase("featureloc")) {
                    if (!sawFeatureLoc) {
                        sawFeatureLoc = true;
                    } else {
                        feature2 = new SeqFeature();
                        feature2.addProperty("is_analysis", "1");
                        current_feature = feature2;
                    }
                    this.handleFeatureLoc(tp, current_feature, curation);
                    continue;
                }
                current_feature.addProperty(child.getType(), child.getCharData());
            }
        }
        feature1.setFeatureType(result.getFeatureType());
        if (feature2 == null) {
            feature1.setName(result.getName());
            return feature1;
        }
        SeqFeature query = feature2;
        SeqFeature subject = feature1;
        if (feature2.getProperty("rank").equals("1")) {
            query = feature2;
            subject = feature1;
        }
        if (subject.getRefSequence() != null) {
            curation.addSequence(subject.getRefSequence());
        }
        query.setFeatureType(subject.getFeatureType());
        query.setScore(subject.getScore());
        FeaturePair pair = new FeaturePair(query, subject);
        pair.setExplicitAlignment(query.getExplicitAlignment());
        pair.setName(subject.getName());
        pair.setId(subject.getId());
        ChadoXmlAdapter.copyProperties(subject, pair);
        if (!subject.getProperty("tag").equals("")) {
            result.addProperty("tag", subject.getProperty("tag"));
        }
        return pair;
    }

    private void handleAnalysisType(XMLElement xml, FeatureSetI result) {
        XMLElement analysis = this.getGrandchild(xml, 0, null);
        if (analysis == null) {
            result.setFeatureType("unknown_type");
            return;
        }
        String program = "";
        String db = "";
        Vector fields = analysis.getChildren();
        for (int i = 0; i < fields.size(); ++i) {
            XMLElement field = (XMLElement)fields.elementAt(i);
            String name = field.getType();
            String value = field.getCharData();
            result.addProperty(name, value);
            if (name.equalsIgnoreCase("program")) {
                program = value;
                result.setProgramName(program);
                continue;
            }
            if (!name.equalsIgnoreCase("sourcename")) continue;
            db = value;
            result.setDatabase(db);
        }
        result.setFeatureType(this.constructAnalysisType(program, db));
    }

    private String constructAnalysisType(String prog, String db) {
        String analysis_type = prog != null && !prog.equals("") && db != null && !db.equals("") ? prog + ":" + db : (prog != null && !prog.equals("") ? prog : (db != null && !db.equals("") ? db : "no_type"));
        return analysis_type;
    }

    private void getScore(XMLElement xml, SeqFeatureI result) {
        XMLElement xml_score = this.getChild(xml, "rawscore");
        if (xml_score != null) {
            try {
                double score = Double.parseDouble(xml_score.getCharData());
                result.setScore(score);
            }
            catch (Exception e) {
                System.err.println("Exception parsing score " + ChadoXmlUtils.printXMLElement(xml_score));
            }
        }
    }

    private void addResultToAnalysis(FeatureSetI result) {
        String prog = result.getProperty("program");
        String db = result.getProperty("sourcename");
        String date = result.getProperty("timeexecuted");
        String programversion = result.getProperty("programversion");
        String sourceversion = result.getProperty("sourceversion");
        FeatureSetI forward_analysis = this.initAnalysis(this.analyses, 1, prog, db, date, programversion, sourceversion, this.all_analyses);
        FeatureSetI reverse_analysis = this.initAnalysis(this.analyses, -1, prog, db, date, programversion, sourceversion, this.all_analyses);
        if (result.getStrand() == 1) {
            forward_analysis.addFeature(result);
            if (!forward_analysis.hasFeatureType()) {
                forward_analysis.setFeatureType(result.getFeatureType());
            }
        } else {
            reverse_analysis.addFeature(result);
            if (!reverse_analysis.hasFeatureType()) {
                reverse_analysis.setFeatureType(result.getFeatureType());
            }
        }
        boolean fwd = this.addAnalysisIfHasFeatures(forward_analysis, this.all_analyses, this.analyses);
        boolean rev = this.addAnalysisIfHasFeatures(reverse_analysis, this.all_analyses, this.analyses);
        if (fwd && rev) {
            forward_analysis.setAnalogousOppositeStrandFeature(reverse_analysis);
            reverse_analysis.setAnalogousOppositeStrandFeature(forward_analysis);
        }
    }

    private FeatureSetI initAnalysis(StrandedFeatureSetI analyses, int strand, String prog, String db, String date, String programversion, String sourceversion, Hashtable all_analyses) {
        FeatureSetI analysis;
        String analysis_type = this.constructAnalysisType(prog, db);
        String analysis_name = !analysis_type.equals("no_type") ? analysis_type + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : "")) : "no_name" + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : ""));
        if (all_analyses == null) {
            all_analyses = new Hashtable();
        }
        if ((analysis = (FeatureSetI)all_analyses.get(analysis_name)) == null) {
            analysis = new FeatureSet();
            analysis.setProgramName(prog);
            analysis.setDatabase(db);
            analysis.setFeatureType(analysis_type);
            if (!analysis_type.equals("no_type")) {
                analysis.setName(analysis_name);
            }
            analysis.setStrand(strand);
        }
        return analysis;
    }

    private boolean addAnalysisIfHasFeatures(FeatureSetI analysis, Hashtable all_analyses, StrandedFeatureSetI analyses) {
        if (all_analyses == null) {
            return false;
        }
        if (all_analyses.containsKey(analysis.getName())) {
            return true;
        }
        if (analysis.size() > 0) {
            all_analyses.put(analysis.getName(), analysis);
            analyses.addFeature(analysis);
            return true;
        }
        return false;
    }

    private static void copyProperties(SeqFeatureI from, SeqFeatureI to) {
        Hashtable props = from.getProperties();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Vector values;
            String type = (String)e.nextElement();
            if (ChadoXmlAdapter.dontCopyProperty(type) || (values = ((SeqFeature)from).getPropertyMulti(type)) == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.elementAt(i);
                to.addProperty(type, value);
            }
        }
    }

    private static boolean dontCopyProperty(String prop) {
        return ChadoXmlWrite.isSpecialProperty(prop);
    }

    private XMLElement getChild(XMLElement xml, String elementType) {
        return this.getChild(xml, -1, elementType);
    }

    private XMLElement getChild(XMLElement xml, int num, String elementType) {
        if (xml == null) {
            return null;
        }
        Vector children = xml.getChildren();
        if (children == null || children.size() <= num) {
            return null;
        }
        if (num < 0 && elementType != null) {
            for (int i = 0; i < children.size(); ++i) {
                XMLElement child = (XMLElement)children.elementAt(i);
                if (!child.getType().equalsIgnoreCase(elementType)) continue;
                return child;
            }
            return null;
        }
        XMLElement child = (XMLElement)children.elementAt(num);
        if (elementType != null && !child.getType().equalsIgnoreCase(elementType)) {
            return null;
        }
        return child;
    }

    private XMLElement getGrandchild(XMLElement xml, String elementType) {
        return this.getGrandchild(xml, -1, elementType);
    }

    private XMLElement getGrandchild(XMLElement xml, int num, String elementType) {
        XMLElement child = this.getChild(xml, 0, null);
        if (child == null) {
            return null;
        }
        Vector grandchildren = child.getChildren();
        if (grandchildren == null || grandchildren.size() <= num) {
            System.out.println("getGrandchild: failed to find children of child " + ChadoXmlUtils.printXMLElement(child));
            return null;
        }
        if (num < 0 && elementType != null) {
            for (int i = 0; i < grandchildren.size(); ++i) {
                XMLElement grandchild = (XMLElement)grandchildren.elementAt(i);
                if (!grandchild.getType().equalsIgnoreCase(elementType)) continue;
                return grandchild;
            }
            return null;
        }
        XMLElement grandchild = (XMLElement)grandchildren.elementAt(num);
        if (elementType != null && !grandchild.getType().equalsIgnoreCase(elementType)) {
            return null;
        }
        return grandchild;
    }

    public void commitChanges(CurationSet curation) {
        this.commitChanges(curation, true, true);
    }

    public void commitChanges(CurationSet curation, boolean saveAnnots, boolean saveResults) {
        File handle;
        String filename = IOUtil.findFile(this.getInput(), true);
        if (filename == null) {
            filename = this.getInput();
        }
        if (filename == null) {
            return;
        }
        String msg = "Retrieving preamble from original file... ";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), msg));
        String preamble = this.getPreamble(curation.getInputFilename());
        if (Config.getConfirmOverwrite() && (handle = new File(filename)).exists() && !LoadUtil.areYouSure(filename + " already exists--overwrite?")) {
            DataLoader loader = new DataLoader();
            loader.saveFileDialog(curation);
            return;
        }
        this.setInput(filename);
        msg = "Saving Chado XML to file " + filename + "... ";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(20.0), msg));
        if (ChadoXmlWrite.writeXML(curation, filename, preamble, saveAnnots, saveResults, this.getNameAdapter(curation), "Apollo version: " + Version.getVersion())) {
            System.out.println("Saved Chado XML to " + filename);
            ChadoXmlWrite.saveTransactions(curation, filename);
        } else {
            String message = "Failed to save Chado XML to " + filename;
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        }
    }

    private ApolloNameAdapterI getNameAdapter(CurationSet curation) {
        StrandedFeatureSetI annots = curation.getAnnots();
        if (annots == null || annots.size() == 0) {
            return new GmodNameAdapter();
        }
        AnnotatedFeatureI annot = (AnnotatedFeatureI)annots.getFeatureAt(0);
        return this.getCurationState().getNameAdapter(annot);
    }

    public boolean appearsToBeChadoXML(String filename, BufferedReader in) throws ApolloAdapterException {
        for (int i = 0; i < 5000; ++i) {
            String line = "";
            try {
                line = in.readLine();
            }
            catch (Exception e) {
                throw new ApolloAdapterException("Error: ChadoXML file " + filename + " is empty.");
            }
            if (line == null) break;
            if (line.toLowerCase().indexOf("<chado") < 0) continue;
            return true;
        }
        return false;
    }

    private String getPreamble(String filename) {
        if (filename == null || filename.equals("")) {
            System.err.println("Warning: original input filename not set--couldn't retrieve preamble");
            return "";
        }
        System.out.println("Retrieving preamble from " + filename + "...");
        StringBuffer input = new StringBuffer();
        try {
            BufferedReader in;
            if (filename.startsWith("http")) {
                URL url = new URL(filename);
                InputStream stream = IOUtil.getStreamFromUrl(url, "URL " + url + " not found");
                in = new BufferedReader(new InputStreamReader(stream));
            } else {
                in = new BufferedReader(new FileReader(filename));
            }
            input.append("<!-- Header lines that follow were preserved from the input source: " + filename + " -->\n");
            String line = "";
            while ((line = in.readLine()) != null) {
                if (line.toLowerCase().indexOf("<chado") >= 0 && line.indexOf("<!--") < 0) {
                    return input.toString();
                }
                if (line.toLowerCase().indexOf("<game>") >= 0 && line.indexOf("<!--") < 0) {
                    return input.toString();
                }
                if (line.indexOf("<?xml") >= 0) continue;
                input.append(line + "\n");
            }
        }
        catch (Exception exception) {
            System.err.println("Warning: failed to retrieve preamble from original input file " + filename);
            return "";
        }
        return "";
    }
}

