/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.Region;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.jdbc.AbstractChadoInstance;
import apollo.dataadapter.chado.jdbc.ChadoCds;
import apollo.dataadapter.chado.jdbc.ChadoProgram;
import apollo.dataadapter.chado.jdbc.FeatureLocImplementation;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.dataadapter.chado.jdbc.RelationshipCVException;
import apollo.dataadapter.chado.jdbc.SchemaVersion;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.Transcript;
import java.sql.Connection;
import java.sql.SQLException;
import org.bdgp.util.ProgressEvent;

public class TigrSybilChadoInstance
extends AbstractChadoInstance {
    private ChadoProgram[] predictionProgs;

    public TigrSybilChadoInstance() {
    }

    TigrSybilChadoInstance(JdbcChadoAdapter jdbcChadoAdapter) {
        super(jdbcChadoAdapter);
    }

    public String getGeneNameField() {
        return "gene_uniquename";
    }

    public String getTranscriptNameField() {
        return "transcript_uniquename";
    }

    public String getCdsSql(FeatureLocImplementation featLocImp) throws RelationshipCVException {
        String fminCol = this.getChadoVersion().getFMinCol();
        String fmaxCol = this.getChadoVersion().getFMaxCol();
        String subjFeatCol = this.getChadoVersion().getSubjFeatCol();
        String objFeatCol = this.getChadoVersion().getObjFeatCol();
        Long producedByCvId = this.getProducedByCVTermId();
        return "SELECT cds.uniquename AS cds_name, trans.uniquename AS transcript_uniquename, trans.residues AS transcript_seq, cdsloc." + fminCol + " AS fmin, cdsloc." + fmaxCol + " AS fmax, " + "cdsloc.strand, prot.uniquename AS protein_name, prot.residues AS protein_seq " + "FROM featureloc cdsloc, feature cds, feature_relationship cds2trans, " + "feature trans, feature_relationship cds2prot, feature prot " + "WHERE cdsloc.srcfeature_id = " + featLocImp.getContainingFeatureId() + " " + "AND cdsloc.feature_id = cds.feature_id " + "AND cds.type_id = " + this.getFeatureCVTermId("CDS") + " " + "AND cds.feature_id = cds2trans." + subjFeatCol + " " + "AND cds2trans." + objFeatCol + " = trans.feature_id " + "AND cds2trans.type_id = " + producedByCvId + " " + "AND trans.type_id = " + this.getFeatureCVTermId("transcript") + " " + "AND cds.feature_id = cds2prot." + objFeatCol + " " + "AND cds2prot.type_id = " + producedByCvId + " " + "AND cds2prot." + subjFeatCol + " = prot.feature_id " + "AND prot.type_id = " + this.getPolypeptideCVTermId();
    }

    public String getPredictedCdsSql(FeatureLocImplementation featLocImp, ChadoProgram[] chadoPrgs) throws RelationshipCVException {
        return this.getCdsSql(featLocImp);
    }

    private SchemaVersion getChadoVersion() {
        return this.getChadoAdapter().getChadoVersion();
    }

    public String getTargetName(String targetChadoName, String species, String alignType, String queryName) {
        if (alignType.equals("SNP")) {
            return queryName;
        }
        return species + " " + targetChadoName;
    }

    public String getFeatureType(String alignType, String program, String programversion, String targetSp, String sourcename, String featProp) {
        if (alignType.equals("SNP")) {
            return "SNP" + featProp != null ? " - " + featProp : "";
        }
        return program + " " + programversion + " " + targetSp;
    }

    public String getFeatureCVName() {
        if (super.getFeatureCVName() != null) {
            return super.getFeatureCVName();
        }
        return "TIGR Ontology";
    }

    public CurationSet getCurationSet(ChadoAdapter adapter, String seqType, String seqId) {
        super.clear();
        Connection conn = this.getConnection();
        if (conn == null) {
            return null;
        }
        CurationSet cset = null;
        StrandedFeatureSet results = this.getResultStrandedFeatSet();
        StrandedFeatureSet annotations = this.getAnnotStrandedFeatSet();
        cset = new CurationSet();
        long seqFeatId = this.getChadoAdapter().getFeatureId(conn, seqType, seqId);
        FeatureLocImplementation featLocImp = new FeatureLocImplementation(seqFeatId, this.haveRedundantFeatureLocs(), conn);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Retrieving " + seqType + " sequence " + seqId));
        SequenceI seq = this.getChadoAdapter().getSequence(seqFeatId);
        cset.setRefSequence(seq);
        cset.setName(seq.getName());
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving " + seqType + " sequence " + seqId));
        cset.setStart(1);
        cset.setEnd(seq.getLength());
        this.getAnnotations(conn, seq, annotations, featLocImp, false, false, false, adapter);
        String scoreColumn = this.getChadoAdapter().getAnalysisFeatureIdentityField();
        boolean getTgtSeqSep = true;
        boolean getAlignSeqs = false;
        boolean getTargetDescriptions = false;
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Retrieving NUCmer annotations"));
        this.getChadoAdapter().addSearchHits(conn, new String[]{"NUCmer%"}, false, getTgtSeqSep, false, getTargetDescriptions, false, seq, results, scoreColumn, getAlignSeqs, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving NUCmer annotations"));
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Retrieving PROmer annotations"));
        this.getChadoAdapter().addSearchHits(conn, new String[]{"PROmer%"}, false, getTgtSeqSep, false, getTargetDescriptions, false, seq, results, scoreColumn, getAlignSeqs, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving PROmer annotations"));
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Retrieving SNPs"));
        this.getChadoAdapter().addSearchHits(conn, new String[]{"TIGR SNP%"}, true, getTgtSeqSep, false, getTargetDescriptions, true, seq, results, null, getAlignSeqs, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving SNPs"));
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Retrieving region analyses"));
        this.getChadoAdapter().addSearchHits(conn, new String[]{"region%"}, false, getTgtSeqSep, false, getTargetDescriptions, false, seq, results, scoreColumn, getAlignSeqs, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving region analyses"));
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Retrieving peffect annotation"));
        this.getChadoAdapter().addProteinAlignments(conn, "peffect", results, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Retrieving peffect annotation"));
        cset.setAnnots(annotations);
        cset.setResults(results);
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            System.err.println(this.getClass() + ": failed to close JDBC Connection");
        }
        return cset;
    }

    public void setTranslationStartAndStop(Transcript trans, ChadoCds cds) {
        boolean calculateEnd = false;
        trans.setTranslationStart(cds.getStart(), calculateEnd);
        trans.setTranslationEnd(cds.getTranslationEnd());
    }

    private boolean haveRedundantFeatureLocs() {
        return true;
    }

    public CurationSet getCurationSetInRange(ChadoAdapter adapter, String seqType, Region region) {
        throw new UnsupportedOperationException("TigrSybilChadoInstance.getCurationSetInRange()");
    }

    public ChadoProgram[] getPredictionPrograms() {
        return this.predictionProgs;
    }

    public void setPredictionPrograms(ChadoProgram[] progs) {
        this.predictionProgs = progs;
    }
}

