/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.config.Config;
import apollo.dataadapter.TransactionOutputAdapter;
import apollo.dataadapter.chado.ChadoDatabase;
import apollo.dataadapter.chado.ChadoTransaction;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chado.ChadoUpdateTransaction;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.dataadapter.chadoxml.ChadoTransactionXMLTemplate;
import apollo.util.IOUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCTransactionWriter
extends TransactionOutputAdapter {
    private String dbUrl;
    private String dbUser;
    private String dbPwd;
    private Connection conn;
    private Map idMap;
    private boolean debug = Config.DEBUG;
    private String writebackTemplateFilename = null;
    private List chadoTransMacrosFromConfig = null;

    public JDBCTransactionWriter(String dbHost, String dbName, String dbUser, String pwd, int port) {
        this("jdbc:postgresql://" + dbHost + ":" + port + "/" + dbName, dbUser, pwd);
    }

    public JDBCTransactionWriter(ChadoDatabase chadoDB) {
        this(chadoDB.getJdbcUrl(), chadoDB.getLogin(), chadoDB.getPassword());
        this.chadoTransMacrosFromConfig = chadoDB.getChadoInstance().getChadoTransMacros();
        this.writebackTemplateFilename = chadoDB.getChadoInstance().getWritebackTemplateFile();
    }

    private JDBCTransactionWriter(String url, String dbUser, String pwd) {
        this.dbUser = dbUser;
        this.dbPwd = pwd;
        this.dbUrl = url;
        try {
            Class.forName("org.postgresql.Driver");
            this.conn = this.getConnection();
        }
        catch (Exception e) {
            System.err.println("ChadoTransactionProcessor.init(): " + e);
            e.printStackTrace();
        }
        this.idMap = new HashMap();
    }

    private Connection getConnection() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            return this.conn;
        }
        this.conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPwd);
        this.target = this.conn;
        return this.conn;
    }

    protected void commitTransformedTransactions(List transformedTn) throws Exception {
        if (transformedTn == null || transformedTn.size() == 0) {
            System.out.println("JDBCTransactionWriter.commitTransactions(): No transactions!");
            return;
        }
        ArrayList<ChadoTransaction> macros = new ArrayList<ChadoTransaction>();
        if (this.chadoTransMacrosFromConfig != null) {
            macros.addAll(this.chadoTransMacrosFromConfig);
        }
        macros.addAll(this.loadTnsFromTemplate());
        ChadoTransaction srcTn = ((ChadoTransactionTransformer)this.transformer).createSrcFeatureIDTransaction(this.mapID, this.mapType);
        macros.add(srcTn);
        ArrayList<ChadoTransaction> tns = new ArrayList<ChadoTransaction>();
        tns.addAll(macros);
        tns.addAll(transformedTn);
        Connection connection = null;
        connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            ChadoTransaction tn = null;
            ChadoTransaction.Operation op = null;
            Iterator it = tns.iterator();
            while (it.hasNext()) {
                tn = (ChadoTransaction)it.next();
                op = tn.getOperation();
                if (op == ChadoTransaction.LOOKUP) {
                    this.commitLookup(tn, connection);
                    continue;
                }
                if (op == ChadoTransaction.INSERT) {
                    this.commitInsert(tn, connection);
                    continue;
                }
                if (op == ChadoTransaction.FORCE) {
                    this.commitForce(tn, connection);
                    continue;
                }
                if (op == ChadoTransaction.DELETE) {
                    this.commitDelete(tn, connection);
                    continue;
                }
                if (op != ChadoTransaction.UPDATE) continue;
                this.commitUpdate(tn, connection);
            }
            connection.commit();
            connection.close();
            if (this.debug) {
                System.out.println("JDBCTransactionWriter.commitTransaction(): Transactions saved to the database successfully.");
            }
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                System.err.println("JDBCTransactionWriter.commitTransaction(): Cannot roll back changes during exception throwing. Please contact DBA ASAP!!!");
            }
            e.printStackTrace();
            throw e;
        }
    }

    private String getWritebackTemplateFilename() {
        if (this.writebackTemplateFilename == null) {
            this.writebackTemplateFilename = Config.getChadoTemplateName();
        }
        return this.writebackTemplateFilename;
    }

    private List loadTnsFromTemplate() {
        ArrayList<ChadoTransaction> tns = new ArrayList<ChadoTransaction>();
        String name = "conf" + File.separator + this.getWritebackTemplateFilename();
        String tmpFileName = IOUtil.findFile(name);
        if (tmpFileName == null) {
            String m = "JDBCTransactionWriter.loadTnsFromTemplate(): Cannot find xml templatefor chado transaction. filename: " + name;
            throw new IllegalStateException(m);
        }
        ChadoTransactionXMLTemplate template = new ChadoTransactionXMLTemplate(tmpFileName);
        Element elm = template.getElement("preamble");
        NodeList children = elm.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node tmp = children.item(i);
            if (tmp.getNodeType() != 1) continue;
            tns.add(this.loadOpElement((Element)tmp));
        }
        return tns;
    }

    private ChadoTransaction loadOpElement(Element elm) {
        String op = elm.getAttribute("op");
        ChadoTransaction tn = null;
        tn = op.equals("update") ? new ChadoUpdateTransaction() : new ChadoTransaction();
        String tableName = elm.getNodeName();
        tn.setTableName(tableName);
        if (op == null || op.length() == 0) {
            tn.setOperation(ChadoTransaction.FORCE);
        } else {
            tn.setOperation(ChadoTransaction.Operation.getOperation(op));
        }
        String id = elm.getAttribute("id");
        if (id != null && id.length() > 0) {
            tn.setID(id);
        }
        NodeList children = elm.getChildNodes();
        int size = children.getLength();
        if (tn instanceof ChadoUpdateTransaction) {
            for (int i = 0; i < size; ++i) {
                Node tmp = children.item(i);
                if (tmp.getNodeType() != 1) continue;
                String propName = tmp.getNodeName();
                String update = ((Element)tmp).getAttribute("update");
                String value = this.getTextValue(tmp);
                if (update == null || update.length() == 0) {
                    tn.addProperty(propName, value);
                    continue;
                }
                ((ChadoUpdateTransaction)tn).addUpdateProperty(propName, value);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Node tmp = children.item(i);
                if (tmp.getNodeType() != 1) continue;
                String propName = tmp.getNodeName();
                String value = this.getTextValue(tmp);
                tn.addProperty(propName, value);
            }
        }
        return tn;
    }

    private String getTextValue(Node elm) {
        return elm.getFirstChild().getNodeValue();
    }

    private void commitLookup(ChadoTransaction tn, Connection conn) throws SQLException {
        long id = this.lookup(tn, conn);
        if (id < 0L) {
            String m = "Error in ChadoTransactionProcessor.commitLookup()\nLookup query failed to return anything:\n " + this.makeLookupQuery(tn);
            throw new IllegalStateException(m);
        }
    }

    private long lookup(ChadoTransaction tn, Connection conn) throws SQLException {
        String query = this.makeLookupQuery(tn);
        if (this.debug) {
            System.out.println("Lookup Query: " + query);
        }
        Statement stat = conn.createStatement();
        ResultSet result = stat.executeQuery(query);
        int count = 0;
        long id1 = -1L;
        String id = tn.getID();
        while (result.next()) {
            ++count;
            id1 = result.getLong(1);
            this.idMap.put(id, new Long(id1));
        }
        this.cleanUp(result, stat);
        if (count > 1) {
            throw new IllegalStateException("JDBCTransactionWriter.lookup(): more than one row matches the query.");
        }
        return id1;
    }

    private String makeLookupQuery(ChadoTransaction tn) {
        String tableName = tn.getTableName();
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append(tableName);
        query.append("_id FROM ");
        query.append(tableName);
        Map prop = tn.getUniqueKeyProps();
        this.constructWhereClause(prop, query);
        return query.toString();
    }

    private void constructWhereClause(Map prop, StringBuffer query) {
        query.append(" WHERE ");
        Iterator it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)prop.get(key);
            query.append(key);
            query.append("=");
            this.appendValue(key, value, query);
            if (!it.hasNext()) continue;
            query.append(" AND ");
        }
    }

    private void cleanUp(ResultSet rs) throws SQLException {
        this.cleanUp(rs, rs.getStatement());
    }

    private void cleanUp(ResultSet result, Statement stat) throws SQLException {
        if (result != null) {
            result.close();
        }
        if (stat != null) {
            stat.close();
        }
    }

    private void commitInsert(ChadoTransaction tn, Connection conn) throws SQLException {
        String tableName = tn.getTableName();
        String tempId = tn.getID();
        String idQuery = "SELECT nextval('public." + tableName + "_" + tableName + "_id_seq')";
        JDBCTransactionWriter.debugMsgAndTime(idQuery);
        ResultSet rs = conn.createStatement().executeQuery(idQuery);
        rs.next();
        long idLong = rs.getLong(1);
        if (tempId != null) {
            this.idMap.put(tempId, new Long(idLong));
        }
        this.cleanUp(rs);
        StringBuffer query = new StringBuffer();
        query.append("INSERT INTO ");
        query.append(tableName);
        query.append(" (");
        query.append(tableName + "_id, ");
        Map prop = tn.getProperties();
        Iterator it = prop.keySet().iterator();
        while (it.hasNext()) {
            query.append(it.next());
            if (!it.hasNext()) continue;
            query.append(", ");
        }
        query.append(") VALUES (");
        query.append(idLong + ", ");
        it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)prop.get(key);
            this.appendValue(key, value, query);
            if (!it.hasNext()) continue;
            query.append(", ");
        }
        query.append(")");
        JDBCTransactionWriter.debugMsgAndTime("Insert: " + query.toString());
        Statement stat = conn.createStatement();
        int row = 0;
        try {
            row = stat.executeUpdate(query.toString());
        }
        catch (SQLException e) {
            this.processException(e, stat, query.toString());
        }
        if (row == 0) {
            throw new IllegalStateException("JDBCTransactionWriter.commitInsert(): insert cannot work.");
        }
        this.cleanUp(null, stat);
    }

    private void processException(SQLException e, Statement s, String sql) throws SQLException {
        for (SQLWarning warning = s.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            System.out.println(warning.getMessage());
        }
        throw new SQLException(e.getMessage() + "\nProblematic query: " + sql);
    }

    private void commitForce(ChadoTransaction tn, Connection conn) throws SQLException {
        long id = this.lookup(tn, conn);
        if (id < 0L) {
            this.commitInsert(tn, conn);
        }
    }

    private void commitUpdate(ChadoTransaction tn, Connection conn) throws SQLException {
        String tableName = tn.getTableName();
        String id = tn.getID();
        if (id != null) {
            this.debugPrint("id is not null - looking up id for update id: " + id);
            long idLong = this.lookup(tn, conn);
            if (idLong < 0L) {
                throw new IllegalStateException("JDBCTransactionWriter.commitUpdate(): cannot find record for updating.");
            }
        }
        StringBuffer query = new StringBuffer();
        query.append("UPDATE ");
        query.append(tableName);
        query.append(" SET ");
        Map updateProp = ((ChadoUpdateTransaction)tn).getUpdateProperies();
        Iterator it = updateProp.keySet().iterator();
        while (it.hasNext()) {
            String propName = (String)it.next();
            String value = (String)updateProp.get(propName);
            query.append(propName);
            query.append("=");
            this.appendValue(propName, value, query);
            if (!it.hasNext()) continue;
            query.append(", ");
        }
        Map prop = tn.getProperties();
        this.constructWhereClause(prop, query);
        if (this.debug) {
            System.out.println("Update Query: " + query.toString());
        }
        Statement stat = conn.createStatement();
        int row = stat.executeUpdate(query.toString());
        this.cleanUp(null, stat);
        if (row == 0) {
            String m = "JDBCTransactionWriter.commitUpdate(): Cannot update. Update attempted but no row was effected. Check where clause.";
            throw new IllegalStateException(m);
        }
        if (row > 1) {
            throw new IllegalStateException("JDBCTransactionWriter.commitUpdate(): More than one row is updated.");
        }
    }

    private void commitDelete(ChadoTransaction tn, Connection conn) throws SQLException {
        String tableName = tn.getTableName();
        String id = tn.getID();
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append(tableName);
        Map prop = tn.getProperties();
        this.constructWhereClause(prop, query);
        if (this.debug) {
            System.out.println("Delete Query: " + query.toString());
        }
        Statement stat = conn.createStatement();
        int row = stat.executeUpdate(query.toString());
        this.cleanUp(null, stat);
        if (row == 0) {
            throw new IllegalStateException("JDBCTransactionWriter.commitDelete(): Cannot delete a row.");
        }
        if (row > 1) {
            throw new IllegalStateException("JDBCTransactionWriter.commitDelete(): More than one row is deleted.");
        }
    }

    private void appendValue(String key, String value, StringBuffer query) {
        if (key.endsWith("_id") && this.idMap.containsKey(value)) {
            query.append(this.idMap.get(value));
        } else {
            if (key.endsWith("_id")) {
                this.debugPrint("ERROR: no id mapped for " + key + " with value " + value + " for query " + query + " Will try to do query without it but will probably fail");
            }
            query.append("'");
            query.append(value);
            query.append("'");
        }
    }

    static void debugMsgAndTime(String m) {
        JdbcChadoAdapter.debugMsgAndTime(m);
    }

    private void debugPrint(String m) {
        if (!this.debug) {
            return;
        }
        System.out.println(m);
    }
}

