/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;

public class ChadoProgram {
    private String name;
    private boolean retrieveCDS;
    private long analysis_id;
    private String sourcename;
    private String programversion;

    public ChadoProgram() {
        this.setName(null);
        this.setRetrieveCDS(false);
    }

    public ChadoProgram(String name) {
        this.setName(name);
        this.setRetrieveCDS(false);
    }

    public ChadoProgram(String newName, boolean retrievecds) {
        this.name = newName;
        this.retrieveCDS = retrievecds;
    }

    ChadoProgram(ResultSet rs) {
        try {
            this.name = rs.getString("program");
            this.analysis_id = rs.getInt("analysis_id");
            this.sourcename = rs.getString("sourcename");
            this.programversion = rs.getString("programversion");
        }
        catch (SQLException e) {
            System.err.println(this.getClass() + ":\nSQLException retrieving analysis.\n" + e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isRetrieveCDS() {
        return this.retrieveCDS;
    }

    public void setRetrieveCDS(boolean retrieveCDS) {
        this.retrieveCDS = retrieveCDS;
    }

    public long getDbId() {
        return this.analysis_id;
    }

    public void setDbId(long analysis_id) {
        this.analysis_id = analysis_id;
    }

    public void setSource(String sourcename) {
        this.sourcename = sourcename;
    }

    public String getSource() {
        return this.sourcename;
    }

    public void setVersion(String programversion) {
        this.programversion = programversion;
    }

    public String getVersion() {
        return this.programversion;
    }

    boolean hasSourceAndVersion() {
        return this.programversion != null && this.sourcename != null;
    }

    boolean nameSrcVerEquals(ChadoProgram cp) {
        return this.getName().equals(cp.getName()) && this.getSource().equals(cp.getSource()) && this.getVersion().equals(cp.getVersion());
    }

    public String toString() {
        return this.getName() + "," + this.getSource() + "," + this.getVersion();
    }
}

