/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado.jdbc;

import apollo.dataadapter.DataInput;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.ChadoTransaction;
import apollo.dataadapter.chado.SeqType;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.dataadapter.chado.jdbc.ChadoProgram;
import apollo.dataadapter.chado.jdbc.FeatureLocImplementation;
import apollo.dataadapter.chado.jdbc.JdbcChadoAdapter;
import apollo.dataadapter.chado.jdbc.RelationshipCVException;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bdgp.util.ProgressEvent;

abstract class AbstractChadoInstance
implements ChadoInstance {
    private JdbcChadoAdapter jdbcChadoAdapter;
    private String writebackTemplateFile;
    private List chadoTransactionMacros;
    private ChadoProgram[] predictionPrograms;
    private String[] hitPrograms;
    private ChadoProgram[] oneLevelResultPrograms;
    private List oneLevelAnnotTypes;
    private List threeLevelAnnotTypes;
    private boolean searchHitsHaveFeatLocs = false;
    private String featureCVName = null;
    private String polypeptideType = "polypeptide";
    private String relationshipCVName;
    private String propertyTypeCVName;
    private String partOfCvTerm = "part_of";
    private String transProtRelationCvTerm = "derives_from";
    private boolean retrieveAnnotations = true;
    private String topLevelFeatType;
    private String id;
    private static final Double Z = new Double(0.0);
    private static final Double D100 = new Double(100.0);
    private List seqTypes;
    private StrandedFeatureSet results;
    private StrandedFeatureSet annots;
    private FeatureLocImplementation topFeatLoc;

    protected AbstractChadoInstance() {
    }

    protected AbstractChadoInstance(JdbcChadoAdapter jdbcChadoAdapter) {
        this.jdbcChadoAdapter = jdbcChadoAdapter;
    }

    public ChadoInstance cloneInstance() {
        try {
            return (ChadoInstance)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChadoAdapter(JdbcChadoAdapter jdbcAdapter) {
        this.jdbcChadoAdapter = jdbcAdapter;
    }

    public JdbcChadoAdapter getChadoAdapter() {
        return this.jdbcChadoAdapter;
    }

    protected Connection getConnection() {
        return this.getChadoAdapter().getConnection();
    }

    public void setWritebackTemplateFile(String templateFile) {
        this.writebackTemplateFile = templateFile;
    }

    public String getWritebackTemplateFile() {
        return this.writebackTemplateFile;
    }

    public void setPredictionPrograms(ChadoProgram[] predictionPrograms) {
        this.predictionPrograms = predictionPrograms;
    }

    public ChadoProgram[] getPredictionPrograms() {
        return this.predictionPrograms;
    }

    public void setHitPrograms(String[] hitPrograms) {
        this.hitPrograms = hitPrograms;
    }

    public String[] getHitPrograms() {
        return this.hitPrograms;
    }

    public void setOneLevelResultPrograms(ChadoProgram[] oneLevelResults) {
        this.oneLevelResultPrograms = oneLevelResults;
    }

    public ChadoProgram[] getOneLevelResultPrograms() {
        return this.oneLevelResultPrograms;
    }

    public List getOneLevelAnnotTypes() {
        if (this.oneLevelAnnotTypes == null) {
            this.oneLevelAnnotTypes = new ArrayList(0);
        }
        return this.oneLevelAnnotTypes;
    }

    public void setOneLevelAnnotTypes(List features) {
        this.oneLevelAnnotTypes = new ArrayList(features);
    }

    public List getThreeLevelAnnotTypes() {
        if (this.threeLevelAnnotTypes == null) {
            this.threeLevelAnnotTypes = new ArrayList(0);
        }
        return this.threeLevelAnnotTypes;
    }

    public void setThreeLevelAnnotTypes(List features) {
        this.threeLevelAnnotTypes = new ArrayList(features);
    }

    public boolean searchHitsHaveFeatLocs() {
        return this.searchHitsHaveFeatLocs;
    }

    public void setSearchHitsHaveFeatLocs(boolean haveFeatLocs) {
        this.searchHitsHaveFeatLocs = haveFeatLocs;
    }

    protected Long getRelationshipCVTermId(String name) {
        return this.getChadoAdapter().getRelationshipCVTermId(name);
    }

    public void setRelationshipCVName(String relCV) {
        this.relationshipCVName = relCV;
    }

    public String getRelationshipCVName() {
        return this.relationshipCVName;
    }

    public String getPartOfCvTerm() {
        return this.partOfCvTerm;
    }

    public void setPartOfCvTerm(String term) {
        this.partOfCvTerm = term;
    }

    public String getTransProtRelationTerm() {
        return this.transProtRelationCvTerm;
    }

    public void setTranProtRelationTerm(String term) {
        this.transProtRelationCvTerm = term;
    }

    protected Long getProducedByCVTermId() throws ProducedByException {
        Long id = this.getRelationshipCVTermId(this.getTransProtRelationTerm());
        if (id == null) {
            String m = "produced by cv term '" + this.getTransProtRelationTerm() + "' not found in " + "relationship cv " + this.getRelationshipCVName();
            ProducedByException e = new ProducedByException(m);
            if (JdbcChadoAdapter.debug) {
                e.printStackTrace();
            }
            throw e;
        }
        return id;
    }

    public void setFeatureCVName(String featCV) {
        this.featureCVName = featCV;
    }

    public String getFeatureCVName() {
        return this.featureCVName;
    }

    public void setPolypeptideType(String polypeptideType) {
        this.polypeptideType = polypeptideType;
    }

    public String getPolypeptideType() {
        return this.polypeptideType;
    }

    protected Long getPolypeptideCVTermId() {
        return this.getFeatureCVTermId(this.getPolypeptideType());
    }

    protected Long getFeatureCVTermId(String name) {
        return this.getChadoAdapter().getFeatureCVTermId(name);
    }

    public void setPropertyTypeCVName(String cv) {
        this.propertyTypeCVName = cv;
    }

    public String getPropertyTypeCVName() {
        return this.propertyTypeCVName;
    }

    public String getAnalysisType(ResultSet rs) throws SQLException {
        int analysisId = rs.getInt("analysis_id");
        String analysisSource = this.jdbcChadoAdapter.getAnalysisSource(analysisId);
        String program = this.jdbcChadoAdapter.getAnalysisProgram(analysisId);
        return program + ":" + analysisSource;
    }

    public void setRetrieveAnnotations(boolean retrieveAnnotations) {
        this.retrieveAnnotations = retrieveAnnotations;
    }

    protected void getAnnotations(Connection conn, SequenceI refSeq, StrandedFeatureSet sfs, FeatureLocImplementation featLocImp, boolean getFeatProps, boolean getSynonyms, boolean getDbXRefs, ChadoAdapter adapter) {
        if (!this.retrieveAnnotations) {
            return;
        }
        this.debugPrintTime();
        adapter.fireProgressEvent(new ProgressEvent((Object)this, Z, "Retrieving gene models"));
        this.getChadoAdapter().addGeneModels(conn, refSeq, sfs, featLocImp, getFeatProps, getSynonyms, getDbXRefs);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, new Double(75.0), "Gene models retrieved"));
        this.getChadoAdapter().addOneLevelAnnotations(conn, refSeq, sfs, featLocImp);
        adapter.fireProgressEvent(new ProgressEvent((Object)this, D100, "Gene models retrieved"));
        this.debugPrintTime();
    }

    public List getChadoTransMacros() {
        if (this.chadoTransactionMacros != null) {
            return this.chadoTransactionMacros;
        }
        this.chadoTransactionMacros = new ArrayList(2);
        ChadoTransaction chadoTrans = this.makeCvTrans(this.getFeatureCVName());
        this.chadoTransactionMacros.add(chadoTrans);
        chadoTrans = this.makeCvTrans(this.getRelationshipCVName());
        this.chadoTransactionMacros.add(chadoTrans);
        chadoTrans = this.makeCvTermTrans(this.getPolypeptideType(), this.getFeatureCVName());
        this.chadoTransactionMacros.add(chadoTrans);
        chadoTrans = this.makeCvTermTrans(this.getTransProtRelationTerm(), this.getRelationshipCVName());
        this.chadoTransactionMacros.add(chadoTrans);
        return this.chadoTransactionMacros;
    }

    private ChadoTransaction makeCvTrans(String cv) {
        ChadoTransaction chadoTrans = new ChadoTransaction();
        chadoTrans.setOperation(ChadoTransaction.LOOKUP);
        chadoTrans.setTableName("cv");
        chadoTrans.setID(cv);
        chadoTrans.addProperty("name", cv);
        return chadoTrans;
    }

    private ChadoTransaction makeCvTermTrans(String id, String cv) {
        ChadoTransaction chadoTrans = new ChadoTransaction();
        chadoTrans.setOperation(ChadoTransaction.LOOKUP);
        chadoTrans.setTableName("cvterm");
        chadoTrans.setID(id);
        chadoTrans.addProperty("cv_id", cv);
        chadoTrans.addProperty("name", id);
        return chadoTrans;
    }

    public void setSeqTypeList(List seqTypes) {
        this.seqTypes = seqTypes;
    }

    public int getSeqTypesSize() {
        if (this.seqTypes == null) {
            return 0;
        }
        return this.seqTypes.size();
    }

    public SeqType getSeqType(int i) {
        return (SeqType)this.seqTypes.get(i);
    }

    public SeqType getLocationSeqType() {
        for (int i = 0; i < this.getSeqTypesSize(); ++i) {
            SeqType seqType = this.getSeqType(i);
            if (!seqType.hasStartAndEnd()) continue;
            return seqType;
        }
        return null;
    }

    public String getTopLevelFeatType() {
        SeqType seqType;
        int i;
        if (this.topLevelFeatType != null) {
            return this.topLevelFeatType;
        }
        for (i = 0; i < this.getSeqTypesSize(); ++i) {
            seqType = this.getSeqType(i);
            if (!seqType.isTopLevelFeatType()) continue;
            this.topLevelFeatType = seqType.getName();
            return this.topLevelFeatType;
        }
        for (i = 0; i < this.getSeqTypesSize(); ++i) {
            seqType = this.getSeqType(i);
            if (!seqType.hasStartAndEnd()) continue;
            if (this.topLevelFeatType == null) {
                this.topLevelFeatType = seqType.getName();
                continue;
            }
            String m = "2 locations specified in seq types for instance " + this.id;
            if (this.hasChromosomeInString(seqType.getName())) {
                this.topLevelFeatType = seqType.getName();
            }
            m = this.hasChromosomeInString(this.topLevelFeatType) ? m + "using " + this.topLevelFeatType + " for top level feat because it has " + "'chromosome' in it" : m + "Arbitrarily setting top level feat to " + this.topLevelFeatType + ". Set top level feat type explicitly with <isTopLevel>";
            System.out.println(m);
        }
        if (this.topLevelFeatType != null) {
            return this.topLevelFeatType;
        }
        for (i = 0; i < this.getSeqTypesSize(); ++i) {
            seqType = this.getSeqType(i);
            if (!this.hasChromosomeInString(seqType.getName())) continue;
            this.topLevelFeatType = seqType.getName();
            System.out.println("Setting top level feat type to " + this.topLevelFeatType + " because it had 'chromosome' in it. Set explicitly " + "with <isTopLevel>true in <sequenceTypes> <type>");
            return this.topLevelFeatType;
        }
        this.topLevelFeatType = "chromosome";
        System.out.println("Couldnt discern top level feat type from config. Just setting it to 'choromosome' and hoping to get lucky. Top level seq type needs to be configured.");
        return this.topLevelFeatType;
    }

    private boolean hasChromosomeInString(String type) {
        return type.indexOf("chromosome") != -1;
    }

    public void checkForLocation(DataInput dataInput) {
        if (dataInput.getSoType() == null && dataInput.isRegion()) {
            dataInput.setSoType(this.getLocationSeqType().getName());
        }
        if (this.isLocation(dataInput.getSoType()) && !dataInput.isRegion()) {
            dataInput.makeDataTypeRegion();
        }
    }

    private boolean isLocation(String type) {
        SeqType st = this.getSeqType(type);
        if (st == null) {
            return false;
        }
        return st.hasStartAndEnd();
    }

    public SeqType getSeqType(String name) {
        for (int i = 0; i < this.getSeqTypesSize(); ++i) {
            if (!this.getSeqType(i).getName().equals(name)) continue;
            return this.getSeqType(i);
        }
        return null;
    }

    public boolean typeHasStartAndEnd(String typeName) {
        SeqType st = this.getSeqType(typeName);
        if (st == null) {
            return false;
        }
        return st.hasStartAndEnd();
    }

    public StrandedFeatureSet getResultStrandedFeatSet() {
        if (this.results == null) {
            this.results = new StrandedFeatureSet();
        }
        return this.results;
    }

    public StrandedFeatureSet getAnnotStrandedFeatSet() {
        if (this.annots == null) {
            this.annots = new StrandedFeatureSet();
        }
        return this.annots;
    }

    protected void clear() {
        this.annots = null;
        this.results = null;
    }

    void setTopFeatLoc(FeatureLocImplementation topFeatLoc) {
        this.topFeatLoc = topFeatLoc;
    }

    public FeatureLocImplementation getTopFeatLoc() {
        return this.topFeatLoc;
    }

    protected void debugPrintTime() {
        JdbcChadoAdapter.debugPrintTime();
    }

    class ProducedByException
    extends RelationshipCVException {
        ProducedByException(String m) {
            super(m);
        }
    }
}

