/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.config.Config;
import apollo.dataadapter.chado.ChadoDatabase;
import apollo.dataadapter.chado.SeqType;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import apollo.dataadapter.chado.jdbc.ChadoProgram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XmlConfigFileParser {
    private Map chadoInstanceMap = new HashMap();

    XmlConfigFileParser() {
    }

    ChadoDatabase[] readConfigFile() {
        ArrayList<ChadoDatabase> databases = new ArrayList<ChadoDatabase>();
        String configFileName = Config.getChadoJdbcAdapterConfigFile();
        if (Config.getDebug()) {
            System.out.println("XmlConfigFileParser.readConfigFile: configFileName = " + configFileName);
        }
        if (configFileName == null) {
            return databases.toArray(new ChadoDatabase[0]);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = null;
            doc = builder.parse(configFileName);
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = list.item(i);
                if (node.getNodeName().equals("chadodb")) {
                    ChadoDatabase chadoDb = this.extractDBInfo(node);
                    databases.add(chadoDb);
                    continue;
                }
                if (!node.getNodeName().equals("chadoInstance")) continue;
                String id = ((Element)node).getAttribute("id");
                ChadoInstance instance = this.generateChadoInstance((Element)node);
                instance.setId(id);
                this.addChadoInstance(id, instance);
            }
        }
        catch (ParserConfigurationException e) {
            System.err.println("ChadoAdapter.readConfigFile() 1: " + e);
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.err.println("ChadoAdapter.readConfigFile() 2: " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("ChadoAdapter.readConfigFile() 3: " + e);
            e.printStackTrace();
        }
        return databases.toArray(new ChadoDatabase[0]);
    }

    private void addChadoInstance(String id, ChadoInstance instance) {
        this.chadoInstanceMap.put(id, instance);
    }

    private ChadoInstance getChadoInstance(String id) {
        ChadoInstance instance = (ChadoInstance)this.chadoInstanceMap.get(id);
        if (instance == null) {
            throw new IllegalStateException("Chado instance " + id + " not defined.");
        }
        return instance;
    }

    private ChadoDatabase extractDBInfo(Node dbNode) {
        ChadoDatabase db = new ChadoDatabase();
        boolean commandLineDefaultIsSet = false;
        NodeList list = dbNode.getChildNodes();
        int size = list.getLength();
        Node tmp = null;
        String nodeName = null;
        for (int i = 0; i < size; ++i) {
            tmp = list.item(i);
            nodeName = tmp.getNodeName();
            if (nodeName.equals("name")) {
                db.setName(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("adapter")) {
                db.setAdapterClassName(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("url")) {
                db.setJdbcUrl(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("dbName")) {
                db.setChadoDb(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("dbUser")) {
                db.setLogin(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("dbInstance")) {
                String instanceId = this.getTextNodeValue(tmp);
                db.setChadoInstance(this.getChadoInstance(instanceId));
                continue;
            }
            if (nodeName.equals("style")) {
                db.setStyleFileName(this.getTextNodeValue(tmp));
                continue;
            }
            if (nodeName.equals("sequenceTypes")) {
                System.out.println("sequenceTypes now go in chado instance, please correct your chado xml config file (" + Config.getChadoJdbcAdapterConfigFile() + ")");
                continue;
            }
            if (nodeName.equals("chromosomes")) {
                System.out.println("chromosomes now go in chado instance, please correct your chado xml config file (" + Config.getChadoJdbcAdapterConfigFile() + ")");
                continue;
            }
            if (!nodeName.equals("default-command-line-db") || !this.getTextNodeValue(tmp).equals("true")) continue;
            if (!commandLineDefaultIsSet) {
                db.setIsDefaultDatabase(true);
                commandLineDefaultIsSet = true;
                continue;
            }
            System.out.println("Default cmd line db set more than once, ignoring for " + db.getName());
        }
        return db;
    }

    private ChadoInstance generateChadoInstance(Element dbInstElm) {
        NodeList list = dbInstElm.getChildNodes();
        int size = list.getLength();
        String className = null;
        String inheritedInstance = null;
        String writebackTemplate = null;
        String featureCV = null;
        String polypeptideType = null;
        String relationshipCV = null;
        String partOfCvTerm = null;
        String transProtRelTerm = null;
        String propertyTypeCV = null;
        List oneLevelTypes = null;
        List threeLevelTypes = null;
        ChadoProgram[] genePredictionPrograms = null;
        String[] searchHitPrograms = null;
        ChadoProgram[] oneLevelResultPrograms = null;
        boolean searchHitsHaveFeatLocs = false;
        boolean retrieveAnnotations = true;
        List seqTypeList = null;
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("#text") || nodeName.equals("#comment")) continue;
            if (nodeName.equals("clsName")) {
                className = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("inheritsInstance")) {
                inheritedInstance = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("sequenceTypes")) {
                seqTypeList = this.extractSeqTypes(node);
                continue;
            }
            if (nodeName.equalsIgnoreCase("writebackXmlTemplateFile")) {
                writebackTemplate = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("featureCV")) {
                featureCV = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("polypeptideType")) {
                polypeptideType = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("relationshipCV")) {
                relationshipCV = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("partOfCvTerm")) {
                partOfCvTerm = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("producedByCvTerm") || nodeName.equals("transProtRelationTerm")) {
                transProtRelTerm = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("propertyTypeCV")) {
                propertyTypeCV = this.getTextNodeValue(node);
                continue;
            }
            if (nodeName.equals("retrieveAnnotations")) {
                retrieveAnnotations = this.getTextNodeBoolean(node);
                continue;
            }
            if (nodeName.equals("oneLevelAnnotTypes")) {
                oneLevelTypes = this.extractAnnotTypes(node);
                continue;
            }
            if (nodeName.equals("threeLevelAnnotTypes")) {
                threeLevelTypes = this.extractAnnotTypes(node);
                continue;
            }
            if (nodeName.equals("genePredictionPrograms")) {
                genePredictionPrograms = this.extractRichPrograms(node);
                continue;
            }
            if (nodeName.equals("searchHitPrograms")) {
                searchHitPrograms = this.extractPrograms(node);
                continue;
            }
            if (nodeName.equals("searchHitsHaveFeatLocs")) {
                searchHitsHaveFeatLocs = this.extractHitFeatLocs(node);
                continue;
            }
            if (nodeName.equals("oneLevelResultPrograms")) {
                oneLevelResultPrograms = this.extractRichPrograms(node);
                continue;
            }
            System.out.println("Unknown xml element in chado config file: " + nodeName);
        }
        ChadoInstance inst = null;
        if (className != null || inheritedInstance != null) {
            try {
                if (inheritedInstance != null) {
                    ChadoInstance superClass = this.getChadoInstance(inheritedInstance);
                    inst = superClass.cloneInstance();
                } else {
                    Class<?> cls = Class.forName(className);
                    inst = (ChadoInstance)cls.newInstance();
                }
                if (oneLevelTypes != null) {
                    inst.setOneLevelAnnotTypes(oneLevelTypes);
                }
                if (seqTypeList != null) {
                    inst.setSeqTypeList(seqTypeList);
                }
                if (threeLevelTypes != null) {
                    inst.setThreeLevelAnnotTypes(threeLevelTypes);
                }
                if (writebackTemplate != null) {
                    inst.setWritebackTemplateFile(writebackTemplate);
                }
                if (featureCV != null) {
                    inst.setFeatureCVName(featureCV);
                }
                if (polypeptideType != null) {
                    inst.setPolypeptideType(polypeptideType);
                }
                if (relationshipCV != null) {
                    inst.setRelationshipCVName(relationshipCV);
                }
                if (partOfCvTerm != null) {
                    inst.setPartOfCvTerm(partOfCvTerm);
                }
                if (transProtRelTerm != null) {
                    inst.setTranProtRelationTerm(transProtRelTerm);
                }
                if (propertyTypeCV != null) {
                    inst.setPropertyTypeCVName(propertyTypeCV);
                }
                if (genePredictionPrograms != null) {
                    inst.setPredictionPrograms(genePredictionPrograms);
                }
                if (searchHitPrograms != null) {
                    inst.setHitPrograms(searchHitPrograms);
                }
                if (oneLevelResultPrograms != null) {
                    inst.setOneLevelResultPrograms(oneLevelResultPrograms);
                }
                inst.setSearchHitsHaveFeatLocs(searchHitsHaveFeatLocs);
                inst.setRetrieveAnnotations(retrieveAnnotations);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("ChadoAdapter.generateChadoInstance(): " + e);
                e.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("ChadoAdapter.generateChadoInstance(): " + e);
                e.printStackTrace();
            }
        }
        return inst;
    }

    private List extractAnnotTypes(Node typeNode) {
        NodeList children = typeNode.getChildNodes();
        int size = children.getLength();
        ArrayList<String> rtn = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals("type")) continue;
            rtn.add(this.getTextNodeValue(node));
        }
        return rtn;
    }

    private List extractValues(Node node) {
        String text = this.getTextNodeValue(node);
        StringTokenizer tokenizer = new StringTokenizer(text, ", ");
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    private List extractSeqTypes(Node node) {
        ArrayList<SeqType> seqTypes = new ArrayList<SeqType>();
        NodeList list = node.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = list.item(i);
            if (!childNode.getNodeName().equals("type")) continue;
            SeqType st = this.extractSeqType(childNode);
            seqTypes.add(st);
        }
        return seqTypes;
    }

    private SeqType extractSeqType(Node typeNode) {
        NodeList nodeList = typeNode.getChildNodes();
        if (nodeList.getLength() == 1) {
            return new SeqType(this.getTextNodeValue(typeNode));
        }
        SeqType seqType = new SeqType();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeName().equals("name")) {
                seqType.setName(this.getTextNodeValue(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("useStartAndEnd")) {
                seqType.setHasStartAndEnd(this.getTextNodeBoolean(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("queryForValueList")) {
                seqType.setQueryForValues(this.getTextNodeBoolean(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("isTopLevel")) {
                seqType.setIsTopLevelFeatType(this.getTextNodeBoolean(childNode));
                continue;
            }
            if (!childNode.getNodeName().equals("values")) continue;
            seqType.setValues(this.extractValues(childNode));
        }
        return seqType;
    }

    private String[] extractPrograms(Node programsNode) {
        ChadoProgram[] prg = this.extractRichPrograms(programsNode);
        String[] ret = new String[prg.length];
        for (int i = 0; i < prg.length; ++i) {
            ret[i] = prg[i].getName();
        }
        return ret;
    }

    private ChadoProgram[] extractRichPrograms(Node programsNode) {
        NodeList children = programsNode.getChildNodes();
        int size = children.getLength();
        ArrayList<ChadoProgram> programList = new ArrayList<ChadoProgram>();
        for (int i = 0; i < size; ++i) {
            Node progNode = children.item(i);
            if (!progNode.getNodeName().equals("program")) continue;
            NodeList progTree = progNode.getChildNodes();
            if (progTree.getLength() > 1) {
                ChadoProgram currentPrg = new ChadoProgram();
                for (int j = 0; j < progTree.getLength(); ++j) {
                    Node progSubNode = progTree.item(j);
                    if (progSubNode.getNodeName().equals("retrieveCDS")) {
                        currentPrg.setRetrieveCDS(this.getTextNodeBoolean(progSubNode));
                        continue;
                    }
                    if (progSubNode.getNodeName().equals("name")) {
                        currentPrg.setName(this.getTextNodeValue(progSubNode));
                        continue;
                    }
                    if (progSubNode.getNodeName().equals("source")) {
                        currentPrg.setSource(this.getTextNodeValue(progSubNode));
                        continue;
                    }
                    if (!progSubNode.getNodeName().equals("version")) continue;
                    currentPrg.setVersion(this.getTextNodeValue(progSubNode));
                }
                programList.add(currentPrg);
                continue;
            }
            programList.add(new ChadoProgram(this.getTextNodeValue(progNode)));
        }
        ChadoProgram[] programs = new ChadoProgram[programList.size()];
        programList.toArray(programs);
        return programs;
    }

    private boolean extractHitFeatLocs(Node node) {
        String boolString = this.getTextNodeValue(node);
        return boolString.equals("true");
    }

    private String getTextNodeValue(Node node) {
        Node textNode = node.getFirstChild();
        return textNode.getNodeValue().trim();
    }

    private boolean getTextNodeBoolean(Node node) {
        return this.getTextNodeValue(node).equals("true");
    }
}

