/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.ChadoDatabase;
import java.util.ArrayList;
import java.util.List;

public class SeqType {
    private String name;
    private boolean hasStartAndEnd = false;
    private boolean isTopLevelFeatType = false;
    private boolean queryForValues = false;
    private List locationTopLevelSeqIds;
    private List valueList;

    SeqType() {
    }

    SeqType(String name) {
        this.setName(name);
    }

    void setName(String nm) {
        this.name = nm;
        if (this.name.equals("chromosome")) {
            this.hasStartAndEnd = true;
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List getLocationTopLevelSeqIds(ChadoDatabase db) {
        if (!this.hasStartAndEnd) {
            return new ArrayList(0);
        }
        if (this.locationTopLevelSeqIds != null) {
            return this.locationTopLevelSeqIds;
        }
        if (this.queryForValues) {
            try {
                this.locationTopLevelSeqIds = db.getJdbcChadoAdapter().getFeatNamesByType(this.name);
                if (this.locationTopLevelSeqIds.size() != 0) return this.locationTopLevelSeqIds;
                String m = "No features returned for type " + this.name + " either check db for " + this.name + " in cvterm and feature tables or ammend your config file " + " (chado-adapter.xml), change seq type or config values.";
                System.out.println(m);
                return this.locationTopLevelSeqIds;
            }
            catch (ApolloAdapterException e) {
                System.out.println("cant connect to database");
                if (ChadoAdapter.DEBUG) {
                    e.printStackTrace();
                }
                ArrayList<String> locationTopLevelSeqIds = new ArrayList<String>();
                locationTopLevelSeqIds.add("No database connection");
                return locationTopLevelSeqIds;
            }
        } else if (this.hasValues()) {
            this.locationTopLevelSeqIds = this.getValues();
            return this.locationTopLevelSeqIds;
        } else {
            this.locationTopLevelSeqIds = new ArrayList(1);
            this.locationTopLevelSeqIds.add("No values specified in chado adapter config");
        }
        return this.locationTopLevelSeqIds;
    }

    public boolean isTopLevelFeatType() {
        return this.isTopLevelFeatType;
    }

    public void setHasStartAndEnd(boolean sae) {
        this.hasStartAndEnd = sae;
    }

    public boolean hasStartAndEnd() {
        return this.hasStartAndEnd;
    }

    public void setQueryForValues(boolean q) {
        this.queryForValues = q;
    }

    public void setIsTopLevelFeatType(boolean tl) {
        this.isTopLevelFeatType = tl;
    }

    void setValues(List values) {
        this.valueList = values;
    }

    private List getValues() {
        return this.valueList;
    }

    private boolean hasValues() {
        return this.valueList != null;
    }
}

