/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.chado;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.chado.ChadoAdapter;
import apollo.dataadapter.chado.ChadoDatabase;
import apollo.dataadapter.chado.jdbc.ChadoInstance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class ChadoAdapterGUI
extends AbstractDataAdapterUI
implements ActionListener,
ItemListener {
    protected static String[] DRIVER_CLASSES = new String[]{"apollo.dataadapter.chado.jdbc.PostgresChadoAdapter", "apollo.dataadapter.chado.jdbc.SybaseChadoAdapter"};
    protected static String CUSTOM_DB_PROMPT = "Enter database info below or select from list";
    protected static String CUSTOM_SEQ_PROMPT = "Enter an ID below:";
    protected static String DEFAULT_LOGIN = "flybase";
    protected IOOperation operation;
    protected ChadoDatabase[] chado_dbs;
    private JPanel seqQueryPanel;
    protected JLabel databaseChoicePrompt = new JLabel("Chado database", 4);
    protected JComboBox databaseComboBox = null;
    protected JLabel driverClassPrompt = new JLabel("Chado driver class: ", 4);
    protected JComboBox driverClassComboBox = new JComboBox<String>(DRIVER_CLASSES);
    protected JLabel jdbcUrlPrompt = new JLabel("JDBC URL: ", 4);
    protected JTextField jdbcUrlTextField = new JTextField(30);
    protected JLabel chadoDbPrompt = new JLabel("Database/schema: ", 4);
    protected JTextField chadoDbTextField = new JTextField(30);
    protected JLabel usernamePrompt = new JLabel("          Login: ", 4);
    protected JTextField usernameTextField = new JTextField(30);
    protected JLabel passwordPrompt = new JLabel("       Password: ", 4);
    protected JPasswordField passwordTextField = new JPasswordField(30);
    protected String[] seqTypes = new String[]{"gene", "golden_path_region"};
    protected JLabel seqTypePrompt = new JLabel("Type of region: ", 4);
    protected JComboBox seqTypeComboBox = new JComboBox<String>(this.seqTypes);
    protected JLabel seqChoicePrompt = new JLabel("Region: ", 4);
    protected JComboBox seqChoiceComboBox = null;
    protected JButton seqChoiceButton = new JButton("Get " + this.seqTypes[0] + " list");
    protected JLabel seqIdPrompt = new JLabel("Region ID (e.g. gene name): ", 4);
    protected JTextField seqIdTextField = new JTextField();
    private JLabel startLabel = new JLabel("Start:");
    private JTextField startField = new JTextField();
    private JLabel endLabel = new JLabel("End:");
    private JTextField endField = new JTextField();
    private JLabel chromosomeLabel = new JLabel("Choose Chromosome:");
    private JComboBox chromosomeComboBox = new JComboBox();
    private static final String dbLabelPropName = "dbLabel";
    private static final String loginPropName = "Login";
    private static final String SEQ_ID_PROP_NAME = "SequenceID";
    private static final String seqTypePropName = "SequenceType";
    private static final String startPropName = "Start";
    private static final String endPropName = "End";
    String[] sequenceUniquenames;

    public ChadoAdapterGUI(IOOperation operation, ChadoDatabase[] chado_dbs) {
        this.operation = operation;
        this.chado_dbs = chado_dbs;
        this.makeUI();
    }

    public void doLayout() {
        this.validateSeqQueryPanel();
        super.doLayout();
    }

    private void validateSeqQueryPanel() {
        if (this.seqQueryPanel == null) {
            return;
        }
        if (this.operation.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            this.seqQueryPanel.setVisible(true);
        } else if (this.operation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            this.seqQueryPanel.setVisible(false);
        }
    }

    void setOperation(IOOperation operation) {
        if (operation == this.operation) {
            return;
        }
        this.operation = operation;
        this.validateSeqQueryPanel();
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 200);
    }

    public void setProperties(Properties props) {
        String dbLabel = props.getProperty(dbLabelPropName);
        if (dbLabel != null) {
            this.databaseComboBox.setSelectedItem(dbLabel);
        }
        if (!this.usernameIsConfigged()) {
            String login = props.getProperty(loginPropName);
            if (login != null) {
                this.usernameTextField.setText(login);
                this.passwordTextField.setEditable(true);
            } else {
                this.usernameTextField.setText(DEFAULT_LOGIN);
                this.passwordTextField.setEditable(false);
            }
        }
        this.setSequenceType(props.getProperty(this.getDbSpecificPropName(seqTypePropName)));
        String seqId = props.getProperty(this.getSeqIdPropName());
        if (seqId != null) {
            this.seqIdTextField.setText(seqId);
        }
        this.setStart(props.getProperty(this.getDbSpecificPropName(startPropName)));
        this.setEnd(props.getProperty(this.getDbSpecificPropName(endPropName)));
    }

    private String getSeqIdPropName() {
        return this.getDbSpecificPropName(SEQ_ID_PROP_NAME) + ":" + this.getSelectedSeqType();
    }

    private String getDbSpecificPropName(String propName) {
        return propName + ":" + this.getDbLabel();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put(dbLabelPropName, this.getDbLabel());
        props.put(loginPropName, this.getUsername());
        String typePropName = this.getDbSpecificPropName(seqTypePropName);
        props.put(typePropName, this.getSelectedSeqType());
        props.put(this.getSeqIdPropName(), this.getSequenceId());
        if (this.getStart() != null) {
            props.put(this.getDbSpecificPropName(startPropName), this.getStart());
        }
        if (this.getEnd() != null) {
            props.put(this.getDbSpecificPropName(endPropName), this.getEnd());
        }
        return props;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        ChadoAdapter adapter = this.getAndInitAdapter();
        IOOperation op = this.getOperation();
        adapter.setDatabase(this.getChadoDbString());
        if (op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            return adapter.getCurationSet();
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            adapter.commitChanges(values);
            return null;
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_READ_SEQUENCE)) {
            System.err.println(this.getClass() + ".doOperation: OP_READ_SEQUENCE unsupported");
            throw new ApolloAdapterException("Unsupported operation");
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_READ_RAW_ANALYSIS)) {
            System.err.println(this.getClass() + ".doOperation: OP_READ_RAW_ANALYSIS unsupported");
            throw new ApolloAdapterException("Unsupported operation");
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            System.err.println(this.getClass() + ".doOperation: OP_APPEND_DATA unsupported");
            throw new ApolloAdapterException("Unsupported operation");
        }
        throw new ApolloAdapterException("Unsupported operation");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.seqChoiceButton) {
            try {
                ChadoAdapter adapter = this.getAndInitAdapter();
                Vector uniquenames = new Vector();
                Vector descriptions = new Vector();
                adapter.getSequenceList(this.getSelectedSeqType(), uniquenames, descriptions);
                int nn = uniquenames.size();
                this.clearSeqChoiceComboBox();
                for (int i = 0; i < nn; ++i) {
                    String descr = (String)descriptions.elementAt(i);
                    this.seqChoiceComboBox.addItem(descr);
                }
                if (nn > 0) {
                    this.seqChoiceComboBox.setEnabled(true);
                }
                this.sequenceUniquenames = new String[nn];
                uniquenames.copyInto(this.sequenceUniquenames);
            }
            catch (ApolloAdapterException apolloAdapterException) {
                // empty catch block
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object[] selections;
        if (e.getItemSelectable() == this.seqChoiceComboBox) {
            if (e.getStateChange() == 1) {
                Object[] selections2 = this.seqChoiceComboBox.getSelectedObjects();
                int selection = this.seqChoiceComboBox.getSelectedIndex();
                if (selection == 0) {
                    this.seqIdTextField.setEditable(true);
                } else if (selection > 0) {
                    String newval = this.sequenceUniquenames[selection - 1];
                    this.seqIdTextField.setEditable(false);
                    this.seqIdTextField.setText(newval);
                }
            }
        } else if (e.getItemSelectable() == this.seqTypeComboBox) {
            this.clearSeqChoiceComboBox();
            String type = (String)this.seqTypeComboBox.getSelectedItem();
            if (this.isLocationQuery()) {
                this.setChromosomeGUIVisible(true);
                this.setSeqIDGUIVisible(false);
            } else {
                this.setChromosomeGUIVisible(false);
                this.setSeqIDGUIVisible(true);
            }
        } else if (e.getItemSelectable() == this.databaseComboBox && e.getStateChange() == 1 && (selections = this.databaseComboBox.getSelectedObjects()) != null && selections.length == 1) {
            String newval = selections[0].toString();
            this.newDatabaseSelected(newval, true);
        }
    }

    private void newDatabaseSelected(String newDb, boolean changeUI) {
        if (newDb.equals(CUSTOM_DB_PROMPT)) {
            this.driverClassComboBox.setEnabled(true);
            this.jdbcUrlTextField.setEditable(true);
            this.chadoDbTextField.setEditable(true);
        } else {
            ChadoDatabase db = this.getChadoDatabaseByName(newDb);
            if (db != null) {
                this.driverClassComboBox.setEnabled(false);
                this.jdbcUrlTextField.setEditable(false);
                this.chadoDbTextField.setEditable(false);
                this.driverClassComboBox.setSelectedItem(db.getAdapterClassName());
                this.jdbcUrlTextField.setText(db.getJdbcUrl());
                this.chadoDbTextField.setText(db.getChadoDb());
                if (db.hasLogin()) {
                    this.usernameTextField.setText(db.getLogin());
                }
                this.seqTypeComboBox.removeAllItems();
                ChadoInstance chadoInstance = db.getChadoInstance();
                for (int i = 0; i < chadoInstance.getSeqTypesSize(); ++i) {
                    this.seqTypeComboBox.addItem(chadoInstance.getSeqType(i).getName());
                }
            }
        }
        if (changeUI) {
            this.makeReadDataUI();
            this.validate();
            this.validateTree();
            this.repaint();
        }
    }

    protected ChadoDatabase getChadoDatabaseByName(String name) {
        if (this.chado_dbs != null) {
            int nc = this.chado_dbs.length;
            for (int i = 0; i < nc; ++i) {
                if (!this.chado_dbs[i].getName().equals(name)) continue;
                return this.chado_dbs[i];
            }
        }
        return null;
    }

    private ChadoAdapter getAndInitAdapter() throws ApolloAdapterException {
        ChadoAdapter adapter = this.setUpChadoAdapter();
        IOOperation op = this.getOperation();
        if (op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            DataInput dataInput;
            if (this.isLocationQuery()) {
                String startString = this.startField.getText();
                String endString = this.endField.getText();
                try {
                    String type = this.getSelectedSeqType();
                    dataInput = new DataInput(this.getSequenceId(), startString, endString, type);
                }
                catch (RuntimeException e) {
                    throw new ApolloAdapterException(e.getMessage());
                }
            } else {
                dataInput = new DataInput(this.getSelectedSeqType(), this.getSequenceId());
            }
            adapter.setDataInput(dataInput);
        }
        return adapter;
    }

    private ChadoAdapter setUpChadoAdapter() throws ApolloAdapterException {
        ChadoAdapter adapter = null;
        if (!(this.driver instanceof ChadoAdapter)) {
            throw new ApolloAdapterException("ChadoAdapterGUI not compatible with adapter " + this.driver);
        }
        adapter = (ChadoAdapter)this.driver;
        ChadoDatabase selectedDb = this.getSelectedDatabase();
        if (selectedDb == null) {
            throw new ApolloAdapterException("No database selected(or custom - fix this)");
        }
        selectedDb.setLogin(this.getUsername());
        selectedDb.setPassword(this.getPassword());
        adapter.setActiveDatabase(selectedDb);
        return adapter;
    }

    private boolean isLocationQuery() {
        if (this.getSelectedSeqType() == null) {
            return false;
        }
        if (this.getSelectedDatabase().getChadoInstance().typeHasStartAndEnd(this.getSelectedSeqType())) {
            return true;
        }
        DataInputType d = DataInputType.getDataTypeForSoType(this.getSelectedSeqType());
        if (d == null) {
            return false;
        }
        return d.isLocation();
    }

    protected void makeUI() {
        int nc = this.chado_dbs.length;
        if (nc == 0) {
            nc = 1;
        }
        String[] databaseChoices = new String[nc];
        for (int i = 0; i < this.chado_dbs.length; ++i) {
            databaseChoices[i] = this.chado_dbs[i].getName();
        }
        if (this.chado_dbs.length == 0) {
            databaseChoices[0] = "No dbs available--conf/chado-adapter.xml may be missing";
        }
        this.databaseComboBox = new JComboBox<String>(databaseChoices);
        this.seqChoiceComboBox = new JComboBox();
        this.clearSeqChoiceComboBox();
        this.databaseComboBox.addItemListener(this);
        this.seqTypeComboBox.addItemListener(this);
        this.seqChoiceComboBox.addItemListener(this);
        this.seqChoiceButton.addActionListener(this);
        if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            this.makeReadDataUI();
        }
        this.newDatabaseSelected(databaseChoices[0], false);
    }

    protected void makeReadDataUI() {
        this.removeAll();
        Insets i0 = new Insets(0, 0, 0, 0);
        Insets ir4 = new Insets(0, 0, 0, 4);
        int y = 0;
        Border lineborder = BorderFactory.createLineBorder(Color.gray);
        JPanel dbPanel = new JPanel();
        dbPanel.setLayout(new GridBagLayout());
        TitledBorder dbTitle = BorderFactory.createTitledBorder(lineborder, "Chado database");
        dbPanel.setBorder(dbTitle);
        dbPanel.add((Component)this.databaseChoicePrompt, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, ir4, 0, 0));
        dbPanel.add((Component)this.databaseComboBox, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, i0, 0, 0));
        y = 0;
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new GridBagLayout());
        TitledBorder userTitle = BorderFactory.createTitledBorder(lineborder, "Username and password");
        userPanel.setBorder(userTitle);
        userPanel.add((Component)this.usernamePrompt, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, ir4, 0, 0));
        userPanel.add((Component)this.usernameTextField, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, i0, 0, 0));
        userPanel.add((Component)this.passwordPrompt, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, ir4, 0, 0));
        userPanel.add((Component)this.passwordTextField, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, i0, 0, 0));
        y = 0;
        this.seqQueryPanel = this.createSeqQueryPanel();
        TitledBorder seqTitle = BorderFactory.createTitledBorder(lineborder, "Select a region to display");
        this.seqQueryPanel.setBorder(seqTitle);
        y = 0;
        this.setLayout(new GridBagLayout());
        Insets betweenInsets = new Insets(4, 4, 4, 4);
        this.add(dbPanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 13, 2, betweenInsets, 0, 0));
        if (!this.usernameIsConfigged()) {
            this.add(userPanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 13, 2, betweenInsets, 0, 0));
        }
        this.add(this.seqQueryPanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 13, 2, betweenInsets, 0, 0));
    }

    private JPanel createSeqQueryPanel() {
        Insets inset2;
        Insets inset1;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.insets = inset1 = new Insets(1, 2, 1, 2);
        panel.add((Component)this.seqTypePrompt, constraints);
        constraints.gridx = 1;
        constraints.anchor = 17;
        panel.add((Component)this.seqTypeComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 13;
        panel.add((Component)this.seqIdPrompt, constraints);
        constraints.gridx = 1;
        constraints.anchor = 17;
        this.seqIdTextField.setColumns(20);
        panel.add((Component)this.seqIdTextField, constraints);
        constraints.insets = inset2 = new Insets(1, 12, 1, 2);
        constraints.anchor = 13;
        constraints.gridx = 2;
        constraints.gridy = 0;
        panel.add((Component)this.startLabel, constraints);
        constraints.gridx = 3;
        constraints.insets = inset1;
        this.startField.setColumns(12);
        panel.add((Component)this.startField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = inset2;
        panel.add((Component)this.endLabel, constraints);
        constraints.gridx = 3;
        this.endField.setColumns(12);
        constraints.insets = inset1;
        panel.add((Component)this.endField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        panel.add((Component)this.chromosomeLabel, constraints);
        constraints.gridx = 1;
        panel.add((Component)this.chromosomeComboBox, constraints);
        return panel;
    }

    private void setChromosomeGUIVisible(boolean isVisible) {
        this.startLabel.setVisible(isVisible);
        this.startField.setVisible(isVisible);
        this.endLabel.setVisible(isVisible);
        this.endField.setVisible(isVisible);
        this.chromosomeLabel.setVisible(isVisible);
        this.setLocationTopLevelSeqIdList();
        this.chromosomeComboBox.setVisible(isVisible);
    }

    private void setLocationTopLevelSeqIdList() {
        if (this.getSelectedSeqType() == null) {
            return;
        }
        this.chromosomeComboBox.removeAllItems();
        List locTopLevelSeqIds = null;
        try {
            ChadoDatabase db = this.getSelectedDatabase();
            String seqType = this.getSelectedSeqType();
            locTopLevelSeqIds = db.getLocationTopLevelSeqIds(seqType);
        }
        catch (ApolloAdapterException e) {
            locTopLevelSeqIds = new ArrayList<String>(1);
            locTopLevelSeqIds.add("No db connection");
        }
        int size = locTopLevelSeqIds.size();
        for (int i = 0; i < size; ++i) {
            this.chromosomeComboBox.addItem(locTopLevelSeqIds.get(i));
        }
    }

    private void setSeqIDGUIVisible(boolean isVisible) {
        this.seqIdPrompt.setVisible(isVisible);
        this.seqIdTextField.setVisible(isVisible);
    }

    protected IOOperation getOperation() {
        return this.operation;
    }

    protected String getComboBoxValue(JComboBox cb) {
        Object sel = cb.getSelectedItem();
        return sel != null && sel instanceof String ? (String)sel : null;
    }

    protected void clearSeqChoiceComboBox() {
        this.seqChoiceComboBox.removeAllItems();
        this.seqChoiceComboBox.addItem(CUSTOM_SEQ_PROMPT);
        this.seqIdTextField.setEditable(true);
        this.seqChoiceComboBox.setEnabled(false);
    }

    private String getDbLabel() {
        return this.databaseComboBox.getSelectedItem().toString();
    }

    protected String getDriverClass() {
        return this.getComboBoxValue(this.driverClassComboBox);
    }

    protected String getJdbcUrl() {
        return this.jdbcUrlTextField.getText();
    }

    private String getChadoDbString() {
        return this.chadoDbTextField.getText();
    }

    protected String getUsername() {
        return this.usernameTextField.getText();
    }

    private boolean usernameIsConfigged() {
        if (this.getSelectedDatabase() == null) {
            return false;
        }
        return this.getSelectedDatabase().hasLogin();
    }

    protected String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    private void setStart(String start) {
        if (this.startField == null) {
            return;
        }
        this.startField.setText(start);
    }

    private String getStart() {
        if (this.startField == null) {
            return null;
        }
        return this.startField.getText();
    }

    private void setEnd(String end) {
        if (this.endField == null) {
            return;
        }
        this.endField.setText(end);
    }

    private String getEnd() {
        if (this.endField == null) {
            return null;
        }
        return this.endField.getText();
    }

    protected String getSelectedSeqType() {
        return this.getComboBoxValue(this.seqTypeComboBox);
    }

    private void setSequenceType(String type) {
        if (type == null) {
            return;
        }
        this.seqTypeComboBox.setSelectedItem(type);
    }

    protected String getSequenceId() {
        if (this.isLocationQuery()) {
            return (String)this.chromosomeComboBox.getSelectedItem();
        }
        return this.seqIdTextField.getText();
    }

    private ChadoDatabase getSelectedDatabase() {
        String newval;
        Object[] selections = this.databaseComboBox.getSelectedObjects();
        if (selections != null && selections.length == 1 && !(newval = selections[0].toString()).equals(CUSTOM_DB_PROMPT)) {
            return this.getChadoDatabaseByName(newval);
        }
        return null;
    }
}

