/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AbstractParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import java.io.InputStream;
import java.text.ParseException;
import java.util.StringTokenizer;

public class tRNA_Parser
extends AbstractParser {
    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            input.runFilter(false);
            try {
                while ((this.line = this.data.readLine()) != null) {
                    this.line = this.line.trim();
                    SeqFeatureI tRNA = this.grab_tRNA(curation, this.line, new_curation);
                    if (tRNA == null) continue;
                    System.out.println("Adding tRNA " + tRNA.getName());
                    if (tRNA.isForwardStrand()) {
                        this.forward_analysis.addFeature(tRNA);
                        continue;
                    }
                    this.reverse_analysis.addFeature(tRNA);
                }
                this.data.close();
            }
            catch (Exception ex) {
                this.parsed = false;
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    public String getProgram() {
        return "tRNAscan-SE";
    }

    public boolean recognizedInput() {
        try {
            this.readLine();
            boolean bl = this.parsed = this.line != null && this.line.startsWith("Sequence");
            if (this.parsed) {
                this.readLine();
                this.parsed &= this.line != null && this.line.startsWith("Name");
                if (this.parsed) {
                    this.readLine();
                    this.parsed &= this.line != null && this.line.startsWith("------");
                }
            }
        }
        catch (Exception e) {
            this.parsed = false;
        }
        return this.parsed;
    }

    private SeqFeatureI grab_tRNA(CurationSet curation, String line, boolean new_curation) throws ParseException {
        String value = "";
        boolean valid = true;
        SeqFeatureI tRNA = null;
        int begin = 0;
        int end = 0;
        String aa = "";
        String codon = "";
        double score = 0.0;
        StringTokenizer tokens = new StringTokenizer(line);
        try {
            if (valid &= tokens.hasMoreElements()) {
                String seq_name = tokens.nextToken();
                SequenceI focal_seq = curation.getRefSequence();
                if (focal_seq == null) {
                    System.out.println("Would like genomic sequence fasta file");
                    focal_seq = this.initSequence(curation, seq_name, 300000);
                    this.initCuration(curation, focal_seq);
                }
            }
            if (valid &= tokens.hasMoreElements()) {
                try {
                    int id = Integer.parseInt(tokens.nextToken());
                }
                catch (Exception e) {
                    valid = false;
                }
            }
            if (valid &= tokens.hasMoreElements()) {
                try {
                    begin = Integer.parseInt(tokens.nextToken());
                }
                catch (Exception e) {
                    valid = false;
                }
            }
            if (valid &= tokens.hasMoreElements()) {
                try {
                    end = Integer.parseInt(tokens.nextToken());
                }
                catch (Exception e) {
                    valid = false;
                }
            }
            if (valid &= tokens.hasMoreElements()) {
                aa = tokens.nextToken();
            }
            if (valid &= tokens.hasMoreElements()) {
                codon = tokens.nextToken();
            }
            if (valid &= tokens.hasMoreElements()) {
                tokens.nextToken();
            }
            if (valid &= tokens.hasMoreElements()) {
                tokens.nextToken();
            }
            if (valid &= tokens.hasMoreElements()) {
                try {
                    score = Double.valueOf(tokens.nextToken());
                }
                catch (Exception e) {
                    valid = false;
                }
            }
            if (valid) {
                tRNA = this.initFeature();
                int strand = begin > end ? 1 : -1;
                tRNA.setStrand(strand);
                tRNA.setStart(begin);
                tRNA.setEnd(end);
                tRNA.setName(aa);
                tRNA.setProgramName(this.program);
                tRNA.addProperty("aminoacid", aa);
                tRNA.addProperty("anticodon", codon);
                tRNA.setRefSequence(curation.getRefSequence());
                tRNA.setScore(score);
            }
        }
        catch (Exception ex) {
            throw new ParseException(ex.getMessage() + " occurred in tRNAscan parsing of line ", this.line_number);
        }
        if (valid) {
            return tRNA;
        }
        return null;
    }
}

