/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AbstractParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.util.FastaHeader;
import java.io.InputStream;
import java.util.StringTokenizer;

public class RpMaskerParser
extends AbstractParser {
    double score;
    String perc_sub = "";
    String perc_del = "";
    String perc_ins = "";
    String seq_name = "";
    int query_1;
    int query_2;
    int query_past;
    String complement = "";
    String repeatname = "";
    String acc = "";
    int subj_1;
    int subj_2;
    int subj_prior;
    String subj_unique = "";
    SequenceI focal_seq = null;

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            input.runFilter(false);
            if (this.focal_seq != null && curation.getRefSequence() == null) {
                curation.addSequence(this.focal_seq);
                this.initCuration(curation, this.focal_seq);
            } else {
                try {
                    while (this.line != null) {
                        this.parseLine(this.line);
                        FeaturePairI repeat = this.grabRepeat(curation);
                        if (repeat != null) {
                            if (repeat.isForwardStrand()) {
                                this.forward_analysis.addFeature(repeat);
                            } else {
                                this.reverse_analysis.addFeature(repeat);
                            }
                        }
                        this.readLine();
                    }
                    this.data.close();
                }
                catch (Exception ex) {
                    this.parsed = false;
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    public String getProgram() {
        return "RepeatMasker";
    }

    public boolean recognizedInput() {
        try {
            this.readLine();
            int i = 0;
            while (this.line != null && i < 10 && !this.parsed && this.line.toLowerCase().indexOf("genscan") < 0) {
                this.parsed = true;
                if (this.line.startsWith("There were no repetitive sequences detected in")) {
                    this.program = "repeatmasker";
                    int index = this.line.lastIndexOf(47);
                    String seq_name = index >= 0 ? this.line.substring(index + 1) : this.line;
                    index = seq_name.lastIndexOf(46);
                    if (index > 0) {
                        seq_name = seq_name.substring(0, index);
                    }
                    FastaHeader fasta = new FastaHeader(seq_name);
                    String seq_id = fasta.getSeqId();
                    this.focal_seq = fasta.generateSequence();
                    continue;
                }
                this.parseLine(this.line);
                if (!this.parsed) {
                    this.readLine();
                    ++i;
                    continue;
                }
                this.program = "repeatmasker";
            }
        }
        catch (Exception e) {
            this.parsed = false;
        }
        return this.parsed;
    }

    private FeaturePairI grabRepeat(CurationSet curation) {
        FeaturePair repeat = null;
        if (this.subj_unique.equals("")) {
            int length;
            if (curation.getRefSequence() == null) {
                System.out.println("Would like genomic sequence fasta file");
                SequenceI target_seq = this.initSequence(curation, this.seq_name, 300000);
                this.initCuration(curation, target_seq);
            }
            repeat = new FeaturePair(new SeqFeature(), new SeqFeature());
            int strand = this.complement.equals("+") ? 1 : -1;
            repeat.setStrand(strand);
            repeat.setRefSequence(curation.getRefSequence());
            repeat.setProgramName(this.program);
            repeat.setDatabase(this.database);
            repeat.setFeatureType(this.getAnalysisType());
            repeat.setId(this.repeatname);
            repeat.setScore(this.score);
            repeat.setLow(this.query_1);
            repeat.setHigh(this.query_2);
            repeat.setHstrand(1);
            if (this.complement.equals("+")) {
                repeat.setHlow(this.subj_1);
                repeat.setHhigh(this.subj_2);
                length = repeat.length() + this.subj_prior;
            } else {
                repeat.setHlow(this.subj_prior);
                repeat.setHhigh(this.subj_2);
                length = repeat.length() + this.subj_1;
            }
            SequenceI aligned_seq = curation.getSequence(this.repeatname);
            if (aligned_seq == null) {
                aligned_seq = curation.getSequence(this.acc);
            }
            if (aligned_seq == null) {
                aligned_seq = new Sequence(this.repeatname, "");
                aligned_seq.setLength(length);
                aligned_seq.setAccessionNo(this.acc);
                if (this.acc.startsWith("FB") || this.acc.startsWith("fb")) {
                    aligned_seq.addDbXref("FB", this.acc);
                } else {
                    aligned_seq.addDbXref("gb", this.acc);
                }
                curation.addSequence(aligned_seq);
            }
            repeat.setHitSequence(aligned_seq);
            repeat.addProperty("substitutions", this.perc_sub);
            repeat.addProperty("deletions", this.perc_del);
            repeat.addProperty("insertions", this.perc_ins);
        }
        return repeat;
    }

    private boolean parseLine(String line) {
        try {
            line = line.trim();
            StringTokenizer tokens = new StringTokenizer(line);
            this.score = this.parseDouble(tokens, "score_str");
            this.perc_sub = this.parseToken(tokens, "percent_sub");
            this.perc_del = this.parseToken(tokens, "percent_del");
            this.perc_ins = this.parseToken(tokens, "percent_ins");
            this.seq_name = this.parseToken(tokens, "seq_name");
            this.query_1 = this.parseLocation(tokens);
            this.query_2 = this.parseLocation(tokens);
            this.query_past = this.parseLocation(tokens);
            this.complement = this.parseToken(tokens, "complement");
            this.repeatname = this.parseToken(tokens, "repeat_name");
            this.acc = this.parseToken(tokens, "accession");
            this.subj_1 = this.parseLocation(tokens);
            this.subj_2 = this.parseLocation(tokens);
            this.subj_prior = this.parseLocation(tokens);
            this.subj_unique = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        }
        catch (Exception ex) {
            System.out.println("Caught exception " + ex);
            this.parsed = false;
        }
        return this.parsed;
    }

    private int parseLocation(StringTokenizer tokens) {
        String loc_str = this.parseToken(tokens, "location");
        int loc = -1;
        if (this.parsed) {
            int index = loc_str.indexOf("(");
            if (index >= 0) {
                loc_str = loc_str.substring(index + 1);
            }
            if ((index = loc_str.indexOf(")")) > 0) {
                loc_str = loc_str.substring(0, index);
            }
            try {
                loc = Integer.parseInt(loc_str);
            }
            catch (NumberFormatException ex) {
                this.parsed = false;
            }
        }
        return loc;
    }
}

