/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.GeneFinderParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import java.io.InputStream;
import java.text.ParseException;
import java.util.StringTokenizer;

public class GenieParser
extends GeneFinderParser {
    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            try {
                this.parsed = this.grabGenes(curation, this.forward_analysis, this.reverse_analysis);
                this.data.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                this.parsed = false;
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    protected boolean isCommentary() {
        if (this.line.startsWith("#")) {
            this.comment = this.line;
            return true;
        }
        this.comment = "";
        return false;
    }

    public boolean recognizedInput() {
        int tries = 0;
        try {
            this.readLine();
            this.parsed = false;
            while (this.line != null && !this.parsed && tries < 10) {
                this.line = this.line.trim();
                this.parsed = this.isCommentary();
                if (this.parsed) {
                    this.version = this.parseProgram();
                    this.parsed &= this.version != null && this.program != null;
                }
                if (this.parsed) continue;
                this.readLine();
                ++tries;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.parsed;
    }

    protected boolean parseLine() {
        this.comment = "";
        this.seq_name = "";
        this.source = "";
        this.type = "";
        this.low = 0;
        this.high = 0;
        this.score = 0.0;
        this.strand = 0;
        this.phase = "";
        this.gene_id = "";
        try {
            if (this.line != null) {
                this.line = this.line.trim();
                if (!this.isCommentary()) {
                    StringTokenizer tokens = new StringTokenizer(this.line);
                    this.seq_name = this.parseToken(tokens, "seq_name");
                    this.source = this.parseToken(tokens, "source");
                    this.type = this.parseToken(tokens, "type");
                    if (this.parsed) {
                        this.low = this.parseInteger(tokens, "low");
                    }
                    if (this.parsed) {
                        this.high = this.parseInteger(tokens, "high");
                    }
                    if (this.parsed) {
                        this.score = this.parseDouble(tokens, "score_str");
                    }
                    if (this.parsed) {
                        String strand_str = this.parseToken(tokens, "strand_str");
                        this.parsed &= strand_str.equals("+") || strand_str.equals("-") || strand_str.equals(".");
                        this.strand = strand_str.equals("+") || strand_str.equals(".") ? 1 : -1;
                        this.phase = this.parseToken(tokens, "phase");
                        this.parsed &= this.phase.equals("0") || this.phase.equals("1") || this.phase.equals("2") || this.phase.equals(".");
                        if (!this.parsed) {
                            this.phase = "";
                        } else {
                            String string = this.gene_id = tokens.hasMoreTokens() ? tokens.nextToken() : "";
                            if (this.gene_id == null) {
                                this.gene_id = "";
                            }
                            if (this.gene_id.startsWith("gene") && tokens.hasMoreTokens()) {
                                this.gene_id = tokens.nextToken();
                            }
                        }
                    }
                } else {
                    this.comment = this.line;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing line " + this.line);
            e.printStackTrace();
            this.parsed = false;
        }
        return this.parsed;
    }

    protected boolean grabGenes(CurationSet curation, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        SeqFeatureI gene = null;
        FeatureSetI transcript = null;
        try {
            while (this.line != null && this.parsed) {
                SequenceI focal_seq;
                if (this.comment.startsWith("##date")) {
                    this.grabDate(forward_analysis, reverse_analysis);
                } else if (this.comment.startsWith("##DNA")) {
                    focal_seq = this.grabDNA();
                    this.initCuration(curation, focal_seq);
                } else if (this.comment.equals("")) {
                    if (curation.getRefSequence() == null) {
                        focal_seq = this.initSequence(curation, this.seq_name, 50000000);
                        this.initCuration(curation, focal_seq);
                    }
                    if (gene != null && !gene.getId().equals(this.gene_id)) {
                        gene.addFeature(transcript);
                        this.addGene((FeatureSetI)gene, forward_analysis, reverse_analysis);
                        gene = null;
                        transcript = null;
                    }
                    if (this.type.equals("exon")) {
                        if (gene == null) {
                            gene = this.initSet(this.gene_id, this.strand);
                        }
                        if (transcript == null) {
                            transcript = this.initSet(this.trans_id, this.strand);
                        }
                        SeqFeatureI exon = this.initFeature();
                        exon.setScore(this.score);
                        transcript.setScore(transcript.getScore() + exon.getScore());
                        exon.setStrand(this.strand);
                        exon.setLow(this.low);
                        exon.setHigh(this.high);
                        transcript.addFeature(exon);
                    }
                } else if (!this.comment.startsWith("#") && !this.type.equals("sequence")) {
                    this.parsed = false;
                }
                this.readLine();
                if (this.line == null) continue;
                this.parseLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            this.parsed = false;
        }
        if (transcript != null) {
            gene.addFeature(transcript);
        }
        if (gene != null) {
            this.addGene(transcript, forward_analysis, reverse_analysis);
        }
        return this.parsed;
    }

    protected void grabDate(FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        String value = this.comment.substring("##date".length()).trim();
        if (value != null && !value.equals("")) {
            forward_analysis.addProperty("date", value);
            reverse_analysis.addProperty("date", value);
        }
    }

    protected SequenceI grabDNA() throws ParseException {
        String value;
        Sequence seq = null;
        if (this.comment.startsWith("##DNA ") && (value = this.comment.substring("##DNA".length()).trim()) != null && !value.equals("")) {
            seq = new Sequence(value, "");
            StringBuffer dna = new StringBuffer();
            this.line = "";
            try {
                this.readLine();
                while (this.line != null && !this.line.startsWith("##end-DNA")) {
                    dna.append(this.line.substring(2));
                    this.readLine();
                }
                seq.setResidues(dna.toString());
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                this.parsed = false;
                throw new ParseException("Error when parsing line " + this.line, this.line_number);
            }
        }
        if (seq == null) {
            System.out.println("Could not parse out ##DNA");
        }
        return seq;
    }

    private void debugLine(String line) {
        System.out.println("Parsed (" + this.parsed + ") " + "from line " + this.line_number + ": " + line + "\n\tcomment=" + this.comment + "\n\tseq_name=" + this.seq_name + "\n\tsource=" + this.source + "\n\ttype=" + this.type + "\n\tlow=" + this.low + "\n\thigh=" + this.high + "\n\tscore=" + this.score + "\n\tstrand=" + this.strand + "\n\tphase=" + this.phase + "\n\tgene_id=" + this.gene_id);
    }
}

