/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AlignmentParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.Sequence;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class BlatParser
extends AlignmentParser {
    String match;
    String misMatch;
    String repMatch;
    String numN;
    String queryGapCount;
    String queryGapBases;
    String targetGapCount;
    String targetGapBases;
    String strand;
    String queryName;
    String querySize;
    String queryStart;
    String queryEnd;
    String targetName;
    String targetSize;
    String targetStart;
    String targetEnd;
    String blockCount;
    String blockSizes;
    String queryStarts;
    String targetStarts;
    Vector splitBlockSizes;
    Vector splitQueryStarts;
    Vector splitTargetStarts;
    Vector all_features;

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            System.out.println("Parsing blat analysis  type is " + input.getType() + " analysis type is " + this.getAnalysisType());
            try {
                while (this.line != null) {
                    FeatureSetI hit = this.createFP();
                    if (hit.getStrand() == 1) {
                        this.forward_analysis.addFeature(hit, true);
                    } else {
                        this.reverse_analysis.addFeature(hit, true);
                    }
                    System.out.println("Hit size is " + hit.size());
                    this.readLine();
                    if (this.line == null) continue;
                    this.line = this.line.trim();
                    this.grabGenes();
                }
                this.data.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                this.parsed = false;
            }
        } else {
            System.out.println("Failed to parse blat data");
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    public String getProgram() {
        return "blat";
    }

    public boolean recognizedInput() {
        try {
            this.readLine();
            if (this.line == null) {
                return false;
            }
            if (this.line.startsWith("psLayout")) {
                this.readLine();
                if (this.line == null) {
                    return false;
                }
                if (this.line.length() < 2) {
                    this.readLine();
                }
                if (this.line == null) {
                    return false;
                }
                if (this.line.startsWith("match")) {
                    this.readLine();
                }
                if (this.line == null) {
                    return false;
                }
                this.line = this.line.trim();
                if (this.line.startsWith("match")) {
                    this.readLine();
                }
                if (this.line == null) {
                    return false;
                }
                if (this.line.startsWith("---")) {
                    this.readLine();
                }
                if (this.line == null) {
                    return false;
                }
            }
            if (this.line != null) {
                this.line = this.line.trim();
                this.grabGenes();
            } else {
                System.out.println("Failed to parse first line of blat data: " + this.line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.parsed;
    }

    public FeatureSetI createFP() {
        int blocks = this.splitBlockSizes.size();
        System.out.println(this.strand);
        FeatureSet hit = new FeatureSet();
        Sequence query_seq = new Sequence(this.queryName, "");
        query_seq.setLength(Integer.parseInt(this.querySize));
        Sequence target_seq = new Sequence(this.targetName, "");
        target_seq.setLength(Integer.parseInt(this.targetSize));
        hit.setRefSequence(query_seq);
        hit.setHitSequence(target_seq);
        int query_strand = this.strand.equals("+") ? 1 : -1;
        hit.setStrand(query_strand);
        hit.setScore(100.0);
        hit.setName(this.queryName);
        for (int index = 0; index < blocks; ++index) {
            int qHigh;
            int qLow;
            if (query_strand == 1) {
                qLow = Integer.parseInt((String)this.splitQueryStarts.elementAt(index));
                qHigh = qLow + Integer.parseInt((String)this.splitBlockSizes.elementAt(index));
            } else {
                qHigh = Integer.parseInt(this.querySize) - Integer.parseInt((String)this.splitQueryStarts.elementAt(index));
                qLow = Integer.parseInt(this.querySize) - Integer.parseInt((String)this.splitQueryStarts.elementAt(index)) - Integer.parseInt((String)this.splitBlockSizes.elementAt(index));
            }
            SeqFeature query = new SeqFeature();
            query.setStrand(query_strand);
            query.setLow(++qLow);
            query.setHigh(qHigh);
            System.out.print("STRAND" + this.strand + "  LOWER" + qLow + "--");
            System.out.println("HIGHER" + qHigh);
            System.out.println("SETTING Start as" + qLow + "  End" + qHigh + "--");
            query.setRefSequence(query_seq);
            query.setName(this.queryName);
            int tLow = Integer.parseInt((String)this.splitTargetStarts.elementAt(index));
            int tHigh = tLow + Integer.parseInt((String)this.splitBlockSizes.elementAt(index));
            SeqFeature target = new SeqFeature();
            target.setStrand(1);
            target.setLow(++tLow);
            target.setHigh(tHigh);
            System.out.print("TARGET" + this.strand + "  LOWER" + tLow + "--");
            System.out.println("HIGHER" + tHigh);
            System.out.println("SETTING Start as" + tLow + "  End" + tHigh + "--");
            target.setRefSequence(target_seq);
            FeaturePair fp = new FeaturePair(query, target);
            fp.setScore(100.0);
            hit.addFeature(fp);
            System.out.println("Added feature " + fp.getName());
            System.out.println(tLow + "-" + tHigh + " (" + qLow + "-" + qHigh + ")");
            System.out.println("made seqfeature object for each pair");
        }
        return hit;
    }

    public void errorCheck() {
        System.out.print(this.blockSizes + "-->");
        System.out.println(this.splitBlockSizes.lastElement());
        System.out.print(this.queryStarts + "-->");
        System.out.println(this.splitQueryStarts.lastElement());
        System.out.print(this.targetStarts + "--> ");
        System.out.println(this.splitTargetStarts.lastElement());
        System.out.print("*******************");
        System.out.println("THIS MANY LINES PARSED: " + this.line_number);
    }

    private void grabGenes() {
        StringTokenizer tokens = new StringTokenizer(this.line);
        int count = tokens.countTokens();
        boolean okay = true;
        this.match = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.match.equals("");
        this.misMatch = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.misMatch.equals("");
        this.repMatch = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.repMatch.equals("");
        this.numN = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.numN.equals("");
        this.queryGapCount = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryGapCount.equals("");
        this.queryGapBases = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryGapBases.equals("");
        this.targetGapCount = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetGapCount.equals("");
        this.targetGapBases = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetGapBases.equals("");
        this.strand = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.strand.equals("");
        this.queryName = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryName.equals("");
        this.querySize = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.querySize.equals("");
        this.queryStart = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryStart.equals("");
        this.queryEnd = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryEnd.equals("");
        this.targetName = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetName.equals("");
        this.targetSize = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetSize.equals("");
        this.targetStart = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetStart.equals("");
        this.targetEnd = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.targetEnd.equals("");
        this.blockCount = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.blockCount.equals("");
        this.blockSizes = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.blockSizes.equals("");
        this.queryStarts = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        okay &= !this.queryStarts.equals("");
        this.targetStarts = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        if (!(okay &= !this.targetStarts.equals(""))) {
            this.parsed = false;
            System.out.println("Could not parse " + this.line);
        } else {
            StringTokenizer tokensBS = new StringTokenizer(this.blockSizes, ",");
            this.splitBlockSizes = new Vector();
            while (tokensBS.hasMoreTokens()) {
                this.splitBlockSizes.add(tokensBS.nextToken());
            }
            StringTokenizer tokensQS = new StringTokenizer(this.queryStarts, ",");
            this.splitQueryStarts = new Vector();
            while (tokensQS.hasMoreTokens()) {
                this.splitQueryStarts.add(tokensQS.nextToken());
            }
            StringTokenizer tokensSS = new StringTokenizer(this.targetStarts, ",");
            this.splitTargetStarts = new Vector();
            while (tokensSS.hasMoreTokens()) {
                this.splitTargetStarts.add(tokensSS.nextToken());
            }
        }
    }
}

