/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AlignmentParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class BlastParser
extends AlignmentParser {
    boolean ncbi_version;
    boolean queryIsGenomic = true;
    boolean isFlyblast = false;
    String currentChrom = null;
    Hashtable hit_hash = new Hashtable();

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        this.queryIsGenomic = input.queryIsGenomic();
        this.initLoad(curation, new_curation, data_stream, input);
        if (this.parsed) {
            try {
                boolean bl = this.ncbi_version = this.version.toLowerCase().indexOf("wash") < 0 && this.version.toLowerCase().indexOf("build") < 0;
                if (this.ncbi_version) {
                    this.parseNCBI(curation, this.forward_analysis, this.reverse_analysis);
                } else {
                    this.parseWU(curation, this.forward_analysis, this.reverse_analysis);
                }
                this.data.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                this.parsed = false;
            }
        }
        return this.parsed ? this.getAnalysisType() : null;
    }

    public String getProgram() {
        return this.program;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean recognizedInput() {
        int tries = 0;
        try {
            this.readLine();
            while (this.line != null && !this.parsed && tries < 10) {
                int index;
                if (this.line.startsWith("<blast_form.map>")) {
                    this.isFlyblast = true;
                }
                boolean bl = this.parsed = (index = this.line.indexOf(32)) >= 0 && this.line.indexOf("BLAST") >= 0;
                if (!this.parsed) {
                    ++tries;
                    this.readLine();
                    continue;
                }
                this.program = this.line.substring(this.line.indexOf("BLAST"), index).toLowerCase();
                this.version = this.line.substring(++index);
                System.err.println("program = " + this.program + ", version = " + this.version);
                this.data.mark(9999999);
                SequenceI focal_seq = this.getQuerySequence(this.curation);
                if (this.curation.getRefSequence() == null) {
                    System.err.println("Genomic ref sequence was empty--using query sequence " + focal_seq.getName() + " as genomic ref seq.");
                    this.curation.setRefSequence(focal_seq);
                }
                this.data.reset();
                this.database = this.grabDatabase();
                System.err.println("database = " + this.database);
            }
        }
        catch (Exception e) {
            System.err.println("Exception while trying to parse blast output: " + e);
        }
        if (!this.parsed) {
            System.err.println("Unable to parse purported BLAST input--maybe it's a new BLAST format I don't recognize?");
            System.out.println("tries = " + tries + ", last line read: " + this.line);
        }
        return this.parsed;
    }

    private void parseWU(CurationSet curation, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) throws Exception {
        System.out.println("Parsing WU-blast or old NCBI blast (version 1) output.");
        this.readLine();
        boolean found_hit = false;
        FeatureSetI query_hit_minus = null;
        FeatureSetI query_hit_plus = null;
        FeaturePairI span = null;
        while (this.line != null) {
            SequenceI aligned_seq;
            this.line = this.line.trim();
            if (this.line.indexOf("*** NONE **") != -1) {
                System.out.println("No hits!");
                return;
            }
            if (this.line.length() > 0 && this.line.charAt(0) == '>') {
                this.recordHit(query_hit_plus, query_hit_minus, span, forward_analysis, reverse_analysis);
                this.grabHeader(this.hit_hash);
                span = null;
                found_hit = false;
                this.grabLength(this.hit_hash);
                if (this.program.equals("BLASTP")) {
                    aligned_seq = this.initSequence(curation, (String)this.hit_hash.get("header"), Integer.parseInt((String)this.hit_hash.get("length")));
                    query_hit_plus = this.initAlignment(aligned_seq, 1);
                    query_hit_minus = this.initAlignment(aligned_seq, -1);
                    found_hit = true;
                }
            } else if (this.line.startsWith("Plus Strand") || this.line.startsWith("Minus Strand")) {
                this.recordHit(query_hit_plus, query_hit_minus, span, forward_analysis, reverse_analysis);
                aligned_seq = this.initSequence(curation, (String)this.hit_hash.get("header"), Integer.parseInt((String)this.hit_hash.get("length")));
                query_hit_plus = this.initAlignment(aligned_seq, 1);
                query_hit_minus = this.initAlignment(aligned_seq, -1);
                span = null;
                found_hit = true;
            } else if (found_hit && this.line.trim().startsWith("Score =")) {
                if (span != null) {
                    this.addSpan(span, query_hit_plus, query_hit_minus);
                }
                span = this.initAlignPair();
                this.grabScores(span);
                this.readLine();
                this.grabMatches(span);
                this.grabFrame(span);
            } else if (span != null && found_hit && this.line.startsWith("Query")) {
                this.grabQueryMatch(span, false);
            } else if (span != null && found_hit && this.line.startsWith("Sbjct")) {
                this.grabSubjMatch(span, false);
            }
            this.readLine();
        }
        this.recordHit(query_hit_plus, query_hit_minus, span, forward_analysis, reverse_analysis);
        System.out.println("Done parsing WU-BLAST results.  Got " + forward_analysis.size() + " plus-strand hits and " + reverse_analysis.size() + " minus-strand hits.");
    }

    private void parseNCBI(CurationSet curation, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) throws Exception {
        boolean none = false;
        boolean found_hit = false;
        boolean flip = false;
        FeatureSetI query_hit_minus = null;
        FeatureSetI query_hit_plus = null;
        FeaturePairI span = null;
        this.currentChrom = curation.getChromosome();
        if (this.currentChrom == null) {
            System.out.println("Note: current region has no chromosome!");
            this.currentChrom = "";
        } else {
            if (this.currentChrom.indexOf(":") > 0 && this.currentChrom.indexOf("chromosome:") > 0) {
                this.currentChrom = this.currentChrom.substring(this.currentChrom.indexOf("chromosome:") + "chromosome:".length());
            }
            System.out.println("Currently loaded genomic region is on chromosome " + this.currentChrom);
        }
        this.readLine();
        while (this.line != null && !none) {
            this.line = this.line.trim();
            if (this.line.indexOf("*** NONE **") != -1) {
                none = true;
            } else if (this.line.length() > 0 && this.line.charAt(0) == '>') {
                this.recordHit(query_hit_plus, query_hit_minus, span, forward_analysis, reverse_analysis);
                this.grabHeader(this.hit_hash);
                span = null;
                found_hit = false;
                this.grabLength(this.hit_hash);
                int length = 0;
                try {
                    length = Integer.parseInt((String)this.hit_hash.get("length"));
                }
                catch (Exception e) {
                    System.err.println("Error while parsing NCBI blast output: length for hit " + this.hit_hash.get("header") + " is not an int: " + this.hit_hash.get("length"));
                }
                String header = (String)this.hit_hash.get("header");
                SequenceI aligned_seq = this.initSequence(curation, header, length);
                query_hit_plus = this.initAlignment(aligned_seq, 1);
                query_hit_minus = this.initAlignment(aligned_seq, -1);
                found_hit = true;
            } else if (found_hit && this.line.trim().startsWith("Score =")) {
                if (span != null) {
                    this.addSpan(span, query_hit_plus, query_hit_minus);
                }
                span = this.initAlignPair();
                this.grabScores(span);
                this.readLine();
                this.grabMatches(span);
                this.readLine();
                String subj_strand = this.grabFrame(span);
                flip = subj_strand.equals("Minus");
            } else if (span != null && found_hit && this.line.startsWith("Query")) {
                if (this.queryIsGenomic) {
                    this.grabQueryMatch(span, flip);
                } else {
                    this.grabSubjMatch(span, flip);
                }
            } else if (span != null && found_hit && this.line.startsWith("Sbjct")) {
                if (this.queryIsGenomic) {
                    this.grabSubjMatch(span, flip);
                } else {
                    this.grabQueryMatch(span, flip);
                }
            }
            this.readLine();
        }
        if (!none) {
            this.recordHit(query_hit_plus, query_hit_minus, span, forward_analysis, reverse_analysis);
        }
        System.out.println("Done parsing NCBI BLAST results.  Got " + forward_analysis.size() + " plus-strand hits and " + reverse_analysis.size() + " minus-strand hits.");
        System.gc();
    }

    private SequenceI getQuerySequence(CurationSet curation) throws Exception {
        StringBuffer query_name = new StringBuffer();
        query_name.append(this.findKeyValue("Query="));
        int length = 0;
        this.readLine();
        while (this.line != null && length == 0) {
            this.line = this.line.trim();
            int index = this.line.indexOf(" letters");
            if (index > 0) {
                String value = this.line.substring(0, index);
                value = value.replace(',', ' ');
                value = value.replace('(', ' ');
                value = value.trim();
                StringTokenizer tokens = new StringTokenizer(value);
                while (tokens.hasMoreElements()) {
                    String numb = tokens.nextToken();
                    length = length * 1000 + Integer.parseInt(numb);
                }
                continue;
            }
            query_name.append(" " + this.line);
            this.readLine();
        }
        SequenceI focal_seq = null;
        if (this.queryIsGenomic) {
            focal_seq = curation.getRefSequence();
            if (focal_seq == null) {
                focal_seq = this.initSequence(curation, query_name.toString(), length);
                focal_seq.setLength(length);
            }
            System.out.println("Query is genomic seq: " + focal_seq.getName() + "--length is " + length);
        } else {
            focal_seq = this.initSequence(curation, query_name.toString(), length);
            if (focal_seq == null) {
                System.err.println("Hey, after initSequence, focal_seq is still null!");
            }
            this.hit_hash.put("query_header", query_name.toString());
            String query_id = query_name.toString();
            if (query_id.indexOf(" ") > 0 && (query_id = query_id.substring(0, query_id.indexOf(" "))).length() > 12 && query_id.indexOf("|") > 2) {
                query_id = query_id.substring(0, query_id.indexOf("|"));
            }
            this.hit_hash.put("query_id", query_id.toString());
            System.out.println("Genomic is not query.  Query is " + focal_seq.getName() + "--length is " + focal_seq.getLength());
        }
        return focal_seq;
    }

    private String findKeyValue(String goal) throws Exception {
        String keyword = "";
        String value = "";
        boolean value_found = false;
        this.readLine();
        while (this.line != null && !value_found) {
            if (this.line.startsWith(goal)) {
                value = this.line.substring(goal.length());
                value = value.trim();
                value_found = true;
                continue;
            }
            if (this.line.startsWith("*" + goal)) {
                this.line = this.line.substring(1);
                value = this.line.substring(goal.length());
                if (value.startsWith("*")) {
                    value = value.substring(1);
                }
                value = value.trim();
                value_found = true;
                continue;
            }
            this.readLine();
        }
        return value;
    }

    private String grabDatabase() throws Exception {
        String db = this.findKeyValue("Database:");
        int index = db.lastIndexOf(47) + 1;
        if (index > 0 && index < db.length()) {
            db = db.substring(index);
        }
        return db;
    }

    private void grabLength(Hashtable hit_hash) throws Exception {
        boolean value_found = false;
        int MAX_DESCRIP_LENGTH = 1000;
        this.readLine();
        while (!value_found && this.line != null) {
            String value;
            this.line = this.line.trim();
            if (this.line.startsWith("Length")) {
                int equalpos = this.line.indexOf("=");
                value = this.line.substring(equalpos + 1);
                value.trim();
                value = value.replace(',', ' ');
                StringTokenizer tokens = new StringTokenizer(value);
                int length = 0;
                while (tokens.hasMoreElements()) {
                    String numb = tokens.nextToken();
                    length = length * 1000 + Integer.parseInt(numb);
                }
                value = String.valueOf(length);
                hit_hash.put("length", value);
                value_found = true;
                continue;
            }
            value = (String)hit_hash.get("header");
            if (value == null) {
                value = this.line;
            } else if (value.length() < MAX_DESCRIP_LENGTH) {
                value = value.concat(" " + this.line);
            }
            hit_hash.put("header", value);
            this.readLine();
        }
    }

    private void grabScores(FeaturePairI span) throws Exception {
        this.line.trim();
        try {
            String expect;
            String score;
            String bits;
            if (this.line.indexOf("bits (") >= 0) {
                bits = this.line.substring(this.line.indexOf("Score = ") + "Score = ".length(), this.line.indexOf("bits ("));
                bits.trim();
                score = this.line.substring(this.line.indexOf("bits (") + "bits (".length(), this.line.indexOf(41));
                score.trim();
                expect = this.line.substring(this.line.indexOf("Expect"), this.line.length());
                int lindex = expect.indexOf(" =");
                expect = expect.substring(lindex + 3, expect.length());
                if (expect.indexOf(" ") > 0) {
                    expect = expect.substring(0, expect.indexOf(" "));
                }
                expect = this.getDoubleValue(expect);
            } else {
                int last_separator;
                int first_separator = this.line.indexOf(44);
                String score_line = this.line.substring(0, first_separator);
                int next_separator = this.line.indexOf(44, ++first_separator);
                String expect_line = this.line.substring(first_separator, next_separator);
                String prob_line = (last_separator = this.line.indexOf(44, ++next_separator)) < 0 ? this.line.substring(next_separator) : this.line.substring(next_separator, last_separator);
                score = score_line.substring("Score =".length(), score_line.indexOf(40));
                score = score.trim();
                bits = this.line.substring(this.line.indexOf(" (") + " (".length(), this.line.indexOf(" bits)"));
                expect = expect_line.substring(expect_line.indexOf("Expect = ") + "Expect = ".length());
                expect = expect.trim();
                if (prob_line.indexOf("P =") >= 0) {
                    String prob = prob_line.substring(prob_line.indexOf(" = ") + " = ".length());
                    prob = prob.trim();
                    span.addScore("probability", Double.valueOf(prob));
                }
            }
            span.setScore(Double.valueOf(score));
            span.addScore("expect", Double.valueOf(expect));
            span.addScore("bits", Double.valueOf(bits));
        }
        catch (RuntimeException ex) {
            throw new Exception("BlastParser: error parsing score from " + this.line + ": " + ex.getMessage());
        }
    }

    private String getDoubleValue(String str) {
        String d_str = str.trim();
        try {
            double value = Double.valueOf(str);
        }
        catch (Exception e) {
            System.out.println("BlastParser: unable to convert " + str + " to double--using 1.0" + str + " instead");
            d_str = "1.0" + str;
        }
        return d_str;
    }

    private void grabMatches(FeaturePairI span) throws Exception {
        try {
            if (this.line != null) {
                this.line = this.line.trim();
                int index = this.line.indexOf("/");
                String match_string = this.line.substring("Identities = ".length(), index);
                int matches = this.program.toLowerCase().endsWith("blastx") ? Integer.parseInt(match_string) * 3 : Integer.parseInt(match_string);
                span.addScore("matches", matches);
            }
        }
        catch (RuntimeException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new Exception("BlastParser: error parsing identities from " + this.line + " " + ex.getMessage());
        }
    }

    private String grabFrame(FeaturePairI span) throws Exception {
        String keyword = "";
        String subj = "Plus";
        try {
            if (this.line != null && !this.line.equals("")) {
                this.line = this.line.trim();
                int index = this.line.lastIndexOf("Frame = ");
                if (index != -1) {
                    keyword = this.line.substring(index);
                    subj = (index = keyword.indexOf(" / ")) != -1 ? keyword.substring(index + " / ".length()) : keyword.substring("Frame = ".length());
                    span.getHitFeature().addProperty("frame", subj);
                } else {
                    index = this.line.lastIndexOf("Strand");
                    if (index >= 0) {
                        index = this.line.indexOf("/");
                        subj = this.line.substring(index + "/".length());
                        subj.trim();
                    } else if (!this.program.equals("BLASTP")) {
                        throw new Exception("Error parsing strand from " + this.line);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new Exception("BlastParser: error parsing strand/frame in " + this.line + " " + ex.getMessage());
        }
        return subj;
    }

    private void addSpan(FeaturePairI span, FeatureSetI query_hit_plus, FeatureSetI query_hit_minus) {
        if (span != null && query_hit_plus != null && query_hit_minus != null) {
            FeatureSetI hit = span.getStrand() == 1 ? query_hit_plus : query_hit_minus;
            this.addAlignPair(span, hit);
            this.rollCigar(span);
            double matches = span.getScore("matches");
            if (matches > 0.0) {
                double identity = matches * 100.0 / (double)span.length();
                span.addScore("identity", identity);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void grabQueryMatch(FeaturePairI span, boolean flip) throws Exception {
        void var3_4;
        StringTokenizer tokens;
        String queryOrSubject = "Query";
        if (!this.queryIsGenomic) {
            queryOrSubject = "Sbjct";
        }
        if (this.line.indexOf(queryOrSubject + ":") >= 0) {
            tokens = new StringTokenizer(this.line.substring(6));
        } else if (this.line.indexOf("*" + queryOrSubject + "=") >= 0) {
            tokens = new StringTokenizer(this.line.substring("*Query=* ".length()));
        } else if (this.line.indexOf(queryOrSubject) >= 0) {
            tokens = new StringTokenizer(this.line.substring(5));
        } else {
            System.err.println("Error: couldn't find " + queryOrSubject + " string in supposed query line " + this.line);
            return;
        }
        int start = -1;
        int end = -1;
        String value = var3_4.nextToken();
        if (!flip) {
            start = Integer.parseInt(value);
        } else {
            end = Integer.parseInt(value);
        }
        this.coord_seq = this.coord_seq + var3_4.nextToken();
        if (!var3_4.hasMoreElements()) {
            throw new Exception("Error parsing sbjct from " + this.line + " for span " + span.getName());
        }
        value = var3_4.nextToken();
        if (!flip) {
            end = Integer.parseInt(value);
        } else {
            start = Integer.parseInt(value);
        }
        int genomic_offset = this.input.getOffset();
        SeqFeatureI query_span = span.getQueryFeature();
        if (query_span.getStrand() == 0) {
            int strand = start < end ? 1 : (start > end ? -1 : 0);
            query_span.setStrand(strand);
            if (!flip) {
                query_span.setStart(start + genomic_offset);
            } else {
                query_span.setEnd(end + genomic_offset);
            }
        }
        if (!flip) {
            query_span.setEnd(end + genomic_offset);
        } else {
            query_span.setStart(start + genomic_offset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void grabSubjMatch(FeaturePairI span, boolean flip) throws Exception {
        String value;
        int pos;
        void var3_4;
        StringTokenizer tokens;
        String queryOrSubject = "Sbjct";
        if (!this.queryIsGenomic) {
            queryOrSubject = "Query";
        }
        if (this.line.indexOf(queryOrSubject + ":") >= 0) {
            tokens = new StringTokenizer(this.line.substring(6));
        } else if (this.line.indexOf(queryOrSubject) >= 0) {
            tokens = new StringTokenizer(this.line.substring(5));
        } else {
            System.err.println("Error: couldn't find " + queryOrSubject + " string in supposed subject line " + this.line);
            return;
        }
        int start = -1;
        int end = -1;
        String posStr = var3_4.nextToken();
        try {
            pos = Integer.parseInt(posStr);
            value = var3_4.nextToken();
        }
        catch (NumberFormatException e) {
            int index;
            for (index = 0; index < posStr.length() && Character.isDigit(posStr.charAt(index)); ++index) {
            }
            pos = Integer.parseInt(posStr.substring(0, index));
            value = posStr.substring(index);
        }
        if (!flip) {
            start = pos;
        } else {
            end = pos;
        }
        this.align_seq = this.align_seq + value;
        if (!var3_4.hasMoreElements()) {
            throw new Exception("Error parsing sbjct from " + this.line + " for span " + span.getName());
        }
        posStr = var3_4.nextToken();
        if (!flip) {
            end = Integer.parseInt(posStr);
        } else {
            start = Integer.parseInt(posStr);
        }
        SeqFeatureI align_span = span.getHitFeature();
        if (align_span.getStrand() == 0) {
            int strand = start < end ? 1 : (start > end ? -1 : 0);
            align_span.setStrand(strand);
            if (!flip) {
                align_span.setStart(start);
            } else {
                align_span.setEnd(end);
            }
        }
        if (!flip) {
            align_span.setEnd(end);
        } else {
            align_span.setStart(start);
        }
    }

    protected void setHitScore(FeatureSetI hit, FeaturePairI span) {
        double hit_expect = hit.getScore("expect");
        double span_expect = span.getScore("expect");
        if (hit.size() == 1 || span_expect < hit_expect) {
            hit.addScore("expect", hit_expect);
            hit.addScore("probability", span.getScore("probability"));
        }
        if (hit.size() == 1 || span.getScore() > hit.getScore()) {
            hit.setScore(span.getScore());
        }
    }

    private void recordHit(FeatureSetI query_hit_plus, FeatureSetI query_hit_minus, FeaturePairI span, FeatureSetI forward_analysis, FeatureSetI reverse_analysis) {
        if (query_hit_plus != null && query_hit_minus != null) {
            String header;
            if (span != null) {
                this.addSpan(span, query_hit_plus, query_hit_minus);
            }
            if (query_hit_plus.size() > 0) {
                if (!this.queryIsGenomic && this.currentChrom != null) {
                    header = (String)this.hit_hash.get("header");
                    if (header.indexOf("chromosome " + this.currentChrom) < 0) {
                        System.out.println("Skipping hit that does not match current chrom " + this.currentChrom + ": " + header);
                        return;
                    }
                    if (query_hit_plus.getHitSequence().getName().indexOf((String)this.hit_hash.get("query_id")) < 0) {
                        query_hit_plus.getHitSequence().setName((String)this.hit_hash.get("query_id") + " hit to " + query_hit_plus.getName());
                    }
                }
                System.out.println("recordHit: adding plus strand hit " + query_hit_plus);
                forward_analysis.addFeature(query_hit_plus, true);
            }
            if (query_hit_minus.size() > 0) {
                if (!this.queryIsGenomic && this.currentChrom != null) {
                    header = (String)this.hit_hash.get("header");
                    if (header.indexOf("chromosome " + this.currentChrom) < 0) {
                        return;
                    }
                    if (query_hit_minus.getHitSequence().getName().indexOf((String)this.hit_hash.get("query_id")) < 0) {
                        query_hit_minus.getHitSequence().setName((String)this.hit_hash.get("query_id") + " hit to " + query_hit_minus.getName());
                    }
                }
                reverse_analysis.addFeature(query_hit_minus, true);
            }
        }
    }

    private void grabHeader(Hashtable hit_hash) {
        hit_hash.put("header", this.line.substring(1));
    }
}

