/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisFilter;
import apollo.analysis.filter.AnalysisFilterI;
import apollo.analysis.filter.AnalysisInput;
import apollo.analysis.filter.FilterPanel;
import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.config.TierProperty;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.analysis.AnalysisAdapterGUI;
import apollo.dataadapter.analysis.AnalysisParserI;
import apollo.datamodel.CurationSet;
import apollo.gui.GenericFileAdapterGUI;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AnalysisPanel
extends JPanel {
    private String label;
    protected JComboBox fileBox;
    protected JTextField seqField;
    protected JComboBox displayTierBox;
    protected JComboBox displayTypeBox;
    public JTextField offsetField;
    private Box box;
    private String example;
    protected AnalysisAdapterGUI parent;
    protected CurationSet curation;
    protected static String seq_label = "Query sequence file (FASTA format)";
    protected static String tier_label = "Tier ";
    protected static String type_label = "Type ";
    protected static String file_prop = "file";
    protected static String seq_prop = "seq";
    protected static String offset_label = "Offset";
    protected static String DEFAULT_TYPE = "New analysis results";
    protected static String DEFAULT_TIER = "New analysis results";
    private HashMap tier_history = new HashMap(20);
    private HashMap file_history = new HashMap(100);
    private String most_recent_tier;
    private String most_recent_file;
    private String historic_file;
    private boolean history_is_initialized = false;
    static final short DEFAULT_MAX_HISTORY_LENGTH = 10;
    protected AnalysisParserI parser;
    protected AnalysisFilterI filter;
    protected FilterPanel filterPanel;

    AnalysisPanel(AnalysisAdapterGUI parent, String name, AnalysisParserI parser, FilterPanel filter_panel) {
        this.parent = parent;
        this.curation = parent.getCurationSet();
        this.setName(name);
        this.label = name + " output file ";
        this.parser = parser;
        this.filter = new AnalysisFilter();
        this.filterPanel = filter_panel;
        filter_panel.setAnalysisPanel(this);
        this.setBackground(filter_panel.getBackground());
        this.buildGUI();
    }

    void addActionListener(ActionListener l) {
        if (this.fileBox != null) {
            this.fileBox.addActionListener(l);
        }
    }

    public AnalysisParserI getParser() {
        return this.parser;
    }

    public AnalysisFilterI getFilter() {
        return this.filter;
    }

    protected short getMaxHistoryLength() {
        return 10;
    }

    protected void setInputs(AnalysisInput in) {
        in.setTier((String)this.displayTierBox.getEditor().getItem());
        in.setType((String)this.displayTypeBox.getEditor().getItem());
        this.filterPanel.setInputs(in);
        if (this.isNewCuration()) {
            in.setOffset("", 1);
        } else if (!in.queryIsGenomic()) {
            in.setOffset(this.offsetField.getText(), 0);
        } else {
            in.setOffset(this.offsetField.getText(), this.curation.getStart());
        }
    }

    protected boolean isNewCuration() {
        return this.curation == null;
    }

    protected String getCurrentFile() {
        return this.most_recent_file;
    }

    protected String getCurrentSeq() {
        return this.isNewCuration() ? this.seqField.getText() : null;
    }

    protected String getCurrentTier() {
        if (this.most_recent_tier == null) {
            this.most_recent_tier = (String)this.displayTierBox.getEditor().getItem();
        }
        return this.most_recent_tier;
    }

    protected AnalysisInput getCurrentInput() {
        String input_src = this.getCurrentFile();
        AnalysisInput in = null;
        if (input_src != null) {
            in = new AnalysisInput();
            this.setInputs(in);
        }
        return in;
    }

    public DataInputType getInputType() {
        String filename = this.getCurrentFile();
        if (filename != null && filename.startsWith("http")) {
            return DataInputType.URL;
        }
        return DataInputType.FILE;
    }

    private String getToolTip() {
        return this.label;
    }

    protected void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = GuiUtil.makeJLabelWithFont(this.label);
        this.box = new Box(1);
        Box browsebox = new Box(0);
        browsebox.add(jLabel);
        this.fileBox = new JComboBox();
        this.fileBox.setPreferredSize(new Dimension(500, 15));
        this.fileBox.setEditable(true);
        browsebox.add(this.fileBox);
        browsebox.add(Box.createHorizontalGlue());
        this.fileBox.addItemListener(new fileItemListener());
        JButton browseOutputButton = new JButton("Browse...");
        browseOutputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalysisPanel.this.browseFiles();
            }
        });
        browsebox.add(browseOutputButton);
        this.box.add(browsebox);
        this.box.add(Box.createVerticalGlue());
        if (this.isNewCuration()) {
            browsebox = new Box(0);
            this.seqField = new JTextField("");
            this.seqField.setEditable(true);
            this.seqField.setPreferredSize(new Dimension(500, 30));
            this.seqField.setMaximumSize(new Dimension(500, 30));
            browsebox.add(GuiUtil.makeJLabelWithFont(seq_label));
            browsebox.add(this.seqField);
            browsebox.add(Box.createHorizontalGlue());
            JButton browseSeqButton = new JButton("Browse...");
            browseSeqButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnalysisPanel.this.browseSeqs();
                }
            });
            browsebox.add(browseSeqButton);
            this.box.add(browsebox);
            this.box.add(Box.createVerticalGlue());
        }
        this.addDisplayComponents();
        this.add(this.box);
        this.filterPanel.setVisible(true);
        this.addToPanel(this.filterPanel);
    }

    private void browseFiles() {
        File browsedFile;
        File selectedFile = null;
        String current_file = this.getCurrentFile();
        if (current_file == null) {
            current_file = (String)this.fileBox.getEditor().getItem();
        }
        if (current_file != null) {
            selectedFile = new File(current_file);
        }
        if ((browsedFile = GenericFileAdapterGUI.fileBrowser(selectedFile, (Component)((Object)this.parent))) == null) {
            return;
        }
        this.fileBox.configureEditor(this.fileBox.getEditor(), browsedFile.toString());
        this.most_recent_file = (String)this.fileBox.getEditor().getItem();
    }

    private void browseSeqs() {
        File browsedFile;
        File selectedFile = null;
        String current_file = this.getCurrentSeq();
        if (current_file == null) {
            current_file = this.seqField.getText();
        }
        if (current_file != null) {
            selectedFile = new File(current_file);
        }
        if ((browsedFile = GenericFileAdapterGUI.fileBrowser(selectedFile, (Component)((Object)this.parent))) == null) {
            return;
        }
        this.seqField.setText(browsedFile.toString());
    }

    protected void addDisplayComponents() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        this.displayTierBox = new JComboBox();
        this.displayTierBox.setEditable(true);
        JLabel tierLabel = GuiUtil.makeJLabelWithFont(tier_label);
        this.displayTypeBox = new JComboBox();
        this.displayTypeBox.setEditable(true);
        JLabel typeLabel = GuiUtil.makeJLabelWithFont(type_label);
        this.displayTierBox.addItemListener(new displayTierItemListener());
        panel.add((Component)tierLabel, GuiUtil.makeConstraintAt(0, 0, 1));
        panel.add((Component)this.displayTierBox, GuiUtil.makeConstraintAt(1, 0, 1));
        panel.add((Component)typeLabel, GuiUtil.makeConstraintAt(2, 0, 1));
        panel.add((Component)this.displayTypeBox, GuiUtil.makeConstraintAt(3, 0, 1));
        if (!this.isNewCuration()) {
            this.offsetField = new JTextField("0", 12);
            this.offsetField.setEditable(true);
            JLabel offsetLabel = GuiUtil.makeJLabelWithFont("Genomic offset from " + this.curation.getStart());
            panel.add((Component)offsetLabel, GuiUtil.makeConstraintAt(0, 1, 1));
            panel.add((Component)this.offsetField, GuiUtil.makeConstraintAt(1, 1, 1));
        }
        this.addToPanel(panel);
    }

    protected void addToPanel(JComponent comp) {
        this.box.add(Box.createVerticalGlue());
        this.box.add(comp);
    }

    public Properties getProperties() {
        Properties current_properties = new Properties();
        current_properties.setProperty(tier_label, this.getCurrentTier());
        this.recordCurrentTierProperties();
        Iterator e = this.tier_history.keySet().iterator();
        while (e.hasNext()) {
            String tier_name = (String)e.next();
            Properties tier_props = (Properties)this.tier_history.get(tier_name);
            this.parent.addPropertiesWithPrefix(current_properties, tier_name, tier_props);
        }
        return current_properties;
    }

    protected String recordCurrentTierProperties() {
        String tier;
        Properties tier_properties = new Properties();
        String file_name = this.getCurrentFile();
        if (file_name != null) {
            tier_properties.setProperty(file_prop, file_name);
        }
        if ((tier = this.getCurrentTier()) != null) {
            this.tier_history.put(this.getCurrentTier(), tier_properties);
        }
        this.recordCurrentFileProperties();
        Iterator e = this.file_history.keySet().iterator();
        while (e.hasNext()) {
            file_name = (String)e.next();
            Properties file_properties = (Properties)this.file_history.get(file_name);
            this.parent.addPropertiesWithPrefix(tier_properties, file_name, file_properties);
        }
        return file_name;
    }

    protected void recordCurrentFileProperties() {
        Properties file_properties = this.filterPanel.getProperties();
        String type = (String)this.displayTypeBox.getEditor().getItem();
        file_properties.setProperty(type_label, type);
        if (this.isNewCuration()) {
            file_properties.setProperty(seq_prop, this.getCurrentSeq());
        } else {
            file_properties.setProperty(offset_label, this.offsetField.getText());
        }
        this.file_history.put(this.getCurrentFile(), file_properties);
    }

    public void initTiersList(String tier) {
        PropertyScheme scheme = Config.getPropertyScheme();
        Vector tier_scheme = scheme.getAllTiers();
        this.displayTierBox.removeAllItems();
        for (int i = 0; i < tier_scheme.size(); ++i) {
            TierProperty tp = (TierProperty)tier_scheme.elementAt(i);
            this.displayTierBox.addItem(tp.getLabel());
        }
        if (tier == null) {
            tier = DEFAULT_TIER;
        }
        this.displayTierBox.setSelectedItem(tier);
        this.displayTierBox.configureEditor(this.displayTierBox.getEditor(), tier);
        this.most_recent_tier = tier;
        this.initTypesList(tier);
    }

    public void initTypesList(String tier) {
        String type;
        PropertyScheme scheme;
        TierProperty tp;
        this.displayTypeBox.removeAllItems();
        if (tier != null && (tp = (scheme = Config.getPropertyScheme()).getTierProperty(tier, false)) != null) {
            Vector fp_vect = tp.getFeatureProperties();
            int fp_size = fp_vect.size();
            for (int i = 0; i < fp_size; ++i) {
                FeatureProperty fp = (FeatureProperty)fp_vect.elementAt(i);
                this.displayTypeBox.addItem(fp.getDisplayType());
            }
        }
        if ((type = (String)this.displayTypeBox.getItemAt(0)) != null) {
            this.displayTypeBox.setSelectedItem(type);
            this.displayTypeBox.configureEditor(this.displayTypeBox.getEditor(), type);
        }
    }

    public void setProperties(Properties combinedProperties) {
        this.tier_history.clear();
        this.parent.setChildProperties(combinedProperties, this.tier_history);
        this.history_is_initialized = false;
        this.initTiersList((String)combinedProperties.get(tier_label));
        this.setTierProperties((String)this.displayTierBox.getEditor().getItem());
        this.history_is_initialized = true;
    }

    protected void setTierProperties(String tier) {
        if (tier != null) {
            Properties combinedTierProperties = (Properties)this.tier_history.get(tier);
            this.file_history.clear();
            this.parent.setChildProperties(combinedTierProperties, this.file_history);
            Vector file_list = new Vector(this.file_history.keySet());
            this.fileBox.setModel(new DefaultComboBoxModel(file_list));
            if (combinedTierProperties != null) {
                this.setFileProperties(combinedTierProperties.getProperty(file_prop));
            } else if (this.most_recent_file != null) {
                this.fileBox.setSelectedItem(this.most_recent_file);
                this.fileBox.configureEditor(this.fileBox.getEditor(), this.most_recent_file);
            }
        }
    }

    protected void setFileProperties(String file) {
        if (file != null) {
            if (this.most_recent_file == null || this.most_recent_file != null && this.historic_file != null && !this.historic_file.equals("") && this.most_recent_file.equals(this.historic_file)) {
                this.fileBox.setSelectedItem(file);
                this.fileBox.configureEditor(this.fileBox.getEditor(), file);
                this.most_recent_file = file;
            }
            this.historic_file = file;
            Properties fileProperties = (Properties)this.file_history.get(file);
            if (fileProperties != null) {
                String type = fileProperties.getProperty(type_label);
                this.setCurrentTypeAndTier(type);
                String offset = fileProperties.getProperty(offset_label);
                String seq_file = fileProperties.getProperty(seq_prop);
                if (offset != null && !this.isNewCuration()) {
                    this.offsetField.setText(offset);
                } else if (this.isNewCuration() && seq_file != null) {
                    this.seqField.setText(seq_file);
                }
                if (this.filterPanel != null) {
                    this.filterPanel.setProperties(fileProperties);
                }
            }
        }
    }

    private void setCurrentTypeAndTier(String type) {
        String tier_label;
        if (type == null || type.equals("")) {
            type = DEFAULT_TYPE;
        }
        if ((tier_label = Config.getPropertyScheme().getTierProperty(type).getLabel()) != null) {
            this.displayTierBox.setSelectedItem(tier_label);
        }
        this.displayTypeBox.setSelectedItem(type);
        this.displayTypeBox.configureEditor(this.displayTypeBox.getEditor(), type);
    }

    void insertIntoTabbedPane(JTabbedPane pane, int index) {
        pane.insertTab(this.getName(), null, this, this.getToolTip(), index);
        pane.setBackgroundAt(index, this.getBackground());
    }

    public class displayTierItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                if (AnalysisPanel.this.history_is_initialized) {
                    AnalysisPanel.this.recordCurrentTierProperties();
                }
                AnalysisPanel.this.initTypesList((String)event.getItem());
                AnalysisPanel.this.setTierProperties((String)event.getItem());
            }
        }
    }

    public class fileItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1 && AnalysisPanel.this.history_is_initialized) {
                AnalysisPanel.this.recordCurrentFileProperties();
                AnalysisPanel.this.setFileProperties((String)event.getItem());
            }
        }
    }
}

