/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.analysis;

import apollo.analysis.filter.AnalysisInput;
import apollo.dataadapter.analysis.AbstractParser;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SequenceI;
import apollo.util.CigarUtil;
import java.io.InputStream;

public abstract class AlignmentParser
extends AbstractParser {
    protected String coord_seq;
    protected String align_seq;

    public String load(CurationSet curation, boolean new_curation, InputStream data_stream, AnalysisInput input) {
        System.err.println(this.getClass().getName() + " is Abstract and should never be used");
        return null;
    }

    protected void addAlignPair(FeaturePairI span, FeatureSetI hit) {
        hit.addFeature(span, true);
        span.setName(hit.getName() + " pair" + hit.size());
        span.setRefSequence(hit.getRefSequence());
        span.setHitSequence(hit.getHitSequence());
        this.setHitScore(hit, span);
    }

    protected void rollCigar(FeaturePairI span) {
        span.setExplicitAlignment(this.coord_seq);
        span.getHitFeature().setExplicitAlignment(this.align_seq);
        int untranslate = this.program.toLowerCase().endsWith("blastx") ? 3 : 1;
        span.setCigar(CigarUtil.roll(this.coord_seq, this.align_seq, untranslate));
        this.coord_seq = "";
        this.align_seq = "";
    }

    protected FeatureSetI initAlignment(SequenceI aligned_seq, int strand) {
        FeatureSet hit = new FeatureSet();
        hit.setStrand(strand);
        hit.setRefSequence(this.curation.getRefSequence());
        hit.setProgramName(this.program);
        hit.setDatabase(this.database);
        hit.setFeatureType(this.getAnalysisType());
        if (this.program.equalsIgnoreCase("blastx") || this.program.equalsIgnoreCase("blastp")) {
            aligned_seq.setResidueType("AA");
        } else {
            aligned_seq.setResidueType("DNA");
        }
        hit.setHitSequence(aligned_seq);
        hit.setName(aligned_seq.getName());
        return hit;
    }

    protected FeaturePairI initAlignPair() {
        SeqFeature query = new SeqFeature();
        SeqFeature sbjct = new SeqFeature();
        FeaturePair span = new FeaturePair(query, sbjct);
        span.setFeatureType(this.getAnalysisType());
        span.setRefSequence(this.curation.getRefSequence());
        this.coord_seq = "";
        this.align_seq = "";
        return span;
    }
}

