/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Region {
    private String chrom;
    private int start;
    private int end;

    public Region(String regionString) {
        this.parseRegionString(regionString);
    }

    public Region(String chrom, String startString, String endString) {
        this.start = Region.stringToPositiveInt(startString);
        this.end = Region.stringToPositiveInt(endString);
        this.checkStartLessThanEnd();
        this.chrom = chrom;
    }

    public Region(String chrom, int start, int end) {
        this.start = start;
        this.end = end;
        this.chrom = chrom;
        this.checkStartLessThanEnd();
    }

    public String getChromosome() {
        return this.chrom;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return this.getColonDashString();
    }

    public String getColonDashString() {
        return this.getChromosome() + ":" + this.getStart() + "-" + this.getEnd();
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    private void checkStartLessThanEnd() {
        if (this.start > this.end) {
            throw new RuntimeException("End value should be greater than start value.");
        }
    }

    private void parseRegionString(String regionString) {
        Region.nullCheck(regionString);
        boolean parsed = this.parseColonString(regionString);
        if (!parsed) {
            parsed = this.parseChrSpacesString(regionString);
        }
        if (!parsed) {
            throw new RuntimeException("failed to parse loc string " + regionString);
        }
        this.checkStartLessThanEnd();
    }

    private boolean parseColonString(String colonString) {
        Pattern p = Pattern.compile("(\\w+):(\\d+)[-:](\\d+)");
        Matcher m = p.matcher(colonString);
        boolean match = m.matches();
        if (!match) {
            return false;
        }
        this.chrom = m.group(1);
        String startString = m.group(2);
        String endString = m.group(3);
        this.start = Region.stringToInt(startString);
        this.end = Region.stringToInt(endString);
        return true;
    }

    private boolean parseChrSpacesString(String spacesString) {
        Pattern p = Pattern.compile("Chr (\\w+) (\\d+) (\\d+)");
        Matcher m = p.matcher(spacesString);
        boolean match = m.matches();
        if (!match) {
            return false;
        }
        this.chrom = m.group(1);
        String startString = m.group(2);
        String endString = m.group(3);
        this.start = Region.stringToInt(startString);
        this.end = Region.stringToInt(endString);
        return true;
    }

    public static void nullCheck(String chromString) {
        if (chromString == null) {
            throw new RuntimeException("Chromosome string is null");
        }
        if (chromString.equals("")) {
            throw new RuntimeException("Chromosome string is empty");
        }
    }

    private static int stringToPositiveInt(String intString) {
        int intVal = Region.stringToInt(intString);
        if (intVal < 0) {
            String m = "Positive integer value should be input for start or end field.";
            throw new RuntimeException(m);
        }
        return intVal;
    }

    public static int stringToInt(String intString) {
        int intValue;
        String errorMsg = intString + " is not valid in this field--expecting positive integer value.\n";
        if ((intString = Region.takeOutCommas(intString)).length() == 0) {
            throw new RuntimeException(errorMsg);
        }
        try {
            intValue = Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(errorMsg + e.getMessage());
        }
        return intValue;
    }

    private static String takeOutCommas(String intString) {
        int index = (intString = intString.trim()).indexOf(44);
        if (index < 0) {
            return intString;
        }
        return intString.replaceAll(",", "");
    }
}

