/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.EnsCGIAdapter;
import apollo.datamodel.CurationSet;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.gui.ProxyDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class EnsCGIAdapterGUI
extends AbstractDataAdapterUI {
    JComboBox regionList;
    JComboBox pathList;
    JComboBox chrStartEndList;
    JTextField chrTextBox;
    JTextField startTextBox;
    JTextField endTextBox;
    JLabel regionLabel;
    JLabel chrLabel;
    JLabel startLabel;
    JLabel endLabel;
    JLabel pathLabel;
    JLabel chrStartEndLabel;
    JTabbedPane pane;
    JPanel rangePanel;
    JPanel regionPanel;
    JButton proxyButton;
    ActionListener chrAction;
    Vector pathVector = new Vector();
    Vector regionVector = new Vector();
    Vector chrStartEndVector = new Vector();
    public static final int MAX_HISTORY_LENGTH = 5;
    public static final int REGION = 1;
    public static final int RANGE = 2;
    protected DataAdapter driver;
    protected IOOperation op;
    private Properties props;

    public EnsCGIAdapterGUI(IOOperation op) {
        this.op = op;
        this.regionList = new JComboBox();
        this.pathList = new JComboBox();
        this.chrTextBox = new JTextField();
        this.startTextBox = new JTextField();
        this.endTextBox = new JTextField();
        this.chrStartEndList = new JComboBox();
        this.regionLabel = new JLabel("Contig");
        this.chrLabel = new JLabel("Chr");
        this.startLabel = new JLabel("Start");
        this.endLabel = new JLabel("End");
        this.chrStartEndLabel = new JLabel("History");
        this.pathLabel = new JLabel("EnsCGI Server");
        this.proxyButton = new JButton("Proxy settings");
        this.proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(null);
                pd.setVisible(true);
            }
        });
        this.buildGUI();
        this.chrAction = new ChrStartEndListener();
        this.chrStartEndList.addActionListener(this.chrAction);
    }

    public static RangeI parseChrStartEndString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str);
        if (!tokenizer.nextToken().equals("Chr")) {
            System.out.println("Failed parsing location string " + str);
            return null;
        }
        String chr = tokenizer.nextToken();
        int start = Integer.parseInt(tokenizer.nextToken());
        int end = Integer.parseInt(tokenizer.nextToken());
        return new Range(chr, start, end);
    }

    public void setProperties(Properties in) {
        block7: {
            this.props = in;
            this.pathVector = new Vector();
            this.regionVector = new Vector();
            this.chrStartEndVector = new Vector();
            try {
                int i;
                int items = Integer.parseInt(this.props.getProperty("pathItems"));
                if (items != 0) {
                    for (i = 0; i < items; ++i) {
                        this.pathVector.addElement(this.props.getProperty("pathItem" + i));
                    }
                } else {
                    this.pathVector.addElement(Config.getCGIHost());
                }
                items = Integer.parseInt(this.props.getProperty("regionItems"));
                for (i = 0; i < items; ++i) {
                    this.regionVector.addElement(this.props.getProperty("regionItem" + i));
                }
                items = Integer.parseInt(this.props.getProperty("chrStartEndItems"));
                for (i = 0; i < items; ++i) {
                    this.chrStartEndVector.addElement(this.props.getProperty("chrStartEndItem" + i));
                }
            }
            catch (Exception e) {
                if (this.pathVector.size() != 0) break block7;
                this.pathVector.addElement(Config.getCGIHost());
            }
        }
        this.chrStartEndList.removeActionListener(this.chrAction);
        this.pathList.setModel(new DefaultComboBoxModel(this.pathVector));
        this.regionList.setModel(new DefaultComboBoxModel(this.regionVector));
        this.chrStartEndList.setModel(new DefaultComboBoxModel(this.chrStartEndVector));
        this.chrStartEndList.addActionListener(this.chrAction);
    }

    public Properties getProperties() {
        int i;
        this.chrStartEndList.removeActionListener(this.chrAction);
        String selectedPath = this.getSelectedPath();
        this.pathVector.removeElement(selectedPath);
        this.pathVector.insertElementAt(selectedPath, 0);
        if (this.pane.getSelectedComponent() == this.regionPanel) {
            String selectedRegion = this.getSelectedRegion();
            this.regionVector.removeElement(selectedRegion);
            this.regionVector.insertElementAt(selectedRegion, 0);
        } else {
            String selectedChrStartEnd = this.getSelectedChrStartEnd();
            this.chrStartEndVector.removeElement(selectedChrStartEnd);
            this.chrStartEndVector.insertElementAt(selectedChrStartEnd, 0);
        }
        Properties out = new Properties();
        if (this.pathVector.size() > 5) {
            out.put("pathItems", "5");
        } else {
            out.put("pathItems", this.pathVector.size() + "");
        }
        if (this.regionVector.size() > 5) {
            out.put("regionItems", "5");
        } else {
            out.put("regionItems", this.regionVector.size() + "");
        }
        if (this.chrStartEndVector.size() > 5) {
            out.put("chrStartEndItems", "5");
        } else {
            out.put("chrStartEndItems", this.chrStartEndVector.size() + "");
        }
        for (i = 0; i < this.pathVector.size() && i < 5; ++i) {
            out.put("pathItem" + i, (String)this.pathVector.elementAt(i));
        }
        for (i = 0; i < this.regionVector.size() && i < 5; ++i) {
            out.put("regionItem" + i, (String)this.regionVector.elementAt(i));
        }
        for (i = 0; i < this.chrStartEndVector.size() && i < 5; ++i) {
            out.put("chrStartEndItem" + i, (String)this.chrStartEndVector.elementAt(i));
        }
        this.chrStartEndList.addActionListener(this.chrAction);
        return out;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.pathLabel != null) {
            this.pathLabel.setFont(font);
        }
        if (this.regionLabel != null) {
            this.regionLabel.setFont(font);
        }
        if (this.regionList != null) {
            this.regionList.setFont(font);
        }
        if (this.pathList != null) {
            this.pathList.setFont(font);
        }
    }

    public void buildGUI() {
        this.setPreferredSize(new Dimension(450, 200));
        this.pathList.setPreferredSize(new Dimension(150, 20));
        this.pathList.setEditable(true);
        this.regionList.setPreferredSize(new Dimension(250, 10));
        this.regionList.setEditable(true);
        this.chrTextBox.setPreferredSize(new Dimension(150, 10));
        this.chrTextBox.setEditable(true);
        this.startTextBox.setPreferredSize(new Dimension(150, 10));
        this.startTextBox.setEditable(true);
        this.endTextBox.setPreferredSize(new Dimension(150, 10));
        this.endTextBox.setEditable(true);
        this.chrStartEndList.setPreferredSize(new Dimension(150, 20));
        this.chrStartEndList.setEditable(false);
        this.regionLabel.setPreferredSize(new Dimension(130, 12));
        this.pathLabel.setPreferredSize(new Dimension(130, 12));
        this.chrLabel.setPreferredSize(new Dimension(130, 12));
        this.startLabel.setPreferredSize(new Dimension(130, 12));
        this.endLabel.setPreferredSize(new Dimension(130, 12));
        this.chrStartEndLabel.setPreferredSize(new Dimension(130, 12));
        Box regionBox = new Box(0);
        regionBox.add(this.regionLabel);
        regionBox.add(this.regionList);
        regionBox.add(Box.createHorizontalGlue());
        Box pathBox = new Box(0);
        pathBox.add(this.pathLabel);
        pathBox.add(this.pathList);
        Box chrBox = new Box(0);
        chrBox.add(this.chrLabel);
        chrBox.add(this.chrTextBox);
        chrBox.add(Box.createHorizontalGlue());
        Box startBox = new Box(0);
        startBox.add(this.startLabel);
        startBox.add(this.startTextBox);
        startBox.add(Box.createHorizontalGlue());
        Box endBox = new Box(0);
        endBox.add(this.endLabel);
        endBox.add(this.endTextBox);
        endBox.add(Box.createHorizontalGlue());
        Box chrStartEndBox = new Box(0);
        chrStartEndBox.add(this.chrStartEndLabel);
        chrStartEndBox.add(this.chrStartEndList);
        chrStartEndBox.add(Box.createHorizontalGlue());
        this.pane = new JTabbedPane();
        this.rangePanel = new JPanel();
        this.pane.setPreferredSize(new Dimension(600, 70));
        this.rangePanel.setLayout(new BoxLayout(this.rangePanel, 1));
        this.rangePanel.setPreferredSize(new Dimension(450, 70));
        this.rangePanel.add(chrBox);
        this.rangePanel.add(startBox);
        this.rangePanel.add(endBox);
        this.rangePanel.add(chrStartEndBox);
        this.pane.insertTab("Range", null, this.rangePanel, "Select by base range", 0);
        this.regionPanel = new JPanel();
        this.regionPanel.setLayout(new BoxLayout(this.regionPanel, 1));
        this.regionPanel.add(regionBox);
        this.pane.insertTab("Contig", null, this.regionPanel, "Select by region name", 1);
        Box proxyBox = new Box(0);
        proxyBox.add(Box.createHorizontalGlue());
        proxyBox.add(this.proxyButton);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(pathBox);
        this.add(this.pane);
        this.add(proxyBox);
    }

    public void setDataAdapter(DataAdapter driver) {
        this.driver = driver;
    }

    public String getSelectedPath() {
        String selectedPath = (String)this.pathList.getSelectedItem();
        if (selectedPath == null || !selectedPath.equals(this.pathList.getEditor().getItem())) {
            selectedPath = (String)this.pathList.getEditor().getItem();
        }
        return selectedPath;
    }

    public String getSelectedRegion() {
        String selectedRegion = (String)this.regionList.getSelectedItem();
        if (selectedRegion == null || !selectedRegion.equals(this.regionList.getEditor().getItem())) {
            selectedRegion = (String)this.regionList.getEditor().getItem();
        }
        return selectedRegion;
    }

    public String getSelectedChrStartEnd() {
        return new String("Chr " + this.getSelectedChr() + " " + this.getSelectedStart() + " " + this.getSelectedEnd());
    }

    public String getSelectedChr() {
        String selectedChr = this.chrTextBox.getText();
        return selectedChr;
    }

    public String getSelectedStart() {
        String selectedStart = this.startTextBox.getText();
        return selectedStart;
    }

    public String getSelectedEnd() {
        String selectedEnd = this.endTextBox.getText();
        return selectedEnd;
    }

    private boolean areAllTextBoxesFilled() {
        if (this.pane.getSelectedComponent() == this.regionPanel) {
            return !this.getSelectedRegion().equals("") && this.getSelectedRegion() != null;
        }
        return this.chrTextBox.getText() != null && this.startTextBox.getText() != null && this.endTextBox.getText() != null && !this.chrTextBox.getText().equals("") && !this.startTextBox.getText().equals("") && !this.endTextBox.getText().equals("");
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        EnsCGIAdapter eca = (EnsCGIAdapter)this.driver;
        eca.setupAdapter(this.getSelectedPath());
        if (this.areAllTextBoxesFilled()) {
            if (this.pane.getSelectedComponent() == this.regionPanel) {
                eca.setRegion(this.getSelectedRegion());
                eca.setGetMode(1);
            } else {
                eca.setRegion(this.getSelectedChrStartEnd());
                eca.setGetMode(2);
            }
            if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                CurationSet out = ((ApolloDataAdapterI)this.driver).getCurationSet();
                return out;
            }
            return null;
        }
        throw new ApolloAdapterException("Didn't specify enough information");
    }

    public class ChrStartEndListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            RangeI loc = EnsCGIAdapterGUI.parseChrStartEndString((String)EnsCGIAdapterGUI.this.chrStartEndList.getSelectedItem());
            if (loc != null) {
                EnsCGIAdapterGUI.this.chrTextBox.setText(loc.getName());
                EnsCGIAdapterGUI.this.startTextBox.setText(loc.getStart() + "");
                EnsCGIAdapterGUI.this.endTextBox.setText(loc.getEnd() + "");
            }
        }
    }
}

