/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.CGI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.EnsCGIAdapterGUI;
import apollo.dataadapter.FeatureSetBuilder;
import apollo.dataadapter.NotImplementedException;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.seq.EnsCGISequence;
import apollo.datamodel.seq.SRSSequence;
import apollo.seq.io.GFFFile;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterRegistry;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.widget.DataAdapterChooser;
import org.bdgp.util.ProgressEvent;

public class EnsCGIAdapter
extends AbstractApolloAdapter {
    String path;
    String region;
    String chr;
    int start;
    int end;
    int mode;
    private SequenceI genomeSeq = null;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE};

    public void init() {
    }

    public String getName() {
        return "Ensembl - web site access for homo sapiens";
    }

    public String getType() {
        return "CGI server";
    }

    public DataInputType getInputType() {
        if (this.mode == 2) {
            return DataInputType.BASEPAIR_RANGE;
        }
        return DataInputType.CONTIG;
    }

    public String getInput() {
        return this.region;
    }

    public void setupAdapter(String path) throws ApolloAdapterException {
        this.path = path;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new EnsCGIAdapterGUI(op);
    }

    public EnsCGIAdapter(String filename) {
        this.path = this.path;
    }

    public EnsCGIAdapter() {
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        this.region = region;
        if (region.substring(0, 4).equals("Chr ")) {
            RangeI loc = EnsCGIAdapterGUI.parseChrStartEndString(region);
            if (loc != null) {
                this.start = loc.getStart();
                this.end = loc.getEnd();
                this.chr = loc.getName();
                this.mode = 2;
            }
        } else {
            this.mode = 1;
        }
    }

    public void setStart(String start) throws ApolloAdapterException {
        this.start = Integer.parseInt(start, 10);
    }

    public void setChr(String chr) throws ApolloAdapterException {
        this.chr = chr;
    }

    public void setEnd(String end) throws ApolloAdapterException {
        this.end = Integer.parseInt(end, 10);
    }

    public void setGetMode(int mode) {
        this.mode = mode;
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        props.put("path", this.path);
        return props;
    }

    public void setStateInformation(Properties props) {
        this.setPath(props.getProperty("path"));
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        super.clearOldData();
        CurationSet curationSet = new CurationSet();
        curationSet.setAnnots(new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet()));
        curationSet.setResults((StrandedFeatureSetI)this.getAnalysisRegion(curationSet));
        curationSet.setName(this.chr);
        curationSet.setChromosome(this.chr);
        curationSet.setLow(this.start);
        curationSet.setHigh(this.end);
        try {
            this.genomeSeq = this.getSequence(new DbXref(this.region, this.region, this.region));
            curationSet.setRefSequence(this.genomeSeq);
            System.out.println("Annotated Sequence: " + this.genomeSeq.getName() + " " + curationSet.length() + " bases");
        }
        catch (Exception e) {
            throw new ApolloAdapterException("Load failed. Are you sure " + this.region + "is a real sequence?", e);
        }
        return curationSet;
    }

    public FeatureSetI getAnalysisRegion(CurationSet curationSet) throws ApolloAdapterException {
        try {
            CGI cgi;
            block12: {
                Hashtable<String, String> var = new Hashtable<String, String>();
                if (this.mode == 2) {
                    var.put("chr", this.chr);
                    var.put("vc_start", String.valueOf(new Integer(this.start)));
                    var.put("vc_end", String.valueOf(new Integer(this.end)));
                    var.put("est", "on");
                    if (!Config.getDBHost().equals("")) {
                        var.put("dbhost", Config.getDBHost());
                    }
                    if (!Config.getDBName().equals("")) {
                        var.put("dbname", Config.getDBName());
                    }
                    if (!Config.getGPName().equals("")) {
                        var.put("gp", Config.getGPName());
                    }
                } else {
                    var.put("contig", this.region);
                }
                String host = this.path;
                int port = Config.getCGIPort();
                String cgistr = Config.getCGIScript();
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(0.0), "Contacting Ensembl server..."));
                cgi = new CGI(host, port, cgistr, var, System.out);
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(25.0), "Requesting region..."));
                cgi.run();
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(50.0), "Getting data..."));
                try {
                    String data = cgi.getInput().readLine();
                    if (data != null && data.startsWith("GENOMIC RANGE: ")) {
                        String region = data.substring("GENOMIC RANGE: ".length());
                        RangeI returnedRange = EnsCGIAdapterGUI.parseChrStartEndString(region);
                        System.out.println("Got range: " + returnedRange.getName() + " " + returnedRange.getStart() + "-" + returnedRange.getEnd());
                        if (this.mode == 1) {
                            this.start = returnedRange.getStart();
                            this.end = returnedRange.getEnd();
                            this.chr = returnedRange.getName();
                        }
                        break block12;
                    }
                    throw new ApolloAdapterException("Didn't find GENOMIC RANGE: line");
                }
                catch (IOException ioex) {
                    System.out.println("Exception " + ioex);
                }
            }
            GFFFile gff = new GFFFile(cgi.getInput());
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(75.0), "Populating data structures..."));
            for (int i = 0; i < gff.seqs.size(); ++i) {
                SeqFeatureI sf = (SeqFeatureI)gff.seqs.elementAt(i);
                this.setSequence(sf, curationSet);
            }
            StrandedFeatureSet fset = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            FeatureSetBuilder fsb = new FeatureSetBuilder();
            fsb.makeSetFeatures(fset, gff.seqs, Config.getPropertyScheme());
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(100.0), "Done..."));
            return fset;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApolloAdapterException(e);
        }
    }

    private void setSequence(SeqFeatureI sf, CurationSet curationSet) {
        if (sf instanceof FeaturePair) {
            FeaturePair pair = (FeaturePair)sf;
            String name = pair.getHname();
            SequenceI seq = curationSet.getSequence(name);
            if (seq == null) {
                seq = new SRSSequence(name, Config.getController());
                curationSet.addSequence(seq);
            }
            pair.getHitFeature().setRefSequence(seq);
        }
    }

    public static void main(String[] args) throws Exception {
        DataAdapterRegistry registry = new DataAdapterRegistry();
        registry.installDataAdapter("apollo.dataadapter.EnsCGIAdapter");
        registry.installDataAdapter("apollo.dataadapter.SerialDiskAdapter");
        registry.installDataAdapter("apollo.dataadapter.gamexml.GAMEAdapter");
        DataAdapterChooser chooser = new DataAdapterChooser(registry, ApolloDataAdapterI.OP_READ_DATA, "Load data", null, false);
        chooser.setPropertiesFile(new File("/mnt/Users/jrichter/cvs/apollo/src/java/apollo/dataadapter/junk.history"));
        chooser.show();
    }

    public FeatureSetI getAnnotatedRegion() throws ApolloAdapterException {
        return new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        if (dbxref.getIdValue().equals(this.region)) {
            EnsCGISequence ecs = new EnsCGISequence(this.region, Config.getController(), new Range(this.chr, this.start, this.end), this.path);
            ecs.getCacher().setMaxSize(1000000);
            return ecs;
        }
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }
}

