/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.DataListener;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class EfetchSequenceAdapter
extends AbstractApolloAdapter {
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_SEQUENCE};

    public void init() {
    }

    public String getName() {
        return "Efetch Sequence Adapter";
    }

    public String getType() {
        return "Efetch Sequence Data";
    }

    public DataInputType getInputType() {
        return null;
    }

    public String getInput() {
        return null;
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        String command = "efetch -q " + id;
        Process p = null;
        StringBuffer sb = new StringBuffer();
        try {
            p = Runtime.getRuntime().exec(command);
            BufferedInputStream is = new BufferedInputStream(p.getInputStream());
            int len = 0;
            byte[] buf = new byte[100];
            while (p != null && is != null && (len = is.read(buf)) != -1) {
                String str = new String(buf, 0, 0, len);
                sb.append(str);
            }
        }
        catch (EOFException eof) {
            System.out.println("Exception : " + eof);
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        String seqStr = sb.toString();
        if (id.equals("AF300871")) {
            System.out.println("Full string is " + seqStr);
        }
        Sequence seq = new Sequence(id, seqStr.toUpperCase());
        return seq;
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        return this.getSequence(dbxref.getIdValue());
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < dbxref.length; ++i) {
            seqs.addElement(this.getSequence(dbxref[i]));
        }
        return seqs;
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        if (end < start) {
            int tmp = start;
            start = end;
            end = tmp;
            System.out.println("WARNING: Correcting start and end in EfetchSequenceAdapter getSequence");
        }
        String command = "efetch -q -s " + start + " -e " + end + " " + dbxref.getIdValue();
        System.out.println("Running command: " + command);
        Process p = null;
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        try {
            p = Runtime.getRuntime().exec(command);
            BufferedInputStream is = new BufferedInputStream(p.getInputStream());
            int len = 0;
            byte[] buf = new byte[100];
            while (p != null && is != null && (len = is.read(buf)) != -1 && !done) {
                String str = new String(buf, 0, 0, len);
                sb.append(str);
            }
            System.out.println("Command thread is done");
        }
        catch (EOFException eof) {
            System.out.println("Exception : " + eof);
        }
        catch (IOException e) {
            System.out.println("Exception : " + e);
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        String str = sb.toString().toUpperCase();
        System.out.println("Fullstring " + str);
        Sequence seq = new Sequence(dbxref.getIdValue(), str);
        System.out.println("Got sequence " + seq);
        return seq;
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < dbxref.length; ++i) {
            seqs.addElement(this.getSequence(dbxref[i], start[i], end[i]));
        }
        return seqs;
    }

    public void addDataListener(DataListener dl) {
    }

    protected boolean rollbackAnnotations(CurationSet curationSet) {
        return true;
    }

    public DataAdapterUI getUI(IOOperation op) {
        return null;
    }
}

