/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.Config;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.Region;

public class DataInput {
    private DataInputType inputType;
    private Region region;
    private String inputString;
    private String sequenceFilename;

    public DataInput(DataInputType inputType, String inputString) {
        this.inputType = inputType;
        this.inputString = inputString;
        if (this.isRegion()) {
            this.parseRegion(this.inputString);
        }
    }

    public DataInput(String soType, String inputString) {
        if (soType == null) {
            return;
        }
        this.inputType = DataInputType.getDataTypeForSoType(soType);
        if (this.inputType.isLocation()) {
            this.parseRegion(inputString);
        } else {
            this.inputString = inputString;
        }
    }

    public DataInput(String chrom, String start, String end) {
        this.region = new Region(chrom, start, end);
        this.inputType = DataInputType.BASEPAIR_RANGE;
    }

    public DataInput(String chrom, String start, String end, String seqType) {
        this(chrom, start, end);
        this.inputType.setSoType(seqType);
    }

    public DataInput(DataInputType inputType) {
        this.inputType = inputType;
    }

    public DataInput(String inputString) {
        this.inputString = inputString;
    }

    public DataInputType getType() {
        return this.inputType;
    }

    public String getSoType() {
        return this.getType().getSoType();
    }

    public void setSoType(String soType) {
        this.getType().setSoType(soType);
    }

    public String getInputString() {
        if (this.haveRegion()) {
            return this.region.getColonDashString();
        }
        return this.inputString;
    }

    public String getSeqId() {
        if (Config.DEBUG) {
            System.out.println("DI.getSeqId() isReg " + this.isRegion() + " in string " + this.getInputString() + " this " + this);
        }
        if (this.isRegion()) {
            return this.getRegion().getChromosome();
        }
        return this.getInputString();
    }

    public void setType(DataInputType type) {
        this.inputType = type;
        if (this.isRegion() && this.haveInputString()) {
            this.parseRegion(this.getInputString());
        }
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
        if (this.isRegion()) {
            this.parseRegion(inputString);
        }
    }

    private boolean haveInputString() {
        return this.getInputString() != null;
    }

    public boolean isFile() {
        return this.getType() == DataInputType.FILE;
    }

    public String getFilename() {
        if (!this.isFile()) {
            return null;
        }
        return this.getInputString();
    }

    public boolean isRegion() {
        return this.getType() == DataInputType.BASEPAIR_RANGE;
    }

    public void makeDataTypeRegion() {
        if (this.isRegion()) {
            return;
        }
        String soType = this.inputType.getSoType();
        DataInputType t = DataInputType.BASEPAIR_RANGE;
        t.setSoType(soType);
        this.setType(t);
    }

    public Region getRegion() {
        return this.region;
    }

    private void parseRegion(String regionString) {
        this.region = new Region(regionString);
    }

    private boolean haveRegion() {
        return this.region != null;
    }

    public boolean hasInput() {
        if (this.getType() == null) {
            return false;
        }
        return this.haveInputString() || this.haveRegion();
    }

    public void setSequenceFilename(String sequenceFilename) {
        this.sequenceFilename = sequenceFilename;
    }

    public boolean hasSequenceFilename() {
        return this.getSequenceFilename() != null;
    }

    public String getSequenceFilename() {
        return this.sequenceFilename;
    }

    public String toString() {
        return "DataInput type: " + this.getType() + " input: " + this.getInputString();
    }
}

