/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.config.ApolloNameAdapterI;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.editor.AnnotationEditor;
import apollo.editor.TransactionManager;
import java.util.HashMap;
import java.util.Map;

public class CurationState {
    private int curationNumber;
    private String curationName;
    private CurationSet curationSet;
    private AnnotationEditor forwardAnnotEditor;
    private AnnotationEditor reverseAnnotEditor;
    private TransactionManager transactionManager;
    private ApolloDataAdapterI dataAdapter;
    private Map stringToNameAdapters = new HashMap(3);

    public CurationState(int i) {
        this.curationNumber = i;
    }

    public void setCurationName(String spStr) {
        this.curationName = spStr;
    }

    public String getCurationName() {
        return this.curationName;
    }

    public void setCurationSet(CurationSet cs) {
        this.curationSet = cs;
        if (cs.hasTransactionManager()) {
            this.transactionManager = cs.getTransactionManager();
        } else {
            cs.setTransactionManager(this.getTransactionManager());
        }
    }

    public CurationSet getCurationSet() {
        return this.curationSet;
    }

    public void setDataAdapter(ApolloDataAdapterI da) {
        this.dataAdapter = da.isComposite() ? da.getChildAdapter(this.curationNumber) : da;
    }

    public ApolloDataAdapterI getDataAdapter() {
        return this.dataAdapter;
    }

    public PropertyScheme getPropertyScheme() {
        if (this.getDataAdapter() == null) {
            return null;
        }
        return this.getDataAdapter().getStyle().getPropertyScheme();
    }

    public ApolloNameAdapterI getNameAdapter(AnnotatedFeatureI af) {
        if (af == null) {
            return null;
        }
        FeatureProperty fp = this.getPropertyScheme().getFeatureProperty(af.getTopLevelType());
        Object o = this.stringToNameAdapters.get(fp.getNameAdapterString());
        if (o != null) {
            return (ApolloNameAdapterI)o;
        }
        ApolloNameAdapterI na = fp.createNameAdapter();
        na.setTransactionManager(this.getTransactionManager());
        this.stringToNameAdapters.put(fp.getNameAdapterString(), na);
        return na;
    }

    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            if (this.curationSet != null && this.curationSet.hasTransactionManager()) {
                this.transactionManager = this.curationSet.getTransactionManager();
            } else {
                this.transactionManager = new TransactionManager();
                if (this.curationSet != null) {
                    this.curationSet.setTransactionManager(this.transactionManager);
                }
            }
        }
        return this.transactionManager;
    }

    public void addAnnotationEditor(AnnotationEditor ae, boolean forwardStrand) {
        if (forwardStrand) {
            this.forwardAnnotEditor = ae;
        } else {
            this.reverseAnnotEditor = ae;
        }
    }

    public AnnotationEditor getAnnotationEditor(boolean forwardStrand) {
        return forwardStrand ? this.forwardAnnotEditor : this.reverseAnnotEditor;
    }

    public boolean haveSequence() {
        SequenceI seq = this.curationSet.getRefSequence();
        if (seq == null) {
            return false;
        }
        if (seq.isLazy()) {
            return true;
        }
        return seq.getResidues() != null && !seq.getResidues().equals("");
    }

    public boolean haveAnnots() {
        if (this.curationSet == null || this.curationSet.getAnnots() == null) {
            return false;
        }
        return this.curationSet.getAnnots().size() > 0;
    }
}

