/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.datamodel.Chromosome;
import apollo.datamodel.ChromosomeBand;
import apollo.datamodel.Karyotype;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChromosomeAdapter {
    String filename;
    Vector karyotypes;

    public void init() {
    }

    public String getName() {
        return "Chromosome properties";
    }

    public String getType() {
        return "Chromosome file";
    }

    public ChromosomeAdapter(String filename) {
        this.filename = filename;
        try {
            this.karyotypes = this.parse_data();
        }
        catch (Exception e) {
            System.err.println("Execption parsing chromosome file " + e);
        }
    }

    public ChromosomeAdapter() {
    }

    public void setFilename(String filename) {
        this.filename = filename;
        try {
            this.karyotypes = this.parse_data();
        }
        catch (Exception e) {
            System.err.println("Execption parsing chromosome file " + e);
        }
    }

    public Vector getKaryotypes() {
        return this.karyotypes;
    }

    public Karyotype getKaryotypeBySpeciesName(String name) {
        for (int i = 0; i < this.karyotypes.size(); ++i) {
            Karyotype k = (Karyotype)this.karyotypes.elementAt(i);
            if (!k.getSpeciesName().equals(name)) continue;
            return k;
        }
        return null;
    }

    public Vector parse_data() throws ApolloAdapterException {
        this.karyotypes = new Vector();
        try {
            String line;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(this.filename)));
            BufferedReader dataIn = new BufferedReader(new InputStreamReader(bis));
            Hashtable<String, Hashtable> orgs = new Hashtable<String, Hashtable>();
            while ((line = dataIn.readLine()) != null) {
                Vector bandvec;
                Hashtable chrs;
                StringTokenizer str = new StringTokenizer(line);
                int count = str.countTokens();
                if (count != 6) {
                    System.err.println("Wrong number of tokens [" + count + "] should be 6");
                    continue;
                }
                String organism = str.nextToken();
                String chrname = str.nextToken();
                int start = Integer.parseInt(str.nextToken());
                int end = Integer.parseInt(str.nextToken());
                String bandid = str.nextToken();
                String stain = str.nextToken();
                ChromosomeBand band = new ChromosomeBand(bandid, chrname, start, end, stain);
                if (!orgs.containsKey(organism)) {
                    chrs = new Hashtable();
                    orgs.put(organism, chrs);
                } else {
                    chrs = (Hashtable)orgs.get(organism);
                }
                if (!chrs.containsKey(chrname)) {
                    bandvec = new Vector();
                    chrs.put(chrname, bandvec);
                } else {
                    bandvec = (Vector)chrs.get(chrname);
                }
                bandvec.addElement(band);
            }
            Enumeration en = orgs.keys();
            Hashtable chromosomes = new Hashtable();
            while (en.hasMoreElements()) {
                String org = (String)en.nextElement();
                Hashtable chr = (Hashtable)orgs.get(org);
                Enumeration en2 = chr.keys();
                Vector<Chromosome> chrs = new Vector<Chromosome>();
                chromosomes.put(org, chrs);
                while (en2.hasMoreElements()) {
                    String chrname = (String)en2.nextElement();
                    Vector bands = (Vector)chr.get(chrname);
                    Chromosome newchr = new Chromosome(org, chrname, bands);
                    chrs.addElement(newchr);
                }
            }
            Enumeration en3 = chromosomes.keys();
            while (en3.hasMoreElements()) {
                String org = (String)en3.nextElement();
                Vector chrs = (Vector)chromosomes.get(org);
                Karyotype kary = new Karyotype(org, chrs);
                this.karyotypes.addElement(kary);
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
        return this.karyotypes;
    }

    public static void main(String[] args) {
        try {
            ChromosomeAdapter ad = new ChromosomeAdapter(args[0]);
            Vector kary = ad.getKaryotypes();
            for (int i = 0; i < kary.size(); ++i) {
                Karyotype ka = (Karyotype)kary.elementAt(i);
                System.out.println("Org " + ka.getSpeciesName());
                Vector chr = ka.getChromosomes();
                for (int j = 0; j < chr.size(); ++j) {
                    Chromosome c = (Chromosome)chr.elementAt(j);
                    System.out.println("Chr " + c.getDisplayId() + " " + c.getPlength() + " " + c.getQlength() + " " + c.getCentroLength());
                    Vector bands = c.getBands();
                    for (int k = 0; k < bands.size(); ++k) {
                        ChromosomeBand band = (ChromosomeBand)bands.elementAt(k);
                        System.out.println("Band " + band.getDisplayId() + " " + band.getChrStart() + " " + band.getChrEnd() + " " + band.getStain());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
    }
}

