/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.DefaultDisplayPrefs;
import apollo.config.DisplayPrefsI;
import apollo.config.FeatureProperty;
import apollo.config.PeptideStatus;
import apollo.config.PropertyScheme;
import apollo.config.TierProperty;
import apollo.main.LoadUtil;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Style {
    private boolean queryForNamesOnSplit = false;
    private PropertyScheme properties;
    private String tiersFile;
    private DisplayPrefsI displayPrefs;
    private String blixemLocation = null;
    private boolean showAnnotations = false;
    private boolean showResults = true;
    private boolean editingEnabled = false;
    private boolean navigationManagerEnabled = false;
    private Vector chromosomes;
    private Vector annotationComments;
    private Vector transcriptComments;
    private Hashtable userToColor;
    private Hashtable userToProject;
    private Hashtable userToFullName;
    private Hashtable peptideStates = new Hashtable();
    private boolean verticallyMovePopups = true;
    private String geneUrl;
    private String scaffoldUrl;
    private String bandUrl;
    private String seqUrl;
    private String rangeUrl;
    private String nameAdapter;
    private String styleFileString;
    private ArrayList styleFiles = new ArrayList(2);
    private Color coordBackground = Color.white;
    private Color coordForeground = Color.black;
    private Color coordRevcompColor = Color.red;
    private Color featureBackground = Color.black;
    private Color annotationBackground = Color.cyan;
    private Color edgematchColor = Color.black;
    private Color highlightColor = Color.green;
    private Color selectionColor = Color.red;
    private Color seqGapColor = Color.yellow;
    private Color featureLabelColor = Color.white;
    private Color annotationLabelColor = Color.black;
    private Color edeBackgroundColor1 = Color.gray;
    private Color edeBackgroundColor2 = Color.black;
    private Color edeFeatureColor1 = Color.blue;
    private Color edeFeatureColor2 = new Color(0, 0, 180);
    private boolean dashSets = false;
    private int edgematchWidth = 2;
    private Color sequenceColor = this.coordForeground;
    private Color taggedColor = new Color(255, 0, 204);
    private Color seqErrorColor = new Color(255, 153, 0);
    private int evidencePanelHeight = 200;
    private boolean noStripes = true;
    private boolean draw3D = false;
    private boolean drawOutline = false;
    private boolean userTranscriptColouring = false;
    private boolean colorAllAnnotsByOwner = false;
    private boolean fastClipGraphics = true;
    private boolean internalMode = false;
    private String externalRefUrl;
    private Font defaultFont = new Font("Dialog", 0, 9);
    private Font defaultFeatureLabelFont = new Font("Dialog", 0, 9);
    private Font exonDetailEditorSequenceFont = new Font("Courier", 1, 12);
    private Color defaultUserColor = Color.orange;
    private int featureLoadSize = 1000000;
    private Hashtable resultTag = new Hashtable();
    private String errors = "";
    private int lineNum = 0;
    private Vector databaseList;
    private String defaultDatabase;
    private static final String defaultDefaultDatabase = "gadfly";
    private String databaseURLField = "%DATABASE%";
    private String padLeftURLField = "%PADLEFT%";
    private String padRightURLField = "%PADRIGHT%";
    private int defaultPadding = 25000;
    private boolean initialSitesVisibility = true;
    private int numberOfSpecies = 1;
    private boolean useGenericSyntenySpecies = false;
    private String defaultSyntenyDataAdapter;
    private List syntenySpeciesOrder = new ArrayList();
    private List syntenyLinkOrder = new ArrayList();
    private List syntenySpeciesAndLinkOrder = new ArrayList();
    private HashMap syntenySpeciesNames = new HashMap();
    private HashMap syntenySpeciesProperties = new HashMap();
    private boolean naiveCrossSpeciesDataLoading = false;
    private boolean useOpaqueLinks = true;
    private boolean addSyntenySpeciesNumDropdown = false;
    private boolean addSyntenyResultMenuItem = false;
    private boolean initialShiftForLockedZooming = true;
    private boolean initialLockedScrolling = false;
    private boolean syntenyLinksAreGeneToGene = true;
    private int singleSpeciesPanelSize = 0;
    private int linkPanelSize = 0;
    private Map syntenySpeciesToDb;
    private Map dbToStyle;
    private boolean showIdField = true;
    private boolean transcriptSymbolEditable = true;
    private boolean showIsDicistronicCheckbox = true;
    private boolean showEvalOfPeptide = true;
    private boolean showIsProbCheckbox = true;
    private boolean showFinishedCheckbox = true;
    private boolean showDbXRefTable = true;
    private boolean showReplaceStopCheckbox = true;
    private boolean translationalFrameShiftEditingEnabled = true;
    private boolean seqErrorEditingIsEnabled = true;
    private boolean showOwnershipAnnotMenuItem = true;
    private boolean showTranscriptFinishedAnnotMenuItem = true;
    private boolean transactionsAreInGameFile = false;
    private boolean enableIgbHttpConnection = false;
    private int geneticCodeNumber = 1;
    protected Hashtable parameters = null;

    public Style(String styleFileString) {
        this.setStyleFile(styleFileString);
        File styleFile = new File(styleFileString);
        this.readStyle(styleFile);
    }

    public void setStyleFile(String name) {
        this.styleFileString = name;
    }

    public String getAllStyleFilesString() {
        if (this.styleFiles.size() == 0) {
            return null;
        }
        String files = (String)this.styleFiles.get(0);
        for (int i = 1; i < this.styleFiles.size(); ++i) {
            files = files + ", " + this.styleFiles.get(i);
        }
        return files;
    }

    public void readStyle(String styleFilename) {
        if (styleFilename == null) {
            return;
        }
        if (this.styleFiles.contains(styleFilename)) {
            return;
        }
        this.readStyle(new File(styleFilename));
    }

    public void readStyle(File styleFile) {
        this.styleFiles.add(styleFile.toString());
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(styleFile)));
            tokenizer.eolIsSignificant(true);
            tokenizer.slashStarComments(true);
            boolean endOfFile = false;
            int tokType = 0;
            ArrayList<String> lineWords = new ArrayList<String>();
            while (!endOfFile) {
                tokType = tokenizer.nextToken();
                if (tokType == -1) {
                    endOfFile = true;
                    continue;
                }
                if (tokType != 10) {
                    if (tokenizer.sval != null) {
                        lineWords.add(tokenizer.sval);
                    }
                    ++this.lineNum;
                    continue;
                }
                if (lineWords.size() == 2) {
                    String key = (String)lineWords.get(0);
                    String value = (String)lineWords.get(1);
                    if (key.equals("Types")) {
                        String newTiersFile;
                        if (this.getFileName().indexOf("fly") >= 0) {
                            Style.askRenameGameConfig("game.tiers", "fly.tiers");
                        }
                        if ((newTiersFile = IOUtil.findFile(value)) == null) {
                            System.err.println("Can't find tiers file " + value + "--looking in jar");
                            newTiersFile = Config.getRootDir() + "/conf/" + value;
                            File tiers = new File(newTiersFile);
                            try {
                                Config.ensureExists(tiers, value, true);
                            }
                            catch (Exception e) {
                                System.out.println("Couldn't get " + value + " from jar");
                                newTiersFile = null;
                            }
                        }
                        if (newTiersFile == null) {
                            this.complain("Types file " + value + " not found!");
                            return;
                        }
                        if (this.tiersFile == null || !newTiersFile.equals(this.tiersFile)) {
                            this.setPropertyScheme(newTiersFile);
                        }
                        this.tiersFile = newTiersFile;
                    } else if (key.equals("BlixemLocation")) {
                        this.blixemLocation = new String(value);
                    } else if (key.equalsIgnoreCase("ShowAnnotations")) {
                        if (this.checkBoolean(value, "ShowAnnotations")) {
                            this.showAnnotations = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowResults")) {
                        if (this.checkBoolean(value, "ShowResults")) {
                            this.showResults = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EnableEditing")) {
                        if (this.checkBoolean(value, "EnableEditing")) {
                            this.editingEnabled = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EnableNavigationManager")) {
                        if (this.checkBoolean(value, "EnableNavigationManager")) {
                            this.navigationManagerEnabled = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("Chromosomes")) {
                        this.chromosomes = this.parseStringIntoVector(value);
                    } else if (key.equalsIgnoreCase("AnnotationTypes")) {
                        System.err.println("As of November 30, 2003 annotation types  are set using the tiers file. Ignoring " + value + " in style file " + styleFile);
                    } else if (key.equalsIgnoreCase("CommentOption")) {
                        System.err.println("Note: CommentOption (found in " + styleFile + ") is obsolete--use GeneComment or TranscriptComment.\n  Adding comment '" + value + "' to both lists.");
                        this.addCannedComment(value, "annotation");
                        this.addCannedComment(value, "transcript");
                    } else if (key.equalsIgnoreCase("AnnotationComment")) {
                        this.addCannedComment(value, "annotation");
                    } else if (key.equalsIgnoreCase("TranscriptComment")) {
                        this.addCannedComment(value, "transcript");
                    } else if (key.equalsIgnoreCase("UserInfo")) {
                        this.addUserInfo(value);
                    } else if (key.equalsIgnoreCase("PeptideStatus")) {
                        this.addPeptideStatus(value);
                    } else if (key.equalsIgnoreCase("FeatureLoadSize")) {
                        this.addFeatureLoadSize(Integer.valueOf(value));
                    } else if (key.equalsIgnoreCase("GeneURL")) {
                        this.geneUrl = value;
                    } else if (key.equalsIgnoreCase("BandURL")) {
                        this.bandUrl = value;
                    } else if (key.equalsIgnoreCase("ScaffoldURL")) {
                        this.scaffoldUrl = value;
                    } else if (key.equalsIgnoreCase("SequenceURL")) {
                        this.seqUrl = value;
                    } else if (key.equalsIgnoreCase("RangeURL")) {
                        this.rangeUrl = value;
                    } else if (key.equalsIgnoreCase("ExternalRefURL")) {
                        this.externalRefUrl = value;
                    } else if (key.equalsIgnoreCase("ProjectRefURL")) {
                        System.err.println("Warning: ProjectRefURL parameter (found in " + this.getFileName() + ") is no longer supported.\nUse the InternalMode parameter instead.");
                    } else if (key.equalsIgnoreCase("InternalMode")) {
                        if (this.checkBoolean(value, "internalMode")) {
                            this.internalMode = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("NameAdapterInstall")) {
                        this.installNameAdapter(value);
                    } else if (key.equalsIgnoreCase("OverlapDefinition")) {
                        this.setOverlapper(value);
                    } else if (key.equalsIgnoreCase("DisplayPreferences")) {
                        this.installDisplayPrefs(value);
                    } else if (key.equalsIgnoreCase("GeneDefinition")) {
                        System.out.println("GeneDefinition is no longer used");
                    } else if (key.equalsIgnoreCase("DashSets")) {
                        if (this.checkBoolean(value, "DashSets")) {
                            this.dashSets = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("FeatureBackgroundColor") || key.equalsIgnoreCase("ResultBackgroundColor")) {
                        if (this.checkValidColor(value, "FeatureBackgroundColor")) {
                            this.setFeatureBackground(FeatureProperty.toColour(value, this.featureBackground));
                        }
                    } else if (key.equalsIgnoreCase("AnnotationBackgroundColor")) {
                        if (this.checkValidColor(value, "AnnotationBackgroundColor")) {
                            this.setAnnotationBackground(FeatureProperty.toColour(value, this.annotationBackground));
                        }
                    } else if (key.equalsIgnoreCase("EdgematchWidth")) {
                        try {
                            this.edgematchWidth = Integer.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            this.complain("Can't parse number for EdgematchWidth: " + value);
                        }
                    } else if (key.equalsIgnoreCase("EdgematchColor")) {
                        if (this.checkValidColor(value, "EdgematchColor")) {
                            this.edgematchColor = FeatureProperty.toColour(value, this.edgematchColor);
                        }
                    } else if (key.equalsIgnoreCase("AnnotationLabelColor")) {
                        if (this.checkValidColor(value, "AnnotationLabelColor")) {
                            this.setAnnotationLabelColor(FeatureProperty.toColour(value, this.annotationLabelColor));
                        }
                    } else if (key.equalsIgnoreCase("LabelColor") || key.equalsIgnoreCase("featureLabelColor")) {
                        if (this.checkValidColor(value, "FeatureLabelColor")) {
                            this.setFeatureLabelColor(FeatureProperty.toColour(value, this.featureLabelColor));
                        }
                    } else if (key.equalsIgnoreCase("DefaultAnnotationColor")) {
                        if (this.checkValidColor(value, "DefaultAnnotationColor")) {
                            Config.defaultAnnotationColor = FeatureProperty.toColour(value, Config.defaultAnnotationColor);
                        }
                    } else if (key.equalsIgnoreCase("HighlightColor")) {
                        if (this.checkValidColor(value, "HighlightColor")) {
                            this.highlightColor = FeatureProperty.toColour(value, this.highlightColor);
                        }
                    } else if (key.equalsIgnoreCase("SelectionColor")) {
                        if (this.checkValidColor(value, "SelectionColor")) {
                            this.selectionColor = FeatureProperty.toColour(value, this.selectionColor);
                        }
                    } else if (key.equalsIgnoreCase("CoordBackgroundColor")) {
                        if (this.checkValidColor(value, "CoordBackgroundColor")) {
                            this.coordBackground = FeatureProperty.toColour(value, this.coordBackground);
                        }
                    } else if (key.equalsIgnoreCase("SequenceColor")) {
                        if (this.checkValidColor(value, "SequenceColor")) {
                            this.sequenceColor = FeatureProperty.toColour(value, this.sequenceColor);
                        }
                    } else if (key.equalsIgnoreCase("ExonDetailEditorBackgroundColor1")) {
                        if (this.checkValidColor(value, "ExonDetailEditorBackgroundColor1")) {
                            this.edeBackgroundColor1 = FeatureProperty.toColour(value, this.edeBackgroundColor1);
                        }
                    } else if (key.equalsIgnoreCase("ExonDetailEditorBackgroundColor2")) {
                        if (this.checkValidColor(value, "ExonDetailEditorBackgroundColor2")) {
                            this.edeBackgroundColor2 = FeatureProperty.toColour(value, this.edeBackgroundColor2);
                        }
                    } else if (key.equalsIgnoreCase("ExonDetailEditorFeatureColor1")) {
                        if (this.checkValidColor(value, "ExonDetailEditorFeatureColor1")) {
                            this.edeFeatureColor1 = FeatureProperty.toColour(value, this.edeFeatureColor1);
                        }
                    } else if (key.equalsIgnoreCase("ExonDetailEditorFeatureColor2")) {
                        if (this.checkValidColor(value, "ExonDetailEditorFeatureColor2")) {
                            this.edeFeatureColor2 = FeatureProperty.toColour(value, this.edeFeatureColor2);
                        }
                    } else if (key.equalsIgnoreCase("DashSets")) {
                        if (this.checkBoolean(value, "DashSets")) {
                            this.dashSets = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("FastClipGraphics")) {
                        if (this.checkBoolean(value, "FastClipGraphics")) {
                            this.fastClipGraphics = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("UserTranscriptColouring") || key.equalsIgnoreCase("UserTranscriptColoring")) {
                        if (this.checkBoolean(value, "UserTranscriptColoring")) {
                            this.userTranscriptColouring = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("colorAllAnnotsByOwner")) {
                        if (this.checkBoolean(value, "colorAllAnnotsByOwner")) {
                            this.colorAllAnnotsByOwner = new Boolean(value);
                            this.userTranscriptColouring = true;
                        }
                    } else if (key.equalsIgnoreCase("Draw3D")) {
                        if (this.checkBoolean(value, "Draw3D")) {
                            this.draw3D = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("DrawOutline")) {
                        if (this.checkBoolean(value, "drawOutline")) {
                            this.drawOutline = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("NoStripes")) {
                        if (this.checkBoolean(value, "NoStripes")) {
                            this.noStripes = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("CoordForegroundColor")) {
                        if (this.checkValidColor(value, "CoordForegroundColor")) {
                            this.coordForeground = FeatureProperty.toColour(value, this.coordForeground);
                        }
                    } else if (key.equalsIgnoreCase("SequenceGapColor")) {
                        if (this.checkValidColor(value, "SequenceGapColor")) {
                            this.seqGapColor = FeatureProperty.toColour(value, this.seqGapColor);
                        }
                    } else if (key.equalsIgnoreCase("VerticallyMovePopups")) {
                        if (this.checkBoolean(value, "VerticallyMovePopups")) {
                            this.verticallyMovePopups = new Boolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EvidencePanelHeight")) {
                        try {
                            this.evidencePanelHeight = Integer.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            this.complain("Can't parse number for EvidencePanelHeight: " + value);
                        }
                    } else if (key.startsWith("Name")) {
                        this.getSyntenySpeciesNames().put(key, value);
                        this.getSyntenySpeciesAndLinkOrder().add(key);
                        if (!this.stringIsTagForSyntenyLink(value)) {
                            this.getSyntenySpeciesOrder().add(key);
                        } else {
                            this.getSyntenyLinkOrder().add(key);
                        }
                    } else if (key.equalsIgnoreCase("ResultTag")) {
                        int breakIndex = value.indexOf(":");
                        if (breakIndex < 0) {
                            System.err.println("Warning--couldn't find : separator in ResultTag line " + value + ".  Ignoring line.");
                            continue;
                        }
                        String result_types = value.substring(0, breakIndex).trim();
                        Vector result_type_vector = this.parseStringIntoVector(result_types);
                        String tag = value.substring(breakIndex + 1);
                        for (int i = 0; i < result_type_vector.size(); ++i) {
                            String result_type = (String)result_type_vector.elementAt(i);
                            Vector<String> tag_list = (Vector<String>)this.resultTag.get(result_type);
                            if (tag_list == null) {
                                tag_list = new Vector<String>();
                                this.resultTag.put(result_type, tag_list);
                            }
                            tag_list.addElement(tag);
                        }
                    } else if (key.equals("SpeciesToDatabase")) {
                        this.addSyntenySpeciesToDatabase(value);
                    } else if (key.equals("DatabaseToStyle")) {
                        this.addDatabaseToStyle(value);
                    } else if (key.startsWith("Species")) {
                        this.getSyntenySpeciesProperties().put(key, value);
                    } else if (key.equalsIgnoreCase("UseGenericSyntenySpecies")) {
                        if (this.checkBoolean(value, key)) {
                            this.useGenericSyntenySpecies = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("DefaultSyntenyDataAdapter")) {
                        this.defaultSyntenyDataAdapter = value;
                    } else if (key.equalsIgnoreCase("NumberOfSpecies")) {
                        if (this.checkInteger(value, key)) {
                            int num = this.getInteger(value);
                            if (num < 1) {
                                num = 1;
                            }
                            this.numberOfSpecies = num;
                        }
                    } else if (key.equalsIgnoreCase("NaiveCrossSpeciesDataLoading")) {
                        this.naiveCrossSpeciesDataLoading = Boolean.valueOf(value);
                    } else if (key.equalsIgnoreCase("useOpaqueLinks")) {
                        this.useOpaqueLinks = Boolean.valueOf(value);
                    } else if (key.equalsIgnoreCase("SingleSpeciesPanelSize")) {
                        this.singleSpeciesPanelSize = Integer.valueOf(value);
                    } else if (key.equalsIgnoreCase("LinkPanelSize")) {
                        this.linkPanelSize = Integer.valueOf(value);
                    } else if (key.equalsIgnoreCase("DefaultFont")) {
                        this.defaultFont = Style.parseFont(value);
                    } else if (key.equalsIgnoreCase("DefaultFeatureLabelFont")) {
                        this.defaultFeatureLabelFont = Style.parseFont(value);
                    } else if (key.equalsIgnoreCase("ExonDetailEditorSequenceFont")) {
                        this.exonDetailEditorSequenceFont = Style.parseFont(value);
                    } else if (key.equals("DatabaseList")) {
                        this.databaseList = this.parseStringIntoVector(value);
                    } else if (key.equals("DefaultDatabase")) {
                        this.defaultDatabase = value;
                    } else if (key.equals("DatabaseURLField")) {
                        this.databaseURLField = value;
                    } else if (key.equals("PadLeftURLField")) {
                        this.padLeftURLField = value;
                    } else if (key.equals("PadRightURLField")) {
                        this.padRightURLField = value;
                    } else if (key.equals("DefaultPadding")) {
                        if (this.checkInteger(value, key)) {
                            this.defaultPadding = this.getInteger(value);
                        }
                    } else if (key.equals("AddSyntenySpeciesNumberDropdown")) {
                        if (this.checkBoolean(value, key)) {
                            this.addSyntenySpeciesNumDropdown = this.getBoolean(value);
                        }
                    } else if (key.equals("AddSyntenyResultMenuItem")) {
                        if (this.checkBoolean(value, key)) {
                            this.addSyntenyResultMenuItem = this.getBoolean(value);
                        }
                    } else if (key.equals("SyntenyLinksAreGeneToGene")) {
                        if (this.checkBoolean(value, key)) {
                            this.syntenyLinksAreGeneToGene = this.getBoolean(value);
                        }
                    } else if (key.equals("InitialStateForStartStopCodonVisibility")) {
                        if (this.checkBoolean(value, key)) {
                            this.initialSitesVisibility = this.getBoolean(value);
                        }
                    } else if (key.equals("InitialShiftForLockedZooming")) {
                        if (this.checkBoolean(value, key)) {
                            this.initialShiftForLockedZooming = this.getBoolean(value);
                        }
                    } else if (key.equals("InitialLockedScrolling")) {
                        if (this.checkBoolean(value, key)) {
                            this.initialLockedScrolling = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowIdField")) {
                        if (this.checkBoolean(value, key)) {
                            this.showIdField = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("TranscriptSymbolEditable")) {
                        if (this.checkBoolean(value, key)) {
                            this.transcriptSymbolEditable = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowIsDicistronicAnnotInfoCheckbox")) {
                        if (this.checkBoolean(value, key)) {
                            this.showIsDicistronicCheckbox = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowEvaluationOfPeptide")) {
                        if (this.checkBoolean(value, key)) {
                            this.showEvalOfPeptide = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowIsProblematicAnnotInfoCheckbox")) {
                        if (this.checkBoolean(value, key)) {
                            this.showIsProbCheckbox = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowFinishedAnnotInfoCheckbox")) {
                        if (this.checkBoolean(value, key)) {
                            this.showFinishedCheckbox = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowDBCrossRefAnnotInfoTable")) {
                        if (this.checkBoolean(value, key)) {
                            this.showDbXRefTable = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowReplaceStopAnnotInfoCheckbox")) {
                        if (this.checkBoolean(value, key)) {
                            this.showReplaceStopCheckbox = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EnableTranslationalFrameShiftEditing")) {
                        if (this.checkBoolean(value, key)) {
                            this.translationalFrameShiftEditingEnabled = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EnableSequenceErrorEditing")) {
                        if (this.checkBoolean(value, key)) {
                            this.seqErrorEditingIsEnabled = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowOwnershipAnnotMenuItem")) {
                        if (this.checkBoolean(value, key)) {
                            this.showOwnershipAnnotMenuItem = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("ShowTranscriptFinishedAnnotMenuItem")) {
                        if (this.checkBoolean(value, key)) {
                            this.showTranscriptFinishedAnnotMenuItem = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("EnableIgbHttpConnection")) {
                        if (this.checkBoolean(value, key)) {
                            this.enableIgbHttpConnection = this.getBoolean(value);
                        }
                    } else if (key.equalsIgnoreCase("TransactionXmlInGameFile")) {
                        if (this.checkBoolean(value, key)) {
                            this.transactionsAreInGameFile = this.getBoolean(value);
                        }
                    } else if (key.equals("ImportStyle")) {
                        this.importStyle(value);
                    } else if (key.equalsIgnoreCase("QueryForNamesOnSplit")) {
                        this.queryForNamesOnSplit = value.equalsIgnoreCase("true");
                    } else if (key.equalsIgnoreCase("GeneticCode")) {
                        if (this.checkInteger(value, key)) {
                            int num = this.getInteger(value);
                            if (num != 1 && num != 6) {
                                System.out.println("GeneticCode style config only takes 1 & 6");
                                num = 1;
                            }
                            this.geneticCodeNumber = num;
                        }
                    } else {
                        if (Config.getDebug()) {
                            System.out.println("Saved unknown parameter from " + styleFile + ": " + key + "=" + value);
                        }
                        this.addParameter(key, value);
                    }
                    lineWords.clear();
                    continue;
                }
                if (lineWords.size() != 0 && ((String)lineWords.get(0)).equals("link")) {
                    System.out.println("got link " + lineWords.get(0));
                    lineWords.clear();
                    continue;
                }
                if (lineWords.size() == 0) continue;
                String error = "Line " + this.lineNum + " in " + styleFile + " has only 1 word, not two words separated by spaces: " + lineWords.get(0);
                if (lineWords.size() >= 3) {
                    error = "Line " + this.lineNum + " in " + styleFile + " has " + lineWords.size() + "words, not two words separated by spaces: " + lineWords.get(0) + "," + lineWords.get(1) + "," + lineWords.get(2) + " (etc.)";
                }
                this.complain(error);
                lineWords.clear();
            }
        }
        catch (FileNotFoundException e) {
            IOUtil.errorDialog("Style file " + styleFile + " not found");
        }
        catch (Exception e) {
            String error = "Error parsing style file " + styleFile + ": " + e;
            IOUtil.errorDialog(error);
        }
    }

    public void complain(String message) {
        System.err.println("Error on line " + this.lineNum + " of " + this.styleFileString + ":\n  " + message);
        this.errors = this.errors + "\n" + "Error on line " + this.lineNum + " of " + this.styleFileString + ":\n   " + message;
    }

    public String getErrors() {
        return this.errors;
    }

    public boolean queryForNamesOnSplit() {
        return this.queryForNamesOnSplit;
    }

    public static void askRenameGameConfig(String oldname, String newname) {
        String homeDotApolloDir = System.getProperty("user.home") + "/.apollo/";
        String oldfile = IOUtil.findFile(homeDotApolloDir + oldname);
        if (oldfile != null) {
            String newfile = IOUtil.findFile(homeDotApolloDir + newname);
            if (newfile != null) {
                String msg = "You have both a " + oldname + " and a " + newname + "\nin your .apollo directory.  You really should only\nhave a " + newname + ".  You might want to fix this.";
                IOUtil.errorDialog(msg);
                return;
            }
            String msg = "You have a " + oldname + " in your .apollo directory.\nApollo now looks for " + newname + " instead.\nDo you want to rename your .apollo/" + oldname + " to .apollo/" + newname + "?";
            boolean answer = LoadUtil.areYouSure(msg);
            if (answer) {
                File oldF = new File(oldfile);
                newfile = IOUtil.findFile(homeDotApolloDir + newname, true);
                if (newfile == null) {
                    msg = "Failed to rename " + oldfile + " to " + newname;
                    IOUtil.errorDialog(msg);
                    return;
                }
                File newF = new File(newfile);
                if (oldF.renameTo(newF)) {
                    System.out.println("Renamed " + oldfile + " to " + newfile);
                } else {
                    msg = "Failed to rename " + oldfile + " to " + newfile;
                    IOUtil.errorDialog(msg);
                }
            }
        }
    }

    public boolean checkValidColor(String colorStr, String variableName) {
        try {
            Color color = FeatureProperty.parseColour(colorStr);
        }
        catch (NumberFormatException e) {
            this.complain("Bad color " + colorStr + " for " + variableName);
            return false;
        }
        return true;
    }

    public String getBlixemLocation() {
        if (this.blixemLocation == null) {
            return null;
        }
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Linux") || osname.startsWith("linux")) {
            this.blixemLocation = "bin/blixem.LINUX";
        } else if (osname.startsWith("Solaris") || osname.startsWith("Sun")) {
            this.blixemLocation = "bin/blixem.SOLARIS";
        }
        String absolute_path = IOUtil.findFile(this.blixemLocation);
        return absolute_path;
    }

    private boolean checkInteger(String value, String varName) {
        try {
            Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.complain("Can't parse number for " + varName + ": " + value);
            return false;
        }
        return true;
    }

    private int getInteger(String value) {
        return Integer.valueOf(value);
    }

    private boolean getBoolean(String value) {
        return Config.getBoolean(value);
    }

    public boolean checkBoolean(String value, String variableName) {
        return Config.checkBoolean(value, variableName);
    }

    public String getTiersFile() {
        return this.tiersFile;
    }

    public boolean getShowAnnotations() {
        return this.showAnnotations;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    public int getEdgematchWidth() {
        return this.edgematchWidth;
    }

    public boolean doUserTranscriptColouring() {
        return this.userTranscriptColouring;
    }

    public boolean colorAllAnnotsByOwner() {
        return this.colorAllAnnotsByOwner;
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public void setDraw3D(boolean state) {
        this.draw3D = state;
    }

    public boolean getNoStripes() {
        return this.noStripes;
    }

    public int getEvidencePanelHeight() {
        return this.evidencePanelHeight;
    }

    boolean verticallyMovePopups() {
        return this.verticallyMovePopups;
    }

    boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    boolean isNavigationManagerEnabled() {
        return this.navigationManagerEnabled;
    }

    boolean hasChromosomes() {
        return this.chromosomes != null;
    }

    public Vector getChromosomes() {
        return this.chromosomes;
    }

    public boolean getDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean state) {
        this.drawOutline = state;
    }

    private Vector parseStringIntoVector(String string) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken().trim());
        }
        return v;
    }

    public Vector getDatabaseList() {
        if (this.databaseList == null) {
            this.databaseList = new Vector(1);
            this.databaseList.add(this.getDefaultDatabase());
        }
        return this.databaseList;
    }

    public Vector getDatabaseList(String queryType) {
        if (queryType.equalsIgnoreCase("sequence")) {
            Vector seqDbList = (Vector)this.getDatabaseList().clone();
            for (int i = 0; i < seqDbList.size(); ++i) {
                String db = (String)seqDbList.elementAt(i);
                if (db.indexOf("r3.2") < 0) continue;
                seqDbList.setElementAt("(Not available for release 3.2)", i);
            }
            return seqDbList;
        }
        return this.databaseList;
    }

    public String getDefaultDatabase() {
        if (this.defaultDatabase == null) {
            this.defaultDatabase = this.databaseList != null && this.databaseList.size() > 0 ? (String)this.databaseList.get(0) : defaultDefaultDatabase;
        }
        return this.defaultDatabase;
    }

    Vector getAnnotationComments() {
        return this.annotationComments;
    }

    Vector getTranscriptComments() {
        return this.transcriptComments;
    }

    private void addCannedComment(String comment, String which) {
        Vector comments;
        if (which.equals("annotation")) {
            if (this.annotationComments == null) {
                this.annotationComments = new Vector();
            }
            comments = this.annotationComments;
        } else {
            if (this.transcriptComments == null) {
                this.transcriptComments = new Vector();
            }
            comments = this.transcriptComments;
        }
        if (comments.size() == 0) {
            comments.addElement("Select comment or enter your own");
        }
        if (comments.indexOf(comment) == -1) {
            comments.addElement(comment);
        }
    }

    public boolean internalMode() {
        return this.internalMode;
    }

    public String getProjectName(String username) {
        String projectname = null;
        if (this.userToProject != null && !this.internalMode() && username != null) {
            projectname = (String)this.userToProject.get(username);
        }
        return projectname == null ? username : projectname;
    }

    public Color getAnnotationColor(String username) {
        Color color = null;
        if (username == null || username.trim().length() <= 0 || username.equalsIgnoreCase("auto") || this.userToColor == null) {
            color = Config.defaultAnnotationColor;
        } else {
            color = (Color)this.userToColor.get(username);
            if (color == null) {
                color = Config.defaultAnnotationColor;
            }
        }
        return color;
    }

    public Color getTaggedColor() {
        return this.taggedColor;
    }

    public Color getSeqErrorColor() {
        return this.seqErrorColor;
    }

    private void addUserInfo(String userinfo) {
        StringTokenizer tokens = new StringTokenizer(userinfo, ":");
        String user = null;
        String project = null;
        Color color = null;
        String full_name = null;
        while (tokens.hasMoreTokens()) {
            String tagval = tokens.nextToken();
            int breakIndex = tagval.indexOf("=");
            if (breakIndex <= 0) continue;
            String tag = tagval.substring(0, breakIndex);
            String val = tagval.substring(breakIndex + 1);
            if (tag.equals("user")) {
                user = val;
                continue;
            }
            if (tag.equals("project")) {
                project = val;
                continue;
            }
            if (tag.equals("color")) {
                color = FeatureProperty.toColour(val, this.defaultUserColor);
                continue;
            }
            if (!tag.equals("full-name")) continue;
            full_name = val;
        }
        if (user != null) {
            if (project != null) {
                if (this.userToProject == null) {
                    this.userToProject = new Hashtable();
                }
                this.userToProject.put(user, project);
            }
            if (color != null) {
                if (this.userToColor == null) {
                    this.userToColor = new Hashtable();
                }
                this.userToColor.put(user, color);
            }
            if (full_name != null) {
                if (this.userToFullName == null) {
                    this.userToFullName = new Hashtable();
                }
                this.userToFullName.put(user, full_name);
            }
        }
        if (user == null || color == null) {
            this.complain("Bad user info string: " + userinfo);
        }
    }

    Hashtable getPeptideStates() {
        return this.peptideStates;
    }

    PeptideStatus getPeptideStatus(String pep_status) {
        PeptideStatus status = (PeptideStatus)this.peptideStates.get(pep_status = pep_status == null || pep_status.equals("") ? "not analyzed" : pep_status.toLowerCase());
        if (status == null) {
            status = new PeptideStatus();
            this.peptideStates.put(pep_status, status);
        }
        return status;
    }

    private void addFeatureLoadSize(int size) {
        this.featureLoadSize = size;
    }

    public int getFeatureLoadSize() {
        return this.featureLoadSize;
    }

    private void addPeptideStatus(String peptideString) {
        PeptideStatus status = new PeptideStatus();
        String peptide_key = status.initStatus(peptideString);
        if (this.peptideStates == null) {
            this.peptideStates = new Hashtable();
        }
        this.peptideStates.put(peptide_key.toLowerCase(), status);
    }

    public String getGeneUrl() {
        return this.geneUrl;
    }

    public String getBandUrl() {
        return this.bandUrl;
    }

    public String getScaffoldUrl() {
        return this.scaffoldUrl;
    }

    public String getSeqUrl() {
        return this.seqUrl;
    }

    public String getRangeUrl() {
        return this.rangeUrl;
    }

    String getExternalRefUrl() {
        return this.externalRefUrl;
    }

    public boolean getDashSets() {
        return this.dashSets;
    }

    public Color getAnnotationBackground() {
        return this.annotationBackground;
    }

    public void setAnnotationBackground(Color color) {
        this.annotationBackground = color;
    }

    public Color getFeatureBackground() {
        return this.featureBackground;
    }

    public void setFeatureBackground(Color col) {
        this.featureBackground = col;
    }

    public Color getEdgematchColor() {
        return this.edgematchColor;
    }

    public void setEdgematchColor(Color col) {
        this.edgematchColor = col;
    }

    public Color getOutlineColor() {
        return this.edgematchColor;
    }

    public Color getFeatureLabelColor() {
        return this.featureLabelColor;
    }

    public void setFeatureLabelColor(Color col) {
        this.featureLabelColor = col;
    }

    public Color getAnnotationLabelColor() {
        return this.annotationLabelColor;
    }

    public void setAnnotationLabelColor(Color col) {
        this.annotationLabelColor = col;
    }

    public Color getCoordBackground() {
        return this.coordBackground;
    }

    public void setCoordBackground(Color col) {
        this.coordBackground = col;
    }

    public Color getCoordForeground() {
        return this.coordForeground;
    }

    public void setCoordForeground(Color col) {
        this.coordForeground = col;
    }

    public Color getCoordRevcompColor() {
        return this.coordRevcompColor;
    }

    public void setCoordRevcompColor(Color col) {
        this.coordRevcompColor = col;
    }

    public Color getSequenceColor() {
        return this.sequenceColor;
    }

    public void setSequenceColor(Color col) {
        this.sequenceColor = col;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getSeqGapColor() {
        return this.seqGapColor;
    }

    Color getExonDetailEditorBackgroundColor1() {
        return this.edeBackgroundColor1;
    }

    Color getExonDetailEditorBackgroundColor2() {
        return this.edeBackgroundColor2;
    }

    Color getExonDetailEditorFeatureColor1() {
        return this.edeFeatureColor1;
    }

    Color getExonDetailEditorFeatureColor2() {
        return this.edeFeatureColor2;
    }

    private void installDisplayPrefs(String nameString) {
        try {
            if (nameString.startsWith("apollo.gui.schemes")) {
                System.out.println("Found obsolete DisplayPreferences " + nameString + "--using ");
                nameString = "apollo.config" + nameString.substring(nameString.lastIndexOf("."));
                System.out.println(nameString + ".  Please update " + this.styleFileString + ".");
            }
            Class<?> namerClass = Class.forName(nameString);
            this.displayPrefs = (DisplayPrefsI)namerClass.newInstance();
        }
        catch (Exception e) {
            System.out.println("Warning: could not find DisplayPreferences " + nameString + " (err " + e.getMessage() + ")");
        }
    }

    protected DisplayPrefsI getDisplayPrefs() {
        if (this.displayPrefs == null) {
            this.displayPrefs = new DefaultDisplayPrefs();
        }
        return this.displayPrefs;
    }

    private void installNameAdapter(String nameString) {
        this.nameAdapter = nameString;
        PropertyScheme scheme = this.getPropertyScheme();
        TierProperty tp = scheme.getTierProperty("annotation", false);
        if (tp != null) {
            Vector annot_types = tp.getFeatureProperties();
            for (int i = 0; i < annot_types.size(); ++i) {
                FeatureProperty fp = (FeatureProperty)annot_types.elementAt(i);
                fp.setNameAdapterStringIfNotSet(nameString);
            }
        }
    }

    public String getNameAdapter() {
        return this.nameAdapter;
    }

    private void setOverlapper(String classString) {
        PropertyScheme scheme = this.getPropertyScheme();
        TierProperty tp = scheme.getTierProperty("annotation", false);
        if (tp != null) {
            Vector annot_types = tp.getFeatureProperties();
            for (int i = 0; i < annot_types.size(); ++i) {
                FeatureProperty fp = (FeatureProperty)annot_types.elementAt(i);
                fp.setOverlapperIfNotSet(classString);
            }
        }
    }

    public String getFileName() {
        return this.styleFileString;
    }

    Font getDefaultFont() {
        return this.defaultFont;
    }

    Font getDefaultFeatureLabelFont() {
        return this.defaultFeatureLabelFont;
    }

    public Font getExonDetailEditorSequenceFont() {
        return this.exonDetailEditorSequenceFont;
    }

    public Vector getResultTag(String result_type) {
        return (Vector)this.resultTag.get(result_type);
    }

    public Hashtable getResultTags() {
        return this.resultTag;
    }

    public String getDatabaseURLField() {
        return this.databaseURLField;
    }

    public String getPadLeftURLField() {
        return this.padLeftURLField;
    }

    public String getPadRightURLField() {
        return this.padRightURLField;
    }

    public int getDefaultPadding() {
        return this.defaultPadding;
    }

    static Font parseFont(String font_str) {
        StringTokenizer tokenizer = new StringTokenizer(font_str, ",");
        String font_name = "Dialog";
        int font_style = 0;
        int font_size = 9;
        Font font = null;
        try {
            if (tokenizer.hasMoreTokens()) {
                font_name = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                font_style = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                font_size = Integer.parseInt(tokenizer.nextToken());
            }
            font = new Font(font_name, font_style, font_size);
        }
        catch (Exception e) {
            System.out.println("Failed to parse Font from " + font_str);
        }
        return font;
    }

    public String toString() {
        return this.getFileName();
    }

    String getFullNameForUser(String user) {
        if (user == null) {
            return null;
        }
        if (this.userToFullName == null) {
            return user;
        }
        String fullName = (String)this.userToFullName.get(user);
        if (fullName == null) {
            fullName = user;
        }
        if (!this.internalMode() && (fullName = (String)this.userToProject.get(user)) == null) {
            fullName = "unknown";
        }
        return fullName;
    }

    public boolean isSuperUser(String name) {
        return true;
    }

    public PropertyScheme getPropertyScheme() {
        if (this.properties == null && this.getTiersFile() != null) {
            this.setPropertyScheme(this.getTiersFile());
        }
        return this.properties;
    }

    private void setPropertyScheme(String tiersFile) {
        try {
            this.properties = new PropertyScheme(tiersFile);
        }
        catch (Exception e) {
            String msg = "Failed to parse tiers file " + tiersFile;
            IOUtil.errorDialog(msg);
        }
    }

    private void importStyle(String styleFilename) {
        String personalStyleFilePath;
        String styleFilePath;
        String pathname = styleFilename;
        if (!styleFilename.startsWith("conf/")) {
            pathname = "conf/" + pathname;
        }
        if ((styleFilePath = IOUtil.findFile(pathname)) == null) {
            if (Config.getDebug()) {
                System.out.println("importStyle: couldn't find " + styleFilename + " with findFile--trying findStyleFile");
            }
            styleFilePath = Config.digForConfigFile(styleFilename);
        }
        if (styleFilePath != null) {
            for (int i = 0; i < this.styleFiles.size(); ++i) {
                String sf = (String)this.styleFiles.get(i);
                if (!sf.equals(styleFilePath)) continue;
                System.out.println("NOTE: already read style file " + sf + "--ignoring ImportStyle line for it in " + styleFilePath);
            }
            this.readStyle(styleFilePath);
        }
        if ((personalStyleFilePath = IOUtil.findFile("~/.apollo/" + styleFilename)) != null && !personalStyleFilePath.equals(styleFilePath)) {
            this.readStyle(personalStyleFilePath);
        }
    }

    public int getSingleSpeciesPanelSize() {
        return this.singleSpeciesPanelSize;
    }

    public int getLinkPanelSize() {
        return this.linkPanelSize;
    }

    public boolean getInitialSitesVisibility() {
        return this.initialSitesVisibility;
    }

    public boolean addSyntenySpeciesNumDropdown() {
        return this.addSyntenySpeciesNumDropdown;
    }

    public boolean addSyntenyResultMenuItem() {
        return this.addSyntenyResultMenuItem;
    }

    public boolean syntenyLinksAreGeneToGene() {
        return this.syntenyLinksAreGeneToGene;
    }

    public boolean initialShiftForLockedZooming() {
        return this.initialShiftForLockedZooming;
    }

    public boolean initialLockedScrolling() {
        return this.initialLockedScrolling;
    }

    public boolean getNaiveCrossSpeciesDataLoading() {
        return this.naiveCrossSpeciesDataLoading;
    }

    public boolean useOpaqueLinks() {
        return this.useOpaqueLinks;
    }

    private boolean useGenericSyntenySpecies() {
        return this.useGenericSyntenySpecies;
    }

    public String getDefaultSyntenyDataAdapterString() {
        return this.defaultSyntenyDataAdapter;
    }

    public int getNumberOfSpecies() {
        return this.numberOfSpecies;
    }

    public HashMap getSyntenySpeciesNames() {
        if (this.syntenySpeciesNames.isEmpty() && this.useGenericSyntenySpecies()) {
            for (int i = 1; i <= this.getNumberOfSpecies(); ++i) {
                this.syntenySpeciesNames.put("Species" + i, "Species" + i);
            }
        }
        return this.syntenySpeciesNames;
    }

    public HashMap getSyntenySpeciesProperties() {
        return this.syntenySpeciesProperties;
    }

    public List getSyntenySpeciesOrder() {
        if (this.syntenySpeciesOrder.isEmpty() && this.useGenericSyntenySpecies()) {
            for (int i = 1; i <= this.getNumberOfSpecies(); ++i) {
                this.syntenySpeciesOrder.add("Species" + i);
            }
        }
        return this.syntenySpeciesOrder;
    }

    public List getSyntenyLinkOrder() {
        return this.syntenyLinkOrder;
    }

    public String getSyntenySpeciesString(int i) {
        if (i >= this.getNumberOfSyntenySpecies()) {
            return null;
        }
        return (String)this.getSyntenySpeciesOrder().get(i);
    }

    public int getNumberOfSyntenySpecies() {
        return this.getSyntenySpeciesOrder().size();
    }

    boolean stringIsTagForSyntenyLink(String string) {
        if (string.toLowerCase().equals("compara")) {
            return true;
        }
        return string.toLowerCase().equals("links");
    }

    public List getSyntenySpeciesAndLinkOrder() {
        if (this.useGenericSyntenySpecies()) {
            return this.getSyntenySpeciesOrder();
        }
        return this.syntenySpeciesAndLinkOrder;
    }

    private Map getSpeciesToDbMap() {
        if (this.syntenySpeciesToDb == null) {
            this.syntenySpeciesToDb = new HashMap(5);
        }
        return this.syntenySpeciesToDb;
    }

    private void addSyntenySpeciesToDatabase(String speciesToDbString) {
        int arrowIndex = speciesToDbString.indexOf("->");
        String species = speciesToDbString.substring(0, arrowIndex);
        String db = speciesToDbString.substring(arrowIndex + 2);
        this.getSpeciesToDbMap().put(species.trim(), db.trim());
    }

    public String getSyntenyDatabaseForSpecies(String species) {
        String db = (String)this.getSpeciesToDbMap().get(species);
        if (db == null) {
            String m = "No mapping to database for species " + species + " in style " + " file. Need to have:\nSpeciesToDatabase \"" + species + " -> database\"";
            System.err.println(m);
        }
        return db;
    }

    private void addDatabaseToStyle(String databaseToStyleString) {
        int arrowIndex = databaseToStyleString.indexOf("->");
        String db = databaseToStyleString.substring(0, arrowIndex);
        String style = databaseToStyleString.substring(arrowIndex + 2);
        this.getDbToStyleMap().put(db.trim(), style.trim());
    }

    private Map getDbToStyleMap() {
        if (this.dbToStyle == null) {
            this.dbToStyle = new HashMap(5);
        }
        return this.dbToStyle;
    }

    public boolean databaseHasStyle(String db) {
        if (db == null) {
            return false;
        }
        return this.getStyleForDb(db) != null;
    }

    public Style getStyleForDb(String db) {
        String styleString = (String)this.getDbToStyleMap().get(db);
        if (styleString == null) {
            return null;
        }
        return Config.createStyle(styleString);
    }

    public boolean showIdField() {
        return this.showIdField;
    }

    public boolean getTranscriptSymbolEditable() {
        return this.transcriptSymbolEditable;
    }

    public boolean showIsDicistronicCheckbox() {
        return this.showIsDicistronicCheckbox;
    }

    public boolean showEvalOfPeptide() {
        return this.showEvalOfPeptide;
    }

    public boolean showIsProbCheckbox() {
        return this.showIsProbCheckbox;
    }

    public boolean showFinishedCheckbox() {
        return this.showFinishedCheckbox;
    }

    public boolean showDbXRefTable() {
        return this.showDbXRefTable;
    }

    public boolean showReplaceStopCheckbox() {
        return this.showReplaceStopCheckbox;
    }

    public boolean translationalFrameShiftEditingIsEnabled() {
        return this.translationalFrameShiftEditingEnabled;
    }

    public boolean seqErrorEditingIsEnabled() {
        return this.seqErrorEditingIsEnabled;
    }

    public boolean showOwnershipAnnotMenuItem() {
        return this.showOwnershipAnnotMenuItem;
    }

    public boolean showTranscriptFinishedAnnotMenuItem() {
        return this.showTranscriptFinishedAnnotMenuItem;
    }

    public boolean igbHttpConnectionEnabled() {
        return this.enableIgbHttpConnection;
    }

    public boolean transactionsAreInGameFile() {
        return this.transactionsAreInGameFile;
    }

    public int getGeneticCodeNumber() {
        return this.geneticCodeNumber;
    }

    public void addParameter(String name, String value) {
        if (value != null && !value.equals("")) {
            Vector values;
            if (this.parameters == null) {
                this.parameters = new Hashtable(1, 1.0f);
            }
            if (this.parameters.get(name = name.toLowerCase()) == null) {
                values = new Vector();
                this.parameters.put(name, values);
            } else {
                values = (Vector)this.parameters.get(name);
            }
            values.addElement(value);
        }
    }

    public void removeParameter(String key) {
        if (key != null && !key.equals("")) {
            if (this.parameters == null) {
                return;
            }
            if (this.parameters.containsKey(key = key.toLowerCase())) {
                this.parameters.remove(key);
            }
        }
    }

    public void replaceParameter(String key, String value) {
        key = key.toLowerCase();
        this.removeParameter(key);
        this.addParameter(key, value);
    }

    public String getParameter(String name) {
        name = name.toLowerCase();
        if (this.parameters == null || this.parameters.get(name) == null) {
            return "";
        }
        Vector values = (Vector)this.parameters.get(name);
        return (String)values.lastElement();
    }

    public Vector getParameterMulti(String name) {
        if (this.parameters == null) {
            return null;
        }
        name = name.toLowerCase();
        return (Vector)this.parameters.get(name);
    }

    public Hashtable getParameters() {
        if (this.parameters == null) {
            this.parameters = new Hashtable(1, 1.0f);
        }
        Hashtable hash = new Hashtable(1, 1.0f);
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)((Vector)this.parameters.get(key)).elementAt(0);
            hash.put(key, value);
        }
        return hash;
    }

    public Hashtable getParametersMulti() {
        if (this.parameters == null) {
            this.parameters = new Hashtable(1, 1.0f);
        }
        return this.parameters;
    }
}

