/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.OverlapI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;

public class SimpleOverlap
implements OverlapI {
    private static final SimpleOverlap simpleOverlapSingleton = new SimpleOverlap();

    public static SimpleOverlap getSimpleOverlap() {
        return simpleOverlapSingleton;
    }

    public boolean areOverlapping(SeqFeatureI sa, SeqFeatureI sb) {
        boolean overlap = false;
        if (sb.canHaveChildren()) {
            FeatureSetI fb = (FeatureSetI)sb;
            for (int i = 0; i < fb.size() && !overlap; ++i) {
                overlap = this.areOverlapping(sa, fb.getFeatureAt(i));
            }
        } else if (sa.canHaveChildren()) {
            FeatureSetI fa = (FeatureSetI)sa;
            for (int i = 0; i < fa.size() && !overlap; ++i) {
                overlap = this.areOverlapping(fa.getFeatureAt(i), sb);
            }
        } else if (sa.overlaps(sb)) {
            overlap = sa.overlaps(sb);
        }
        return overlap;
    }
}

