/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.Config;
import apollo.config.Style;
import java.awt.Font;

public class PeptideStatus {
    private String status = "not analyzed";
    private int precedence = 0;
    private Font font = null;
    private Font default_font = Config.getDefaultFeatureLabelFont();
    private boolean curated = false;

    public String initStatus(String config_str) {
        int breakIndex = config_str.indexOf(":");
        if (breakIndex > 0) {
            String prec_str = config_str.substring(0, breakIndex);
            this.setPrecedence(prec_str);
            config_str = config_str.substring(breakIndex + 1);
            breakIndex = config_str.indexOf(":");
            if (breakIndex > 0) {
                String font_str = config_str.substring(0, breakIndex);
                this.font = Style.parseFont(font_str);
                if ((breakIndex = (config_str = config_str.substring(breakIndex + 1)).indexOf(":")) > 0) {
                    String curated_str = config_str.substring(0, breakIndex);
                    this.curated = curated_str.equalsIgnoreCase("true");
                    config_str = config_str.substring(breakIndex + 1);
                }
            }
        }
        if (config_str != null && !config_str.equals("")) {
            this.status = config_str;
        }
        return this.status;
    }

    public String getText() {
        return this.status;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int prec) {
        this.precedence = prec;
    }

    public void setPrecedence(String precedence_str) {
        try {
            int prec = Integer.parseInt(precedence_str);
            this.setPrecedence(prec);
        }
        catch (Exception e) {
            System.out.println("Failed to parse precedence from " + precedence_str);
            this.setPrecedence(0);
        }
    }

    public Font getFont() {
        return this.font == null ? this.default_font : this.font;
    }

    public boolean getCurated() {
        return this.curated;
    }
}

