/*
 * Decompiled with CFR 0.152.
 */
package apollo.config;

import apollo.config.DefaultDisplayPrefs;
import apollo.config.FeatureProperty;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;

public class EnsjDisplayPrefs
extends DefaultDisplayPrefs {
    protected String getURLPrefix(FeatureProperty prop, SeqFeatureI f, String id) {
        String url = prop.getURLString();
        SequenceI seq = f.getRefSequence();
        if (seq != null && seq.getOrganism() != null) {
            try {
                int index = url.indexOf(42);
                if (index > 0) {
                    url = url.substring(0, index) + seq.getOrganism() + url.substring(index + 1);
                }
            }
            catch (Exception e) {
                System.out.println("Could not parse * from url " + url);
            }
        }
        return url;
    }

    protected String getIdForURL(SeqFeatureI f) {
        String id;
        if (f instanceof FeaturePair) {
            FeaturePair fp = (FeaturePair)f;
            SeqFeatureI sbjct = fp.getHitFeature();
            id = sbjct.getName();
        } else {
            id = !(f instanceof FeatureSet) ? this.getDisplayName(f.getRefFeature()) : this.getDisplayName(f);
        }
        return id;
    }
}

