/*
 * Decompiled with CFR 0.152.
 */
package apollo.bop;

import apollo.analysis.filter.AnalysisFilter;
import apollo.analysis.filter.AnalysisInput;
import apollo.bop.JDBCPipelineAdapter;
import apollo.bop.JobOutput;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.GFFAdapter;
import apollo.dataadapter.analysis.AnalysisParserI;
import apollo.dataadapter.exception.BopException;
import apollo.dataadapter.exception.NoOutputException;
import apollo.dataadapter.gamexml.GAMESave;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.seq.io.FastaFile;
import apollo.util.IOUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class bop {
    static Vector arg_list = new Vector(7);
    protected static String[] output_formats;
    static HashMap datatype2options;
    static Vector parsers;
    static boolean caught_exception;

    public static void main(String[] args) {
        caught_exception = false;
        HashMap arg_hash = bop.parseArgs(args);
        CurationSet curation = new CurationSet();
        if (arg_hash.get("s") != null) {
            try {
                FastaFile ff = new FastaFile((String)arg_hash.get("s"), "File", curation);
            }
            catch (IOException e) {
                System.out.println("IOException caught reading sequence file " + arg_hash.get("s") + " " + e);
                caught_exception = true;
            }
        }
        for (int i = 0; i < args.length - 1 && !caught_exception; i += 2) {
            String arg_name = bop.getArgType(args[i]);
            if (arg_name.equals("list")) {
                String listfile = args[i + 1];
                bop.processFileList(curation, arg_hash, listfile);
                System.out.println("Processed complete list");
                continue;
            }
            if (arg_name.equals("job")) {
                String job_str = args[i + 1];
                int job_id = Integer.valueOf(job_str);
                arg_hash.put("job", job_str);
                bop.processJob(curation, arg_hash, job_id);
                continue;
            }
            if (datatype2options.get(arg_name.toLowerCase()) == null) continue;
            String file_name = args[i + 1];
            bop.processFile(curation, arg_name, file_name, arg_hash);
        }
        if (caught_exception) {
            System.exit(1);
        } else {
            bop.saveResults(curation, arg_hash);
            System.exit(0);
        }
    }

    private static void processFileList(CurationSet curation, HashMap arg_hash, String list_name) {
        String list_file = IOUtil.findFile(list_name);
        try {
            FileInputStream data_stream = new FileInputStream(list_file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(data_stream));
            StreamTokenizer tokens = new StreamTokenizer(reader);
            tokens.eolIsSignificant(true);
            tokens.quoteChar(34);
            tokens.commentChar(35);
            try {
                int tok = tokens.nextToken();
                while (true) {
                    if (tok != -1) {
                        if (tok != 10) {
                            if (tok == -3) {
                                String input_type = tokens.sval;
                                if (input_type.equals("file")) {
                                    tokens.nextToken();
                                    String data_type = tokens.sval;
                                    tokens.nextToken();
                                    String file_name = IOUtil.findFile(tokens.sval);
                                    bop.processFile(curation, data_type, file_name, arg_hash);
                                }
                                while (true) {
                                    if (tok == 10) break;
                                    tok = tokens.nextToken();
                                }
                            }
                        }
                        tok = tokens.nextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                caught_exception = true;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            caught_exception = true;
        }
    }

    private static void processFile(CurationSet curation, String data_type, String file_name, HashMap arg_hash) {
        AnalysisInput parameters = bop.getAnalysisInput(data_type, true);
        System.out.println("Processing " + data_type + " from " + file_name);
        int index = data_type.indexOf(":");
        if (index > 0) {
            parameters.setType(data_type.substring(0, index));
            parameters.setDatabase(data_type.substring(index + 1));
        } else {
            parameters.setType(data_type);
        }
        File af = new File(file_name);
        long modification = af.lastModified();
        Date run_date = new Date(modification);
        try {
            boolean parsed = false;
            for (int i = 0; i < parsers.size() && !parsed; ++i) {
                AnalysisParserI parser = (AnalysisParserI)parsers.elementAt(i);
                InputStream input = bop.getInputStream(file_name);
                parsed = bop.processInput(curation, input, run_date, parameters, parser, arg_hash);
                input.close();
            }
            if (!parsed) {
                bop.failureError("Unable to find a parser for these data in " + file_name);
            }
        }
        catch (Exception e) {
            System.err.println("Could not process file input for " + file_name);
            System.err.println(e.getMessage());
            e.printStackTrace();
            caught_exception = true;
        }
    }

    private static void processJob(CurationSet curation, HashMap arg_hash, int job_id) {
        String host = (String)arg_hash.get("host");
        String dbname = (String)arg_hash.get("db");
        JDBCPipelineAdapter ad = new JDBCPipelineAdapter(host, dbname);
        JobOutput job_data = null;
        try {
            job_data = ad.retrieveJob(job_id);
            SequenceI seq = job_data.getQuerySequence();
            if (seq != null) {
                curation.setRefSequence(seq);
                curation.setName(seq.getName());
                curation.setStrand(1);
                curation.setStart(1);
                curation.setEnd(seq.getLength());
            }
        }
        catch (NoOutputException e) {
            bop.logError(e);
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("Error using JDBC getting data: " + e.getMessage());
            System.exit(3);
        }
        String data_type = job_data.getAnalysisType();
        System.out.println("Processing a " + data_type + " job");
        AnalysisInput analysis_input = bop.getAnalysisInput(data_type, true);
        analysis_input.setDatabase(job_data.getDatabase());
        try {
            boolean parsed = false;
            for (int i = 0; i < parsers.size() && !parsed; ++i) {
                AnalysisParserI parser = (AnalysisParserI)parsers.elementAt(i);
                ByteArrayInputStream input = new ByteArrayInputStream(job_data.getRawOutput().getBytes());
                parsed = bop.processInput(curation, input, job_data.getRunDate(), analysis_input, parser, arg_hash);
                ((InputStream)input).close();
            }
            if (!parsed) {
                bop.failureError("Unable to find a parser for these data from job " + job_id);
            }
        }
        catch (Exception e) {
            System.err.println("Could not process job input for " + job_id);
            System.err.println(e.getMessage());
            e.printStackTrace();
            caught_exception = true;
        }
    }

    private static HashMap parseArgs(String[] args) {
        if (args.length % 2 != 0) {
            if (args.length == 1 && args[0].equalsIgnoreCase("-help")) {
                bop.printHelp();
            } else if (args.length == 1 && args[0].equalsIgnoreCase("-version")) {
                bop.printVersion();
            } else {
                bop.invocationError("Odd number of arguments, something is missing?");
            }
        }
        HashMap<String, String> arg_hash = new HashMap<String, String>();
        String data_type = null;
        for (int i = 0; i < args.length - 1; i += 2) {
            String list_file;
            String arg_name = bop.getArgType(args[i]);
            if (arg_list.contains(arg_name)) {
                arg_hash.put(arg_name.toLowerCase(), args[i + 1]);
                continue;
            }
            if (!arg_name.equals("list") && !arg_name.equals("job")) {
                String analysis_file = IOUtil.findFile(args[i + 1]);
                if (analysis_file == null) continue;
                data_type = arg_name;
                arg_hash.put("input_file", analysis_file);
                continue;
            }
            if (!arg_name.equals("list") || (list_file = IOUtil.findFile(args[i + 1])) == null) continue;
            arg_hash.put("input_file", list_file);
        }
        if (arg_hash.get("p") == null) {
            arg_hash.put("p", "bop.prefs");
        }
        if (arg_hash.get("f") == null) {
            arg_hash.put("f", "gamei");
        }
        bop.loadPrefs(arg_hash);
        if (data_type != null) {
            System.out.println("Getting options for " + data_type);
            AnalysisInput params = bop.getAnalysisInput(data_type, false);
            for (int i = 0; i < args.length - 1; i += 2) {
                String arg_name = bop.getArgType(args[i]);
                if (arg_list.contains(arg_name) || arg_name.equals("list") || arg_name.equals("job") || arg_name.equals(data_type)) continue;
                bop.setOption(params, arg_name, args[i + 1]);
            }
        }
        return arg_hash;
    }

    private static void failureError(String msg) {
        System.out.println(msg);
        System.exit(5);
    }

    private static void invocationError(String msg) {
        System.out.println(msg);
        System.out.println(bop.getUsage());
        System.exit(4);
    }

    private static void printHelp() {
        System.out.println(bop.getUsage());
        System.exit(0);
    }

    private static String getVersion() {
        return "BOP v.alpha, August 2003";
    }

    private static void printVersion() {
        System.out.println("\n" + bop.getVersion());
        System.exit(0);
    }

    private static String getUsage() {
        return "To invoke the program:\n\tjava -mx800m apollo.bop.bop \nSpecify where to find the analysis results\n\t-list file_listing_all_resultfiles\n\t-type result_file (where type is a Apollo display types)\n\t[-db db_name -host server_name] -job job_id\nAdditional optional arguments are:\n\t-o output_file (default is genomic sequence name)\n\t-f output format (default GAMEI)\n\t-p filtering_preferences_file (default bop.prefs)\n\t-s query_sequence_fasta_file\nFiltering parameters can be set either by putting them in  bop.prefs\nor on the command line\n\t-min_score\n\t-min_identity\n\t-min_length\n\t-percent_length\n\t-wordsize\n\t-max_compression\n\t-max_expect\n\t-max_coverage\n\t-max_exons\n\t-max_cDNA_gap\n\t-max_coincidence\n\t-remove_twilight\n\t-remove_shadows\n\t-separate_HSP\n\t-split_frames\n\t-split_duplicates\n\t-join_EST_ends\n\t-revcomp_3primeESTs\n\t-trim_polyA\n\t-keep_polyA\n\t-keep_promoter\n\t-debug\n\t\n\nFor example:\nbop -list BAC12345.bopin -f YOUR_APOLLO_DIR/conf/bop.prefs\n\tor\nbop -primate BAC1234.na_dbEST.primate.blastn\n\tor\nbop -job 14";
    }

    private static void logError(BopException e) {
        String msg = e.getMessageWStackTrace();
        String bop_err_file = IOUtil.findFile("bop.errors");
        if (bop_err_file.length() > 0) {
            try {
                FileOutputStream fos = new FileOutputStream(bop_err_file);
                fos.write(msg.getBytes());
            }
            catch (Exception ex) {
                System.err.println("Problem putting msg to file " + bop_err_file);
                System.err.println(msg);
                ex.printStackTrace();
            }
        } else {
            System.err.println(msg);
        }
        caught_exception = true;
    }

    private static String getArgType(String arg) {
        return (arg.startsWith("-") ? arg.substring(1) : arg).toLowerCase();
    }

    private static boolean processInput(CurationSet curation, InputStream raw_data, Date run_date, AnalysisInput analysis_input, AnalysisParserI parser, HashMap arg_hash) {
        boolean parsed;
        String analysis_type = null;
        if (arg_hash.get("debug") != null) {
            analysis_input.setDebug((String)arg_hash.get("debug"));
            System.out.println("Debugging: " + arg_hash.get("debug"));
        }
        System.out.println("Trying to parse with " + parser.getClass().getName());
        analysis_type = parser.load(curation, curation.getRefSequence() == null, raw_data, analysis_input);
        boolean bl = parsed = analysis_type != null;
        if (parsed && analysis_input.runFilter()) {
            AnalysisFilter filter = new AnalysisFilter();
            analysis_input.setAnalysisType(analysis_type);
            filter.cleanUp(curation, analysis_type, analysis_input);
        }
        System.gc();
        return parsed;
    }

    private static InputStream getInputStream(String filename) throws ApolloAdapterException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(filename);
        }
        catch (Exception e) {
            stream = null;
            String rootdir = System.getProperty("APOLLO_ROOT");
            if (!(filename.startsWith("/") || filename.startsWith("\\") || filename.startsWith(rootdir))) {
                String absolute = rootdir + "/" + filename;
                try {
                    stream = new FileInputStream(absolute);
                }
                catch (Exception e2) {
                    absolute = rootdir + "/data/" + filename;
                    try {
                        stream = new FileInputStream(absolute);
                    }
                    catch (Exception e3) {
                        caught_exception = true;
                        throw new ApolloAdapterException("Error: could not open file " + filename + " for reading.");
                    }
                }
            }
            caught_exception = true;
            throw new ApolloAdapterException("Error: could not open " + filename + " for reading.");
        }
        return stream;
    }

    private static AnalysisInput getAnalysisInput(String data_type, boolean report) {
        AnalysisInput options = null;
        if (datatype2options == null) {
            datatype2options = new HashMap();
        } else {
            options = (AnalysisInput)datatype2options.get(data_type.toLowerCase());
        }
        if (options == null) {
            if (report) {
                System.out.println("No filtering found for " + data_type);
            }
            options = new AnalysisInput();
            options.setType(data_type);
            datatype2options.put(data_type.toLowerCase(), options);
        }
        return options;
    }

    /*
     * Loose catch block
     */
    private static void loadPrefs(HashMap arg_hash) {
        datatype2options = null;
        parsers = new Vector();
        String file_name = (String)arg_hash.get("p");
        System.out.println("Reading filtering preferences from " + file_name);
        String prefs_file = IOUtil.findFile(file_name);
        if (prefs_file != null && !prefs_file.equals("")) {
            if (!new File(prefs_file).canRead()) {
                bop.failureError("Can't read options from " + prefs_file);
            }
        } else {
            bop.failureError("Can't find options file " + prefs_file);
        }
        try {
            FileInputStream prefs_stream = new FileInputStream(prefs_file);
            BufferedReader r = new BufferedReader(new InputStreamReader(prefs_stream));
            StreamTokenizer tokens = new StreamTokenizer(r);
            tokens.eolIsSignificant(false);
            tokens.quoteChar(34);
            block10: while (true) {
                while (true) {
                    if (tokens.nextToken() != -1) {
                        try {
                            AnalysisInput options;
                            String data_type;
                            String pref_type = tokens.sval;
                            if (pref_type.equals("filter")) {
                                tokens.nextToken();
                                data_type = tokens.sval;
                                tokens.nextToken();
                                String option_values = tokens.sval;
                                options = bop.getAnalysisInput(data_type, false);
                                bop.parseOptions(options, data_type, option_values);
                                continue block10;
                            }
                            if (pref_type.equals("database")) {
                                tokens.nextToken();
                                String firstWord = tokens.sval;
                                tokens.nextToken();
                                String secondWord = tokens.sval;
                                if (firstWord.toUpperCase().equals("HOSTNAME")) {
                                    if (arg_hash.get("host") != null) continue block10;
                                    arg_hash.put("host", secondWord);
                                    continue block10;
                                }
                                if (!firstWord.toUpperCase().equals("DBNAME") || arg_hash.get("db") != null) continue block10;
                                arg_hash.put("db", secondWord);
                                continue block10;
                            }
                            if (pref_type.equals("parser")) {
                                tokens.nextToken();
                                String parser_name = tokens.sval;
                                try {
                                    Class<?> a_class = Class.forName(parser_name);
                                    Object parser = a_class.newInstance();
                                    parsers.addElement(parser);
                                }
                                catch (Exception e) {
                                    System.err.println("HEY!, couldn't create a " + parser_name);
                                }
                                continue block10;
                            }
                            if (pref_type.equals("autopromote")) {
                                tokens.nextToken();
                                data_type = tokens.sval;
                                tokens.nextToken();
                                String namer = tokens.sval;
                                options = bop.getAnalysisInput(data_type, false);
                                options.promoteResults(namer);
                                continue block10;
                            }
                            if (pref_type.equals("collapse")) {
                                tokens.nextToken();
                                data_type = tokens.sval;
                                AnalysisInput options2 = bop.getAnalysisInput(data_type, false);
                                options2.collapseResults(true);
                                continue block10;
                            }
                            if (pref_type.equals("outputformat")) {
                                tokens.nextToken();
                                arg_hash.put("f", tokens.sval.toLowerCase());
                                continue block10;
                            }
                            if (pref_type.equals("analysis")) {
                                tokens.nextToken();
                                tokens.nextToken();
                                continue block10;
                            }
                            System.out.println("pref type " + pref_type + " not recognized--tokens = " + tokens);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage() + " parsing tokens: " + tokens.toString());
                            caught_exception = true;
                        }
                        continue;
                    }
                    break;
                }
                break;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                caught_exception = true;
            }
            try {
                ((InputStream)prefs_stream).close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                caught_exception = true;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            bop.failureError("Error loading preferences:  " + ex.getMessage());
        }
    }

    private static void parseOptions(AnalysisInput options, String feature_type, String inputs) {
        StringTokenizer tokens = new StringTokenizer(inputs);
        while (tokens.hasMoreElements()) {
            String key = tokens.nextToken();
            String value = tokens.nextToken();
            bop.setOption(options, key, value);
        }
    }

    private static boolean setOption(AnalysisInput options, String key, String value) {
        boolean known = true;
        if (key.startsWith("-")) {
            key = key.substring(1);
        }
        if (key.equals("min_score")) {
            options.setMinScore(value);
        } else if (key.equals("min_identity")) {
            options.setMinIdentity(value);
        } else if (key.equals("min_length")) {
            options.setMinLength(value);
            options.setLengthUnits(false);
        } else if (key.equals("percent_length")) {
            options.setMinLength(value);
            options.setLengthUnits(true);
        } else if (key.equals("wordsize")) {
            options.setWordSize(value);
        } else if (key.equals("max_compression")) {
            options.setMaxRatio(value);
        } else if (key.equals("max_expect")) {
            options.setMaxExpect(value);
        } else if (key.equals("max_coverage")) {
            options.setMaxCover(value);
        } else if (key.equals("max_exons")) {
            options.setMaxExons(value);
        } else if (key.equals("max_cDNA_gap")) {
            options.setMaxAlignGap(value);
        } else if (key.equals("max_coincidence")) {
            options.setCoincidence(value);
        } else if (key.equals("remove_twilight")) {
            options.setRemoveTwilights(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("remove_shadows")) {
            options.filterShadows(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("separate_HSP")) {
            options.autonomousHSPs(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("split_frames")) {
            options.setSplitFrames(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("split_duplicates")) {
            options.setSplitTandems(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("join_EST_ends")) {
            options.joinESTends(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("revcomp_3primeESTs")) {
            options.revComp3Prime(value);
        } else if (key.equals("trim_polyA")) {
            options.trimPolyA(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("keep_polyA")) {
            options.keepPolyA(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("keep_promoter")) {
            options.keepPromoter(value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
        } else if (key.equals("debug")) {
            options.setDebug(value);
        } else {
            System.err.println("Unknown option " + key + "=" + value);
            known = false;
        }
        return known;
    }

    private static void saveResults(CurationSet curation, HashMap arg_hash) {
        String format;
        String output_file = (String)arg_hash.get("o");
        if (output_file == null) {
            if (curation.getRefSequence() != null) {
                String job_id = (String)arg_hash.get("job");
                if (job_id != null) {
                    output_file = job_id + "." + curation.getRefSequence().getName();
                } else {
                    int index;
                    output_file = (String)arg_hash.get("input_file");
                    if (output_file == null) {
                        System.out.println("Don't know what to call the output,  because there was no input file.");
                        output_file = curation.getRefSequence().getName();
                    }
                    output_file = (index = output_file.lastIndexOf("/")) > 0 ? output_file.substring(0, index) + "/" + curation.getRefSequence().getName() : curation.getRefSequence().getName();
                }
            } else {
                int index;
                System.err.println("There is no curated sequence? " + curation.getName());
                output_file = (String)arg_hash.get("input_file");
                if (output_file == null) {
                    bop.failureError("Don't know what to call the output,  because there was no input file.");
                }
                if ((index = output_file.lastIndexOf(".")) > 0) {
                    output_file = output_file.substring(0, index);
                }
            }
            output_file = output_file + ".xml";
        }
        if ((format = (String)arg_hash.get("f")).equals("gamei")) {
            GAMESave.writeXML(curation, output_file, bop.getVersion(), false);
        } else if (format.equals("gameii")) {
            GAMESave.writeXML(curation, output_file, bop.getVersion(), true);
        } else if (format.equals("gff")) {
            try {
                GFFAdapter gff = new GFFAdapter();
                gff.setFilename(output_file);
                gff.commitChanges(curation);
            }
            catch (Exception e) {
                System.out.println("Could not save gff to " + output_file);
                e.printStackTrace();
            }
        } else {
            System.out.println("Don't know about format " + format + " so saving as GAMEI in " + output_file);
            GAMESave.writeXML(curation, output_file, bop.getVersion(), false);
        }
    }

    static {
        arg_list.addElement("db");
        arg_list.addElement("host");
        arg_list.addElement("o");
        arg_list.addElement("f");
        arg_list.addElement("p");
        arg_list.addElement("s");
        arg_list.addElement("debug");
        output_formats = new String[]{"gameII", "gameI", "gff"};
    }
}

