/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis.filter;

import apollo.analysis.filter.AnalysisInput;
import apollo.analysis.filter.FilterPanel;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class BlastFilterPanel
extends FilterPanel {
    private JPanel filterConfigurationPanel;
    private JButton showFilterConfiguration;
    private JTextField min_expect = new JTextField("1.0e-4");
    private JCheckBox use_expect = new JCheckBox("Remove hits with an expect above threshold", false);
    private JTextField min_score = new JTextField("50");
    private JCheckBox use_score = new JCheckBox("Remove hits with a score below threshold", false);
    private JTextField min_identity = new JTextField("50");
    private JCheckBox use_identity = new JCheckBox("Remove HSPs with a percent identity below threshold", false);
    private JTextField min_length = new JTextField("50");
    private JComboBox length_units = new JComboBox();
    private JToggleButton use_length = new JCheckBox("Remove hits where length of aligned sequence is below threshold", false);
    private JTextField min_coincidence = new JTextField("80");
    private JCheckBox use_coincidence = new JCheckBox("Remove overlapping secondary HSPs within hits", false);
    private JTextField max_coverage = new JTextField("10");
    private JCheckBox limit_coverage = new JCheckBox("Remove redundant hits to limit depth of coverage", false);
    private JTextField word_size = new JTextField("2");
    private JTextField compress_threshold = new JTextField("15");
    private JCheckBox remove_lowinfo = new JCheckBox("Remove HSPs that are simple repeats", false);
    private JCheckBox remove_twilight = new JCheckBox("Remove HSPs that are distant and weakly scored", false);
    private JCheckBox remove_shadows = new JCheckBox("Remove hits that are shadowing hits on opposite strand", false);
    private JCheckBox split_frames = new JCheckBox("Split hits according to frame of HSPs", false);
    private JCheckBox split_dups = new JCheckBox("Split hits that are tandemly duplicated on subject into separate hits", false);
    private JCheckBox split_HSPs = new JCheckBox("Split hits into separate hits for each HSPs (for genomic to genomic)", false);
    private JCheckBox queryIsGenomic = new JCheckBox("I used the current genomic sequence (or a portion thereof) as my BLAST query");

    public BlastFilterPanel(Color bg_color) {
        this.setBackground(bg_color);
        this.buildGUI();
    }

    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        int textBoxHeight = 20;
        this.queryIsGenomic.setBackground(this.getBackground());
        this.add((Component)this.queryIsGenomic, GuiUtil.makeConstraintAt(0, row++, 1));
        this.queryIsGenomic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BlastFilterPanel.this.getAnalysisPanel().offsetField != null) {
                    BlastFilterPanel.this.getAnalysisPanel().offsetField.setEditable(BlastFilterPanel.this.queryIsGenomic.isSelected());
                }
            }
        });
        this.split_frames.setBackground(this.getBackground());
        this.add((Component)this.split_frames, GuiUtil.makeConstraintAt(0, row++, 1));
        this.min_coincidence.setPreferredSize(new Dimension(80, textBoxHeight));
        this.add((Component)this.use_coincidence, GuiUtil.makeConstraintAt(0, row, 1));
        this.use_coincidence.setBackground(this.getBackground());
        this.add((Component)this.min_coincidence, GuiUtil.makeConstraintAt(1, row++, 1));
        this.split_HSPs.setBackground(this.getBackground());
        this.add((Component)this.split_HSPs, GuiUtil.makeConstraintAt(0, row++, 1));
        this.split_dups.setBackground(this.getBackground());
        this.add((Component)this.split_dups, GuiUtil.makeConstraintAt(0, row++, 1));
        this.min_expect.setPreferredSize(new Dimension(80, textBoxHeight));
        this.add((Component)this.use_expect, GuiUtil.makeConstraintAt(0, row, 1));
        this.use_expect.setBackground(this.getBackground());
        this.add((Component)this.min_expect, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" maximum expect value"), GuiUtil.makeConstraintAt(2, row++, 1));
        this.min_score.setPreferredSize(new Dimension(80, textBoxHeight));
        this.add((Component)this.use_score, GuiUtil.makeConstraintAt(0, row, 1));
        this.use_score.setBackground(this.getBackground());
        this.add((Component)this.min_score, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" "), GuiUtil.makeConstraintAt(2, row++, 1));
        this.min_identity.setPreferredSize(new Dimension(80, textBoxHeight));
        this.add((Component)this.use_identity, GuiUtil.makeConstraintAt(0, row, 1));
        this.use_identity.setBackground(this.getBackground());
        this.add((Component)this.min_identity, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" %"), GuiUtil.makeConstraintAt(2, row++, 1));
        this.word_size.setPreferredSize(new Dimension(40, textBoxHeight));
        this.compress_threshold.setPreferredSize(new Dimension(40, textBoxHeight));
        this.add((Component)this.remove_lowinfo, GuiUtil.makeConstraintAt(0, row, 1));
        this.remove_lowinfo.setBackground(this.getBackground());
        this.add((Component)this.word_size, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" word size"), GuiUtil.makeConstraintAt(2, row, 1));
        this.add((Component)this.compress_threshold, GuiUtil.makeConstraintAt(3, row, 1));
        this.add((Component)GuiUtil.makeJLabelWithFont(" % compression"), GuiUtil.makeConstraintAt(4, row++, 1));
        this.add((Component)this.remove_twilight, GuiUtil.makeConstraintAt(0, row++, 1));
        this.remove_twilight.setBackground(this.getBackground());
        this.min_length.setPreferredSize(new Dimension(80, textBoxHeight));
        this.length_units.setEditable(false);
        this.length_units.insertItemAt("percentage", 0);
        this.length_units.insertItemAt("fixed minimum", 1);
        this.length_units.setSelectedItem("percentage");
        this.add((Component)this.use_length, GuiUtil.makeConstraintAt(0, row, 1));
        this.use_length.setBackground(this.getBackground());
        this.add((Component)this.min_length, GuiUtil.makeConstraintAt(1, row, 1));
        this.add((Component)this.length_units, GuiUtil.makeConstraintAt(2, row++, 1));
        this.add((Component)this.remove_shadows, GuiUtil.makeConstraintAt(0, row++, 1));
        this.remove_shadows.setBackground(this.getBackground());
        this.max_coverage.setPreferredSize(new Dimension(80, textBoxHeight));
        this.add((Component)this.limit_coverage, GuiUtil.makeConstraintAt(0, row, 1));
        this.limit_coverage.setBackground(this.getBackground());
        this.add((Component)this.max_coverage, GuiUtil.makeConstraintAt(1, row++, 1));
    }

    public Properties getProperties() {
        Properties stateInfo = new Properties();
        stateInfo.setProperty("min_expect", this.min_expect.getText());
        stateInfo.setProperty("use_expect", this.use_expect.isSelected() ? "true" : "false");
        stateInfo.setProperty("min_score", this.min_score.getText());
        stateInfo.setProperty("use_score", this.use_score.isSelected() ? "true" : "false");
        stateInfo.setProperty("min_identity", this.min_identity.getText());
        stateInfo.setProperty("use_identity", this.use_identity.isSelected() ? "true" : "false");
        stateInfo.setProperty("min_length", this.min_length.getText());
        stateInfo.setProperty("use_length", this.use_length.isSelected() ? "true" : "false");
        stateInfo.setProperty("length_units", (String)this.length_units.getSelectedItem());
        stateInfo.setProperty("min_coincidence", this.min_coincidence.getText());
        stateInfo.setProperty("use_coincidence", this.use_coincidence.isSelected() ? "true" : "false");
        stateInfo.setProperty("max_coverage", this.max_coverage.getText());
        stateInfo.setProperty("limit_coverage", this.limit_coverage.isSelected() ? "true" : "false");
        stateInfo.setProperty("word_size", this.word_size.getText());
        stateInfo.setProperty("compress_threshold", this.compress_threshold.getText());
        stateInfo.setProperty("remove_lowinfo", this.remove_lowinfo.isSelected() ? "true" : "false");
        stateInfo.setProperty("remove_twilight", this.remove_twilight.isSelected() ? "true" : "false");
        stateInfo.setProperty("remove_shadows", this.remove_shadows.isSelected() ? "true" : "false");
        stateInfo.setProperty("split_frames", this.split_frames.isSelected() ? "true" : "false");
        stateInfo.setProperty("split_dups", this.split_dups.isSelected() ? "true" : "false");
        stateInfo.setProperty("split_HSPs", this.split_HSPs.isSelected() ? "true" : "false");
        stateInfo.setProperty("queryIsGenomic", this.queryIsGenomic.isSelected() ? "true" : "false");
        return stateInfo;
    }

    public void setProperties(Properties properties) {
        String propValue = properties.getProperty("queryIsGenomic");
        if (propValue != null && propValue.equals("true") && this.getAnalysisPanel().offsetField != null) {
            this.queryIsGenomic.setSelected(true);
            this.getAnalysisPanel().offsetField.setEditable(true);
        } else if (this.getAnalysisPanel().offsetField != null) {
            this.getAnalysisPanel().offsetField.setEditable(false);
        }
        propValue = properties.getProperty("min_expect");
        if (propValue != null) {
            this.min_expect.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_expect")) != null && propValue.equals("true")) {
            this.use_expect.setSelected(true);
        }
        if ((propValue = properties.getProperty("min_score")) != null) {
            this.min_score.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_score")) != null && propValue.equals("true")) {
            this.use_score.setSelected(true);
        }
        if ((propValue = properties.getProperty("min_identity")) != null) {
            this.min_identity.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_identity")) != null && propValue.equals("true")) {
            this.use_identity.setSelected(true);
        }
        if ((propValue = properties.getProperty("min_length")) != null) {
            this.min_length.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_length")) != null && propValue.equals("true")) {
            this.use_length.setSelected(true);
        }
        if ((propValue = properties.getProperty("length_units")) != null) {
            this.length_units.setSelectedItem(propValue);
        }
        if ((propValue = properties.getProperty("min_coincidence")) != null) {
            this.min_coincidence.setText(propValue);
        }
        if ((propValue = properties.getProperty("use_coincidence")) != null && propValue.equals("true")) {
            this.use_coincidence.setSelected(true);
        }
        if ((propValue = properties.getProperty("max_coverage")) != null) {
            this.max_coverage.setText(propValue);
        }
        if ((propValue = properties.getProperty("limit_coverage")) != null && propValue.equals("true")) {
            this.limit_coverage.setSelected(true);
        }
        if ((propValue = properties.getProperty("word_size")) != null) {
            this.word_size.setText(propValue);
        }
        if ((propValue = properties.getProperty("compress_threshold")) != null) {
            this.compress_threshold.setText(propValue);
        }
        if ((propValue = properties.getProperty("remove_lowinfo")) != null && propValue.equals("true")) {
            this.remove_lowinfo.setSelected(true);
        }
        if ((propValue = properties.getProperty("remove_twilight")) != null && propValue.equals("true")) {
            this.remove_twilight.setSelected(true);
        }
        if ((propValue = properties.getProperty("remove_shadows")) != null && propValue.equals("true")) {
            this.remove_shadows.setSelected(true);
        }
        if ((propValue = properties.getProperty("split_frames")) != null && propValue.equals("true")) {
            this.split_frames.setSelected(true);
        }
        if ((propValue = properties.getProperty("split_dups")) != null && propValue.equals("true")) {
            this.split_dups.setSelected(true);
        }
        if ((propValue = properties.getProperty("split_HSPs")) != null && propValue.equals("true")) {
            this.split_HSPs.setSelected(true);
        }
    }

    public void setInputs(AnalysisInput inputs) {
        if (this.use_expect.isSelected()) {
            inputs.setMaxExpect(this.min_expect.getText());
        } else {
            inputs.setMaxExpect(AnalysisInput.NO_LIMIT);
        }
        if (this.use_score.isSelected()) {
            inputs.setMinScore(this.min_score.getText());
        } else {
            inputs.setMinScore(AnalysisInput.NO_LIMIT);
        }
        if (this.use_identity.isSelected()) {
            inputs.setMinIdentity(this.min_identity.getText());
        } else {
            inputs.setMinIdentity(AnalysisInput.NO_LIMIT);
        }
        if (this.use_length.isSelected()) {
            inputs.setMinLength(this.min_length.getText());
            String units = (String)this.length_units.getSelectedItem();
            inputs.setLengthUnits(units.equals("percentage"));
        } else {
            inputs.setMinLength(AnalysisInput.NO_LIMIT);
        }
        if (this.use_coincidence.isSelected()) {
            inputs.setCoincidence(this.min_coincidence.getText());
        } else {
            inputs.setCoincidence(AnalysisInput.NO_LIMIT);
        }
        if (this.limit_coverage.isSelected()) {
            inputs.setMaxCover(this.max_coverage.getText());
        } else {
            inputs.setMaxCover(AnalysisInput.NO_LIMIT);
        }
        if (this.remove_lowinfo.isSelected()) {
            inputs.setWordSize(this.word_size.getText());
            inputs.setMaxRatio(this.compress_threshold.getText());
        } else {
            inputs.setWordSize(AnalysisInput.NO_LIMIT);
        }
        inputs.setRemoveTwilights(this.remove_twilight.isSelected());
        inputs.filterShadows(this.remove_shadows.isSelected());
        inputs.setSplitFrames(this.split_frames.isSelected());
        inputs.setSplitTandems(this.split_dups.isSelected());
        inputs.autonomousHSPs(this.split_HSPs.isSelected());
        inputs.setQueryIsGenomic(this.queryIsGenomic.isSelected());
    }
}

