/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis.filter;

import java.util.Date;

public class AnalysisInput {
    public static int NO_LIMIT = -1;
    protected String tier;
    protected String display_type;
    protected String analysis_type;
    protected boolean filter = true;
    protected int min_score = NO_LIMIT;
    protected int min_identity = NO_LIMIT;
    protected int min_length = NO_LIMIT;
    protected int wordsize = NO_LIMIT;
    protected int max_ratio = 15;
    protected double max_expect = NO_LIMIT;
    protected int max_cover = -1;
    protected int max_exons = -1;
    protected int max_gap = -1;
    protected int coincidence = NO_LIMIT;
    protected int offset = 0;
    protected boolean remove_twilight = false;
    protected boolean remove_shadows = false;
    protected boolean distinctHSPs = false;
    protected boolean split_frames = false;
    protected boolean split_dups = false;
    protected boolean use_percentage = true;
    protected boolean join_EST_ends = false;
    protected boolean trim_polyA = false;
    protected String revcomp_3prime = null;
    protected String debug_str = null;
    protected boolean debug = false;
    protected Date run_date;
    protected String database = "";
    protected boolean collapse = false;
    protected String autopromote = null;
    protected boolean keep_polyApredict = false;
    protected boolean keep_promoter = false;
    protected boolean queryIsGenomic = false;

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public void setType(String type) {
        this.display_type = type;
    }

    public String getType() {
        return this.display_type;
    }

    public void setAnalysisType(String type) {
        this.analysis_type = type;
    }

    public String getAnalysisType() {
        return this.analysis_type;
    }

    public boolean runFilter() {
        return this.filter;
    }

    public void runFilter(boolean filter) {
        this.filter = filter;
    }

    public void setMaxRatio(String maxratioStr) {
        try {
            this.setMaxRatio(Integer.parseInt(maxratioStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse max_ratio from " + maxratioStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMaxRatio(int max_ratio) {
        this.max_ratio = max_ratio;
    }

    public int getMaxRatio() {
        return this.max_ratio;
    }

    public void setWordSize(String wordsizeStr) {
        try {
            this.setWordSize(Integer.parseInt(wordsizeStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse wordsize from " + wordsizeStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setWordSize(int wordsize) {
        this.wordsize = wordsize > 0 ? wordsize : NO_LIMIT;
    }

    public int getWordSize() {
        return this.wordsize;
    }

    public boolean removeLowContent() {
        return this.wordsize != NO_LIMIT;
    }

    public void setMaxExpect(String max_expectStr) {
        try {
            this.setMaxExpect(Double.valueOf(max_expectStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse max_expect from " + max_expectStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMaxExpect(double max_expect) {
        this.max_expect = max_expect >= 0.0 && max_expect <= 1.0 ? max_expect : (double)NO_LIMIT;
    }

    public double getMaxExpect() {
        return this.max_expect;
    }

    public boolean useExpect() {
        return this.max_expect != (double)NO_LIMIT;
    }

    public void setMaxCover(String max_coverStr) {
        try {
            this.setMaxCover(Integer.parseInt(max_coverStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse max_cover from " + max_coverStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMaxCover(int max_cover) {
        this.max_cover = max_cover > 0 ? max_cover : NO_LIMIT;
    }

    public int getMaxCover() {
        return this.max_cover;
    }

    public boolean limitCoverage() {
        return this.max_cover != NO_LIMIT;
    }

    public void setMaxExons(String max_exonsStr) {
        try {
            this.setMaxExons(Integer.parseInt(max_exonsStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse max_exons from " + max_exonsStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMaxExons(int max_exons) {
        this.max_exons = max_exons > 0 ? max_exons : NO_LIMIT;
    }

    public int getMaxExons() {
        return this.max_exons;
    }

    public boolean limitMaxExons() {
        return this.max_exons != NO_LIMIT;
    }

    public void setMaxAlignGap(String max_gapStr) {
        try {
            this.setMaxAlignGap(Integer.parseInt(max_gapStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse max_gap from " + max_gapStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMaxAlignGap(int max_gap) {
        this.max_gap = max_gap >= 0 && max_gap <= 100 ? max_gap : NO_LIMIT;
    }

    public int getMaxAlignGap() {
        return this.max_gap;
    }

    public boolean limitAlignGap() {
        return this.max_gap != NO_LIMIT;
    }

    public void setCoincidence(String coincidenceStr) {
        try {
            this.setCoincidence(Integer.parseInt(coincidenceStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse coincidence from " + coincidenceStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setCoincidence(int coincidence) {
        this.coincidence = coincidence >= 0 && coincidence <= 100 ? coincidence : NO_LIMIT;
    }

    public int getCoincidence() {
        return this.coincidence;
    }

    public boolean useCoincidence() {
        return this.coincidence != NO_LIMIT;
    }

    public boolean removeShadows() {
        return this.remove_shadows;
    }

    public void filterShadows(boolean remove) {
        this.remove_shadows = remove;
    }

    public int getTwilightUpper() {
        return -1;
    }

    public int getTwilightLower() {
        return -1;
    }

    public boolean removeTwilights() {
        return this.remove_twilight;
    }

    public void setRemoveTwilights(boolean dothis) {
        this.remove_twilight = dothis;
    }

    public void setMinScore(String scoreStr) {
        try {
            this.setMinScore(Integer.parseInt(scoreStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse score from " + scoreStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMinScore(int score) {
        this.min_score = score > 0 ? score : NO_LIMIT;
    }

    public int getMinScore() {
        return this.min_score;
    }

    public boolean useScore() {
        return this.min_score != NO_LIMIT;
    }

    public void setMinIdentity(String identityStr) {
        try {
            this.setMinIdentity(Integer.parseInt(identityStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse identity from " + identityStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMinIdentity(int identity) {
        this.min_identity = identity > 0 ? identity : NO_LIMIT;
    }

    public int getMinIdentity() {
        return this.min_identity;
    }

    public boolean useIdentity() {
        return this.min_identity != NO_LIMIT;
    }

    public void setMinLength(String lengthStr) {
        try {
            this.setMinLength(Integer.parseInt(lengthStr));
        }
        catch (Exception e) {
            System.out.println("Unable to parse length from " + lengthStr + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMinLength(int length) {
        this.min_length = length > 0 ? length : NO_LIMIT;
    }

    public int getMinLength() {
        return this.min_length;
    }

    public boolean useLength() {
        return this.min_length != NO_LIMIT;
    }

    public void setLengthUnits(boolean is_percent) {
        this.use_percentage = is_percent;
    }

    public boolean usePercentage() {
        return this.use_percentage;
    }

    public void autonomousHSPs(boolean dothis) {
        this.distinctHSPs = dothis;
    }

    public boolean useAutonomousHSPs() {
        return this.distinctHSPs;
    }

    public void setSplitTandems(boolean dothis) {
        this.split_dups = dothis;
    }

    public boolean splitTandems() {
        return this.split_dups;
    }

    public void revComp3Prime(String suffix) {
        this.revcomp_3prime = suffix;
    }

    public boolean revComp3Prime() {
        return this.revcomp_3prime != null && !this.revcomp_3prime.equals("");
    }

    public String get3PrimeSuffix() {
        return this.revcomp_3prime;
    }

    public void joinESTends(boolean dothis) {
        this.join_EST_ends = dothis;
    }

    public boolean joinESTends() {
        return this.join_EST_ends;
    }

    public void trimPolyA(boolean dothis) {
        this.trim_polyA = dothis;
    }

    public boolean trimPolyA() {
        return this.trim_polyA;
    }

    public void keepPolyA(boolean dothis) {
        this.keep_polyApredict = dothis;
    }

    public boolean keepPolyA() {
        return this.keep_polyApredict;
    }

    public void keepPromoter(boolean dothis) {
        this.keep_promoter = dothis;
    }

    public boolean keepPromoter() {
        return this.keep_promoter;
    }

    public void setDebug(String debug_str) {
        this.debug_str = debug_str;
        this.setDebug(debug_str != null && (debug_str.equalsIgnoreCase("t") || debug_str.equalsIgnoreCase("true")));
    }

    public void setDebug(boolean dothis) {
        this.debug = dothis;
    }

    public boolean debugFilter(String this_str) {
        return this.debug || this.debug_str != null && this_str.startsWith(this.debug_str);
    }

    public void setSplitFrames(boolean dothis) {
        this.split_frames = dothis;
    }

    public boolean splitFrames() {
        return this.split_frames;
    }

    public void setQueryIsGenomic(boolean dothis) {
        this.queryIsGenomic = dothis;
    }

    public boolean queryIsGenomic() {
        return this.queryIsGenomic;
    }

    public void setOffset(String offsetStr, int genomic_start) {
        if ((offsetStr = offsetStr.trim()) != null && !offsetStr.equals("")) {
            try {
                this.setOffset(Integer.parseInt(offsetStr) + genomic_start - 1);
            }
            catch (Exception e) {
                System.out.println("Unable to parse offset from " + offsetStr + " " + e.getMessage());
                e.printStackTrace();
                this.setOffset(genomic_start);
            }
        } else {
            this.setOffset(genomic_start);
        }
    }

    public void setOffset(int offset) {
        this.offset = offset > 0 ? offset : 0;
        System.out.println("Set offset to " + this.offset);
    }

    public int getOffset() {
        return this.offset;
    }

    public Date getRunDate() {
        return this.run_date;
    }

    public void setRunDate(long processed_time) {
        this.run_date = processed_time > 0L ? new Date(processed_time * 1000L) : new Date();
    }

    public void seRtunDate(Date run_date) {
        this.run_date = run_date;
    }

    public void collapseResults(boolean collapse) {
        this.collapse = collapse;
    }

    public boolean collapseResults() {
        return this.collapse;
    }

    public void promoteResults(String baptizer) {
        this.autopromote = baptizer;
    }

    public boolean promoteResults() {
        return this.autopromote != null;
    }

    public String getBaptizer() {
        return this.autopromote;
    }

    public void setDatabase(String db) {
        this.database = db;
    }

    public String getDatabase() {
        return this.database;
    }
}

