/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.HashDB;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class StreamMatch {
    HashDB hash;
    DataInputStream dis;

    public StreamMatch(DataInputStream dis, HashDB hash) {
        this.hash = hash;
        this.dis = dis;
    }

    public void run() {
        long start = System.currentTimeMillis();
        this.hash.run();
        long end = System.currentTimeMillis();
        System.out.println("Time for hash " + (end - start + 1L) / 1000L);
        this.streamDB();
    }

    public void streamDB() {
        long start = System.currentTimeMillis();
        int wordsize = this.hash.getWordSize();
        byte[] bytestr = new byte[wordsize];
        Vector<Vector> hits = new Vector<Vector>();
        try {
            while (this.dis.read(bytestr) > 0) {
                String str = new String(bytestr);
                Vector pos = this.hash.getPositions(str);
                if (pos == null) continue;
                hits.addElement(pos);
            }
        }
        catch (IOException e) {
            System.out.println("Exception reading data stream " + e);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time for stream " + (double)(end - start + 1L) / 1000.0);
        System.out.println("Number of hits " + hits.size());
        System.out.println("Hits " + hits);
    }

    public static void main(String[] args) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(args[0])));
            HashDB hashdb = new HashDB(dis);
            hashdb.setOverlapping(true);
            hashdb.setWordSize(Integer.parseInt(args[1]));
            hashdb.run();
            System.out.println(hashdb);
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(args[2])));
            StreamMatch sm = new StreamMatch(stream, hashdb);
            sm.run();
        }
        catch (FileNotFoundException e) {
            System.out.println("Exception " + e);
        }
    }
}

