/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.SeqAnalysisGUI;
import apollo.analysis.SeqAnalysisRemote;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class SeqAnalysisBDGP
extends SeqAnalysisRemote {
    public SeqAnalysisBDGP() {
        this.initSeqAnalysisBDGP();
    }

    public SeqAnalysisBDGP(Hashtable inproperties) {
        super(inproperties);
        this.initSeqAnalysisBDGP();
    }

    public void initSeqAnalysisBDGP() {
        Vector<String> v = new Vector<String>();
        v.addElement("programName");
        v.addElement("programParams");
        this.setAllowedProperties(v);
        Vector<String> progs = new Vector<String>();
        progs.addElement("sim4wrap");
        progs.addElement("blastp");
        progs.addElement("interpro");
        progs.addElement("full peptide analysis");
        progs.addElement("full genomic analysis");
        this.setAllowedValues("programName", progs);
    }

    public DataAdapterUI getUI(IOOperation op) {
        return new SeqAnalysisGUI(this, op);
    }

    public boolean launch() {
        try {
            String path = "http://www.fruitfly.org/cgi-bin/annot/launch.pl?seqid=" + this.getInputSequence().getName() + "&residues=" + this.getInputSequence().getResidues();
            URL url = new URL(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String ticket = in.readLine();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getName() {
        return "SeqAnalysisBDGP";
    }

    public String getType() {
        return "BDGP beowulf executed analysis";
    }
}

