/*
 * Decompiled with CFR 0.152.
 */
package apollo.analysis;

import apollo.analysis.GenericProgramHandler;
import apollo.analysis.SeqAnalysisI;
import apollo.analysis.SeqAnalysisLocal;
import apollo.datamodel.CurationSet;

public class BlastHandler
extends GenericProgramHandler {
    public String createUnixShellCommand(SeqAnalysisLocal seqAnalysis) {
        String path = "blastall";
        String programName = seqAnalysis.getProperty("programName");
        String dbpath = seqAnalysis.getProperty("datasourcePath");
        if (dbpath == null) {
            String dbdir = seqAnalysis.getProperty("datasourceDir");
            String dbname = seqAnalysis.getProperty("datasourceName");
            dbpath = dbdir == null ? dbname : dbdir + "/" + dbname;
        }
        String cmd = "";
        String seqpath = seqAnalysis.getSeqFile();
        try {
            String args = seqAnalysis.getProperty("programParams");
            if (args == null) {
                args = "";
            }
            cmd = path + " -p " + programName + " -d " + dbpath + " " + " -i " + seqpath + " " + args;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    public CurationSet parseAnalysisResults(SeqAnalysisI seqAnalysis) {
        System.out.println("not implementated!");
        return null;
    }
}

