#!/bin/bash

# bail out upon error
set -e

startdir=`pwd`
destdir=.
ensemblversion=""


if [ -d debian ]; then
	echo "I: Found debian directory, retrieving Ensembl version from debian/changelog"
	ensemblversion=`dpkg-parsechangelog | grep ^Version | head -1 | cut -f2 -d\ | cut -f1 -d-`
	destdir=..
fi



# All libraries must be of the same version - update them all or none
if [ -z "$ensemblversion" ]; then
	echo "W: Ensembl version previously unset, setting to '62'."
	ensemblversion=63
fi

downloaddir=$destdir/$ensemblversion.$$


echo "I: Will download to directory '$downloaddir'."

if [ ! -d "$downloaddir" ] ; then 
	mkdir "$downloaddir"
fi
cd "$downloaddir"

export CVSROOT=":pserver:cvsuser@cvs.sanger.ac.uk:/cvsroot/ensembl"

echo " * Logging in to Sanger CVS, type password CVSUSER"
cvs login

echo
echo "I: Performing checkout"
echo

for package in	ensembl-api ensembl-website
do
	echo "----------------------------------------------------"
	echo "			$package"
	echo "----------------------------------------------------"
	if [ -d "$dname" ]; then
		echo "W: Skipping fetch of package '$dname', directory is already existing."
		#(cd $i && cvs -z 3 update .)
	else 
		cvs -z 3 checkout -r branch-ensembl-${ensemblversion} ${package}
	fi
	echo
done


echo 
echo "  Removing CVS directories."
echo

# still in $downloaddir
find . -name CVS -a -type d | xargs -r rm -rf

cd "$startdir"

echo "I: Renaming for looking nice to ensembl-$ensemblversion"
if [ -e "$$destdir/ensembl-$ensemblversion" ]; then
	echo "   Moving existing file/folder 'ensembl-$ensemblversion' to 'ensembl-$ensemblversion.old'"
	rm -rf "ensembl-$ensemblversion.old" 
	mv "$$destdir/ensembl-$ensemblversion" "$$destdir/ensembl-$ensemblversion.old"
fi

echo "I: Removing a series of files for better DFSG compliance"
find "$destdir"/"ensembl-$ensemblversion" -name "*.pdf" | grep -v ComparaTutorial | xargs -r rm
rm -f "$destdir"/"ensembl-$ensemblversion"/ensembl-compara/scripts/synteny/BuildSynteny.jar
# The jalview.jar needs to remain in the source tree


mv "$downloaddir" "$destdir/ensembl-$ensemblversion"
cd "$destdir"
GZIP="--best --no-name" tar czvf ensembl_${ensemblversion}.orig.tar.gz ensembl-$ensemblversion

echo
echo "I: Success."
echo
echo "I: Left downloaded folder '$destdir/ensembl-$ensemblversion' intact."
echo
