// Copyright (c) 2006 Foundation for Research and Technology-Hellas (Greece).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you may redistribute it under
// the terms of the Q Public License version 1.0.
// See the file LICENSE.QPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/CGAL-3.5-branch/Segment_Delaunay_graph_2/include/CGAL/Segment_Delaunay_graph_storage_traits_with_info_2.h $
// $Id: Segment_Delaunay_graph_storage_traits_with_info_2.h 32899 2006-08-02 10:20:33Z mkaravel $
// 
//
// Author(s)     : Menelaos Karavelas <mkaravel@iacm.forth.gr>

#ifndef CGAL_SEGMENT_DELAUNAY_GRAPH_STORAGE_TRAITS_WITH_INFO_2_H
#define CGAL_SEGMENT_DELAUNAY_GRAPH_STORAGE_TRAITS_WITH_INFO_2_H 1

#include <CGAL/basic.h>
#include <CGAL/Segment_Delaunay_graph_storage_traits_2.h>
#include <CGAL/Segment_Delaunay_graph_storage_site_with_info_2.h>
#include <CGAL/Segment_Delaunay_graph_2/Construct_storage_site_with_info_2.h>

CGAL_BEGIN_NAMESPACE

template<class Gt, typename Info_, class Converter, class Merger>
class Segment_Delaunay_graph_storage_traits_with_info_2
  : public Segment_Delaunay_graph_storage_traits_2<Gt>
{
public:
  typedef Info_                                        Info;
  typedef Converter                                    Convert_info;
  typedef Merger                                       Merge_info;

private:
  typedef Segment_Delaunay_graph_storage_traits_2<Gt>  Base;
  typedef typename Base::Storage_site_2                Base_storage_site_2;

  typedef Segment_Delaunay_graph_storage_traits_with_info_2<Gt,
							    Info,
							    Convert_info,
							    Merge_info>
  Self;

public:
  typedef typename Base::Geom_traits               Geom_traits;

  typedef
  Segment_Delaunay_graph_storage_site_with_info_2<Self,
						  Info,
						  Base_storage_site_2>
  Storage_site_2;

  typedef
  CGAL_SEGMENT_DELAUNAY_GRAPH_2_NS::Construct_storage_site_with_info_2<Self>
  Construct_storage_site_2;

  // MK::FIGURE OUT HOW TO PASS A REFERENCE TO GEOM_TRAITS AND HAVE
  // DEFAULT CONSTRUCTOR AS WELL IF POSSIBLE
  Segment_Delaunay_graph_storage_traits_with_info_2
  (const Geom_traits& gt = Geom_traits())
    : Base(gt) {}

  inline Construct_storage_site_2
  construct_storage_site_2_object() const {
    return Construct_storage_site_2();
  }

  inline Convert_info
  convert_info_object() const {
    return Convert_info();
  }

  inline Merge_info
  merge_info_object() const {
    return Merge_info();
  }
};



CGAL_END_NAMESPACE

#endif // CGAL_SEGMENT_DELAUNAY_GRAPH_STORAGE_TRAITS_WITH_INFO_2_H
