/* jp2tools.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Auxiliary routines for jp2 processing.
 */

#ifndef SRC_JP2TOOLS_H
#define SRC_JP2TOOLS_H

/* types used externally */
enum enum_upsampler {UPS_LINEAR, UPS_LANCZOS};
#define t_upsampler enum enum_upsampler

// FIXME: this shouldn't be necessary as it's redundant, but won't compile otherwise
extern t_upsampler JP2Upsampler;



int return_downscaled_array_len (const int width, const int xpos, const int xstep);
void jp2_downsample_image_components (unsigned char *bitmap, const int width, const int height, const int bpp, const int *csampling, int *csampling_effective, int *cwidth, int *cheight);
void jp2_upsample_image_components (unsigned char *bitmap, const int width, const int height, const int bpp, const int *csampling, const int *cwidth, const int *cheight);

/* PRIVATE */
void upsample_component_line_lanczos (const float *x_in_buff, float *x_out_buff, float *weight_x_out_buff, const float *x_contrib, const int x_contrib_size, const int width, const int xpos, const int xstep, const int compressed_width);
void upsample_component_lanczos (unsigned char *carray, int width, int height, const int xpos, const int ypos, const int xstep, const int ystep);

#endif

