/* text.c - part of ziproxy package
 *
 * Copyright (c)2003-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2007 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * HTML modification, text compression fuctions
 */

#include "http.h"

//To stop multiple inclusions.
#ifndef SRC_TEXT_H
#define SRC_TEXT_H

extern int undo_name (char *path);
extern int do_modify(http_headers *serv_hdr, http_headers *client_hdr, char *inbuf, int insize, int original_size,
		char ** outbuf, int *outsize, FILE *sockrfp, FILE *sockwfp);
extern int do_compress_stream_stream(http_headers *hdr, FILE *from, FILE *to, int *inlen, int *outlen);
extern int do_decompress_stream_stream(http_headers *hdr, FILE *from, FILE *to, int *inlen, int *outlen, int max_ratio, int min_eval);
extern int do_compress_memory_stream(http_headers *hdr, const char *from, FILE *to, const int inlen, int *outlen);
extern int replace_gzipped_with_gunzipped(char **inoutbuf, int inlen, int max_growth);
enum {ONormal, OChunked, OStream, OGzipStream};

#ifdef JP2K
extern char * IMGtoOBJ(char *src, char *original, int attrs, char ** img_attr, char ** img_val);
#endif

#endif //SRC_TEXT_H
