use strict;
use Zim::Utils;

my $app = Zim::GUI->current;

my $actions = __actions( q{
GoToday		.		To_day		<alt>D		Today
} );

my $toggle_actions = __actions( q{
TCalendar	stock_calendar-view-month	Calen_dar	.	Show calendar
} );

$app->add_actions($actions);
$app->add_actions($toggle_actions, 'TOGGLE');

$app->add_ui( q{
<ui>
<menubar name='MenuBar'>
	<menu action='ViewMenu'>
		<placeholder name='PluginItems'>
			<menuitem action='TCalendar'/>
		</placeholder>
	</menu>
	<menu action='GoMenu'>
		<placeholder name='PluginItems'>
			<menuitem action='GoToday'/>
		</placeholder>
	</menu>
</menubar>
<toolbar name='ToolBar'>
	<placeholder name='Tools'>
		<toolitem action='TCalendar'/>
	</placeholder>
</toolbar>
</ui> } );

return 1;

sub TCalendar {
	my ($self, $show) = @_;
	my $cal = $self->Calendar; # autoloads Zim::GUI::Calendar
	$show = $cal->visible ? 0 : 1 unless defined $show;
	$show ? $cal->show : $cal->hide ;
}

sub GoToday {
	my $self = shift;
	my ($day, $month, $year) = ( localtime )[3, 4, 5];
	$year += 1900;
	$self->Calendar->load_date($day, $month, $year);
}

