CPP_PACKAGES=\
  ice$(R)-translators \
  ice$(R)-services \
  libicestorm$(R) \
  libicegrid$(R) \
  libicebox$(R) \
  icebox \
  libicepatch2-$(R) \
  libglacier2-$(R) \
  libfreeze$(R) \
  libicedb$(R) \
  libzeroc-ice$(R) \
  libicessl$(R) \
  libiceutil$(R) \
  libicexml$(R) \
  libslice$(R) \
  libzeroc-ice$(R) \
  libzeroc-ice$(R)-dev \
  libzeroc-ice$(R)-dbg \
  ice$(R)-slice

CPP_PREFIX=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr

debian/stamp-build-cpp:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	OPTIMIZE=$(OPTIMIZE) UNAME=$(UNAME) \
	LP64=yes lp64suffix= USE_READLINE=yes \
	LDPLATFORMFLAGS=-g \
	prefix=/usr \
	QT_HOME=/usr/include/qt4 -j $(PROCESSORS)
debian/stamp-build-cpp::
	-mkdir -p cpp/bin cpp/lib
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C cpp all; \
		$(DEB_MAKE_INVOKE) -C cpp/doc all ; \
	fi
	:> $@

debian/stamp-install-cpp:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	LP64=yes lp64suffix=  UNAME=$(UNAME) \
	prefix=$(CPP_PREFIX) \
	install_docdir=$(CPP_PREFIX)/share/doc/ice$(R)-slice \
	install_slicedir=$(CPP_PREFIX)/share/Ice-$(V)/slice \
	QT_HOME=/usr/include/qt4 -j $(PROCESSORS)
debian/stamp-install-cpp::
	-mkdir -p $(CPP_PREFIX)/bin $(CPP_PREFIX)/lib
	-mkdir -p $(CPP_PREFIX)/share/Ice-$(V)
	-mkdir -p $(CPP_PREFIX)/share/doc/ice$(R)-slice
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C cpp install ; \
		$(DEB_MAKE_INVOKE) -C cpp/doc install ; \
	fi

	:> $@

binary-predeb/ice$(R)-slice::
	-find debian/ice$(R)-slice/usr/share/*/slice -type f -a -name \*.ice \
		| xargs chmod a-x

binary-predeb/libicessl$(R)::
	-find debian/libicessl$(R)/usr/share/java -type f -a -name \*.class \
		| xargs chmod a-x

binary-predeb/libzeroc-ice$(R)-dbg::
	cd debian/libzeroc-ice$(R)-dbg/usr/lib/debug/usr/lib && mv pyshared pymodules

.PHONY: build/cpp install/cpp

build/cpp:: debian/stamp-build-cpp
install/cpp:: debian/stamp-install-cpp

$(patsubst %,build/%,$(CPP_PACKAGES)) :: build/% : build/cpp
$(patsubst %,install/%,$(CPP_PACKAGES)) :: install/% : install/cpp

clean::
	$(MAKE) UNAME=$(UNAME) QT_HOME=/usr/include/qt4 -C cpp clean
	$(MAKE) UNAME=$(UNAME) -C cpp/doc clean
	$(RM) debian/stamp-build-cpp debian/stamp-install-cpp
