/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import java.util.Arrays;
import java.util.Map;

public class DirectReference
extends RoutableReference {
    private EndpointI[] _endpoints;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DirectReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, boolean sec, boolean prefSec, EndpointI[] endpts, RouterInfo rtrInfo, boolean collocationOpt, boolean cacheConnection, EndpointSelectionType endpointSelection, boolean threadPerConnection) {
        super(inst, com, ident, ctx, fs, md, sec, prefSec, rtrInfo, collocationOpt, cacheConnection, endpointSelection, threadPerConnection);
        this._endpoints = endpts;
    }

    public String getAdapterId() {
        return "";
    }

    public EndpointI[] getEndpoints() {
        return this._endpoints;
    }

    public int getLocatorCacheTimeout() {
        return 0;
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        return this;
    }

    public Reference changeCompress(boolean newCompress) {
        DirectReference r = (DirectReference)super.changeCompress(newCompress);
        if (r != this) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].compress(newCompress);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    public Reference changeTimeout(int newTimeout) {
        DirectReference r = (DirectReference)super.changeTimeout(newTimeout);
        if (r != this) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].timeout(newTimeout);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    public Reference changeConnectionId(String connectionId) {
        DirectReference r = (DirectReference)super.changeConnectionId(connectionId);
        if (r != this) {
            EndpointI[] newEndpoints = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                newEndpoints[i] = this._endpoints[i].connectionId(connectionId);
            }
            r._endpoints = newEndpoints;
        }
        return r;
    }

    public Reference changeAdapterId(String newAdapterId) {
        if (newAdapterId == null || newAdapterId.length() == 0) {
            return this;
        }
        LocatorInfo locatorInfo = this.getInstance().locatorManager().get(this.getInstance().referenceFactory().getDefaultLocator());
        return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), this.getPreferSecure(), newAdapterId, this.getRouterInfo(), locatorInfo, this.getCollocationOptimization(), this.getCacheConnection(), this.getEndpointSelection(), this.getThreadPerConnection(), this.getLocatorCacheTimeout());
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        if (Arrays.equals(newEndpoints, this._endpoints)) {
            return this;
        }
        DirectReference r = (DirectReference)this.getInstance().referenceFactory().copy(this);
        r._endpoints = newEndpoints;
        r.applyOverrides(r._endpoints);
        return r;
    }

    public Reference changeLocatorCacheTimeout(int newTimeout) {
        return this;
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        super.streamWrite(s);
        s.writeSize(this._endpoints.length);
        if (this._endpoints.length > 0) {
            for (int i = 0; i < this._endpoints.length; ++i) {
                this._endpoints[i].streamWrite(s);
            }
        } else {
            s.writeString("");
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        for (int i = 0; i < this._endpoints.length; ++i) {
            String endp = this._endpoints[i].toString();
            if (endp == null || endp.length() <= 0) continue;
            s.append(':');
            s.append(endp);
        }
        return s.toString();
    }

    public ConnectionI getConnection(BooleanHolder comp) {
        EndpointI[] endpts = super.getRoutedEndpoints();
        this.applyOverrides(endpts);
        if (endpts.length == 0) {
            endpts = this._endpoints;
        }
        ConnectionI connection = this.createConnection(endpts, comp);
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirectReference)) {
            return false;
        }
        DirectReference rhs = (DirectReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        return Arrays.equals(this._endpoints, rhs._endpoints);
    }

    static {
        $assertionsDisabled = !DirectReference.class.desiredAssertionStatus();
    }
}

