/* extension.c generated by valac 0.14.0, the Vala compiler
 * generated from extension.vala, do not modify */

/* extension.vala
 *
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>


#define ZEITGEIST_TYPE_EXTENSION (zeitgeist_extension_get_type ())
#define ZEITGEIST_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension))
#define ZEITGEIST_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))
#define ZEITGEIST_IS_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_IS_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))

typedef struct _ZeitgeistExtension ZeitgeistExtension;
typedef struct _ZeitgeistExtensionClass ZeitgeistExtensionClass;
typedef struct _ZeitgeistExtensionPrivate ZeitgeistExtensionPrivate;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define ZEITGEIST_TYPE_EXTENSION_LOADER (zeitgeist_extension_loader_get_type ())
#define ZEITGEIST_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader))
#define ZEITGEIST_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))
#define ZEITGEIST_IS_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_IS_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_EXTENSION_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))

typedef struct _ZeitgeistExtensionLoader ZeitgeistExtensionLoader;
typedef struct _ZeitgeistExtensionLoaderClass ZeitgeistExtensionLoaderClass;
typedef struct _ZeitgeistExtensionLoaderPrivate ZeitgeistExtensionLoaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_MODULE_LOADER (zeitgeist_module_loader_get_type ())
#define ZEITGEIST_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader))
#define ZEITGEIST_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))
#define ZEITGEIST_IS_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_IS_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))

typedef struct _ZeitgeistModuleLoader ZeitgeistModuleLoader;
typedef struct _ZeitgeistModuleLoaderClass ZeitgeistModuleLoaderClass;
typedef struct _ZeitgeistModuleLoaderPrivate ZeitgeistModuleLoaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

#define ZEITGEIST_TYPE_BUILTIN_EXTENSION (zeitgeist_builtin_extension_get_type ())
#define ZEITGEIST_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtension))
#define ZEITGEIST_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))
#define ZEITGEIST_IS_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_IS_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_BUILTIN_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))

typedef struct _ZeitgeistBuiltinExtension ZeitgeistBuiltinExtension;
typedef struct _ZeitgeistBuiltinExtensionClass ZeitgeistBuiltinExtensionClass;
typedef struct _ZeitgeistBuiltinExtensionPrivate ZeitgeistBuiltinExtensionPrivate;

struct _ZeitgeistExtension {
	GObject parent_instance;
	ZeitgeistExtensionPrivate * priv;
};

struct _ZeitgeistExtensionClass {
	GObjectClass parent_class;
	void (*unload) (ZeitgeistExtension* self);
	void (*pre_insert_events) (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
	void (*post_insert_events) (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
	guint32* (*pre_delete_events) (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1);
	void (*post_delete_events) (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender);
};

struct _ZeitgeistExtensionPrivate {
	ZeitgeistEngine* _engine;
};

struct _ZeitgeistEngine {
	GObject parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistEngineClass {
	GObjectClass parent_class;
};

typedef GType (*ZeitgeistRegisterExtensionFunc) (GTypeModule* module);
struct _ZeitgeistExtensionLoader {
	GTypeModule parent_instance;
	ZeitgeistExtensionLoaderPrivate * priv;
};

struct _ZeitgeistExtensionLoaderClass {
	GTypeModuleClass parent_class;
	ZeitgeistExtension* (*create_instance) (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine);
};

struct _ZeitgeistExtensionLoaderPrivate {
	GType _extension_type;
};

struct _ZeitgeistModuleLoader {
	ZeitgeistExtensionLoader parent_instance;
	ZeitgeistModuleLoaderPrivate * priv;
};

struct _ZeitgeistModuleLoaderClass {
	ZeitgeistExtensionLoaderClass parent_class;
};

struct _ZeitgeistModuleLoaderPrivate {
	gchar* _module_path;
	GModule* module;
};

struct _ZeitgeistBuiltinExtension {
	ZeitgeistExtensionLoader parent_instance;
	ZeitgeistBuiltinExtensionPrivate * priv;
};

struct _ZeitgeistBuiltinExtensionClass {
	ZeitgeistExtensionLoaderClass parent_class;
};

struct _ZeitgeistBuiltinExtensionPrivate {
	ZeitgeistRegisterExtensionFunc reg_func;
};


static gpointer zeitgeist_extension_parent_class = NULL;
static gpointer zeitgeist_extension_loader_parent_class = NULL;
static gpointer zeitgeist_module_loader_parent_class = NULL;
static gpointer zeitgeist_builtin_extension_parent_class = NULL;

GType zeitgeist_extension_get_type (void) G_GNUC_CONST;
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionPrivate))
enum  {
	ZEITGEIST_EXTENSION_DUMMY_PROPERTY,
	ZEITGEIST_EXTENSION_ENGINE
};
void zeitgeist_extension_unload (ZeitgeistExtension* self);
static void zeitgeist_extension_real_unload (ZeitgeistExtension* self);
void zeitgeist_extension_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
static void zeitgeist_extension_real_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
static void zeitgeist_extension_real_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
guint32* zeitgeist_extension_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1);
static guint32* zeitgeist_extension_real_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender);
static void zeitgeist_extension_real_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender);
void zeitgeist_extension_store_config (ZeitgeistExtension* self, const gchar* key, GVariant* data);
ZeitgeistEngine* zeitgeist_extension_get_engine (ZeitgeistExtension* self);
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
void zeitgeist_extension_store_store (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, GVariant* data);
GVariant* zeitgeist_extension_retrieve_config (ZeitgeistExtension* self, const gchar* key, const gchar* format);
GVariant* zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, const GVariantType* format);
ZeitgeistExtension* zeitgeist_extension_construct (GType object_type);
void zeitgeist_extension_set_engine (ZeitgeistExtension* self, ZeitgeistEngine* value);
static void zeitgeist_extension_finalize (GObject* obj);
static void _vala_zeitgeist_extension_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_extension_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zeitgeist_extension_loader_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderPrivate))
enum  {
	ZEITGEIST_EXTENSION_LOADER_DUMMY_PROPERTY,
	ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE
};
ZeitgeistExtension* zeitgeist_extension_loader_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine);
static ZeitgeistExtension* zeitgeist_extension_loader_real_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine);
GType zeitgeist_extension_loader_get_extension_type (ZeitgeistExtensionLoader* self);
ZeitgeistExtensionLoader* zeitgeist_extension_loader_construct (GType object_type);
void zeitgeist_extension_loader_set_extension_type (ZeitgeistExtensionLoader* self, GType value);
static void zeitgeist_extension_loader_finalize (GObject* obj);
static void _vala_zeitgeist_extension_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_extension_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zeitgeist_module_loader_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_MODULE_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderPrivate))
enum  {
	ZEITGEIST_MODULE_LOADER_DUMMY_PROPERTY,
	ZEITGEIST_MODULE_LOADER_MODULE_PATH
};
ZeitgeistModuleLoader* zeitgeist_module_loader_new (const gchar* module_path);
ZeitgeistModuleLoader* zeitgeist_module_loader_construct (GType object_type, const gchar* module_path);
static gboolean zeitgeist_module_loader_real_load (GTypeModule* base);
const gchar* zeitgeist_module_loader_get_module_path (ZeitgeistModuleLoader* self);
static void zeitgeist_module_loader_real_unload (GTypeModule* base);
static void zeitgeist_module_loader_set_module_path (ZeitgeistModuleLoader* self, const gchar* value);
static GObject * zeitgeist_module_loader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void zeitgeist_module_loader_finalize (GObject* obj);
static void _vala_zeitgeist_module_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_module_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zeitgeist_builtin_extension_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_BUILTIN_EXTENSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionPrivate))
enum  {
	ZEITGEIST_BUILTIN_EXTENSION_DUMMY_PROPERTY
};
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_new (ZeitgeistRegisterExtensionFunc func);
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_construct (GType object_type, ZeitgeistRegisterExtensionFunc func);
static gboolean zeitgeist_builtin_extension_real_load (GTypeModule* base);
static void zeitgeist_builtin_extension_real_unload (GTypeModule* base);
static GObject * zeitgeist_builtin_extension_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void zeitgeist_builtin_extension_finalize (GObject* obj);


/**
         * This method gets called before Zeitgeist stops.
         *
         * Execution of this method isn't guaranteed, and you shouldn't do
         * anything slow in there.
         */
static void zeitgeist_extension_real_unload (ZeitgeistExtension* self) {
}


void zeitgeist_extension_unload (ZeitgeistExtension* self) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_EXTENSION_GET_CLASS (self)->unload (self);
}


/**
         * Hook applied to all events before they are inserted into the
         * log. The returned event is progressively passed through all
         * extensions before the final result is inserted.
         *
         * To block an event completely simply replace it with NULL.
         * The event may also be modified or completely substituted for
         * another event.
         *
         * @param events: A GenericArray of Event instances
         * @param sender: The D-Bus bus name of the client or NULL
         */
static void zeitgeist_extension_real_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender) {
	g_return_if_fail (events != NULL);
}


void zeitgeist_extension_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_EXTENSION_GET_CLASS (self)->pre_insert_events (self, events, sender);
}


/**
         * Hook applied to all events after they are inserted into the log.
         *
         * The inserted events will have been updated to include their new
         * ID.
         *
         * @param events: A GenericArray of Event instances
         * @param sender: The D-Bus bus name of the client or NULL
         */
static void zeitgeist_extension_real_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender) {
	g_return_if_fail (events != NULL);
}


void zeitgeist_extension_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_EXTENSION_GET_CLASS (self)->post_insert_events (self, events, sender);
}


/**
         * Hook applied before events are deleted from the log.
         *
         * @param ids: A list with the IDs of the events whose deletion
         *     is being requested
         * @param sender: The unique DBus name for the client triggering
         *     the delete, or NULL
         * @return: The filtered list of event IDs which should be deleted,
         *     or NULL to specify no change
         */
static guint32* zeitgeist_extension_real_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1) {
	guint32* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


guint32* zeitgeist_extension_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZEITGEIST_EXTENSION_GET_CLASS (self)->pre_delete_events (self, ids, ids_length1, sender, result_length1);
}


/**
         * Hook applied after events have been deleted from the log.
         *
         * @param ids: A list with the IDs of the events that have been deleted
         * @param sender: The unique DBus name for the client triggering the delete
         */
static void zeitgeist_extension_real_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender) {
}


void zeitgeist_extension_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender) {
	g_return_if_fail (self != NULL);
	ZEITGEIST_EXTENSION_GET_CLASS (self)->post_delete_events (self, ids, ids_length1, sender);
}


/**
         * Store `data' under the given (extension unique) key, overwriting any
         * previous value.
         */
void zeitgeist_extension_store_config (ZeitgeistExtension* self, const gchar* key, GVariant* data) {
	ZeitgeistEngine* _tmp0_;
	ZeitgeistExtensionStore* _tmp1_;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->_engine;
	_tmp1_ = _tmp0_->extension_store;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp3_ = g_type_name (_tmp2_);
	_tmp4_ = key;
	_tmp5_ = data;
	zeitgeist_extension_store_store (_tmp1_, _tmp3_, _tmp4_, _tmp5_);
}


/**
         * Retrieve data this extension previously stored under the given key,
         * or null if there is no such data.
         *
         * @param key: key under which the data is stored
         * @param format: type string for the resulting Variant
         */
GVariant* zeitgeist_extension_retrieve_config (ZeitgeistExtension* self, const gchar* key, const gchar* format) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* type;
	ZeitgeistEngine* _tmp2_;
	ZeitgeistExtensionStore* _tmp3_;
	GType _tmp4_ = 0UL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	GVariant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = format;
	_tmp1_ = g_variant_type_new (_tmp0_);
	type = _tmp1_;
	_tmp2_ = self->priv->_engine;
	_tmp3_ = _tmp2_->extension_store;
	_tmp4_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp5_ = g_type_name (_tmp4_);
	_tmp6_ = key;
	_tmp7_ = zeitgeist_extension_store_retrieve (_tmp3_, _tmp5_, _tmp6_, type);
	result = _tmp7_;
	_g_variant_type_free0 (type);
	return result;
}


ZeitgeistExtension* zeitgeist_extension_construct (GType object_type) {
	ZeitgeistExtension * self = NULL;
	self = (ZeitgeistExtension*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistEngine* zeitgeist_extension_get_engine (ZeitgeistExtension* self) {
	ZeitgeistEngine* result;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}


void zeitgeist_extension_set_engine (ZeitgeistExtension* self, ZeitgeistEngine* value) {
	ZeitgeistEngine* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_engine = _tmp0_;
	g_object_notify ((GObject *) self, "engine");
}


static void zeitgeist_extension_class_init (ZeitgeistExtensionClass * klass) {
	zeitgeist_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionPrivate));
	ZEITGEIST_EXTENSION_CLASS (klass)->unload = zeitgeist_extension_real_unload;
	ZEITGEIST_EXTENSION_CLASS (klass)->pre_insert_events = zeitgeist_extension_real_pre_insert_events;
	ZEITGEIST_EXTENSION_CLASS (klass)->post_insert_events = zeitgeist_extension_real_post_insert_events;
	ZEITGEIST_EXTENSION_CLASS (klass)->pre_delete_events = zeitgeist_extension_real_pre_delete_events;
	ZEITGEIST_EXTENSION_CLASS (klass)->post_delete_events = zeitgeist_extension_real_post_delete_events;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_ENGINE, g_param_spec_object ("engine", "engine", "engine", ZEITGEIST_TYPE_ENGINE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void zeitgeist_extension_instance_init (ZeitgeistExtension * self) {
	self->priv = ZEITGEIST_EXTENSION_GET_PRIVATE (self);
}


static void zeitgeist_extension_finalize (GObject* obj) {
	ZeitgeistExtension * self;
	self = ZEITGEIST_EXTENSION (obj);
	G_OBJECT_CLASS (zeitgeist_extension_parent_class)->finalize (obj);
}


/**
     * Base class for all extensions
     *
     * The constructor of an Extension object takes the Engine object
     * it extends as the only argument.
     *
     * Extensions have a set of hooks with which they can control how
     * events are inserted and retrieved from the log.
     *
     * Additionally, extensions may create their own D-Bus interface
     * over which they can expose their own methods.
     */
GType zeitgeist_extension_get_type (void) {
	static volatile gsize zeitgeist_extension_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtension), 0, (GInstanceInitFunc) zeitgeist_extension_instance_init, NULL };
		GType zeitgeist_extension_type_id;
		zeitgeist_extension_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtension", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&zeitgeist_extension_type_id__volatile, zeitgeist_extension_type_id);
	}
	return zeitgeist_extension_type_id__volatile;
}


static void _vala_zeitgeist_extension_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistExtension * self;
	self = ZEITGEIST_EXTENSION (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_ENGINE:
		g_value_set_object (value, zeitgeist_extension_get_engine (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_extension_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistExtension * self;
	self = ZEITGEIST_EXTENSION (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_ENGINE:
		zeitgeist_extension_set_engine (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static ZeitgeistExtension* zeitgeist_extension_loader_real_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine) {
	ZeitgeistExtension* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = g_type_module_use ((GTypeModule*) self);
	if (_tmp0_) {
		GType _tmp1_;
		GType _tmp2_;
		ZeitgeistEngine* _tmp3_;
		GObject* _tmp4_ = NULL;
		GObject* _tmp5_;
		ZeitgeistExtension* instance;
		GType _tmp6_;
		const gchar* _tmp7_ = NULL;
		_tmp1_ = self->priv->_extension_type;
		if (_tmp1_ == G_TYPE_INVALID) {
			result = NULL;
			return result;
		}
		_tmp2_ = self->priv->_extension_type;
		_tmp3_ = engine;
		_tmp4_ = g_object_new (_tmp2_, "engine", _tmp3_, NULL);
		_tmp5_ = G_IS_INITIALLY_UNOWNED (_tmp4_) ? g_object_ref_sink (_tmp4_) : _tmp4_;
		instance = ZEITGEIST_IS_EXTENSION (_tmp5_) ? ((ZeitgeistExtension*) _tmp5_) : NULL;
		_tmp6_ = self->priv->_extension_type;
		_tmp7_ = g_type_name (_tmp6_);
		g_debug ("extension.vala:146: Loaded extension: %s", _tmp7_);
		g_type_module_unuse ((GTypeModule*) self);
		result = instance;
		return result;
	}
	result = NULL;
	return result;
}


ZeitgeistExtension* zeitgeist_extension_loader_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZEITGEIST_EXTENSION_LOADER_GET_CLASS (self)->create_instance (self, engine);
}


ZeitgeistExtensionLoader* zeitgeist_extension_loader_construct (GType object_type) {
	ZeitgeistExtensionLoader * self = NULL;
	self = (ZeitgeistExtensionLoader*) g_object_new (object_type, NULL);
	return self;
}


GType zeitgeist_extension_loader_get_extension_type (ZeitgeistExtensionLoader* self) {
	GType result;
	GType _tmp0_;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->_extension_type;
	result = _tmp0_;
	return result;
}


void zeitgeist_extension_loader_set_extension_type (ZeitgeistExtensionLoader* self, GType value) {
	GType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_extension_type = _tmp0_;
	g_object_notify ((GObject *) self, "extension-type");
}


static void zeitgeist_extension_loader_class_init (ZeitgeistExtensionLoaderClass * klass) {
	zeitgeist_extension_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionLoaderPrivate));
	ZEITGEIST_EXTENSION_LOADER_CLASS (klass)->create_instance = zeitgeist_extension_loader_real_create_instance;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_loader_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE, g_param_spec_gtype ("extension-type", "extension-type", "extension-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zeitgeist_extension_loader_instance_init (ZeitgeistExtensionLoader * self) {
	self->priv = ZEITGEIST_EXTENSION_LOADER_GET_PRIVATE (self);
}


static void zeitgeist_extension_loader_finalize (GObject* obj) {
	ZeitgeistExtensionLoader * self;
	self = ZEITGEIST_EXTENSION_LOADER (obj);
	G_OBJECT_CLASS (zeitgeist_extension_loader_parent_class)->finalize (obj);
}


GType zeitgeist_extension_loader_get_type (void) {
	static volatile gsize zeitgeist_extension_loader_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionLoader), 0, (GInstanceInitFunc) zeitgeist_extension_loader_instance_init, NULL };
		GType zeitgeist_extension_loader_type_id;
		zeitgeist_extension_loader_type_id = g_type_register_static (G_TYPE_TYPE_MODULE, "ZeitgeistExtensionLoader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&zeitgeist_extension_loader_type_id__volatile, zeitgeist_extension_loader_type_id);
	}
	return zeitgeist_extension_loader_type_id__volatile;
}


static void _vala_zeitgeist_extension_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionLoader * self;
	self = ZEITGEIST_EXTENSION_LOADER (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE:
		g_value_set_gtype (value, zeitgeist_extension_loader_get_extension_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_extension_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionLoader * self;
	self = ZEITGEIST_EXTENSION_LOADER (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_LOADER_EXTENSION_TYPE:
		zeitgeist_extension_loader_set_extension_type (self, g_value_get_gtype (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ZeitgeistModuleLoader* zeitgeist_module_loader_construct (GType object_type, const gchar* module_path) {
	ZeitgeistModuleLoader * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (module_path != NULL, NULL);
	_tmp0_ = module_path;
	self = (ZeitgeistModuleLoader*) g_object_new (object_type, "module-path", _tmp0_, NULL);
	return self;
}


ZeitgeistModuleLoader* zeitgeist_module_loader_new (const gchar* module_path) {
	return zeitgeist_module_loader_construct (ZEITGEIST_TYPE_MODULE_LOADER, module_path);
}


static gboolean zeitgeist_module_loader_real_load (GTypeModule* base) {
	ZeitgeistModuleLoader * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GModule* _tmp1_ = NULL;
	GModule* _tmp2_;
	void* func_ptr = NULL;
	GModule* _tmp4_;
	void* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	self = (ZeitgeistModuleLoader*) base;
	_tmp0_ = self->priv->_module_path;
	_tmp1_ = g_module_open (_tmp0_, G_MODULE_BIND_LOCAL);
	_g_module_close0 (self->priv->module);
	self->priv->module = _tmp1_;
	_tmp2_ = self->priv->module;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = g_module_error ();
		g_warning ("extension.vala:176: %s", _tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->module;
	_tmp6_ = g_module_symbol (_tmp4_, "zeitgeist_extension_register", &_tmp5_);
	func_ptr = _tmp5_;
	if (_tmp6_) {
		void* _tmp7_;
		ZeitgeistRegisterExtensionFunc func;
		ZeitgeistRegisterExtensionFunc _tmp8_;
		GType _tmp9_ = 0UL;
		GType _tmp10_;
		GType _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp7_ = func_ptr;
		func = (ZeitgeistRegisterExtensionFunc) _tmp7_;
		_tmp8_ = func;
		_tmp9_ = _tmp8_ ((GTypeModule*) self);
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp9_);
		_tmp10_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_type_is_a (_tmp11_, ZEITGEIST_TYPE_EXTENSION);
		if (_tmp12_ == FALSE) {
			const gchar* _tmp13_;
			zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, G_TYPE_INVALID);
			_tmp13_ = self->priv->_module_path;
			g_warning ("Type implemented in \"%s\" does not subclass " "Zeitgeist.Extension!", _tmp13_);
			result = FALSE;
			return result;
		}
		g_object_ref ((GObject*) self);
	} else {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = g_module_error ();
		g_warning ("extension.vala:200: %s", _tmp14_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void zeitgeist_module_loader_real_unload (GTypeModule* base) {
	ZeitgeistModuleLoader * self;
	self = (ZeitgeistModuleLoader*) base;
	_g_module_close0 (self->priv->module);
	self->priv->module = NULL;
}


const gchar* zeitgeist_module_loader_get_module_path (ZeitgeistModuleLoader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_path;
	result = _tmp0_;
	return result;
}


static void zeitgeist_module_loader_set_module_path (ZeitgeistModuleLoader* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_module_path);
	self->priv->_module_path = _tmp1_;
	g_object_notify ((GObject *) self, "module-path");
}


static GObject * zeitgeist_module_loader_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistModuleLoader * self;
	const gchar* _tmp0_;
	parent_class = G_OBJECT_CLASS (zeitgeist_module_loader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_MODULE_LOADER (obj);
	_tmp0_ = self->priv->_module_path;
	g_type_module_set_name ((GTypeModule*) self, _tmp0_);
	return obj;
}


static void zeitgeist_module_loader_class_init (ZeitgeistModuleLoaderClass * klass) {
	zeitgeist_module_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistModuleLoaderPrivate));
	G_TYPE_MODULE_CLASS (klass)->load = zeitgeist_module_loader_real_load;
	G_TYPE_MODULE_CLASS (klass)->unload = zeitgeist_module_loader_real_unload;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_module_loader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_module_loader_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_module_loader_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_module_loader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MODULE_LOADER_MODULE_PATH, g_param_spec_string ("module-path", "module-path", "module-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void zeitgeist_module_loader_instance_init (ZeitgeistModuleLoader * self) {
	self->priv = ZEITGEIST_MODULE_LOADER_GET_PRIVATE (self);
	self->priv->module = NULL;
}


static void zeitgeist_module_loader_finalize (GObject* obj) {
	ZeitgeistModuleLoader * self;
	self = ZEITGEIST_MODULE_LOADER (obj);
	_g_free0 (self->priv->_module_path);
	_g_module_close0 (self->priv->module);
	G_OBJECT_CLASS (zeitgeist_module_loader_parent_class)->finalize (obj);
}


GType zeitgeist_module_loader_get_type (void) {
	static volatile gsize zeitgeist_module_loader_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_module_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistModuleLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_module_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistModuleLoader), 0, (GInstanceInitFunc) zeitgeist_module_loader_instance_init, NULL };
		GType zeitgeist_module_loader_type_id;
		zeitgeist_module_loader_type_id = g_type_register_static (ZEITGEIST_TYPE_EXTENSION_LOADER, "ZeitgeistModuleLoader", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_module_loader_type_id__volatile, zeitgeist_module_loader_type_id);
	}
	return zeitgeist_module_loader_type_id__volatile;
}


static void _vala_zeitgeist_module_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistModuleLoader * self;
	self = ZEITGEIST_MODULE_LOADER (object);
	switch (property_id) {
		case ZEITGEIST_MODULE_LOADER_MODULE_PATH:
		g_value_set_string (value, zeitgeist_module_loader_get_module_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_module_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistModuleLoader * self;
	self = ZEITGEIST_MODULE_LOADER (object);
	switch (property_id) {
		case ZEITGEIST_MODULE_LOADER_MODULE_PATH:
		zeitgeist_module_loader_set_module_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_construct (GType object_type, ZeitgeistRegisterExtensionFunc func) {
	ZeitgeistBuiltinExtension * self = NULL;
	ZeitgeistRegisterExtensionFunc _tmp0_;
	self = (ZeitgeistBuiltinExtension*) g_object_new (object_type, NULL);
	_tmp0_ = func;
	self->priv->reg_func = _tmp0_;
	return self;
}


ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_new (ZeitgeistRegisterExtensionFunc func) {
	return zeitgeist_builtin_extension_construct (ZEITGEIST_TYPE_BUILTIN_EXTENSION, func);
}


static gboolean zeitgeist_builtin_extension_real_load (GTypeModule* base) {
	ZeitgeistBuiltinExtension * self;
	gboolean result = FALSE;
	GType _tmp0_;
	GType _tmp1_;
	self = (ZeitgeistBuiltinExtension*) base;
	_tmp0_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == G_TYPE_INVALID) {
		ZeitgeistRegisterExtensionFunc _tmp2_;
		GType _tmp3_ = 0UL;
		GType _tmp4_;
		GType _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = self->priv->reg_func;
		_tmp3_ = _tmp2_ ((GTypeModule*) self);
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp3_);
		_tmp4_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_type_is_a (_tmp5_, ZEITGEIST_TYPE_EXTENSION);
		if (_tmp6_ == FALSE) {
			GType _tmp7_;
			GType _tmp8_;
			const gchar* _tmp9_ = NULL;
			ZeitgeistRegisterExtensionFunc _tmp10_;
			_tmp7_ = zeitgeist_extension_loader_get_extension_type ((ZeitgeistExtensionLoader*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_type_name (_tmp8_);
			_tmp10_ = self->priv->reg_func;
			g_warning ("Type \"%s\" implemented by [%p] does not " "subclass Zeitgeist.Extension!", _tmp9_, _tmp10_);
			zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, G_TYPE_INVALID);
			result = FALSE;
			return result;
		}
		g_object_ref ((GObject*) self);
	} else {
		ZeitgeistRegisterExtensionFunc _tmp11_;
		GType _tmp12_ = 0UL;
		_tmp11_ = self->priv->reg_func;
		_tmp12_ = _tmp11_ ((GTypeModule*) self);
		zeitgeist_extension_loader_set_extension_type ((ZeitgeistExtensionLoader*) self, _tmp12_);
	}
	result = TRUE;
	return result;
}


static void zeitgeist_builtin_extension_real_unload (GTypeModule* base) {
	ZeitgeistBuiltinExtension * self;
	self = (ZeitgeistBuiltinExtension*) base;
}


static GObject * zeitgeist_builtin_extension_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistBuiltinExtension * self;
	parent_class = G_OBJECT_CLASS (zeitgeist_builtin_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_BUILTIN_EXTENSION (obj);
	g_type_module_set_name ((GTypeModule*) self, "builtin");
	return obj;
}


static void zeitgeist_builtin_extension_class_init (ZeitgeistBuiltinExtensionClass * klass) {
	zeitgeist_builtin_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistBuiltinExtensionPrivate));
	G_TYPE_MODULE_CLASS (klass)->load = zeitgeist_builtin_extension_real_load;
	G_TYPE_MODULE_CLASS (klass)->unload = zeitgeist_builtin_extension_real_unload;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_builtin_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_builtin_extension_finalize;
}


static void zeitgeist_builtin_extension_instance_init (ZeitgeistBuiltinExtension * self) {
	self->priv = ZEITGEIST_BUILTIN_EXTENSION_GET_PRIVATE (self);
}


static void zeitgeist_builtin_extension_finalize (GObject* obj) {
	ZeitgeistBuiltinExtension * self;
	self = ZEITGEIST_BUILTIN_EXTENSION (obj);
	G_OBJECT_CLASS (zeitgeist_builtin_extension_parent_class)->finalize (obj);
}


GType zeitgeist_builtin_extension_get_type (void) {
	static volatile gsize zeitgeist_builtin_extension_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_builtin_extension_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistBuiltinExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_builtin_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistBuiltinExtension), 0, (GInstanceInitFunc) zeitgeist_builtin_extension_instance_init, NULL };
		GType zeitgeist_builtin_extension_type_id;
		zeitgeist_builtin_extension_type_id = g_type_register_static (ZEITGEIST_TYPE_EXTENSION_LOADER, "ZeitgeistBuiltinExtension", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_builtin_extension_type_id__volatile, zeitgeist_builtin_extension_type_id);
	}
	return zeitgeist_builtin_extension_type_id__volatile;
}



